/* logjam - a GTK client for LiveJournal.
 * Copyright (C) 2000-2002 Evan Martin <evan@livejournal.com>
 *
 * vim: tabstop=4 shiftwidth=4 noexpandtab :
 * $Id: login_server.c,v 1.1 2002/11/26 09:39:16 martine Exp $
 */

#include "config.h"

#include <gtk/gtk.h>

#include "util.h"

typedef struct {
	GtkWidget *dlg;
	GtkTreeModel *store;
	GtkWidget *view;
} ServerManagerUI;

static Server*
cell_edited(GtkCellRendererText *cell,
		const gchar *path_string,
		const gchar *new_text,
		int column,
		ServerManagerUI *smui) {
	GtkTreePath *path = gtk_tree_path_new_from_string(path_string);
	GtkTreeIter iter;
	Server *s;

	gtk_tree_model_get_iter(smui->store, &iter, path);

	gtk_tree_model_get(smui->store, &iter,
			0, &s,
			-1);
	gtk_list_store_set(GTK_LIST_STORE(smui->store), &iter,
			column, new_text,
			-1);
	gtk_tree_path_free(path);
	return s;
}

static void
name_edited(GtkCellRendererText *cell,
		const gchar *path_string,
		const gchar *new_text,
		ServerManagerUI *smui) {
	Server *s = cell_edited(cell, path_string, new_text, 1, smui);
	g_free(s->name);
	s->name = g_strdup(new_text);
}

static void
url_edited(GtkCellRendererText *cell,
		const gchar *path_string,
		const gchar *new_text,
		ServerManagerUI *smui) {
	Server *s = cell_edited(cell, path_string, new_text, 2, smui);
	g_free(s->url);
	s->url = g_strdup(new_text);
}

static GtkWidget*
make_serverlist(ServerManagerUI *smui) {
	GList *l;
	GtkTreeIter iter;
	Server *s;
	GtkCellRenderer *renderer;
	GtkTreeViewColumn *column;
	
	smui->store = GTK_TREE_MODEL(
			gtk_list_store_new(4, G_TYPE_POINTER,
				G_TYPE_STRING, G_TYPE_STRING,
				G_TYPE_BOOLEAN));
	for (l = conf.servers; l; l = l->next) {
		s = l->data;
		gtk_list_store_append(GTK_LIST_STORE(smui->store), &iter);
		gtk_list_store_set(GTK_LIST_STORE(smui->store), &iter,
				0, s, 1, s->name, 2, s->url, 3, TRUE, -1);
	}

	smui->view = gtk_tree_view_new_with_model(smui->store);
	g_object_unref(G_OBJECT(smui->store));
	
	renderer = gtk_cell_renderer_text_new();
	g_signal_connect(G_OBJECT(renderer), "edited",
			G_CALLBACK(name_edited), smui);
	column = gtk_tree_view_column_new_with_attributes("Name", renderer,
			"text", 1,
			"editable", 3,
			NULL);
	gtk_tree_view_append_column(GTK_TREE_VIEW(smui->view), column);

	renderer = gtk_cell_renderer_text_new();
	g_signal_connect(G_OBJECT(renderer), "edited",
			G_CALLBACK(url_edited), smui);
	column = gtk_tree_view_column_new_with_attributes("URL", renderer,
			"text", 2,
			"editable", 3,
			NULL);
	gtk_tree_view_append_column(GTK_TREE_VIEW(smui->view), column);

	return scroll_wrap(smui->view);
}

static void
add_cb(GtkWidget *w, ServerManagerUI *smui) {
	Server *s;
	GtkTreeIter iter;

	s = g_new0(Server, 1);
	s->name = g_strdup("New Server");
	s->url = g_strdup("http://hostname:port");
	conf.servers = g_list_append(conf.servers, s);

	gtk_list_store_append(GTK_LIST_STORE(smui->store), &iter);
	gtk_list_store_set(GTK_LIST_STORE(smui->store), &iter,
			0, s, 1, s->name, 2, s->url, 3, TRUE, -1);
}

static void
remove_cb(GtkWidget *w, ServerManagerUI *smui) {
	Server *s;
	GtkTreeIter iter;
	GtkTreeSelection *selection;
	selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(smui->view));

	if (gtk_tree_selection_get_selected(selection, NULL, &iter)) {
		gtk_tree_model_get(smui->store, &iter,
				0, &s,
				-1);
		gtk_list_store_remove(GTK_LIST_STORE(smui->store), &iter);
		conf.servers = g_list_remove(conf.servers, s);
		g_free(s);
	}
}

static void
make_dialog(ServerManagerUI *smui, GtkWidget *parent) {
	GtkWidget *vbox, *bbox, *badd, *bremove;
	
	smui->dlg = lj_dialog_new(parent, _("Server Manager"), 400, -1);

	vbox = gtk_vbox_new(FALSE, 5);
	gtk_box_pack_start(GTK_BOX(vbox), make_serverlist(smui), TRUE, TRUE, 0);

	bbox = gtk_hbox_new(FALSE, 5);
	badd = gtk_button_new_from_stock(GTK_STOCK_ADD);
	g_signal_connect(badd, "clicked",
			G_CALLBACK(add_cb), smui);
	bremove = gtk_button_new_from_stock(GTK_STOCK_REMOVE);
	g_signal_connect(bremove, "clicked",
			G_CALLBACK(remove_cb), smui);
	gtk_box_pack_end(GTK_BOX(bbox), bremove, FALSE, FALSE, 0);
	gtk_box_pack_end(GTK_BOX(bbox), badd, FALSE, FALSE, 0);

	gtk_box_pack_start(GTK_BOX(vbox), bbox, FALSE, FALSE, 0);

	lj_dialog_set_contents(smui->dlg, vbox);
	gtk_dialog_add_button(GTK_DIALOG(smui->dlg), 
			GTK_STOCK_CLOSE, GTK_RESPONSE_CLOSE);
	/* lj_dialog_add_close(smui->dlg); is what we want,
	 * but that tries to destroy the dialog when close is clicked,
	 * and GTK already does that.  yuck.  i suck.  */
}

void
login_server_manager_run(GtkWidget *parent) {
	ServerManagerUI smui_actual = {0}, *smui = &smui_actual;
	make_dialog(smui, parent);
	lj_dialog_run(smui->dlg);
}

