/* logjam - a GTK client for LiveJournal.
 * Copyright (C) 2000-2002 Evan Martin <evan@livejournal.com>
 *
 * vim: tabstop=4 shiftwidth=4 noexpandtab :
 * $Id: link.c,v 1.11 2002/11/28 06:12:32 martine Exp $
 */

#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>
#include <gdk/gdktypes.h>
#include <stdio.h>
#include "util.h"
#include "conf.h"
#include "lj.h"

static GtkWidget*
hbox_wrap(GtkWidget *w) {
	GtkWidget *hbox;
	hbox = gtk_hbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(hbox), w, FALSE, FALSE, 0);
	return hbox;
}

static void
select_toggled(GtkToggleButton *tb, GtkWidget *focus) {
	if (gtk_toggle_button_get_active(tb))
		gtk_widget_grab_focus(focus);
}

static void
entry_activate_cb(GtkWidget *w, GtkWidget *dlg) {
	gtk_dialog_response(GTK_DIALOG(dlg), GTK_RESPONSE_OK);
}
static void
entry_focus_cb(GtkWidget *w, GdkEventFocus *e, GtkToggleButton *radio) {
	gtk_toggle_button_set_active(radio, TRUE);
}

static GtkWidget*
radio_option(GtkWidget *dlg, GSList *g, GtkWidget **radio, GtkWidget **entry,
		const char *caption, const char *label, const char *initial) {
	GtkWidget *vbox;

	vbox = gtk_vbox_new(FALSE, 0);
	*radio = gtk_radio_button_new_with_mnemonic(g, caption);
	gtk_box_pack_start(GTK_BOX(vbox), hbox_wrap(*radio), FALSE, FALSE, 0);

	*entry = gtk_entry_new();
	g_signal_connect(G_OBJECT(*entry), "activate",
			G_CALLBACK(entry_activate_cb), dlg);
	g_signal_connect(G_OBJECT(*entry), "focus-in-event",
			G_CALLBACK(entry_focus_cb), *radio);
	if (initial)
		gtk_entry_set_text(GTK_ENTRY(*entry), initial);
	gtk_widget_set_size_request(*entry, 75, -1);
	g_signal_connect(G_OBJECT(*radio), "toggled",
			G_CALLBACK(select_toggled), *entry);
	g_signal_connect(G_OBJECT(*radio), "activate",
			G_CALLBACK(select_toggled), *entry);

	if (label) {
		GtkWidget *hbox = gtk_hbox_new(FALSE, 0);
		gtk_box_pack_start(GTK_BOX(hbox), 
				gtk_label_new(label),
				FALSE, FALSE, 0);
		gtk_box_pack_start(GTK_BOX(hbox), *entry, TRUE, TRUE, 0);
		gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, FALSE, 0);
	} else {
		gtk_box_pack_start(GTK_BOX(vbox), *entry, TRUE, TRUE, 0);
	}

	return vbox;
}

void
link_dialog_run(LJWin *ljw) {
	GtkWidget *win;
	GtkWidget *vbox;

	GtkTextBuffer *buffer;
	GtkTextIter start, end;
	char *input = "";

	GtkWidget *etext, *ruser, *euser, *rurl, *eurl;
	GtkWidget *subbox;
	GtkWidget *label;
	GSList *rgroup;

	buffer = gtk_text_view_get_buffer(GTK_TEXT_VIEW(ljw->eentry));
	if (gtk_text_buffer_get_selection_bounds(buffer, &start, &end)) {
		input = gtk_text_buffer_get_text(buffer, &start, &end, FALSE);
	}

	win = lj_dialog_new(GTK_WIDGET(ljw), _("Make Link"), -1, -1);

	vbox = gtk_vbox_new(FALSE, 10);

	subbox = gtk_hbox_new(FALSE, 5);
	label = gtk_label_new_with_mnemonic(_("Link _Text:"));
	etext = gtk_entry_new();
	g_signal_connect(G_OBJECT(etext), "activate",
			G_CALLBACK(entry_activate_cb), win);
	gtk_entry_set_text(GTK_ENTRY(etext), input);
	gtk_box_pack_start(GTK_BOX(subbox), label, FALSE, FALSE, 0);
	gtk_box_pack_start(GTK_BOX(subbox), etext, TRUE, TRUE, 0);
	gtk_label_set_mnemonic_widget(GTK_LABEL(label), etext);
	gtk_box_pack_start(GTK_BOX(vbox), subbox, FALSE, FALSE, 0);

	gtk_box_pack_start(GTK_BOX(vbox), 
			radio_option(win, NULL, &rurl, &eurl, _("_URL:"), NULL, input),
			FALSE, FALSE, 0);

	rgroup = gtk_radio_button_get_group(GTK_RADIO_BUTTON(rurl));

	gtk_box_pack_start(GTK_BOX(vbox), 
			radio_option(win, rgroup, &ruser, &euser, 
				_("_LiveJournal User:"), ".../users/", input),
			FALSE, FALSE, 0);

	lj_dialog_add_okcancel(win, NULL);
	lj_dialog_set_contents(win, vbox);
	if (!lj_dialog_run(win))
		return;

	gtk_text_buffer_delete(buffer, &start, &end);

	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(rurl))) {
		/* build a "url" link.  we can't anticipate how long it'll be. */
		char *link;
		link = g_strdup_printf("<a href=\"%s\">%s</a>",
				gtk_entry_get_text(GTK_ENTRY(eurl)), 
				gtk_entry_get_text(GTK_ENTRY(etext)));
		gtk_text_buffer_insert(buffer, &start, link, -1);
		g_free(link);
	} else if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(ruser))) {
		/* build a "friends" link */
		char *link;
		link = g_strdup_printf("<a href=\"%s/users/%s\">%s</a>",
				conf_cur_server()->url,
				gtk_entry_get_text(GTK_ENTRY(euser)), 
				gtk_entry_get_text(GTK_ENTRY(etext)));
		gtk_text_buffer_insert(buffer, &start, link, -1);
		g_free(link);
	} 
	
	gtk_widget_destroy(win);
}
