/* logjam - a GTK client for LiveJournal.
 * Copyright (C) 2000-2002 Evan Martin <evan@livejournal.com>
 *
 * vim: tabstop=4 shiftwidth=4 noexpandtab :
 * $Id: friendgroupedit.c,v 1.7 2002/09/24 07:57:50 martine Exp $
 */

#include <gtk/gtk.h>

#include <stdlib.h>
#include <string.h>

#include "friends.h"
#include "conf.h"
#include "friendgroupedit.h"
#include "network.h"
#include "util.h"

typedef struct {
	GtkWidget *win;
	GtkWidget *egroupname, *cpublic;

	FriendGroup *editgroup;

	int freegroup; /* index of first free group number. */
} friend_group_edit_dlg;

static gboolean 
editgroup_run(friend_group_edit_dlg *fged) {
	int groupid;
	NetRequest *request;
	NetResult  *result;
	
	request = net_request_new("editfriendgroups");
	if (fged->editgroup) {
		groupid = fged->editgroup->id;
	} else {
		groupid = fged->freegroup;
	}
	net_request_set(request, 
			g_strdup_printf("efg_set_%d_name", groupid),
			g_strdup(gtk_entry_get_text(GTK_ENTRY(fged->egroupname))));
	net_request_set(request, 
			g_strdup_printf("efg_set_%d_public", groupid),
			g_strdup_printf(gtk_toggle_button_get_active(
					GTK_TOGGLE_BUTTON(fged->cpublic)) 
				? "1" : "0"));

	result = net_request_run(fged->win, _("Modifying Friend Group..."), request);
	net_request_free(request);

	if (!net_result_succeeded(result)) {
		net_result_free(result);
		return FALSE;
	}

	if (fged->editgroup == NULL) {
		/* we must create a new group */
		fged->editgroup = g_new0(FriendGroup, 1);
		fged->editgroup->id = fged->freegroup;
	}
	string_replace(&fged->editgroup->name, 
			g_strdup(gtk_entry_get_text(GTK_ENTRY(fged->egroupname))));
	fged->editgroup->ispublic = 
		gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(fged->cpublic));

	gtk_widget_destroy(fged->win);
	net_result_free(result);
	return TRUE;
}

static void
entry_changed(GtkEntry *entry, GtkWidget* button) {
	gtk_widget_set_sensitive(button, 
			(strlen(gtk_entry_get_text(entry)) > 0));
}

FriendGroup*
friend_group_edit_dlg_run(GtkWidget *parent, FriendGroup *fg, int freegroup) {
	friend_group_edit_dlg fged_actual = {0};
	friend_group_edit_dlg *fged = &fged_actual;
	GtkWidget *table, *button;

	fged->editgroup = fg;
	fged->freegroup = freegroup;

	fged->win = lj_dialog_new(parent, 
			fg ? _("Edit Friend Group") : _("New Friend Group"),
			200, 1);

	table = lj_table_new(2, 2);
	lj_table_label(GTK_TABLE(table), 0, _("Group name:"));

	fged->egroupname = gtk_entry_new();
	lj_table_content(GTK_TABLE(table), 0, fged->egroupname);

	fged->cpublic = gtk_check_button_new_with_label("Public");
	lj_table_fillrow(GTK_TABLE(table), 1, fged->cpublic);

	lj_dialog_set_contents(fged->win, table);

	button = lj_dialog_add_okcancel(fged->win, fg ? "  Change  " : "  Create  ");
	
	/* enable/disable the button based on name text */
	g_signal_connect(G_OBJECT(fged->egroupname), "changed",
		G_CALLBACK(entry_changed), button);

	/* fill in default values. */
	if (fg) {
		gtk_entry_set_text(GTK_ENTRY(fged->egroupname), fg->name);
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(fged->cpublic), fg->ispublic);
	} else {
		gtk_entry_set_text(GTK_ENTRY(fged->egroupname), "");
		/* emit the "changed" signal, anyway. */
	}

	while (lj_dialog_run(fged->win)) {
		if (editgroup_run(fged))
			return fged->editgroup;
	} 
	return NULL;
}


