/* logjam - a GTK client for LiveJournal.
 * Copyright (C) 2000-2002 Evan Martin <evan@livejournal.com>
 *
 * vim: tabstop=4 shiftwidth=4 noexpandtab :
 * $Id: conf.c,v 1.9 2002/11/26 09:39:16 martine Exp $
 */

#include <glib.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "util.h"
#include "conf_xml.h"
#include "conf.h"

Configuration conf;
Application app;

char*
conf_nid_by_id(GList *l, int id) {
	for ( ; l; l = l->next) {
		if (((NameIDHash*)l->data)->id == id) 
			return ((NameIDHash*)l->data)->name;
	}
	return NULL;
}
int
conf_nid_by_name(GList *l, const char* name) {
	for ( ; l; l = l->next) {
		if (strcmp(((NameIDHash*)l->data)->name, name) == 0) 
			return ((NameIDHash*)l->data)->id;
	}
	return -1;
}
gint
conf_nid_compare_alpha(NameIDHash *a, NameIDHash *b) {
	return g_ascii_strcasecmp(a->name, b->name);
}

void
conf_nid_free(NameIDHash *nid) {
	g_free(nid->name);
	g_free(nid);
}

static gint
user_compare(gconstpointer a, gconstpointer b) {
	return g_ascii_strcasecmp(((User*)a)->username, ((User*)b)->username);
}

User*
conf_user_by_username(Server *server, const char *username) {
	GList *l;
	for (l = server->users; l != NULL; l = l->next) {
		if (strcmp(username, ((User*)l->data)->username) == 0) {
			return l->data;
		}
	}
	return NULL;
}

void
conf_server_add_user(Server *server, User *user) {
	server->users = g_list_insert_sorted(server->users, user, user_compare);
}

Server*
conf_server_by_name(Configuration *c, const char *servername) {
	GList *l;
	for (l = c->servers; l != NULL; l = l->next) {
		if (strcmp(servername, ((Server*)l->data)->name) == 0) {
			return l->data;
		}
	}
	return NULL;
}

int 
conf_mood_get_last_cached(Server *server) {
	GList *l;
	int max = 0;
	for (l = server->moods; l != NULL; l = l->next) {
		if (((Mood*)l->data)->id > max) 
			max = ((Mood*)l->data)->id;
	}
	return max;
}

void
conf_make_path(const char *file, char *buf, size_t maxlen) {
	const char *homedir;

	if (app.conf_dir) { /* TODO: expand ~ to $HOME? */
		g_snprintf(buf, maxlen, "%s/%s", app.conf_dir,
			file ? file : "");
	} else {
		homedir = g_get_home_dir();
		g_snprintf(buf, maxlen, "%s/.logjam/%s", homedir, 
			file ? file : "");
	}
}

int
conf_verify_dir(void) {
	char path[1024];

	conf_make_path(NULL, path, sizeof(path));

	return verify_dir(path);
}

int
conf_read(Configuration *c) {
	gchar path[1024];
	conf_verify_dir();
	conf_make_path("conf.xml", path, 1024);
	return conf_xml_read(c, path);
}

int
conf_write(Configuration *c) {
	gchar path[1024];
	conf_verify_dir();
	conf_make_path("conf.xml", path, 1024);
	return conf_xml_write(c, path);
}

void
conf_verify_a_server_exists() {
	if (conf.servers == NULL) {
		/* make a default server. */
		Server *s = g_new0(Server, 1);
		s->name = g_strdup("LiveJournal.com");
		s->url = g_strdup("http://www.livejournal.com");
		conf.servers = g_list_append(conf.servers, s);
	}
}

