/***************************************************************************
                          dockwidget.cpp  -  description
                             -------------------
    begin                : Thu Jul 6 2000
    copyright            : (C) 2000 by Ian Reinhart Geiser
    email                : geiseri@msoe.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "dockwidget.h"
#include <qtooltip.h>
#include <qpixmap.h>
#include <qimage.h>
#include <klocale.h>
#include <kstandarddirs.h>
#include <iostream.h>
#include <kdebug.h>

dockwidget::dockwidget(QWidget *parent, const char *name) : QWidget(parent,name){
    initDialog();
    connect(QPushButton_1, SIGNAL( released() ), SLOT( buttonHandler() ));
    QLabel_1->setText(i18n("Unavailable"));
    QLabel_2->setText(i18n("data"));
    QLabel_3->setText("...");
}

dockwidget::~dockwidget(){
}

void dockwidget::setSmall(bool small)
{
    isSmall = small;
}

void dockwidget::setWeatherIcon(QString icon)
{
    QString theImage = "kweather/" + icon + ".png";
    kdDebug(12004) << "Icon: " << theImage << endl;
    theIcon = QImage(locate("data", theImage));
}

/** Change the button icon */
void dockwidget::showIcon(){
    QPushButton_1->setPixmap(QPixmap(theIcon.smoothScale(QPushButton_1->size(), QImage::ScaleMin)));
}

void dockwidget::showWeather()
{
    QString tip;

    if (isSmall)
    {
        tip = i18n("Wind Speed & Direction: ") + wind;
        tip += i18n("\nTemperature: ") + temperature;
        tip += i18n("\nAir Pressure: ") + pressure;
    }
    else
    {
        tip = i18n("Press here to\nsee a weather report...");
    }

    QToolTip::remove(QPushButton_1);
    QToolTip::add(QPushButton_1, tip);

    showIcon();

    QLabel_1->setText(temperature);
    QLabel_2->setText(wind);
    QLabel_3->setText(pressure);
}

/** relay the button pressed to the parent widget */
void dockwidget::buttonHandler(){
    emit ( buttonEvent());
}

void  dockwidget::initDialog(){
    kdDebug(12004) << "Init Dialog " << endl;
    QPushButton_1= new QPushButton(this,"NoName");
    theIcon = QImage(locate("data", "kweather/dunno.png"));
    theIcon.smoothScale(QPushButton_1->size());
    QPushButton_1->setPixmap(QPixmap(theIcon));

    QLabel_1= new QLabel(this,"NoName");
    QLabel_2= new QLabel(this,"NoName");
    QLabel_3= new QLabel(this,"NoName");

    updateFont();
}

/** Set the current temperature. */
void dockwidget::setTemperature( QString s){
    temperature = s;
}

/** Set the current wind speed and direction data. */
void dockwidget::setWind( QString s){
    wind = s;
}

/** Set the current pressure. */
void dockwidget::setPressure( QString s){
    pressure = s;
}

  /** resize the view **/
void dockwidget::resizeView(int w, int h)
{
    kdDebug(12004) << "Changing to size " << w << "," << h << endl;
    this->resize (w, h);

    if (w >= h)
    {
        // Kicker in horizontal mode
        QLabel_1->setGeometry(h+2, 0, h, h/3);
        QLabel_2->setGeometry(h+2, h/3, h, h/3);
        QLabel_3->setGeometry(h+2, 2*h/3, h, h/3);
        QPushButton_1->resize(h, h);
    }
    else
    {
        // Kicker in vertical mode
        QLabel_1->setGeometry(2, w, w, w/3);
        QLabel_2->setGeometry(2, 4*w/3, w, w/3);
        QLabel_3->setGeometry(2, 5*w/3, w, w/3);
        QPushButton_1->resize(w, w);
    }

    showIcon();
}

void dockwidget::setFont(QFont newFont)
{
    theFont = newFont;
    updateFont();
}

void dockwidget::updateFont()
{
    QLabel_1->setFont(theFont);
    QLabel_2->setFont(theFont);
    QLabel_3->setFont(theFont);
}

#include "dockwidget.moc"
