
  

#ifndef KJSEMBED_QCanvasItemList_H
#define KJSEMBED_QCanvasItemList_H

#include <kjs/interpreter.h>
#include <kjs/object.h>

#include <kjsembed/jsobjectproxy_imp.h>

class QCanvasItemList;

/**
 * Namespace containing the KJSEmbed library.
 */
namespace KJSEmbed {

/**
 * Wrapper class for QCanvasItemList methods.
 *
 * @author Richard Moore, rich@kde.org
 */
class QCanvasItemListImp : public JSProxyImp
{
public:
   /** Enumerates the constructors supported by this class. */
   enum Constructors {

       LastConstuctor = -1
   };

   /** Enumerates the methods supported by this class. */
   enum Methods {

       Method_sort_1,
       Method_drawUnique_2,
       Method_Last = -1
   };

   QCanvasItemListImp( KJS::ExecState *exec, int id, bool constructor=false );
   ~QCanvasItemListImp();

   /**
    * Adds the static bindings for this class to the specified Object. The
    * static bindings are the static methods and the enums of this class.
    */
   static void addStaticBindings( KJS::ExecState *exec, KJS::Object &object );

   /**
    * Adds the bindings for this class to the specified Object. The bindings
    * added are the instance methods of this class.
    */
   static void addBindings( KJS::ExecState *exec, KJS::Object &object );

   static QCanvasItemList *toQCanvasItemList( KJS::Object &object );

   //
   // Constructors implemented by this class.
   //


   //
   // Methods implemented by this class.
   //

   KJS::Value sort_1( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );
   KJS::Value drawUnique_2( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args );

   //
   // JS binding code.
   //

   /** Returns true iff this object implements the construct function. */
   virtual bool implementsConstruct() const { return cons; }

   /** Invokes the construct function. */
   virtual KJS::Object construct( KJS::ExecState *exec, const KJS::List &args );

   /** Returns true iff this object implements the call function. */
   virtual bool implementsCall() const { return !cons; }

   /** Invokes the call function. */
   virtual KJS::Value call( KJS::ExecState *exec, KJS::Object &self, const KJS::List &args );

private:
   QCanvasItemList *instance; // Temp
   int id;
   bool cons;
};

} // namespace KJSEmbed

#endif // KJSEMBED_QCanvasItemList_H

// Local Variables:
// c-basic-offset: 4
// End:


