/*
 *      This program is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published by
 *      the Free Software Foundation; either version 2 of the License, or
 *      (at your option) any later version.
 *
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 *
 *      You should have received a copy of the GNU General Public License
 *      along with this program; if not, write to the Free Software
 *      Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */
#include <math.h>

#include <gtk/gtk.h>
#include "draw.h"
#include "def.h"

#define ANIMATIONS 16

/* position_targetzone: set the position (x,y) 
 * and dimension (w, h) of the first target 
 * zone. A target zone is a place where a player 
 * can drop a card by drag'n'droping.
 * This function is be called every time the 
 * size of the window changes.
 */
void position_targetzone(struct _prog *prog_data)
{
	
	if(prog_data->dropping != NULL)
	{
		int w, h;
		GList *lst = prog_data->dropping;
		
		struct _target *zone;
		
		if(prog_data->back)
		{
		
			gdk_drawable_get_size(prog_data->back, 
				&w, &h);
				
			if(lst)
			{
				zone = (struct _target *)lst->data;
				
				zone->dim.x = prog_data->area->allocation.width/2;
				zone->dim.y = prog_data->area->allocation.height/2;
				
				zone->dim.x -= w;
				zone->dim.y -= (2*h)/3;
				zone->dim.w = 2*w;
				zone->dim.h = (4*h)/3;
				
				zone->active = TRUE;
			}
		}
	}
}

/* position_move_card: moving a card from 
 * a position (x,y) to another, and make 
 * it like it's really happening.
 */
void position_move_card(struct _card *card, int x, int y, 
	struct _prog *prog_data)
{
	float difx, dify;
	int i;
	
	difx = card->dim.x - x;
	dify = card->dim.y - y;
	
	difx /= ANIMATIONS;
	dify /= ANIMATIONS;
	
	for(i = 0; i < ANIMATIONS; i++)
	{
		card->dim.x -= difx;
		card->dim.y -= dify;

		draw_container(prog_data);
	}
}

/* position_list: set the position (x,y) 
 * of each cards in a list.
 * See def.h file for more information 
 * about enum eposition
 */
void position_list(GList *ptr, 
	int x, int y, enum eposition ep, float coef, 
	struct _prog *prog_data)
{
	int incx, incy;
	int step;
	int num;
	
	int hspace = prog_data->area->allocation.width/25;
	int vspace = prog_data->area->allocation.height/20;
	
	struct _card *data_ptr;
	
	switch(ep)
	{
		case EP_DIAGONAL:
		incx = (int) floorf(coef);
		incy = (int) floorf(coef);
		step = 3;
		break;
		
		case EP_HORIZONTAL:
		incx = (int) floorf(hspace*coef);
		incy = 0;
		step = 1;
		break;
		
		case EP_VERTICAL:
		incx = 0;
		incy = (int) floorf(vspace*coef);
		step = 1;
		break;
	}
	
	for(num = 0;ptr; ptr = ptr->next)
	{
		data_ptr = (struct _card*) ptr->data;
		
		
		data_ptr->dim.x = x;
		data_ptr->dim.y = y;
		
		
		num++;
		
		if(num == step)
		{
			x += incx;
			y += incy;
			
			num = 0;
		}
			
	}
	
	
}

