/*
 *      This program is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published by
 *      the Free Software Foundation; either version 2 of the License, or
 *      (at your option) any later version.
 *
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 *
 *      You should have received a copy of the GNU General Public License
 *      along with this program; if not, write to the Free Software
 *      Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */
#include <string.h>
#include <gtk/gtk.h>
#include <glib/gi18n.h>
#include "callback.h"
#include "config.h"
#include "def.h"

/* interface_create: take cares of building the interface.
 * Please keep this function at the end of this file.
 */
void interface_create(struct _prog *prog_data)
{
	GtkWidget *fenetre;
	GtkWidget *vbox;
	GtkWidget *hbox;
	GtkWidget *button;
	GtkWidget *aire_de_dessin;
	GtkWidget *icon;
	GtkWidget *label_msg;
	GtkWidget *frame_game;
	GtkWidget *frame_pts;
	GtkWidget *table_game;
	GtkWidget *table_pts;
	GtkWidget *label_gamestat_left;
	GtkWidget *label_gameturn_left;
	GtkWidget *label_gametrump_left;
	GtkWidget *label_gamestat_right;
	GtkWidget *label_gameturn_right;
	GtkWidget *label_ptsleft;
	GtkWidget *label_ptsright;
	GtkWidget *vbox_pts;
	GtkWidget *vboxtable;
	GtkWidget *scrolling;
	GtkWidget *hboxfamily;
	GtkWidget *table_annonces;
	GtkWidget *vbox_annonces;
	GtkWidget *frame_annonces;
	GtkWidget *vboxmenu;
	
	char *iconfile = (char*) g_malloc(sizeof(gchar)*strlen(DATA_DIR)+20 );
	
	if(iconfile)
		g_sprintf(iconfile, "%s/belooted.png", DATA_DIR);
	
	prog_data->allwidgets = (GtkWidget **) g_malloc(sizeof(GtkWidget *)* 22);
	
	if(prog_data->allwidgets != NULL)
	{
		fenetre = gtk_window_new(GTK_WINDOW_TOPLEVEL);
		gtk_window_set_title( GTK_WINDOW(fenetre), _("Belooted") );
		
		if(g_file_test(iconfile, G_FILE_TEST_EXISTS)  )
			gtk_window_set_icon_from_file(GTK_WINDOW(fenetre), iconfile, NULL);
		
		
		vboxmenu = gtk_vbox_new(FALSE, 0);
		
		gtk_container_add( GTK_CONTAINER(fenetre), vboxmenu);
		

		hbox = gtk_hbox_new(FALSE, 0);
		gtk_box_pack_start(GTK_BOX(vboxmenu), hbox, TRUE, TRUE, 0);
		
		aire_de_dessin = gtk_drawing_area_new();
		gtk_box_pack_start(GTK_BOX(hbox), aire_de_dessin, TRUE, TRUE, 2);
		
		gtk_widget_set_size_request( aire_de_dessin, 450, 420);
		
		vbox = gtk_vbox_new(FALSE, 0);
		
		gtk_box_pack_start(GTK_BOX(hbox), vbox, FALSE, TRUE, 2);
		
		gtk_container_set_border_width(GTK_CONTAINER(vbox), 4);
		
		
		frame_game = gtk_frame_new( _("Round") );
		
		gtk_frame_set_label_align(GTK_FRAME(frame_game), 0.5, 0.5);
		
		gtk_box_pack_start(GTK_BOX(vbox), frame_game, FALSE, TRUE, 2);
		
		gtk_frame_set_shadow_type(GTK_FRAME(frame_game), GTK_SHADOW_ETCHED_IN);
		
		table_game = gtk_table_new(3, 2, FALSE);
		
		gtk_container_add( GTK_CONTAINER(frame_game), table_game);
		
		gtk_container_set_border_width(GTK_CONTAINER(table_game), 20);
		
		gtk_table_set_col_spacings(GTK_TABLE(table_game), 20);
		gtk_table_set_row_spacings(GTK_TABLE(table_game), 5);
		
		
		
		label_gamestat_left = gtk_label_new( _("Master:") );
		label_gametrump_left = gtk_label_new( _("Trump:") );
		label_gameturn_left = gtk_label_new( _("Turn:") );
		
		gtk_misc_set_alignment(GTK_MISC(label_gamestat_left), 1, 0.5);
		gtk_misc_set_alignment(GTK_MISC(label_gameturn_left), 1, 0.5);
		gtk_misc_set_alignment(GTK_MISC(label_gametrump_left), 1, 0.5);
		
		gtk_table_attach_defaults(GTK_TABLE(table_game),
			label_gameturn_left, 
			/*left, right, top, bot*/ 0, 1, 0, 1);
		
		gtk_table_attach_defaults(GTK_TABLE(table_game),
			label_gametrump_left, 
			0, 1, 1, 2);
		
		gtk_table_attach_defaults(GTK_TABLE(table_game),
			label_gamestat_left, 
			0, 1, 2, 3);
		
		
		icon = gtk_image_new();
		
		gtk_widget_set_size_request(icon, 16, 16);
		
		gtk_misc_set_alignment(GTK_MISC(icon), 0, 0.5);
		
		
		label_gamestat_right = gtk_label_new( _("N/a") );
		label_gameturn_right = gtk_label_new( _("None") );
		
		gtk_misc_set_alignment(GTK_MISC(label_gamestat_right), 0, 0.5);
		gtk_misc_set_alignment(GTK_MISC(label_gameturn_right), 0, 0.5);
		
		gtk_table_attach_defaults(GTK_TABLE(table_game),
			label_gameturn_right, 
			1, 2, 0, 1);
		
		gtk_table_attach_defaults(GTK_TABLE(table_game),
			icon, 
			 1, 2, 1, 2);
		
		gtk_table_attach_defaults(GTK_TABLE(table_game),
			label_gamestat_right, 
			1, 2, 2, 3);
		
		
		frame_annonces = gtk_frame_new( _("Game Score") );
		
		gtk_frame_set_label_align(GTK_FRAME(frame_annonces), 0.5, 0.5);
		
		gtk_box_pack_start(GTK_BOX(vbox), frame_annonces, TRUE, TRUE, 2);
		
		gtk_frame_set_shadow_type(GTK_FRAME(frame_annonces), GTK_SHADOW_ETCHED_IN);
		
		vbox_annonces = gtk_vbox_new(FALSE, 2);
		
		gtk_container_add( GTK_CONTAINER(frame_annonces), vbox_annonces);
		
		gtk_container_set_border_width(GTK_CONTAINER(vbox_annonces), 5);
		
		table_annonces = gtk_table_new(4, 2, TRUE);
		
		gtk_table_set_col_spacings(GTK_TABLE(table_annonces), 5);
		gtk_table_set_row_spacings(GTK_TABLE(table_annonces), 10);
		
				
		gtk_box_pack_start(GTK_BOX(vbox_annonces), table_annonces, FALSE, TRUE, 5);
		
		
		gtk_table_attach_defaults(GTK_TABLE(table_annonces),
			gtk_label_new( _("You") ), 
			0, 1, 0, 1);
		
		gtk_table_attach_defaults(GTK_TABLE(table_annonces),
			gtk_label_new( _("Computer") ), 
			1, 2, 0, 1);

		prog_data->allwidgets[20] = gtk_label_new(NULL);
		prog_data->allwidgets[21] = gtk_label_new(NULL);
		gtk_table_attach_defaults(GTK_TABLE(table_annonces),
			prog_data->allwidgets[20], 
			0, 1, 1, 2);
		
		gtk_table_attach_defaults(GTK_TABLE(table_annonces),
			prog_data->allwidgets[21], 
			1, 2, 1, 2);
		
		prog_data->allwidgets[18] = gtk_label_new(NULL);
		prog_data->allwidgets[19] = gtk_label_new(NULL);
		gtk_table_attach_defaults(GTK_TABLE(table_annonces),
			prog_data->allwidgets[18], 
			0, 1, 2, 3);
		
		gtk_table_attach_defaults(GTK_TABLE(table_annonces),
			prog_data->allwidgets[19], 
			1, 2, 2, 3);
		
		label_ptsleft = gtk_label_new(NULL);
		label_ptsright = gtk_label_new(NULL);
		gtk_table_attach_defaults(GTK_TABLE(table_annonces),
			label_ptsleft, 
			0, 1, 3, 4);
		
		gtk_table_attach_defaults(GTK_TABLE(table_annonces),
			label_ptsright, 
			1, 2, 3, 4);
		
		
		
		/* ------------------ Game score part */
		
		vbox_pts = gtk_vbox_new(FALSE, 2);
		
		gtk_box_pack_start( GTK_BOX(vbox_annonces), vbox_pts, TRUE , TRUE, 2);
		
		table_pts = gtk_table_new(0, 2, TRUE);

		
		scrolling = gtk_scrolled_window_new(
			NULL, NULL);
		
		gtk_box_pack_start( GTK_BOX(vbox_pts), 
			scrolling, TRUE, TRUE, 2 );
		
		gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrolling), 
			GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);
		
		vboxtable = gtk_vbox_new(FALSE, 2);
		
		gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(scrolling), vboxtable);
		
		
		gtk_box_pack_start(GTK_BOX(vboxtable), table_pts, FALSE, TRUE, 2);
		
		
		gtk_container_set_border_width(GTK_CONTAINER(table_pts), 10);
		
		gtk_table_set_col_spacings(GTK_TABLE(table_pts), 5);
		gtk_table_set_row_spacings(GTK_TABLE(table_pts), 5);
		
		
		
		
		
		
		
		
		label_msg = gtk_label_new(NULL);
		
		gtk_box_pack_start(GTK_BOX(vbox_annonces), label_msg, FALSE, FALSE, 2);
		

		
		
		
		
		/* -------------------- Bottom Part */
		
		
		
		
		hboxfamily = gtk_hbox_new(TRUE, 2);
		
		gtk_box_pack_start(GTK_BOX(vbox), hboxfamily, FALSE, TRUE, 2);
		

		prog_data->allwidgets[10] = gtk_button_new();
		prog_data->allwidgets[11] = gtk_button_new();
		prog_data->allwidgets[12] = gtk_button_new();
		prog_data->allwidgets[13] = gtk_button_new();
		
		gtk_box_pack_start(GTK_BOX(hboxfamily), 
			prog_data->allwidgets[10],
			FALSE, TRUE, 2);
		gtk_box_pack_start(GTK_BOX(hboxfamily), 
			prog_data->allwidgets[11],
			FALSE, TRUE, 2);
		gtk_box_pack_start(GTK_BOX(hboxfamily), 
			prog_data->allwidgets[12],
			FALSE, TRUE, 2);
		gtk_box_pack_start(GTK_BOX(hboxfamily), 
			prog_data->allwidgets[13],
			FALSE, TRUE, 2);


		prog_data->allwidgets[14] = gtk_image_new();
		prog_data->allwidgets[15] = gtk_image_new();
		prog_data->allwidgets[16] = gtk_image_new();
		prog_data->allwidgets[17] = gtk_image_new();
		

		gtk_container_add( GTK_CONTAINER(prog_data->allwidgets[10]), prog_data->allwidgets[14]);
		gtk_container_add( GTK_CONTAINER(prog_data->allwidgets[11]), prog_data->allwidgets[15]);
		gtk_container_add( GTK_CONTAINER(prog_data->allwidgets[12]), prog_data->allwidgets[16]);
		gtk_container_add( GTK_CONTAINER(prog_data->allwidgets[13]), prog_data->allwidgets[17]);

		
		button= gtk_button_new_with_label( _("Start") );
		gtk_widget_set_sensitive(button, FALSE);
		
		gtk_box_pack_start(GTK_BOX(vbox), button, FALSE, TRUE, 2);
		
		
		
		/* ----------------------- Signals */
		
		g_signal_connect( G_OBJECT(fenetre), "destroy", G_CALLBACK(quit), prog_data );
		g_signal_connect( G_OBJECT(fenetre), "check_resize", G_CALLBACK(resize), prog_data );
		
		
		
		g_signal_connect( G_OBJECT(prog_data->allwidgets[10]), "clicked", G_CALLBACK(click_diamond), prog_data);
		g_signal_connect( G_OBJECT(prog_data->allwidgets[11]), "clicked", G_CALLBACK(click_spade), prog_data);
		g_signal_connect( G_OBJECT(prog_data->allwidgets[12]), "clicked", G_CALLBACK(click_heart), prog_data);
		g_signal_connect( G_OBJECT(prog_data->allwidgets[13]), "clicked", G_CALLBACK(click_club), prog_data);
		
		g_signal_connect( G_OBJECT(button), "clicked", G_CALLBACK(event_start), prog_data);
		
		g_signal_connect( G_OBJECT(aire_de_dessin), "realize", G_CALLBACK(realisation), prog_data );
		g_signal_connect( G_OBJECT(aire_de_dessin), "expose_event", G_CALLBACK(rafraichissement), prog_data );

		gtk_widget_add_events(aire_de_dessin, GDK_BUTTON_PRESS_MASK | GDK_BUTTON_RELEASE_MASK | GDK_BUTTON_MOTION_MASK );

		g_signal_connect(G_OBJECT(aire_de_dessin), "button_press_event", G_CALLBACK(button_press_event), prog_data);
		g_signal_connect(G_OBJECT(aire_de_dessin), "button_release_event", G_CALLBACK(button_release_event), prog_data);

		g_signal_connect(G_OBJECT(aire_de_dessin), "motion_notify_event", G_CALLBACK(motion_notify_event), prog_data);
		
		g_signal_connect( G_OBJECT(fenetre), "key_press_event", G_CALLBACK(key_down), prog_data );
		
		
		/* ---------------------------- Pointers */
		
		
		prog_data->allwidgets[0] = fenetre;
		prog_data->allwidgets[1] = scrolling;
		prog_data->allwidgets[2] = button;
		prog_data->allwidgets[3] = label_ptsleft;
		prog_data->allwidgets[4] = label_ptsright;
		prog_data->allwidgets[5] = icon;
		prog_data->allwidgets[6] = label_msg;
		prog_data->allwidgets[7] = label_gamestat_right;
		prog_data->allwidgets[8] = label_gameturn_right;
		prog_data->allwidgets[9] = table_pts;
		
		
		prog_data->area = aire_de_dessin;
	}
	
	
}
