/*
 *      This program is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published by
 *      the Free Software Foundation; either version 2 of the License, or
 *      (at your option) any later version.
 *
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 *
 *      You should have received a copy of the GNU General Public License
 *      along with this program; if not, write to the Free Software
 *      Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */
#include <gtk/gtk.h>
#include "def.h"

/* free_generic_list : takes care 
 * of freeing memory of a entire list.
 * Don't forget to free the data 
 * slot first.
 */
void free_generic_list(GList **ptrlist)
{
	GList *ptr;
	
	for(ptr = *ptrlist; ptr; ptr = ptr->next)
	{
		g_free(ptr->data);
		ptr->data = NULL;
	}
	
	if(*ptrlist)
		g_list_free(*ptrlist);
	*ptrlist = NULL;
}


void free_cell_list(GList **ptrlist)
{
	GList *ptr;
	
	GtkWidget *cell;
	
	for(ptr = *ptrlist; ptr; ptr = ptr->next)
	{
		cell = (GtkWidget*)ptr->data;
		gtk_widget_destroy(GTK_WIDGET(cell));
		ptr->data = NULL;
	}
	
	if(*ptrlist)
	g_list_free(*ptrlist);
	*ptrlist = NULL;
}
/* free_list : this is like only 
 * usefull for the GList called 
 * "all", which is defined in the 
 * struct _prog (see file def.h 
 * for more details).
 * That's because we need to 
 * unref the data pointer on 
 * each element of the list 
 * before freeing it.
 */
void free_list(GList **ptrlist)
{
	GList *ptr;
	struct _card *data_ptr;
	
	for(ptr = *ptrlist; ptr; ptr = ptr->next)
	{
		data_ptr = ptr->data;
		
		g_object_unref(data_ptr->img);
		g_free(data_ptr);
		ptr->data = NULL;
	}
	
	if(*ptrlist)
	g_list_free(*ptrlist);
	*ptrlist = NULL;
}

void free_blink(GList *lst)
{
	struct _card *data;
	while(lst)
	{
		data =(struct _card*) lst->data;
		
		if(data->blink == TRUE)
		{
			g_object_unref(data->img);
			data->img = NULL;
		}
		lst = lst->next;
	}
}

/* free_clear : called when we need to
 * restart a game. That's related to 
 * what is allocated during or before 
 * a round.
 * 
 * That's just composed by many 
 * g_list_free to clear some GList.
 * 
 * The only exception is the 
 * movecard at the end. That correspond 
 * to the struct _movingcard (see def.h 
 * file for more details).
 */
void free_clear(struct _prog *prog_data)
{
	int i;
	
	if(prog_data->pile)
		g_list_free(prog_data->pile);
	prog_data->pile = NULL;
	
	if(prog_data->waiting)
	{
		g_list_free(prog_data->waiting);
	}
	prog_data->waiting = NULL;
	
	if(prog_data->players != NULL)
	{
		for(i = 0; i < 4; i++)
		{
			if(prog_data->players[i])
				g_list_free(prog_data->players[i]);
			
			prog_data->players[i] = NULL;
		}
	}
	if(prog_data->teams != NULL)
	{
		for(i = 0; i < 2; i++)
		{
			if(prog_data->teams[i])
			{
				g_list_free(prog_data->teams[i]);
			}
			prog_data->teams[i] = NULL;
		}
	}
	
	if(prog_data->movecard)
		g_free(prog_data->movecard);
	
	prog_data->movecard = NULL;
}

/* free_prog : clear everything, 
 * we just want to quit the program.
 */
void free_prog(struct _prog *prog_data)
{
	if(prog_data->output)
		fprintf(prog_data->output, "Quit..\n");
	free_clear(prog_data);
		
	g_free(prog_data->allwidgets);

	g_free(prog_data->players);
	
	g_free(prog_data->teams);
	
	if(prog_data->cells)
		g_list_free(prog_data->cells);
	
	if(prog_data->icons != NULL)
	{
		int i;
		for(i = 0; i< 5; i++)
		{
			if(prog_data->icons[i] != NULL)
			g_object_unref(prog_data->icons[i]);
		}
		
		g_free(prog_data->icons);
	}

	if(prog_data->player_names)
		g_strfreev(prog_data->player_names);

	free_list(&prog_data->all);
	
	free_generic_list(&prog_data->dropping);
}
