#ifndef __DEF_H__
#define __DEF_H__

#include <gtk/gtk.h>

/* enum eposition : how to position a 
 * list of cards.
 */
enum eposition {EP_DIAGONAL, EP_HORIZONTAL, EP_VERTICAL};


/* struct _dim : x,y to position 
 * something on the game area. 
 * Warning: remember that the x axis 
 * is positionned at the top of 
 * the area. This means an increment 
 * of 1 in the y value will go down, 
 * not up.
 * 
 * h is for the height, w for width.
 */
struct _dim
{
	gint x;
	gint y;
	gint h;
	gint w;
};

/* enum estatus: state of a card. 
 * NA: Not disponible in this type of game. 
 * A: Ready to be distributed.
 * D: Already distributed.
 */
enum estatus {NOTAVAILABLE, AVAILABLE, DISTRIBUTED};

/* enum egstate : state of the game right 
 * now. What needs to be done on a click ?
 * It depends mainly of this.
 * Feel free to add as many state as 
 * you think you will need.
 * See function action_click() for 
 * more details.
 */
enum egstate {LOADING, DISTRIBUTING, PLAYING, WAITING, 
	READY_PILE, EGS_SECOND, 
		READY_DISTRIB1, READY_DISTRIB2, ENDGAME};

/* struct _card: each card in the game.
 * (There are 52 cards atm, but only 32 
 * are used) Each card has one and only 
 * struct _card attached to it.
 * 
 * GdkPixmap *img: an image 
 * struct _dim dim: a position and dimension
 * gint family: it's a color
 *  ->0 diamond
 *  ->1 spade
 *  ->2 heart
 *  ->3 club
 * gint num: 0->12 type of the card
 * 	(0 is Ace, 1 is 2, ..., 12 is King)
 * gint points: how many points it is worth
 *  Note: it depends on the trump family
 * enum estatus status: State of the card
 * gboolean draw: should it be drawn to the game area
 * gboolean draw_face: should we draw the card value, or
 *  hide it and show the back of the card instead.
 * gboolean moveable: is it any useful to move it around
 */
struct _card
{
	GdkPixmap *img;
	struct _dim dim;
	gint family;
	gint num;
	gint points;
	enum estatus status;
	gboolean draw;
	gboolean draw_face;
	gboolean moveable;
	gboolean blink;
};

/* struct _moving card: it's a memory 
 * zone allocated in case of dragging 
 * a card around in the game area.
 * If the user do so, we need to draw 
 * the card moving as we move the mouse, 
 * but also keep the original position 
 * of the card (before it was moved).
 * 
 * This is what this struct _movingcard 
 * is all about.
 * 
 * struct _card *card: is a pointer 
 * to the struct _card of this card.
 * This contains original position.
 * 
 * struct _dim dim: this is the actual 
 * position of the card at the eye 
 * of the user dragging it around.
 */
struct _movingcard
{
	struct _card *card;
	struct _dim dim;
};

/* Keep tracks of sequence of cards (ex: 7, 8, 9) */
struct _sequence 
{
	/* the higher card num in the sequence */
	int hinum;
	
	int family;
	
	int points;
};

/* struct _target : it's a rectangle 
 * on the game area where the user 
 * can drop a card.
 * There's only one at the moment 
 * representing the table at the 
 * center of the game area.
 * 
 * Should be better used in the 
 * future. (Only one target zone atm)
 */
struct _target
{
	struct _dim dim;
	gboolean active;
};

/* struct _prog : the main component 
 * of the program. 
 */
struct _prog
{
	/* -------------------- */
	/* - all those GList contains a struct _card 
	 * data pointer in it - */
	
	/* - All Cards loaded - */
	GList *all;
	/* - The Pile of cards not yet distributed - */
	GList *pile;
	/* - Tab of four cell containing each a pointer 
	 * - to each player hand - */
	GList **players;
	/* - Each teams wins a pile of cards, there 
	 * - they are. - */
	GList **teams;
	/* - When cards are waiting in the middle of 
	 * - the table to be winned by one of the teams - */
	GList *waiting;	
	/* -------------------- */
	
	
	/* Contains a struct _target data pointer */
	GList *dropping;
	
	/* cell widget for GtkTable where points are displayed */
	GList *cells;
	
	/* the only card which is dragged 
	 * around at the moment */
	struct _movingcard *movecard;
	
	
	/* Array of 4 cells, corresponding 
	 * to each family icon (images). */
	GdkPixbuf **icons;
	/* This is the image of the back 
	 * of cards. This is the only one 
	 * image for every card. */
	GdkPixmap *back;
	
	
	
	/* target is where everything is 
	 * drawn to. When it's done, target 
	 * is blitted to the screen.
	 * This makes refresh smoother/faster */
	GdkPixmap *target;

	GdkPixmap *copy;
	
	/* backmask is the mask corresponding 
	 * to the back GdkPixmap declared 
	 * earlier. */
	GdkBitmap *backmask;
	
	/* cardmask : mask corresponding to 
	 * every card face. See file mask.xbm 
	 * as text or image to get an idea. */
	GdkBitmap *cardmask;
	
	
	
	/* Those two are needed in the program 
	 * but should be deleted and replaced 
	 * by the allwidgets cell corresponding 
	 * to the widget. See the following 
	 * comment to know more about 
	 * allwidgets array. */
	GtkWidget *area;
	
	
	
	/* Array of all GtkWidget* available 
	 * to the programmer. 
	 * See file main.c to add a new cell 
	 * (that's just modifying a number 
	 * passed to interface_create() 
	 * function). Then edit the interface.c 
	 * file to edit the gui, adding your 
	 * widget to it. Then save the pointer 
	 * to the newly created widget into 
	 * one of this allwidgets array. 
	 * 
	 * See at the end of the interface.c 
	 * file to know what cell correspond 
	 * to what widget.
	 */
	GtkWidget **allwidgets;
	
	
	
	/* State of the game right now. */
	enum egstate state;
	
	
	
	
	/* Who has the pile now and should distribute 
	 * cards to other players. This is needed to 
	 * know which player is playing first. It's a 
	 * random number on the first run, and then 
	 * it's incremented after each round (when 
	 * a team wins or if no ones takes the 
	 * proposed card) */
	int distributer;
	
	
	/* Who has taken the proposed card on the beginning 
	 * of this round. */
	int master;
	
	
	/* Who should drop the first card on this turn only */
	int hashand;
	
	
	/* Who dropped the most powerful card on the table 
	 * at the moment. This is updated everytime someone 
	 * drop a card. It's also the player who plays 
	 * first on the next turn. */
	int menext;
	
	
	/* Who should play now. This is bugged at 
	 * the moment so don't rely on it. */
	int player;
	
	
	/* Which family is the trump on this round. */
	int family;
	
	
	/* Current turn in this round. */
	int turn;
	
	int row;
	
	int points[2];
	int declarations[2];
	int belote;
	int report;
	
	/* for debug message. Default is stdout.
	 * Edit file main.c to change the default. */
	FILE *output;
	
	/* Animate card deplacement (from a player 
	 * hand to the middle of the game area, 
	 * representing the table). */
	gboolean animation;
	
	/* enable declarations points */
	gboolean withdeclaration;
	
	
	/* to know if we need to hide some cards on a click, 
	 * when showing declarations of other players. */
	gboolean hide;
	
	/* does a click on a card drops it 
	 * otherwise the player have to drag the card to the 
	 * target zone */
	gboolean no_drag;
	
	
	/* Multiplier for space between cards on all hands */
	float space;
	
	/* Player names */
	gchar **player_names;
	
	int blinkid;
};

#endif
