/* AbiSource
 * 
 * Copyright (C) 2002 Dom Lachowicz <cinamod@hotmail.com>
 * Copyright (C) 2004 Robert Staudinger <robsta@stereolyzer.net>
 * Copyright (C) 2005 Daniel d'Andrada T. de Carvalho
 * <daniel.carvalho@indt.org.br>
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  
 * 02111-1307, USA.
 */


#ifndef _OO_STYLE_H_
#define _OO_STYLE_H_


#include <pd_Style.h>



/**
 * Class representing any and all OO styles
 * maps from OO->Abi styles. Used for at least 
 * all Abi section, paragraph, and span styles
 */
class OO_Style 
{
public:
  
    OO_Style (const XML_Char** ppProps, const PD_Style* pParentStyle);
    
    OO_Style (const OO_Style* pOther,
              const XML_Char** ppProps,
              PD_Style* pParentStyle);
  
    ~OO_Style () {}
  
    const XML_Char* getAbiStyle () const
    {
        return reinterpret_cast<const XML_Char *>(m_styleProps.c_str());
    }
  
    /**
     * Paragraph style, generate a column break before
     * creating a paragraph in this style
     */
    bool getColBreakBefore () const { return m_bColBreakBefore; }

    bool getPageBreakBefore () const { return m_bPageBreakBefore; }

    void parse (const XML_Char** ppProps);

private:

    OO_Style (); // no impl

    UT_String m_align;
    UT_String m_fontWeight;
    UT_String m_fontStyle;
    UT_String m_color;
    UT_String m_bgcolor;
    UT_String m_fontName;
    UT_String m_fontSize;
    UT_String m_lang;
    UT_String m_textPos;
    UT_String m_textDecoration;
    UT_String m_marginLeft;
    UT_String m_marginTop;
    UT_String m_marginRight;
    UT_String m_marginBottom;
    UT_String m_lineHeight;
    UT_String m_keepWithNext;
    UT_String m_keepTogether;
    UT_String m_widows;
    UT_String m_orphans;
    UT_String m_columns;
  
    UT_String m_styleProps;

    bool m_bColBreakBefore;
    bool m_bPageBreakBefore;
    const PD_Style* m_pParentStyle;

}; // class OO_Style

#endif //_OO_STYLE_H_
