/* AbiSource
 * 
 * Copyright (C) 2002 Dom Lachowicz <cinamod@hotmail.com>
 * Copyright (C) 2004 Robert Staudinger <robsta@stereolyzer.net>
 * Copyright (C) 2005 Daniel d'Andrada T. de Carvalho
 * <daniel.carvalho@indt.org.br>
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  
 * 02111-1307, USA.
 */

#ifndef _OD_TEXTCONTENT_LISTENERSTATE_H_
#define _OD_TEXTCONTENT_LISTENERSTATE_H_

// Internal includes
#include "OD_ListenerState.h"

// AbiWord includes
#include <ut_types.h>
#include <ut_stack.h>
#include <ut_IntStrMap.h>

// External includes
#include <gsf/gsf.h>

// Internal classes
class OD_Office_Styles;
class OD_Style_List;
class OD_TableOfContent_ListenerState;

// AbiWord classes
class PD_Document;
class pf_Frag_Strux;

/**
 * It parses the regular content of a text document. It is used to parse the
 * document text body itself (<office:text>) and the contents of headers
 * (<style:header>) and footers (<style:footer>).
 * 
 * Regular text content may have the following main elements (that is, not
 * mentioning their child elements):
 * <text-h>
 * <text-p>
 * <text-list>
 * <table-table>
 * <text-section>
 * <text-table-of-content>
 * <text-illustration-index>
 * <text-table-index>
 * <text-object-index>
 * <text-user-index>
 * <text-alphabetical-index>
 * <text-bibliography>
 * <text-index-title>
 * <change-marks>
 */
class OD_TextContent_ListenerState : public OD_ListenerState {

public:

    OD_TextContent_ListenerState (
        PD_Document* pDocument,
        OD_Office_Styles* pStyles,
        OD_ElementStack& rElementStack);
        
    virtual ~OD_TextContent_ListenerState();

    void startElement (const XML_Char* pName, const XML_Char** ppAtts,
                       OD_ListenerStateAction& rAction);
                       
    void endElement (const XML_Char* pName, OD_ListenerStateAction& rAction);
    
    void charData (const XML_Char* pBuffer, int length);
    
private:

    void _insertBookmark (const XML_Char * name, const XML_Char * type);
    void _flush ();
    void _startParagraphElement (const XML_Char* pName,
                                 const XML_Char** ppParagraphAtts,
                                 OD_ListenerStateAction& rAction);
    bool _pushInlineFmt(const XML_Char** ppAtts);
    void _popInlineFmt(void);
    void _insureInBlock(const XML_Char ** atts);
    void _insureInSection(const XML_Char* pProps = NULL);
    void _defineAbiTOCHeadingStyles();

    PD_Document* m_pAbiDocument;
    OD_Office_Styles* m_pStyles;

    bool m_bInSection;
    bool m_bAcceptingText;
    bool m_addedMasterPageSectionProps;

    UT_GenericVector<XML_Char*> m_vecInlineFmt;
    UT_NumberStack m_stackFmtStartIndex;
    
    UT_sint8 m_elementParsingLevel;

	// Buffer that stores character data defined between start and end element
	// tags. e.g.: <bla>some char data</bla>
    UT_UCS4String m_charData;

    /**
     * In OpenDocument, <text:h> elements along the text defines the document
     * chapter's structure. So, we must get the styles used by those <text:h>
     * for each content level in order to set AbiWord's <toc> properties
     * correctly.
     */
    // It's weird, but a document may actually have several TOCs.
    UT_GenericVector<pf_Frag_Strux*> m_tablesOfContent;
    UT_GenericVector<UT_UTF8String*> m_tablesOfContentProps;
    // Maps a heading level with its style name
    // e.g.: "1" -> "Heading_20_1"
    UT_UTF8Hash m_headingStyles;
    OD_TableOfContent_ListenerState* m_pCurrentTOCParser;

    // Valued as "true" if it is parsing XML content inside a
    // <office:document-content> tag.
    bool m_bOnContentStream;
    
    // List info
    OD_Style_List* m_pCurrentListStyle;
    UT_uint8 m_listLevel;
    bool m_alreadyDefinedAbiParagraphForList;
    
    // Stuff for footnotes and endnotes.
    bool m_pendingNoteAnchorInsertion;
    UT_UTF8String m_currentNoteId;
};

#endif //_OD_TEXTCONTENT_LISTENERSTATE_H_
