/***************************************************************************
                          napstertransfer.cpp  -  description
                             -------------------
    begin                : Sat Jan 22 2000
    copyright            : (C) 2000 by John Donoghue
    email                : donoghue@chariot.net.au
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "napstertransfer.h"

//TODO #include "propertiesdlg.h"
/*
 * the base class for transfers
 *
 * contains the locking and basic functionality
 */
NapsterTransfer::NapsterTransfer(unsigned long ip,int port,const char *filename,
        const char *user,int speed,const char *dest,bool isdownload)
: EZThread()
{
  _downloadtype = isdownload;
   
   _connected=false;

   _readsize=0;
   _totalsize=0;
   _status=DL_QUEUED;

   _terminate=false;

   _user=user;
   _speed=speed;
   _filename=filename;

   _destname=dest;

   _starttime=0;

   _timeoutval = 9; //TODO PropertiesDlg::readPrefs().downloadtimeout;

   memset(&_sockaddr,0,sizeof(_sockaddr));
   _sockaddr.sin_family = AF_INET;
   _sockaddr.sin_port = htons(port);
   _sockaddr.sin_addr.s_addr = ip;

   _bps = 0;
   _oldreadsize = 0;


   //QString s="";
   struct in_addr in;

   //  if(_napster)
   //     //  {
   in.s_addr = ip; //_napster->ipv4_addr();
   _address = inet_ntoa(in); 

   _port = port;

}
NapsterTransfer::~NapsterTransfer()
{
}
bool NapsterTransfer::cancel()
{
   down();
   _terminate=true;
   // if(_status==DL_QUEUED)
   _status=DL_KILLED;
   up();

   return true;
}

//bool NapsterTransfer::getInfo(long *status,long *red,long *total,long *bps)
bool NapsterTransfer::getInfo(long *status,long *red,long *total,long *bps, long *timeleft)
{
   down();

   if(status) *status=_status;
   if(red) *red=_readsize;
   if(total) *total=_totalsize;

   if(bps) 
   {
      *bps=0;

      time_t currtime;
      time(&currtime); // set the start time
      //    if(_starttime!=0) {
      //      currtime=currtime-_starttime; // number of elased seconds

      if(_starttime!=0) 
      { //changed
	 time_t elasedtime=currtime-_starttime; // number of elased seconds

	 //      if(currtime<1) currtime=1;

	 //       *bps=_readsize/currtime;
	 //     }
	 //if(elasedtime<1) elasedtime=1;
	 if(elasedtime<5) 
	 {
	    *bps=_bps;
	 }
	 else 
	 {
	    _starttime = currtime;
	    _bps=(_readsize-_oldreadsize)/elasedtime;
	    *bps=_bps;
	    _oldreadsize = _readsize;
	 }
      }
   } 

   if (timeleft) 
   {
      if (_bps==0) {
	 *timeleft=-1;
      }
      else {
	 *timeleft=(_totalsize-_readsize)/_bps;
      }
   }

   up();

   return true;
}
