/*
    GQ -- a GTK-based LDAP client
    Copyright (C) 1998-2001 Bert Vermeulen

    This program is released under the Gnu General Public License with
    the additional exemption that compiling, linking, and/or using
    OpenSSL is allowed.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


struct jumptable {
     char *jumpstring;
     void *jumpfunc;
};


void create_form_window(GHashTable *hash);
void create_form_content(GHashTable *hash);
void build_inputform(GHashTable *hash);
void edit_entry(struct ldapserver *server, char *dn);
void new_from_entry(struct ldapserver *server, char *dn);
void update_formlist(GHashTable *hash);
void clear_table(GHashTable *hash);
void add_entry_from_formlist(GHashTable *hash);
void mod_entry_from_formlist(GHashTable *hash);
int change_rdn(GHashTable *hash, int context);
LDAPMod **formdiff_to_ldapmod(GList *oldlist, GList *newlist);
char **glist_to_mod_values(GList *values);
int find_value(GList *list, char *value);
void destroy_editwindow(GHashTable *hash);
void add_row(GtkWidget *button, gpointer hash);
GtkWidget *gq_new_arrowbutton(GHashTable *hash);
GtkWidget *find_focusbox(GtkTable *table);
void change_displaytype(GtkWidget *button, gpointer hash);
