/***************************************************************************/
/* 		This code is part of WWW grabber called pavuk		   */
/*		Copyright (c) 1997 - 2001 Stefan Ondrejicka		   */
/*		(ondrej@idata.sk)					   */
/*		Distributed under GPL 2 or later			   */
/***************************************************************************/

#include <stdlib.h>
#include <locale.h>

#include "config.h"
#include "tools.h"
#include "gui.h"

void init_locale_env()
{
	char *lang;
	char *lc_messages;
	char *lc_all;
	char *lc_ctype;
	char *l = NULL;

	lang = new_string(getenv("LANG"));
	lc_all = new_string(getenv("LC_ALL"));
	lc_messages = new_string(getenv("LC_MESSAGES"));
	lc_ctype = new_string(getenv("LC_CTYPE"));

	if (lc_all) unsetenv("LC_ALL");
	if (lang) unsetenv("LANG");
	if (lc_messages) unsetenv("LC_MESSAGES");
	unsetenv("LC_TIME");
	unsetenv("LC_NUMERIC");

	if (lc_messages) l = lc_messages;
	else if (lang) l = lang;
	else if (lc_all) l = lc_all;

	if (l) setenv("LC_MESSAGES" , l , TRUE);

	if (!lc_ctype)
	{
		if (lc_all) setenv("LC_CTYPE" , lc_all , TRUE);
		else if (lang) setenv("LC_CTYPE" , lang , TRUE);
	}

	setlocale(LC_CTYPE, "");

#ifdef GTK_FACE
	gdk_set_locale();
#endif

	_free(lang);
	_free(lc_messages);
	_free(lc_all);
	_free(lc_ctype);
}

