/* 
   SQL Auditing Tools
   Copyright (C) Patrik Karlsson 2001
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "util.h"

int fileExist(char *pFileName) {

  FILE *fd;

  if ( ( fd = fopen(pFileName, "r" ) ) != NULL ) {
    fclose(fd);
    return TRUE;
  }

  return FALSE;

}

int getNextItem(FILE *fd, char *item, int nLen) {

  memset(item, 0, nLen);
  
  if ( fgets(item, nLen, fd) != NULL ) {
    if ( ( item[strlen(item)-1] == '\n' ) ||
	 ( item[strlen(item)-1] == '\r' ) ) {
      memset(item+strlen(item)-1, 0, 2);
    } /* end if */

    return TRUE;
  } /* end outer if */
  
  return FALSE;

}

char *strrep(char *str, char find, char repl) {

  char *newStr;
  int nLen, i;

  nLen = strlen(str);
  newStr = (char *) malloc( nLen );
  strncpy(newStr, str, nLen);

  for ( i=0; i< nLen; i ++ ) {
    if ( newStr[i] == find )
      memset(newStr+i, repl, 1);
  }

  strcpy(str, newStr);
  free(newStr);

  return str;


}
