%{
/*	$Id: parse.y,v 1.8 2006/02/01 14:38:09 mbalmer Exp $	*/

#include <err.h>
#include <stdarg.h>
#include <stdio.h>
#include <syslog.h>

#if __linux__
#include <stdlib.h>
#endif

#if (__FreeBSD__ || __linux__)
#include "strtonum.h"
#endif

extern FILE	*yyin;
extern int	 yylineno;
extern char	*yytext;

extern char	*cfgfile;
extern char	*ldaphost;
extern int	 ldapport;
extern char	*ldapurl;
extern char	*searchbase;
extern char	*binddn;
extern char	*bindpasswd;
extern char	*spamheader;
extern char	*mailattr;
extern char	*query;
extern int	 ldap_use_tls;
extern int	 log_facility;

int	yyerror(const char *, ...);
int	yyparse(void);
int	yylex(void);
%}

%union {
	long number;
	char *string;
}

%token	LOGFAC LDAPHOST LDAPPORT LDAPURL BINDDN BINDPASSWD SEARCHBASE
%token	QUERY USETLS LOCAL0 LOCAL1 LOCAL2 LOCAL3
%token	LOCAL4 LOCAL5 LOCAL6 LOCAL7 TRUE FALSE COMMENT
%token	DAEMON MAIL USER MAIL SPAMHEADER
%token	<string>	NUMBER
%token	<string>	TEXT
%type	<number>	logfac

%%
statement	: /* empty */
		| statement '\n'
		| statement logfacility '\n'
		| statement ldaphost '\n'
		| statement ldapport '\n'
		| statement ldapurl '\n'
		| statement searchbase '\n'
		| statement query '\n'
		| statement binddn '\n'
		| statement bindpasswd '\n'
		| statement usetls '\n'
		| statement mail '\n'
		| statement spamheader '\n'
		;

ldaphost	: LDAPHOST '=' TEXT			{
			if (ldaphost == NULL)
				ldaphost = $3;
			else
				free($3);
		}
		;

ldapport	: LDAPPORT '=' NUMBER			{
			if (ldapport == -1) {
				const char *errstr;

				ldapport = strtonum($3, 1, 65535, &errstr);
				if (errstr)
					errx(1, "port number is %s:%s", errstr, $3);
			}
			free($3);
		}
		;

ldapurl		: LDAPURL '=' TEXT			{
			if (ldapurl == NULL)
				ldapurl = $3;
			else
				free($3);
		}
		;

searchbase	: SEARCHBASE '=' TEXT		{
			if (searchbase == NULL)
				searchbase = $3;
			else
				free($3);
		}
		;

query		: QUERY '=' TEXT		{
			if (query == NULL)
				query = $3;
			else
				free($3);
		}
		;

binddn		: BINDDN '=' TEXT		{
			if (binddn == NULL)
				binddn = $3;
			else
				free($3);

		}
		;

bindpasswd	: BINDPASSWD '=' TEXT		{
			if (bindpasswd == NULL)
				bindpasswd = $3;
			else
				free($3);
		}
		;

mail		: MAIL '=' TEXT		{
			if (bindpasswd == NULL)
				bindpasswd = $3;
			else
				free($3);
		}
		;

spamheader	: SPAMHEADER '=' TEXT		{
			if (spamheader == NULL && (*$3 == 'x' || *$3 == 'X'))
				spamheader = $3;
			else
				free($3);
		}
		;



logfacility	:	LOGFAC '=' logfac	{
				log_facility = $3;
		}
		;

logfac		:	LOCAL0		{ $$ = LOG_LOCAL0; }
		|	LOCAL1		{ $$ = LOG_LOCAL1; }
		|	LOCAL2		{ $$ = LOG_LOCAL2; }
		|	LOCAL3		{ $$ = LOG_LOCAL3; }
		|	LOCAL4		{ $$ = LOG_LOCAL4; }
		|	LOCAL5		{ $$ = LOG_LOCAL5; }
		|	LOCAL6		{ $$ = LOG_LOCAL6; }
		|	LOCAL7		{ $$ = LOG_LOCAL7; }
		|	DAEMON		{ $$ = LOG_DAEMON; }
		|	MAIL		{ $$ = LOG_MAIL; }
		|	USER		{ $$ = LOG_USER; }
		;
	
usetls		: USETLS '=' TRUE		{
			if (ldap_use_tls == -1)
				ldap_use_tls = 1;
		}
		| USETLS '=' FALSE		{
			if (ldap_use_tls == -1)
				ldap_use_tls = 0;
		}
		;
%%

void
ldapvacation_init(void)
{
	yylineno = 1;
	if ((yyin = fopen(cfgfile, "r")) != NULL) {
		while (!feof(yyin))
			yyparse();
		fclose(yyin);
	}
}

int
yyerror(const char *fmt, ...)
{
	va_list		 ap;
	char		*nfmt;

	va_start(ap, fmt);
	if (asprintf(&nfmt, "%s:%d: %s", cfgfile, yylineno, fmt) == -1)
		errx(1, "yyerror asprintf");
	va_end(ap);
	free(nfmt);
	return (0);
}
