#include "hydra-mod.h"
#include "crc32.h"

struct team_speak {
  char header[16];
  unsigned long crc;
  char clientlen;
  char client[29];
  char oslen;
  char os[29];
  char misc[10];
  char userlen;
  char user[29];
  char passlen;
  char pass[29];
  char loginlen;
  char login[29];
};

extern int hydra_data_ready_timed(int socket, long sec, long usec);

extern char *HYDRA_EXIT;
char *buf;

int start_teamspeak(int s, unsigned long int ip, int port, unsigned char options,
	   char *miscptr, FILE * fp) {
  char *empty = "";
  char *login, *pass; 
  char buf[100]; 
  struct team_speak teamspeak;

  if (strlen(login = hydra_get_next_login()) == 0)
    login = empty;
  if (strlen(pass = hydra_get_next_password()) == 0)
    pass = empty;

  memset(&teamspeak, 0, sizeof(struct team_speak));

  memcpy(&teamspeak.header, "\xf4\xbe\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01\x00\x00\x00", 16);

  teamspeak.clientlen = 9;
  strcpy((char *) &teamspeak.client, "TeamSpeak");

  teamspeak.oslen = 0x1d;
  strcpy((char *) &teamspeak.os, "Linux 2.6.9 #4 Tue Dec 21 15:");

  memcpy(&teamspeak.misc, "\x02\x00\x00\x00\x20\x00\x3c\x00\x01\x02", 10);

  teamspeak.userlen = strlen(login);
  strncpy((char *) &teamspeak.user, login, 29);

  teamspeak.passlen = strlen(pass);
  strncpy((char *) &teamspeak.pass, pass, 29);
 
  teamspeak.loginlen = 0;
  strcpy((char *) &teamspeak.login, "");

  teamspeak.crc = crc32(&teamspeak, sizeof(struct team_speak));

  if (hydra_send(s, (char *) &teamspeak, sizeof(struct team_speak), 0) < 0) {
    return 3;
  }

  if (hydra_data_ready_timed(s, 5, 0) > 0) {
    hydra_recv(s, (char *) buf, sizeof(buf));
    if ( buf[0x58] == 1 ) {
      hydra_report_found_host(port, ip, "teamspeak", fp);
      hydra_completed_pair_found();
    }
  }

  hydra_completed_pair();
  if (memcmp(hydra_get_next_pair(), &HYDRA_EXIT, sizeof(HYDRA_EXIT)) == 0)
    return 3;

  return 1;
}

void service_teamspeak(unsigned long int ip, int sp, unsigned char options,
	     char *miscptr, FILE * fp, int port) {
  int run = 1, next_run, sock = -1;
  int myport = PORT_TEAMSPEAK;

  hydra_register_socket(sp);

  if (memcmp(hydra_get_next_pair(), &HYDRA_EXIT, sizeof(HYDRA_EXIT)) == 0)
    run = 3;

  while (1) {
    switch (run) {
    case 1:			/* connect and service init function */
//      if (sock >= 0)
//	sock = hydra_disconnect(sock);
//      usleep(300000);
      if (sock < 0) {
        if (port != 0)
   	  myport = port;
        sock = hydra_connect_udp(ip, myport);
        port = myport;
        if (sock < 0) {
	  hydra_report(stderr,
		     "Error: Child with pid %d terminating, can not connect\n",
		     (int) getpid());
	  hydra_child_exit(1);
        }
      }
      next_run = start_teamspeak(sock, ip, port, options, miscptr, fp);
      break;
    case 3:			/* clean exit */
      if (sock >= 0)
	sock = hydra_disconnect(sock);
      hydra_child_exit(-1);
      return;
    default:
      hydra_report(stderr, "Caught unknown return code, exiting!\n");
      hydra_child_exit(-1);
      exit(-1);
    }
    run = next_run;
  }
}
