/*
 * $Id: nemesis-udp.c,v 1.7 2000/03/04 10:39:28 obecian Exp $
 *
 * THE NEMESIS PROJECT (c) obecian 1999, 2000
 *
 * nemesis-udp.c (UDP Packet Injector)
 *
 */

#include "nemesis-udp.h"

int
main(int argc, char **argv)
{
	int             m;
	int             opt;
	char           *file = NULL;
	static int		fd = -1;
	char            buff[512];
	extern char    *optarg;
	extern int      opterr;

	int             bindata = 0;

	got_link = 0;
	got_options = 0;
	got_payload = 0;

	verbose = 0;

	if (argc < 2)
		usage(argv[0]);

	if (geteuid() != 0) {
		printf("user '%s' does not have an euid of 0\n", getlogin());
		exit(-1);
	}
	defaults();

	opterr = 0;
	while ((opt = getopt(argc, argv, "S:D:d:H:M:F:x:y:I:T:t:O:P:bv")) != EOF) {
		switch (opt) {
        case 'v':
            verbose = 1;
            putchar('\n');
            puts(TITLE " " VERSION);
            puts(CODERS);
            putchar('\n');
            break;
		case 'S':
			if (!(source = libnet_name_resolve(optarg, 0))) {
				fprintf(stderr, "Invalid source IP address: %s\n", optarg);
				exit(-1);
			}
			if (verbose)
				printf("[IP]  %s > ", optarg);
			break;
		case 'D':
			if (!(dest = libnet_name_resolve(optarg, 0))) {
				fprintf(stderr, "Invalid destination IP address: %s\n", optarg);
				exit(-1);
			}
			if (verbose)
				printf("%s\n", optarg);
			break;
		case 'F':
			frag = atoi(optarg);
		case 'd':
			got_link = 1;
			device = optarg;
			break;
		case 'H':
			if (got_link)
            {
                sscanf(optarg, "%02X:%02X:%02X:%02X:%02X:%02X", &enet_tmp[0],
					&enet_tmp[1], &enet_tmp[2], &enet_tmp[3], &enet_tmp[4],
					&enet_tmp[5]);
                enet_src[0] = (u_char) enet_tmp[0];
                enet_src[1] = (u_char) enet_tmp[1];
                enet_src[2] = (u_char) enet_tmp[2];
                enet_src[3] = (u_char) enet_tmp[3];
                enet_src[4] = (u_char) enet_tmp[4];
                enet_src[5] = (u_char) enet_tmp[5];
            }
			break;
		case 'M':
			if (got_link)
            {
                sscanf(optarg, "%02X:%02X:%02X:%02X:%02X:%02X", &enet_tmp[0],
					&enet_tmp[1], &enet_tmp[2], &enet_tmp[3], &enet_tmp[4],
					&enet_tmp[5]);
                enet_dst[0] = (u_char) enet_tmp[0];
                enet_dst[1] = (u_char) enet_tmp[1];
                enet_dst[2] = (u_char) enet_tmp[2];
                enet_dst[3] = (u_char) enet_tmp[3];
                enet_dst[4] = (u_char) enet_tmp[4];
                enet_dst[5] = (u_char) enet_tmp[5];
            }
			break;
		case 'x':
			sport = atoi(optarg);
			break;
		case 'y':
			dport = atoi(optarg);
			break;
		case 'I':
			id = atoi(optarg);
			break;
		case 'T':
			ttl = atoi(optarg);
			break;
		case 't':
			tos = strtoul(optarg, NULL, 0);
			break;
		case 'b':
			bindata = 1;
			break;
		case 'P':
			file = optarg;
			got_payload = 1;
			if ((fd = open(file, O_RDONLY)) < 0) {
				(void) fprintf(stderr, "%s: open: ", argv[0]);
				perror(file);
				exit(-1);
			}
			break;
		case 'O':
			got_options = 1;
			(u_char) * options = strtoul(optarg, NULL, 0);
			break;
		case '?':
			usage(argv[0]);
			break;
		}
	}

	if (source == 0 || dest == 0) {
		printf("Source and/or Destination Address Missing.\n");
		exit(-1);
	}
	if (verbose)
	{
		if (got_link)
		{
			printf("[MAC]  ");
			printf("%02X:%02X:%02X:%02X:%02X:%02X > %02X:%02X:%02X:%02X:%02X:%02X\n", enet_src[0], enet_src[1], enet_src[2], enet_src[3], enet_src[4], enet_src[5], enet_dst[0], enet_dst[1], enet_dst[2], enet_dst[3], enet_dst[4], enet_dst[5]);
		}
        printf("[Ports] %d > %d\n", sport, dport);

		printf("[IP ID] %d\n", id);
		printf("[IP TTL] %d\n", ttl);
		printf("[IP TOS] 0x%x\n", tos);
		printf("[IP Frag] 0x%x\n", frag);
		printf("[IP Options] %s\n\n", options);
	}

    if (got_payload)
    {
        payload = buff;
        while ((nbytes = read(fd, buff, sizeof(buff))) != 0)
        {
            if (bindata) {
                if (verbose)
                {
                    printf("[BINARY Payload]\n");
                    for (m = 0; m < nbytes; m++) {
                        printf("%02X", (u_char) buff[m]);
                    }
                    putchar('\n');
                }
            }   
            else
            {
                if (verbose)
                {
                    printf("[ASCII Payload]\n");
                    for (m = 0; m < nbytes; m++)
                        printf("%c", buff[m]);
                    putchar('\n');
                }   
            }   
            
            if (buildudp() != -1)
            {
                if (verbose)
                    printf("\nUDP Packet Injected\n");
            }       
            else    
            {
                if (verbose)
                    printf("\nUDP Injection Failure\n");
            }       
        }
		close(fd);
		exit(0);   
	}
        
    if (buildudp() != -1)
    {
    	if (verbose)
    		printf("\nUDP Packet Injected\n");
    }       
    else    
    {
    	if (verbose)
    		printf("\nUDP Injection Failure\n");
    }       
	close(fd);
    exit(0);
}   

void
usage(char *arg)
{
    putchar('\n');
    puts(TITLE " " VERSION);
    puts(CODERS);
    putchar('\n');
    
	printf("UDP usage:\n  %s [-v] [options]\n\n", arg);
	printf("options: \n"
	       "  [-x <Source Port>]\n"
	       "  [-y <Destination Port>]\n"
	       "  -P <Payload File (Binary or ASCII)>\n"
	       "  -b (Enable Binary Payload)\n"
	       "  (-v VERBOSE - packet struct to stdout)\n\n");
	printf("IP options: \n"
	       "  -S <Source IP Address>\n"
	       "  -D <Destination IP Address>\n"
	       "  -I <IP ID>\n"
	       "  -T <IP TTL>\n"
	       "  -t <IP tos>\n"
		   "  -F <IP frag>\n"
	       "  -O <IP Options>\n\n");
	printf("Data Link Options: \n"
	       "  -d <Ethernet Device>\n"
	       "  -H <Source MAC Address>\n"
	       "  -M <Destination MAC Address>\n\n");
	printf("You must define a Source, Destination and Protocol Options.\n");
	exit(-1);
}

void
defaults()
{
	enet_src[0] = 0x02;
	enet_src[1] = 0x0f;
	enet_src[2] = 0x0a;
	enet_src[3] = 0x0d;
	enet_src[4] = 0x0e;
	enet_src[5] = 0x0d;

	enet_dst[0] = 0x0d;
	enet_dst[1] = 0x0e;
	enet_dst[2] = 0x0a;
	enet_dst[3] = 0x0d;
	enet_dst[4] = 0x00;
	enet_dst[5] = 0x01;

	sport = 42069;
	dport = 23;
	id = 0;
	tos = IPTOS_LOWDELAY | IPTOS_THROUGHPUT;
	ttl = 254;
	payload = NULL;
	payload_s = 0;
	*options = NULL;
	option_s = 0;
	frag = IP_DF;
}
