/* $Id: e2p_view.c 1082 2008-08-11 23:30:42Z tpgww $

Copyright (C) 2003-2008 tooar <tooar@gmx.net>
Portions copyright (C) 1999 Michael Clark

This file is part of emelFM2.
emelFM2 is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3, or (at your option)
any later version.

emelFM2 is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with emelFM2; see the file GPL. If not, contact the Free Software
Foundation, 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
*/

/**
@file plugins/e2p_view.c
@brief plugin for view first selected item using the internal viewer
*/

#include "emelfm2.h"
#include "e2_plugins.h"
#include "e2_task.h"

static gboolean _e2p_viewQ (E2_ActionTaskData *qed);

/**
@brief view first selected item using the internal viewer

@param from the button, menu item etc which was activated
@param art action runtime data

@return TRUE if action completed successfully, else FALSE
*/
static gboolean _e2p_view (gpointer from, E2_ActionRuntime *art)
{
	return (e2_task_do_task (E2_TASK_VIEW, art, from, _e2p_viewQ, NULL));
}
static gboolean _e2p_viewQ (E2_ActionTaskData *qed)
{
	gboolean retval;
	GPtrArray *names = qed->names;
	if (names == NULL)
		return FALSE;
	E2_SelectedItemInfo **iterator = (E2_SelectedItemInfo **) names->pdata;
	//".." entries filtered when names compiled
	gchar *localpath = e2_utils_strcat (qed->currdir, (*iterator)->filename);
#ifdef E2_VFS
	VPATH ddata = { localpath, qed->currspace };
#endif
	gdk_threads_enter ();
#ifdef E2_VFS
	retval = e2_view_dialog_create (&ddata);
#else
	retval = e2_view_dialog_create (localpath);
#endif
	gdk_threads_leave ();
	g_free (localpath);
	return retval;
}

//aname must be confined to this module
static gchar *aname;
/**
@brief plugin initialization function, called by main program

@param p ptr to plugin data struct

@return TRUE if the initialization succeeds, else FALSE
*/
gboolean init_plugin (Plugin *p)
{
#define ANAME "view"
  aname = _("view_with_plugin");	//note: the action-name cannot be same as internal file.view

  p->signature = ANAME VERSION;
  p->menu_name = _("_View");
  p->description = g_strdup_printf (_("Open the first selected item with the %s text-file viewer"), PROGNAME);
//  p->icon = "plugin_"ANAME E2ICONTB;  //use icon file pathname if appropriate
//  p->icon = "";  add icon file pathname if appropriate
  p->cleanflags = E2P_CLEANTIP;

  if (p->action == NULL)
  {
	//no need to free this
	gchar *action_name = g_strconcat (_A(6),".",aname,NULL);
	p->action = e2_plugins_action_register
	  (action_name, E2_ACTION_TYPE_ITEM, _e2p_view, NULL, FALSE, 0, NULL);
	return TRUE;
  }
  return FALSE;
}
/**
@brief cleanup transient things for this plugin

@param p pointer to data struct for the plugin

@return TRUE if all cleanups were completed
*/
gboolean clean_plugin (Plugin *p)
{
  gchar *action_name = g_strconcat (_A(6),".",aname,NULL);
  gboolean ret = e2_plugins_action_unregister (action_name);
  g_free (action_name);
  return ret;
}
