/* GKrellM
|  Copyright (C) 1999-2001 Bill Wilson
|
|  Author:  Bill Wilson    bill@gkrellm.net
|  Latest versions might be found at:  http://gkrellm.net
|
|  This program is free software which I release under the GNU General Public
|  License. You may redistribute and/or modify this program under the terms
|  of that license as published by the Free Software Foundation; either
|  version 2 of the License, or (at your option) any later version.
|
|  This program is distributed in the hope that it will be useful,
|  but WITHOUT ANY WARRANTY; without even the implied warranty of
|  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
|  GNU General Public License for more details.
| 
|  To get a copy of the GNU General Puplic License, write to the Free Software
|  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


#include <dlfcn.h>
#include "gkrellm.h"
#include "gkrellm_private_proto.h"

#include <dirent.h>


/* ======================================================================= */
/* Plugin interface to GKrellM.
*/

gchar *
gkrellm_get_theme_path()
	{
	return GK.theme_path;
	}

Krell *
gkrellm_krell_new0()
	{
	Krell *k;

	k = g_new0(Krell, 1);
	return k;
	}

Decal *
gkrellm_decal_new0()
	{
	Decal	*d;

	d = g_new0(Decal, 1);
	return d;
	}


Label *
gkrellm_label_new0()
	{
	Label *l;

	l = g_new0(Label, 1);
	return l;
	}


Style *
gkrellm_style_new0()
	{
	Style	*s;

	s = g_new0(Style, 1);
	return s;
	}

Style *
gkrellm_copy_style(Style *style)
	{
	Style *s	= gkrellm_style_new0();

	*s = *style;
	return s;
	}

TextStyle *
gkrellm_textstyle_new0()
	{
	TextStyle	*t;

	t = g_new0(TextStyle, 1);
	return t;
	}

TextStyle *
gkrellm_copy_textstyle(TextStyle *ts)
	{
	TextStyle *t	= gkrellm_textstyle_new0();

	*t = *ts;
	return t;
	}

Chart *
gkrellm_chart_new0()
	{
	Chart	*c;

	c = g_new0(Chart, 1);
	return c;
	}

Panel *
gkrellm_panel_new0()
	{
	Panel *p;

	p = g_new0(Panel, 1);
	p->label = gkrellm_label_new0();
	return p;
	}


static Style *
get_style_from_list(GList *list, gint n)
	{
	GList	*l;

	l = g_list_nth(list, n);
	if (l == NULL || l->data == NULL)
		l = list;
	if (l->data == NULL)
		{
		printf("Warning: NULL style returned %d\n", n);
		abort();
		}
	return (Style *) l->data;
	}

Style *
gkrellm_meter_style(gint n)
	{
	return get_style_from_list(GK.meter_style_list, n);
	}

Style *
gkrellm_panel_style(gint n)
	{
	return get_style_from_list(GK.panel_style_list, n);
	}

Style *
gkrellm_chart_style(gint n)
	{
	return get_style_from_list(GK.chart_style_list, n);
	}

gint
gkrellm_lookup_chart_style_id(gchar *name)
	{
	GList	*list;
	gint	i;

	for (list = GK.chart_name_list, i = 0; list; list = list->next, ++i)
		if (!strcmp(name, (gchar *)list->data))
			return i;
	return 0;
	}

gint
gkrellm_lookup_meter_style_id(gchar *name)
	{
	GList	*list;
	gint	i;

	for (list = GK.meter_name_list, i = 0; list; list = list->next, ++i)
		if (!strcmp(name, (gchar *)list->data))
			return i;
	return 0;
	}

static GdkImlibImage *
get_image_from_list(GList *list, gint n)
	{
	GList	*l;

	l = g_list_nth(list, n);
	if (l == NULL || l->data == NULL)
		l = list;
	if (l->data == NULL)
		{
		printf("Warning: NULL image returned %d\n", n);
		abort();
		}
	return (GdkImlibImage *) l->data;
	}

GdkImlibImage *
gkrellm_bg_chart_image(gint n)
	{
	return get_image_from_list(GK.bg_chart_image_list, n);
	}

GdkImlibImage *
gkrellm_bg_grid_image(gint n)
	{
	return get_image_from_list(GK.bg_grid_image_list, n);
	}

GdkImlibImage *
gkrellm_bg_panel_image(gint n)
	{
	return get_image_from_list(GK.bg_panel_image_list, n);
	}

GdkImlibImage *
gkrellm_bg_meter_image(gint n)
	{
	return get_image_from_list(GK.bg_meter_image_list, n);
	}

GdkImlibImage *
gkrellm_krell_panel_image(gint n)
	{
	return get_image_from_list(GK.krell_panel_image_list, n);
	}

GdkImlibImage *
gkrellm_krell_meter_image(gint n)
	{
	return get_image_from_list(GK.krell_meter_image_list, n);
	}

void
gkrellm_monitor_height_adjust(gint h)
	{
	GK.monitor_height += h;
	}

GdkPixmap *
gkrellm_decal_misc_pixmap()
	{
	return GK.decal_misc_pixmap;
	}

GdkBitmap *
gkrellm_decal_misc_mask()
	{
	return GK.decal_misc_mask;
	}

GdkPixmap *
gkrellm_data_in_pixmap()
	{
	return GK.data_in_pixmap;
	}

GdkPixmap *
gkrellm_data_in_grid_pixmap()
	{
	return GK.data_in_grid_pixmap;
	}

GdkPixmap *
gkrellm_data_out_pixmap()
	{
	return GK.data_out_pixmap;
	}

GdkPixmap *
gkrellm_data_out_grid_pixmap()
	{
	return GK.data_out_grid_pixmap;
	}


GdkImlibImage *
gkrellm_krell_slider_image()
	{
	return GK.krell_slider_image;
	}

Style *
gkrellm_krell_slider_style()
	{
	return GK.krell_slider_style;
	}

GdkImlibImage *
gkrellm_krell_mini_image()
	{
	return GK.krell_mini_image;
	}

Style *
gkrellm_krell_mini_style()
	{
	return GK.krell_mini_style;
	}

GdkImlibImage *
gkrellm_bg_slider_image(gint n)
	{
	if (n < 0 || n > N_PANEL_TYPES)
		n = 0;
	return GK.bg_slider_image[n];
	}

GdkImlibBorder *
gkrellm_bg_slider_border(gint n)
	{
	if (n < 0 || n > N_PANEL_TYPES)
		n = 0;
	return &GK.bg_slider_border[n];
	}

GdkGC *
gkrellm_draw_GC(gint n)
	{
	GdkGC	*gc;

	if (n == 0)
		return GK.draw_stencil_GC;
	else if (n == 1)
		gc = GK.draw1_GC;
	else if (n == 2)
		gc = GK.draw2_GC;
	else
		gc = GK.draw3_GC;
	return gc;
	}

GdkGC *
gkrellm_bit_GC(gint n)
	{
	if (n == 0)
		return GK.bit0_GC;
	else
		return GK.bit1_GC;
	}

TextStyle *
gkrellm_chart_textstyle(gint n)
	{
	Style		*style;
	TextStyle	*ts;

	style = get_style_from_list(GK.chart_style_list, n);
	ts	= &style->label_tsA;
	ts->font = *(ts->font_seed);
	return ts;
	}

TextStyle *
gkrellm_panel_textstyle(gint n)
	{
	Style		*style;
	TextStyle *ts;

	style = get_style_from_list(GK.panel_style_list, n);
	ts	= &style->label_tsA;
	ts->font = *(ts->font_seed);
	return ts;
	}

TextStyle *
gkrellm_meter_textstyle(gint n)
	{
	Style		*style;
	TextStyle *ts;

	style = get_style_from_list(GK.meter_style_list, n);
	ts	= &style->label_tsA;
	ts->font = *(ts->font_seed);
	return ts;
	}


TextStyle *
gkrellm_chart_alt_textstyle(gint n)
	{
	Style		*style;
	TextStyle *ts;

	style = get_style_from_list(GK.chart_style_list, n);
	ts	= &style->label_tsB;
	ts->font = *(ts->font_seed);
	return ts;
	}

TextStyle *
gkrellm_panel_alt_textstyle(gint n)
	{
	Style		*style;
	TextStyle *ts;

	style = get_style_from_list(GK.panel_style_list, n);
	ts	= &style->label_tsB;
	ts->font = *(ts->font_seed);
	return ts;
	}

TextStyle *
gkrellm_meter_alt_textstyle(gint n)
	{
	Style		*style;
	TextStyle *ts;

	style = get_style_from_list(GK.meter_style_list, n);
	ts	= &style->label_tsB;
	ts->font = *(ts->font_seed);
	return ts;
	}

GdkFont *
gkrellm_default_font(gint n)
	{
	if (n == 0)
		return GK.small_font;
	else if (n == 1)
		return GK.normal_font;
	else
		return GK.large_font;
	}

GdkColor *
gkrellm_white_color()
	{
	return &GK.white_color;
	}

GdkColor *
gkrellm_black_color()
	{
	return &GK.background_color;
	}

gint
gkrellm_update_HZ()
	{
	return UC.update_HZ;
	}

gint
gkrellm_scale_mode()
	{
	return UC.fixed_scale;
	}

gint
gkrellm_chart_width()
	{
	return UC.chart_width;
	}

gint
gkrellm_chart_height(gint n)
	{
	if (n < 0 || n > N_CHART_MONITORS)
		n = 0;
	return UC.chart_height[n];
	}

gint
gkrellm_max_chart_height()
	{
	return GK.max_chart_height;
	}


/* ======================================================================= */

gint				n_system_plugins;

static GtkWidget	*enable_clist;
static GtkWidget	*enable_button;
static GtkWidget	*text_log;

static gint			selected_row	= -1;
static gint			plugin_enable_list_modified;

static GList		*system_plugins_list;
static GList		*user_plugins_list;
static GList		*plugins_enable_list;

gchar				*plugin_install_log = "";

static void
plugin_log(gchar *string1, ...)
	{
	va_list	args;
	gchar	*s;

	if (!string1)
		return;
	va_start(args, string1);
	s = string1;
	while (s)
		{
		plugin_install_log = g_strconcat(plugin_install_log, s, NULL);
		if (GK.debug_level & DEBUG_PLUGIN)
			printf("%s", s);
		s = va_arg(args, gchar *);
		}
	va_end(args);
	}

void
gkrellm_place_plugin(Monitor *plugin)
	{
	Monitor		*mon;
	GList		*list, *plist;
	gint		n, gravity, after_flag;
	gchar		buf[120];

	if (plugin->create_monitor && plugin->private->vbox == NULL)
		{
		plugin->private->spacer_top_vbox = gtk_vbox_new(FALSE, 0);
		plugin->private->vbox = gtk_vbox_new(FALSE, 0);
		plugin->private->spacer_bottom_vbox = gtk_vbox_new(FALSE, 0);
		}
	for (plist = NULL, list = gkrellm_monitor_list; list; list = list->next)
		{
		mon = (Monitor *) list->data;

		/* Save list position as plugins are encountered so we can later
		|  walk through them looking at gravity.
		*/
		if (MONITOR_ID(mon) == MON_PLUGIN && plist == NULL)
			plist = list;
		if (MONITOR_ID(mon) == INSERT_BEFORE_ID(plugin))
			{
			after_flag = INSERT_AFTER_FLAG(plugin);
			gravity = PLUGIN_GRAVITY(plugin);
			snprintf(buf, sizeof(buf), _("\tPlaced %s %s  G:%d\n"),
					after_flag ? _("after") : _("before"), mon->name, gravity);
			plugin_log(buf, NULL);
			if (after_flag)
				{
				if ((n = g_list_position(gkrellm_monitor_list, list)) < 0)
					n = 0;
				g_list_insert(gkrellm_monitor_list, plugin, n + 1);
				}
			else
				{
				/* If there are plugins already above this builtin, then place
				|  based on gravity.  Insert above the first plugin found that
				|  has greater gravity than the current placing plugin.
				*/
				if (plist)
					{
					for ( ; plist != list; plist = plist->next)
						{
						mon = (Monitor *) plist->data;	/* looking at plugins*/
						if (PLUGIN_GRAVITY(mon) > gravity)
							break;
						}
					list = plist;
					}
				if (list == gkrellm_monitor_list)
					gkrellm_monitor_list = g_list_prepend(list, plugin);
				else
					g_list_prepend(list, plugin);
				}
			return;
			}
		else if (MONITOR_ID(mon) != MON_PLUGIN)
			plist = NULL;
		}
	if ((plugin->insert_before_id & MON_ID_MASK) != MON_UPTIME)
		{
		gravity = PLUGIN_GRAVITY(plugin);
		plugin->insert_before_id = MON_UPTIME;
		if (gravity)
			plugin->insert_before_id |= GRAVITY(gravity);
		gkrellm_place_plugin(plugin);
		return;
		}
	gkrellm_monitor_list = g_list_append(gkrellm_monitor_list, plugin);
	}

Monitor *
install_plugin(gchar *plugin_name)
	{
	GList		*list;
	Monitor		*m, *mm;
	void		*handle;
	Monitor		*(*init_plugin)();
	gchar		*error;
	gchar		buf[256];

#ifdef RTLD_NOW
	handle = dlopen(plugin_name, RTLD_NOW);
#else
	handle = dlopen(plugin_name, 0);
#endif

	plugin_log(plugin_name, "\n", NULL);
	if (! handle)
		{
		snprintf(buf, sizeof(buf), _("\tError: %s\n"), dlerror());
		plugin_log(buf, NULL);
		return NULL;
		}
	init_plugin = dlsym(handle, "init_plugin");
	if ((error = dlerror()) != NULL)
		{
		snprintf(buf, sizeof(buf), _("\tError: %s\n"), error);
		plugin_log(buf, NULL);
		dlclose(handle);
		return NULL;
		}
	m = (*init_plugin)();
	if (m == NULL)
		{
		plugin_log(_("\tOoops! plugin returned NULL, aborting\n"), NULL);
		dlclose(handle);
		return NULL;
		}
	for (list = gkrellm_monitor_list; list; list = list->next)
		{
		mm = (Monitor *) list->data;
		if (   !mm->private || !mm->private->style_name
			|| !m->private  || !m->private->style_name
			|| strcmp(mm->private->style_name, m->private->style_name)
		   )
			continue;
		plugin_log(_("\tWarning: style name \""), m->private->style_name,
			_("\" already used by:\n\t\t"), mm->path, "\n", NULL);
		}
	for (list = gkrellm_monitor_list; list; list = list->next)
		{
		mm = (Monitor *) list->data;
		if (   !mm->config_keyword || !m->config_keyword
			|| strcmp(mm->config_keyword, m->config_keyword)
		   )
			continue;
		plugin_log(_("\tWarning: config keyword \""), m->config_keyword,
			_("\" already used by:\n\t\t"), mm->path, "\n", NULL);
		}
	m->handle = handle;
	m->path = plugin_name;
	if (m->private == NULL)		/* Won't be null if style was added */
		m->private = g_new0(MonPrivate, 1);
	m->private->enabled = TRUE;

	/* Enforce some id fields.
	*/
	m->id &= ~(MON_ID_MASK | MON_CONFIG_MASK);
	m->id |= MON_PLUGIN;

	gkrellm_place_plugin(m);
	return m;
	}

static void
disable_plugin(gchar *plugin_path)
	{
	Monitor		*mon;
	MonPrivate	*mp;
	GList		*list;

	for (list = gkrellm_monitor_list; list; list = list->next)
		{
		mon = (Monitor *) list->data;
		mp = mon->private;
		if (   MONITOR_ID(mon) == MON_PLUGIN
			&& !strcmp(plugin_path, mon->path)
			&& mp->enabled == TRUE
		   )
			{
			if (mp->top_pixmapwid)
				gtk_widget_destroy(mp->top_pixmapwid);
			mp->top_pixmapwid = NULL;
			if (mp->bottom_pixmapwid)
				gtk_widget_destroy(mp->bottom_pixmapwid);
			mp->bottom_pixmapwid = NULL;

			/* It is not safe to destroy a plugin widget tree.
			|  They have already done one time first_create stuff.
			*/
			gtk_widget_hide(mp->vbox);
			mp->enabled = FALSE;
			build_gkrellm();
			remove_plugin_config_page(mon);
			plugin_enable_list_modified = TRUE;
			break;
			}
		}
	}

static void
enable_plugin(gchar *plugin_path)
	{
	Monitor	*mon;
	GList	*list;

	for (list = gkrellm_monitor_list; list; list = list->next)
		{
		mon = (Monitor *) list->data;
		if (   MONITOR_ID(mon) == MON_PLUGIN
			&& !strcmp(plugin_path, mon->path)
			&& mon->private->enabled == FALSE
		   )
			{
			gtk_widget_show(mon->private->vbox);
			mon->private->enabled = TRUE;
			build_gkrellm();
			add_plugin_config_page(mon);
			plugin_enable_list_modified = TRUE;
			break;
			}
		}
	}


static void
load_plugins_enable_list()
	{
	FILE	*f;
	gchar	*path, *s, buf[128];

	free_glist_and_data(&plugins_enable_list);
	path = gkrellm_make_config_file_name(gkrellm_homedir(),
						PLUGINS_INSTALL_LIST);
	if ((f = fopen(path, "r")) != NULL)
		{
		while ((fgets(buf, sizeof(buf), f)) != NULL)
			{
			if ((s = strchr(buf, '\n')) != NULL)
				*s = '\0';
			s = g_strdup(buf);
			plugins_enable_list = g_list_append(plugins_enable_list, s);
			}
		fclose(f);
		}
	g_free(path);
	}

void
save_plugins_enable_list()
	{
	FILE	*f;
	gint	row;
	gchar	*path, *s, *si;
	
	if (!plugin_enable_list_modified || GK.demo)
		return;
	path = gkrellm_make_config_file_name(gkrellm_homedir(),
				PLUGINS_INSTALL_LIST);
	if ((f = fopen(path, "w")) != NULL)
		{
		for (row = 0; row < GTK_CLIST(enable_clist)->rows; ++row)
			{
			s = (gchar *) g_list_nth_data(system_plugins_list, row);
			gtk_clist_get_text(GTK_CLIST(enable_clist), row, 1, &si);
			if (strcmp(si, "enabled") == 0)
				fprintf(f, "%s\n", s);
			}
		fclose(f);
		}
	plugin_enable_list_modified = FALSE;
	g_free(path);
	load_plugins_enable_list();
	}

static gboolean
duplicate_plugin(gchar *path, gchar *name)
	{
	if (   basename_in_list(system_plugins_list, name)
		|| basename_in_list(user_plugins_list, name)
	   )
		{
		plugin_log("Ignoring duplicate plugin ", path,"/",name, "\n", NULL);
		return TRUE;
		}
	return FALSE;
	}

static void
scan_for_plugins(gchar *path)
	{
    DIR				*dir;
    struct dirent	*dentry;
	Monitor			*m;
	gchar			*s, *so;
	
	if ((dir = opendir(path)) == NULL)
		return;
	while ((dentry = readdir(dir)) != NULL)
		{
		if (   dentry->d_name[0] != '.'
			&& dentry->d_ino > 0
			&& (so = strrchr(dentry->d_name, '.')) != NULL
			&& strcmp(so, ".so") == 0
		   )
			{
			if (duplicate_plugin(path, dentry->d_name))
				continue;
			s = g_strdup_printf("%s/%s", path, dentry->d_name);
			m = install_plugin(s);
			if (m)
				{
				system_plugins_list = g_list_append(system_plugins_list,s);
				++n_system_plugins;
				if (! string_in_list(plugins_enable_list, s))
					m->private->enabled = FALSE;
				}
			else
				g_free(s);
			}
		}
	closedir(dir);
	}

void
load_plugin_monitors()
	{
	gchar			*plugins_dir;
    DIR				*dir;
    struct dirent	*dentry;
	gchar			*path, *so;

	if (GK.command_line_plugin && strstr(GK.command_line_plugin, ".so"))
		{
		if (   *GK.command_line_plugin != '.'
			&& !strchr(GK.command_line_plugin, '/')
		   )
			path = g_strdup_printf("./%s", GK.command_line_plugin);
		else
			path = g_strdup(GK.command_line_plugin);
		plugin_log(_("*** Command line plugin:\n"), NULL);
		if (!install_plugin(path))
			g_free(path);
		else
			user_plugins_list = g_list_append(user_plugins_list, path);
		plugin_log("\n", NULL);
		}
	plugins_dir= g_strdup_printf("%s/%s", gkrellm_homedir(),
				GKRELLM_PLUGINS_DIR);
	plugin_log(_("*** User plugins found in ~/"),
						GKRELLM_PLUGINS_DIR, ":\n", NULL);
	if ((dir = opendir(plugins_dir)) != NULL)
		{
		while ((dentry = readdir(dir)) != NULL)
			{
			if (   dentry->d_name[0] != '.'
				&& dentry->d_ino > 0
				&& (so = strrchr(dentry->d_name, '.')) != NULL
				&& strcmp(so, ".so") == 0
			   )
				{
				if (duplicate_plugin(plugins_dir, dentry->d_name))
					continue;
				path = g_strdup_printf("%s/%s", plugins_dir, dentry->d_name);
				if (!install_plugin(path))
					g_free(path);
				else
					user_plugins_list = g_list_append(user_plugins_list, path);
				}
			}
		closedir(dir);
		}
	g_free(plugins_dir);

	plugin_log(_("\n*** System wide plugins found:\n"), NULL);
	load_plugins_enable_list();
	scan_for_plugins(LOCAL_PLUGINS_DIR);
	scan_for_plugins(SYSTEM_PLUGINS_DIR);
	scan_for_plugins(OLD_LOCAL_PLUGINS_DIR);
	scan_for_plugins(OLD_SYSTEM_PLUGINS_DIR);
	system_plugins_list = g_list_sort(system_plugins_list,
				(GCompareFunc) strcmp_basename);
	}

static void
cb_enable_button_clicked(GtkWidget *widget, gpointer data)
	{
	gchar	*s;
	gint	state;

	if (selected_row < 0)
		return;
	state = GTK_TOGGLE_BUTTON(enable_button)->active;
	s = state ? "enabled" : "";
	gtk_clist_set_text(GTK_CLIST(enable_clist), selected_row, 1, s);
/*	gtk_clist_get_text(GTK_CLIST(enable_clist), selected_row, 0, &s); */
	s = (gchar *) g_list_nth_data(system_plugins_list, selected_row);
	if (state)
		enable_plugin(s);
	else
		disable_plugin(s);
	}

static void
cb_clist_unselected(GtkWidget *clist, gint row, gint column,
		GdkEventButton *bevent, gpointer data)
	{
	selected_row = -1;
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(enable_button), FALSE);
	}

static void
cb_clist_selected(GtkWidget *clist, gint row, gint column,
		GdkEventButton *bevent, gpointer data)
	{
	gchar	*s;
	gint	state;

	selected_row = row;
	gtk_clist_get_text(GTK_CLIST(clist), row, 1, &s);
	state = (strcmp(s, "enabled") == 0) ? TRUE : FALSE;
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(enable_button), state);
	}

static gchar	*scroll_title[2] = { N_("Plugin"), N_("Status") };

void
create_plugin_config(GtkWidget *tab_vbox)
	{
	GtkWidget	*tabs;
	GtkWidget	*vbox;
	GtkWidget	*hbox;
	GtkWidget	*clist;
	GtkWidget	*scrolled;
	GtkWidget	*label;
	GtkWidget	*separator;
	GList		*list;
	gchar		*buf[4];
	gchar		lbuf[128];
	gchar		*s;

	tabs = gtk_notebook_new();
	gtk_notebook_set_tab_pos(GTK_NOTEBOOK(tabs), GTK_POS_TOP);
	gtk_box_pack_start(GTK_BOX(tab_vbox), tabs, TRUE, TRUE, 0);


/* --System wide plugins tab */
	vbox = gkrellm_create_tab(tabs, _("System Wide Plugins"));
	if (system_plugins_list == NULL)
		{
		snprintf(lbuf, sizeof(lbuf),
			_("There are no system wide plugins available in\n%s\nor\n%s"),
			LOCAL_PLUGINS_DIR, SYSTEM_PLUGINS_DIR);
		label = gtk_label_new(lbuf);
		gtk_box_pack_start(GTK_BOX(vbox), label, TRUE, TRUE, 0);
		}
	else
		{
		snprintf(lbuf, sizeof(lbuf), _("System wide plugins"));
		label = gtk_label_new(lbuf);
		gtk_box_pack_start(GTK_BOX(vbox), label, FALSE, FALSE, 0);

		scrolled = gtk_scrolled_window_new(NULL, NULL);
		gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrolled),
				GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
		gtk_box_pack_start(GTK_BOX(vbox), scrolled, TRUE, TRUE, 0);
		scroll_title[0] = _(scroll_title[0]);
		scroll_title[1] = _(scroll_title[1]);
		clist = gtk_clist_new_with_titles(2, scroll_title);
		enable_clist = clist;
		gtk_clist_set_shadow_type(GTK_CLIST(clist), GTK_SHADOW_OUT);
		gtk_clist_set_column_width(GTK_CLIST(clist), 0, 200);
		gtk_clist_set_column_width(GTK_CLIST(clist), 1, 80);

		gtk_signal_connect(GTK_OBJECT(clist), "select_row",
				(GtkSignalFunc) cb_clist_selected, NULL);
		gtk_signal_connect(GTK_OBJECT(clist), "unselect_row",
				(GtkSignalFunc) cb_clist_unselected, NULL);
		gtk_container_add(GTK_CONTAINER(scrolled), clist);
		for (list = system_plugins_list; list; list = list->next)
			{
			s = (gchar *) list->data;
			if (s == NULL)
				continue;
			snprintf(lbuf, sizeof(lbuf), "%s", s);
			s = strrchr(lbuf, '/');
			buf[0] = s ? s + 1 : lbuf;
			if ((s = strrchr(buf[0], '.')) != NULL)
				*s = '\0';
			buf[1] = string_in_list(plugins_enable_list, (gchar *) list->data)
						? "enabled" : "";
			buf[2] = NULL;
			gtk_clist_append(GTK_CLIST(clist), buf);
			}
		hbox = gtk_hbox_new(FALSE, 3);
		gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, FALSE, 2);
		enable_button = gtk_check_button_new_with_label(_("Enable"));
		gtk_box_pack_start(GTK_BOX(hbox), enable_button, TRUE, TRUE, 0);
		gtk_signal_connect(GTK_OBJECT(GTK_BUTTON(enable_button)), "clicked",
				GTK_SIGNAL_FUNC (cb_enable_button_clicked), NULL);

		separator = gtk_hseparator_new ();
		gtk_widget_set_usize(separator, 320, 4);	/* Fixes the window width */
		gtk_box_pack_start(GTK_BOX(vbox), separator, FALSE, FALSE, 0);
		label = gtk_label_new(
			_("Plugins may need to be configured after they are enabled."));
		gtk_box_pack_start(GTK_BOX(vbox), label, FALSE, FALSE, 0);
		}
/* --Plugins detect log tab */
	vbox = gkrellm_create_tab(tabs, _("Plugin Log"));
	scrolled = gtk_scrolled_window_new(NULL, NULL);
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrolled),
			GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
	gtk_box_pack_start(GTK_BOX(vbox), scrolled, TRUE, TRUE, 0);
	text_log = gtk_text_new(NULL, NULL);
	gtk_text_insert(GTK_TEXT(text_log), NULL, NULL, NULL,
			plugin_install_log, -1);
	gtk_text_set_editable(GTK_TEXT(text_log), FALSE);
	gtk_container_add(GTK_CONTAINER(scrolled), text_log);
	}
