#!/usr/bin/env python
# -*- coding: utf-8 -*-

#This file is part of wxsvg
#
#Copyright (C) 2007: Edouard TISSERANT, Laurent BESSARD, Jonathan HURTREL
#
#See COPYING file for copyrights details.
#
#This library is free software; you can redistribute it and/or
#modify it under the terms of the GNU General Public
#License as published by the Free Software Foundation; either
#version 2.1 of the License, or (at your option) any later version.
#
#This library is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#General Public License for more details.
#
#You should have received a copy of the GNU General Public
#License along with this library; if not, write to the Free Software
#Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

from xmlclass import *
import os, sys

SVGUIClasses = GenerateClassesFromXSD(os.path.join(os.path.dirname(__file__), "svgui.xsd"))

cls = SVGUIClasses.get("Container", None)
if cls:
    
    def getelementbyname(self, name):
        for child in self.content:
            element = child["value"]
            if element.getname() == name:
                return element
            if isinstance(element, (SVGUIClasses["Container"], SVGUIClasses["controls_NoteBook"])):
                result = element.getelementbyname(name)
                if result is not None:
                    return result
        return None
    setattr(cls, "getelementbyname", getelementbyname)
    
    def getelementbyid(self, id):
        for child in self.content:
            element = child["value"]
            if element.getid() == id:
                return element
            if isinstance(element, (SVGUIClasses["Container"], SVGUIClasses["controls_NoteBook"])):
                result = element.getelementbyid(id)
                if result is not None:
                    return result
        return None
    setattr(cls, "getelementbyid", getelementbyid)
    
    def getelements(self):
        return [child["value"] for child in self.content]
    setattr(cls, "getelements", getelements)
    
    def getelementsnames(self):
        names = []
        for child in self.content:
            element = child["value"]
            names.append(element.getname())
            if isinstance(element, (SVGUIClasses["Container"], SVGUIClasses["controls_NoteBook"])):
                names.extend(element.getelementsnames())
        return names
    setattr(cls, "getelementsnames", getelementsnames)
    
    def addelement(self, type, name, id):
        new_element = self.appendcontentbytype(type)
        new_element.setname(name)
        new_element.setid(id)
    setattr(cls, "addelement", addelement)
    
    def removeelement(self, id):
        for idx, element in enumerate(self.content):
            if element["value"].getid() == id:
                return self.content.pop(idx)
    setattr(cls, "removeelement", removeelement)
    
    def removeelementbyname(self, name):
        for idx, child in enumerate(self.content):
            element = child["value"]
            if element.getname() == name:
                return self.content.pop(idx)
            elif isinstance(element, (SVGUIClasses["Container"], SVGUIClasses["controls_NoteBook"])):
                result = element.removeelementbyname(name)
                if result is not None:
                    return result
        return None
    setattr(cls, "removeelementbyname", removeelementbyname)
    
    def removeelementbyid(self, id):
        for idx, child in enumerate(self.content):
            element = child["value"]
            if element.getid() == id:
                removed = self.content.pop(idx)
                return removed["value"]
            elif isinstance(element, (SVGUIClasses["Container"], SVGUIClasses["controls_NoteBook"])):
                result = element.removeelementbyid(id)
                if result is not None:
                    return result
    setattr(cls, "removeelementbyid", removeelementbyid)
    
    def getmaxid(self):
        max_id = self.getid()
        for element in self.getelements():
            if isinstance(element, (SVGUIClasses["Container"], SVGUIClasses["controls_NoteBook"])):
                max_id = max(max_id, element.getmaxid())
            else:
                max_id = max(max_id, element.getid())
        return max_id
    setattr(cls, "getmaxid", getmaxid)

cls = SVGUIClasses.get("controls_NoteBook", None)
if cls:
    
    def getelementbyname(self, name):
        for content in self.NoteBookContent:
            if content.getname() == name:
                return content
            result = content.getelementbyname(name)
            if result is not None:
                return result
        return None
    setattr(cls, "getelementbyname", getelementbyname)
    
    def getelementbyid(self, id):
        for content in self.NoteBookContent:
            if content.getid() == id:
                return content
            result = content.getelementbyid(id)
            if result is not None:
                return result
        return None
    setattr(cls, "getelementbyid", getelementbyid)
    
    def getcontents(self):
        return [child for child in self.NoteBookContent]
    setattr(cls, "getcontents", getcontents)
    
    def getelementsnames(self):
        names = []
        for content in self.NoteBookContent:
            names.append(content.getname())
            names.extend(content.getelementsnames())
        return names
    setattr(cls, "getelementsnames", getelementsnames)
    
    def addcontent(self, name, id):
        new_content = SVGUIClasses["NoteBook_NoteBookContent"]()
        new_content.setname(name)
        new_content.setid(id)
        self.NoteBookContent.append(new_content)
    setattr(cls, "addcontent", addcontent)
    
    def removecontent(self, id):
        for idx, content in enumerate(self.NoteBookContent):
            if content.getid() == id:
                return self.NoteBookContent.pop(idx)
    setattr(cls, "removecontent", removecontent)
    
    def removeelementbyname(self, name):
        for idx, content in enumerate(self.NoteBookContent):
            if content.getname() == name:
                return self.NoteBookContent.pop(idx)
            result = content.removeelementbyname(name)
            if result is not None:
                return result
        return None
    setattr(cls, "removeelementbyname", removeelementbyname)
    
    def removeelementbyid(self, id):
        for idx, content in enumerate(self.NoteBookContent):
            if content.getid() == id:
                return self.NoteBookContent.pop(idx)
            result = content.removeelementbyid(id)
            if result is not None:
                return result
    setattr(cls, "removeelementbyid", removeelementbyid)
    
    def getmaxid(self):
        max_id = self.getid()
        for content in self.getcontents():
            max_id = max(max_id, content.getmaxid())
        return max_id
    setattr(cls, "getmaxid", getmaxid)
    