# $Id: burgerspace.spec.in,v 1.8 2003/01/11 01:41:15 sarrazip Exp $
# Spec file for burgerspace

# Release number can be specified with rpm --define 'rel SOMETHING' ...
# If no such --define is used, the release number is 1.
#
# Source archive's extension can be specified with rpm --define 'srcext .foo'
# where .foo is the source archive's actual extension.
# To compile an RPM from a .bz2 source archive, give the command
#   rpm -tb --define 'srcext .bz2' burgerspace-1.7.0.tar.bz2
#
%if %{?rel:0}%{!?rel:1}
%define rel 1
%endif
%if %{?srcext:0}%{!?srcext:1}
%define srcext .gz
%endif

Summary: A Burgertime(TM) clone.
Name: burgerspace
Version: 1.7.0
Release: %{rel}
Copyright: GPL
Group: Amusements/Games
Source: %{name}-%{version}.tar%{srcext}
URL: http://sarrazip.com/dev/%{name}.html
Packager: Pierre Sarrazin
Prefix: /usr
BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-root
Requires: gengameng	>= 4.0
Requires: SDL		>= 1.2.4
Requires: SDL_image	>= 1.2.2
Requires: SDL_mixer	>= 1.2.4
BuildRequires: gengameng-devel	>= 4.0
BuildRequires: SDL-devel	>= 1.2.4
BuildRequires: SDL_image-devel	>= 1.2.2
BuildRequires: SDL_mixer-devel	>= 1.2.4

%description
BurgerSpace is a game in which you are a chef, and must walk over
hamburger ingredients (buns, meat, lettuce, etc) to make them fall from
floor to floor, until they end up on the plates at the bottom of the
screen. It requires the SDL multimedia library. It is a clone of the
1982 BurgerTime video game by Bally Midway.

This package installs an entry in the GNOME 1.x Games menu.

%description -l fr
BurgerSpace est un jeu o vous tes un chef qui doit marcher sur des
ingrdients de hamburger (pain, viande, lettue, etc) pour les faire
tomber d'tage en tage, jusqu' ce qu'ils se retrouvent dans les
assiettes au bas de l'cran.  Il s'agit d'un clone du jeu BurgerTime
de Bally Midmay datant de 1982.

Ce paquet installe une entre dans le menu Jeux de GNOME 1.x.

%prep
%setup

%build
./configure CXXFLAGS="-DNDEBUG -O2" --prefix=%{prefix} --with-desktop-entry
make

%install
rm -fR $RPM_BUILD_ROOT
make DESTDIR=$RPM_BUILD_ROOT install

%clean
rm -fR $RPM_BUILD_ROOT

%files
%defattr(-, root, root)
%{prefix}/bin/*
%{prefix}/share/pixmaps/*
%{prefix}/share/sounds/*
%{prefix}/man/man*/*
%{prefix}/share/gnome/apps/*/*
