// $Id: SSLCiphers.cc 1678 2005-11-08 19:16:37Z vern $

#include "SSLCiphers.h"

PDict(SSL_CipherSpec) SSL_CipherSpecDict;

// --- definitions for ssl cipher handling ------------------------------------

SSL_CipherSpec SSL_CipherSpecs[] = {
	// --- SSL 2.0 cipher specs
	{ SSL_CK_RC4_128_WITH_MD5,
		SSL_CIPHER_TYPE_STREAM,
		SSL_FLAG_SSLv20,
		SSL_CIPHER_RC4,
		SSL_MAC_MD5,
		SSL_KEY_EXCHANGE_RSA,
		0,
		128,
		128
	},
	{ SSL_CK_RC4_128_EXPORT40_WITH_MD5,
		SSL_CIPHER_TYPE_STREAM,
		SSL_FLAG_EXPORT | SSL_FLAG_SSLv20,
		SSL_CIPHER_RC4,
		SSL_MAC_MD5,
		SSL_KEY_EXCHANGE_RSA,
		88,
		40,
		128
	},
	{ SSL_CK_RC2_128_CBC_WITH_MD5,
		SSL_CIPHER_TYPE_BLOCK,
		SSL_FLAG_SSLv20,
		SSL_CIPHER_RC2,
		SSL_MAC_MD5,
		SSL_KEY_EXCHANGE_RSA,
		0,
		128,
		128
	},
	{ SSL_CK_RC2_128_CBC_EXPORT40_WITH_MD5,
		SSL_CIPHER_TYPE_BLOCK,
		SSL_FLAG_EXPORT | SSL_FLAG_SSLv20,
		SSL_CIPHER_RC2,
		SSL_MAC_MD5,
		SSL_KEY_EXCHANGE_RSA,
		88,
		40,
		128
	},
	{ SSL_CK_IDEA_128_CBC_WITH_MD5,
		SSL_CIPHER_TYPE_BLOCK,
		SSL_FLAG_SSLv20,
		SSL_CIPHER_IDEA,
		SSL_MAC_MD5,
		SSL_KEY_EXCHANGE_RSA,
		0,
		128,
		128
	},
	{ SSL_CK_DES_64_CBC_WITH_MD5,
		SSL_CIPHER_TYPE_BLOCK,
		SSL_FLAG_SSLv20,
		SSL_CIPHER_DES,
		SSL_MAC_MD5,
		SSL_KEY_EXCHANGE_RSA,
		0,
		64,
		128
	},
	{ SSL_CK_DES_192_EDE3_CBC_WITH_MD5,
		SSL_CIPHER_TYPE_BLOCK,
		SSL_FLAG_SSLv20,
		SSL_CIPHER_3DES,
		SSL_MAC_MD5,
		SSL_KEY_EXCHANGE_RSA,
		0,
		192,
		128
	},
	{ SSL_CK_RC4_64_WITH_MD5,
		SSL_CIPHER_TYPE_STREAM,
		SSL_FLAG_SSLv20,
		SSL_CIPHER_RC4,
		SSL_MAC_MD5,
		SSL_KEY_EXCHANGE_RSA,
		0,
		64,
		128
	},
	// --- SSL 3.0 / 3.1 cipher specs
	{ TLS_NULL_WITH_NULL_NULL,
		SSL_CIPHER_TYPE_NULL,
		SSL_FLAG_EXPORT | SSL_FLAG_SSLv30 | SSL_FLAG_SSLv31,
		SSL_CIPHER_NULL,
		SSL_MAC_NULL,
		SSL_KEY_EXCHANGE_NULL,
		0,
		0,
		0
	},
	{ TLS_RSA_WITH_NULL_MD5,
		SSL_CIPHER_TYPE_NULL,
		SSL_FLAG_EXPORT | SSL_FLAG_SSLv30 | SSL_FLAG_SSLv31,
		SSL_CIPHER_NULL,
		SSL_MAC_MD5,
		SSL_KEY_EXCHANGE_RSA,
		0,
		0,
		128
	},
	{ TLS_RSA_WITH_NULL_SHA,
		SSL_CIPHER_TYPE_NULL,
		SSL_FLAG_EXPORT | SSL_FLAG_SSLv30 | SSL_FLAG_SSLv31,
		SSL_CIPHER_NULL,
		SSL_MAC_SHA,
		SSL_KEY_EXCHANGE_RSA,
		0,
		0,
		160
	},
	{ TLS_RSA_EXPORT_WITH_RC4_40_MD5,
		SSL_CIPHER_TYPE_STREAM,
		SSL_FLAG_EXPORT | SSL_FLAG_SSLv30 | SSL_FLAG_SSLv31,
		SSL_CIPHER_RC4,
		SSL_MAC_MD5,
		SSL_KEY_EXCHANGE_RSA_EXPORT,
		0,
		40,
		128
	},
	{ TLS_RSA_WITH_RC4_128_MD5,
		SSL_CIPHER_TYPE_STREAM,
		SSL_FLAG_SSLv30 | SSL_FLAG_SSLv31,
		SSL_CIPHER_RC4,
		SSL_MAC_MD5,
		SSL_KEY_EXCHANGE_RSA,
		0,
		128,
		128
	},
	{ TLS_RSA_WITH_RC4_128_SHA,
		SSL_CIPHER_TYPE_STREAM,
		SSL_FLAG_SSLv30 | SSL_FLAG_SSLv31,
		SSL_CIPHER_RC4,
		SSL_MAC_SHA,
		SSL_KEY_EXCHANGE_RSA,
		0,
		128,
		160
	},
	{ TLS_RSA_EXPORT_WITH_RC2_CBC_40_MD5,
		SSL_CIPHER_TYPE_BLOCK,
		SSL_FLAG_EXPORT | SSL_FLAG_SSLv30 | SSL_FLAG_SSLv31,
		SSL_CIPHER_RC2,
		SSL_MAC_MD5,
		SSL_KEY_EXCHANGE_RSA_EXPORT,
		0,
		40,
		128
	},
	{ TLS_RSA_WITH_IDEA_CBC_SHA,
		SSL_CIPHER_TYPE_BLOCK,
		SSL_FLAG_SSLv30 | SSL_FLAG_SSLv31,
		SSL_CIPHER_IDEA,
		SSL_MAC_SHA,
		SSL_KEY_EXCHANGE_RSA,
		0,
		128,
		160
	},
	{ TLS_RSA_EXPORT_WITH_DES40_CBC_SHA,
		SSL_CIPHER_TYPE_BLOCK,
		SSL_FLAG_EXPORT | SSL_FLAG_SSLv30 | SSL_FLAG_SSLv31,
		SSL_CIPHER_DES40,
		SSL_MAC_SHA,
		SSL_KEY_EXCHANGE_RSA_EXPORT,
		0,
		40,
		160
	},
	{ TLS_RSA_WITH_DES_CBC_SHA,
		SSL_CIPHER_TYPE_BLOCK,
		SSL_FLAG_SSLv30 | SSL_FLAG_SSLv31,
		SSL_CIPHER_DES,
		SSL_MAC_SHA,
		SSL_KEY_EXCHANGE_RSA,
		0,
		56,
		160
	},
	{ TLS_RSA_WITH_3DES_EDE_CBC_SHA,
		SSL_CIPHER_TYPE_BLOCK,
		SSL_FLAG_SSLv30 | SSL_FLAG_SSLv31,
		SSL_CIPHER_3DES,
		SSL_MAC_SHA,
		SSL_KEY_EXCHANGE_RSA,
		0,
		168,
		160
	},
	{ TLS_DH_DSS_EXPORT_WITH_DES40_CBC_SHA,
		SSL_CIPHER_TYPE_BLOCK,
		SSL_FLAG_EXPORT | SSL_FLAG_SSLv30 | SSL_FLAG_SSLv31,
		SSL_CIPHER_DES40,
		SSL_MAC_SHA,
		SSL_KEY_EXCHANGE_DH_DSS_EXPORT,
		0,
		40,
		160
	},
	{ TLS_DH_DSS_WITH_DES_CBC_SHA,
		SSL_CIPHER_TYPE_BLOCK,
		SSL_FLAG_SSLv30 | SSL_FLAG_SSLv31,
		SSL_CIPHER_DES,
		SSL_MAC_SHA,
		SSL_KEY_EXCHANGE_DH_DSS,
		0,
		56,
		160
	},
	{ TLS_DH_DSS_WITH_3DES_EDE_CBC_SHA,
		SSL_CIPHER_TYPE_BLOCK,
		SSL_FLAG_SSLv30 | SSL_FLAG_SSLv31,
		SSL_CIPHER_3DES,
		SSL_MAC_SHA,
		SSL_KEY_EXCHANGE_DH_DSS,
		0,
		168,
		160
	},
	{ TLS_DH_RSA_EXPORT_WITH_DES40_CBC_SHA,
		SSL_CIPHER_TYPE_BLOCK,
		SSL_FLAG_EXPORT | SSL_FLAG_SSLv30 | SSL_FLAG_SSLv31,
		SSL_CIPHER_DES40,
		SSL_MAC_SHA,
		SSL_KEY_EXCHANGE_DH_RSA_EXPORT,
		0,
		168,
		160
	},
	{ TLS_DH_RSA_WITH_DES_CBC_SHA,
		SSL_CIPHER_TYPE_BLOCK,
		SSL_FLAG_SSLv30 | SSL_FLAG_SSLv31,
		SSL_CIPHER_DES,
		SSL_MAC_SHA,
		SSL_KEY_EXCHANGE_DH_RSA,
		0,
		56,
		160
	},
	{ TLS_DH_RSA_WITH_3DES_EDE_CBC_SHA,
		SSL_CIPHER_TYPE_BLOCK,
		SSL_FLAG_SSLv30 | SSL_FLAG_SSLv31,
		SSL_CIPHER_3DES,
		SSL_MAC_SHA,
		SSL_KEY_EXCHANGE_DH_RSA,
		0,
		168,
		160
	},
	{ TLS_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA,
		SSL_CIPHER_TYPE_BLOCK,
		SSL_FLAG_EXPORT | SSL_FLAG_SSLv30 | SSL_FLAG_SSLv31,
		SSL_CIPHER_DES40,
		SSL_MAC_SHA,
		SSL_KEY_EXCHANGE_DHE_DSS_EXPORT,
		0,
		40,
		160
	},
	{ TLS_DHE_DSS_WITH_DES_CBC_SHA,
		SSL_CIPHER_TYPE_BLOCK,
		SSL_FLAG_SSLv30 | SSL_FLAG_SSLv31,
		SSL_CIPHER_DES,
		SSL_MAC_SHA,
		SSL_KEY_EXCHANGE_DHE_DSS,
		0,
		56,
		160
	},
	{ TLS_DHE_DSS_WITH_3DES_EDE_CBC_SHA,
		SSL_CIPHER_TYPE_BLOCK,
		SSL_FLAG_SSLv30 | SSL_FLAG_SSLv31,
		SSL_CIPHER_3DES,
		SSL_MAC_SHA,
		SSL_KEY_EXCHANGE_DHE_DSS,
		0,
		168,
		160
	},
	{ TLS_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA,
		SSL_CIPHER_TYPE_BLOCK,
		SSL_FLAG_EXPORT | SSL_FLAG_SSLv30 | SSL_FLAG_SSLv31,
		SSL_CIPHER_DES40,
		SSL_MAC_SHA,
		SSL_KEY_EXCHANGE_DHE_RSA_EXPORT,
		0,
		40,
		160
	},
	{ TLS_DHE_RSA_WITH_DES_CBC_SHA,
		SSL_CIPHER_TYPE_BLOCK,
		SSL_FLAG_SSLv30 | SSL_FLAG_SSLv31,
		SSL_CIPHER_DES,
		SSL_MAC_SHA,
		SSL_KEY_EXCHANGE_DHE_RSA,
		0,
		56,
		160
	},
	{ TLS_DHE_RSA_WITH_3DES_EDE_CBC_SHA,
		SSL_CIPHER_TYPE_BLOCK,
		SSL_FLAG_SSLv30 | SSL_FLAG_SSLv31,
		SSL_CIPHER_3DES,
		SSL_MAC_SHA,
		SSL_KEY_EXCHANGE_DHE_RSA,
		0,
		168,
		160
	},
	{ TLS_DH_ANON_EXPORT_WITH_RC4_40_MD5,
		SSL_CIPHER_TYPE_STREAM,
		SSL_FLAG_EXPORT | SSL_FLAG_SSLv30 | SSL_FLAG_SSLv31,
		SSL_CIPHER_RC4,
		SSL_MAC_MD5,
		SSL_KEY_EXCHANGE_DH_ANON_EXPORT,
		0,
		40,
		128
	},
	{ TLS_DH_ANON_WITH_RC4_128_MD5,
		SSL_CIPHER_TYPE_STREAM,
		SSL_FLAG_SSLv30 | SSL_FLAG_SSLv31,
		SSL_CIPHER_RC4,
		SSL_MAC_MD5,
		SSL_KEY_EXCHANGE_DH_ANON,
		0,
		128,
		128
	},
	{ TLS_DH_ANON_EXPORT_WITH_DES40_CBC_SHA,
		SSL_CIPHER_TYPE_BLOCK,
		SSL_FLAG_EXPORT | SSL_FLAG_SSLv30 | SSL_FLAG_SSLv31,
		SSL_CIPHER_DES40,
		SSL_MAC_SHA,
		SSL_KEY_EXCHANGE_DH_ANON,
		0,
		40,
		160
	},
	{ TLS_DH_ANON_WITH_DES_CBC_SHA,
		SSL_CIPHER_TYPE_BLOCK,
		SSL_FLAG_SSLv30 | SSL_FLAG_SSLv31,
		SSL_CIPHER_DES,
		SSL_MAC_SHA,
		SSL_KEY_EXCHANGE_DH_ANON,
		0,
		56,
		160
	},
	{ TLS_DH_ANON_WITH_3DES_EDE_CBC_SHA,
		SSL_CIPHER_TYPE_BLOCK,
		SSL_FLAG_SSLv30 | SSL_FLAG_SSLv31,
		SSL_CIPHER_3DES,
		SSL_MAC_SHA,
		SSL_KEY_EXCHANGE_DH_ANON,
		0,
		168,
		160
	},
	{ SSL_FORTEZZA_KEA_WITH_NULL_SHA,
		SSL_CIPHER_TYPE_BLOCK,
		SSL_FLAG_SSLv30,
		SSL_CIPHER_NULL,
		SSL_MAC_SHA,
		SSL_KEY_EXCHANGE_FORTEZZA_KEA,
		0,
		0,
		160
	},
	{ SSL_FORTEZZA_KEA_WITH_FORTEZZA_CBC_SHA,
		SSL_CIPHER_TYPE_BLOCK,
		SSL_FLAG_SSLv30,
		SSL_CIPHER_FORTEZZA,
		SSL_MAC_SHA,
		SSL_KEY_EXCHANGE_FORTEZZA_KEA,
		0,
		96,
		160
	},
	{ SSL_FORTEZZA_KEA_WITH_RC4_128_SHA,
		SSL_CIPHER_TYPE_STREAM,
		SSL_FLAG_SSLv30,
		SSL_CIPHER_RC4,
		SSL_MAC_SHA,
		SSL_KEY_EXCHANGE_FORTEZZA_KEA,
		0,
		128,
		160
	},
	// --- special SSLv3 FIPS ciphers
	{ SSL_RSA_FIPS_WITH_DES_CBC_SHA,
		SSL_CIPHER_TYPE_BLOCK,
		SSL_FLAG_SSLv30 | SSL_FLAG_SSLv31,
		SSL_CIPHER_DES,
		SSL_MAC_SHA,
		SSL_KEY_EXCHANGE_RSA,
		0,
		56,
		160
	},
	{ SSL_RSA_FIPS_WITH_3DES_EDE_CBC_SHA,
		SSL_CIPHER_TYPE_BLOCK,
		SSL_FLAG_SSLv30 | SSL_FLAG_SSLv31,
		SSL_CIPHER_3DES,
		SSL_MAC_SHA,
		SSL_KEY_EXCHANGE_RSA,
		0,
		168,
		160
	},
	// --- new 56 bit export ciphers
	{ TLS_RSA_EXPORT1024_WITH_DES_CBC_SHA,
		SSL_CIPHER_TYPE_BLOCK,
		SSL_FLAG_EXPORT | SSL_FLAG_SSLv30 | SSL_FLAG_SSLv31,
		SSL_CIPHER_DES,
		SSL_MAC_SHA,
		SSL_KEY_EXCHANGE_RSA_EXPORT1024,
		0,
		56,
		160
	},
	{ TLS_RSA_EXPORT1024_WITH_RC4_56_SHA,
		SSL_CIPHER_TYPE_STREAM,
		SSL_FLAG_EXPORT | SSL_FLAG_SSLv30 | SSL_FLAG_SSLv31,
		SSL_CIPHER_RC4,
		SSL_MAC_SHA,
		SSL_KEY_EXCHANGE_RSA_EXPORT1024,
		0,
		56,
		160
	},
	{ TLS_DHE_DSS_EXPORT1024_WITH_DES_CBC_SHA,
		SSL_CIPHER_TYPE_BLOCK,
		SSL_FLAG_EXPORT | SSL_FLAG_SSLv30 | SSL_FLAG_SSLv31,
		SSL_CIPHER_DES,
		SSL_MAC_SHA,
		SSL_KEY_EXCHANGE_DHE_DSS_EXPORT1024,
		0,
		56,
		160
	},
	{ TLS_DHE_DSS_EXPORT1024_WITH_RC4_56_SHA,
		SSL_CIPHER_TYPE_STREAM,
		SSL_FLAG_EXPORT | SSL_FLAG_SSLv30 | SSL_FLAG_SSLv31,
		SSL_CIPHER_RC4,
		SSL_MAC_SHA,
		SSL_KEY_EXCHANGE_DHE_DSS_EXPORT1024,
		0,
		56,
		160
	},
	{ TLS_DHE_DSS_WITH_RC4_128_SHA,
		SSL_CIPHER_TYPE_STREAM,
		SSL_FLAG_SSLv30 | SSL_FLAG_SSLv31,
		SSL_CIPHER_RC4,
		SSL_MAC_SHA,
		SSL_KEY_EXCHANGE_DHE_DSS,
		0,
		128,
		160
	},
	// --- new AES ciphers
	{ TLS_RSA_WITH_AES_128_CBC_SHA,
		SSL_CIPHER_TYPE_BLOCK,
		SSL_FLAG_SSLv30 | SSL_FLAG_SSLv31,
		SSL_CIPHER_AES,
		SSL_MAC_SHA,
		SSL_KEY_EXCHANGE_RSA,
		0,
		128,
		160
	},
	{ TLS_DH_DSS_WITH_AES_128_CBC_SHA,
		SSL_CIPHER_TYPE_BLOCK,
		SSL_FLAG_SSLv30 | SSL_FLAG_SSLv31,
		SSL_CIPHER_AES,
		SSL_MAC_SHA,
		SSL_KEY_EXCHANGE_DH_DSS,
		0,
		128,
		160
	},
	{ TLS_DH_RSA_WITH_AES_128_CBC_SHA,
		SSL_CIPHER_TYPE_BLOCK,
		SSL_FLAG_SSLv30 | SSL_FLAG_SSLv31,
		SSL_CIPHER_AES,
		SSL_MAC_SHA,
		SSL_KEY_EXCHANGE_DH_RSA,
		0,
		128,
		160
	},
	{ TLS_DHE_DSS_WITH_AES_128_CBC_SHA,
		SSL_CIPHER_TYPE_BLOCK,
		SSL_FLAG_SSLv30 | SSL_FLAG_SSLv31,
		SSL_CIPHER_AES,
		SSL_MAC_SHA,
		SSL_KEY_EXCHANGE_DHE_DSS,
		0,
		128,
		160
	},
	{ TLS_DHE_RSA_WITH_AES_128_CBC_SHA,
		SSL_CIPHER_TYPE_BLOCK,
		SSL_FLAG_SSLv30 | SSL_FLAG_SSLv31,
		SSL_CIPHER_AES,
		SSL_MAC_SHA,
		SSL_KEY_EXCHANGE_DHE_RSA,
		0,
		128,
		160
	},
	{ TLS_DH_ANON_WITH_AES_128_CBC_SHA,
		SSL_CIPHER_TYPE_BLOCK,
		SSL_FLAG_SSLv30 | SSL_FLAG_SSLv31,
		SSL_CIPHER_AES,
		SSL_MAC_SHA,
		SSL_KEY_EXCHANGE_DH_ANON,
		0,
		128,
		160
	},
	{ TLS_RSA_WITH_AES_256_CBC_SHA,
		SSL_CIPHER_TYPE_BLOCK,
		SSL_FLAG_SSLv30 | SSL_FLAG_SSLv31,
		SSL_CIPHER_AES,
		SSL_MAC_SHA,
		SSL_KEY_EXCHANGE_RSA,
		0,
		256,
		160
	},
	{ TLS_DH_DSS_WITH_AES_256_CBC_SHA,
		SSL_CIPHER_TYPE_BLOCK,
		SSL_FLAG_SSLv30 | SSL_FLAG_SSLv31,
		SSL_CIPHER_AES,
		SSL_MAC_SHA,
		SSL_KEY_EXCHANGE_DH_DSS,
		0,
		256,
		160
	},
	{ TLS_DH_RSA_WITH_AES_256_CBC_SHA,
		SSL_CIPHER_TYPE_BLOCK,
		SSL_FLAG_SSLv30 | SSL_FLAG_SSLv31,
		SSL_CIPHER_AES,
		SSL_MAC_SHA,
		SSL_KEY_EXCHANGE_DH_RSA,
		0,
		256,
		160
	},
	{ TLS_DHE_DSS_WITH_AES_256_CBC_SHA,
		SSL_CIPHER_TYPE_BLOCK,
		SSL_FLAG_SSLv30 | SSL_FLAG_SSLv31,
		SSL_CIPHER_AES,
		SSL_MAC_SHA,
		SSL_KEY_EXCHANGE_DHE_DSS,
		0,
		256,
		160
	},
	{ TLS_DHE_RSA_WITH_AES_256_CBC_SHA,
		SSL_CIPHER_TYPE_BLOCK,
		SSL_FLAG_SSLv30 | SSL_FLAG_SSLv31,
		SSL_CIPHER_AES,
		SSL_MAC_SHA,
		SSL_KEY_EXCHANGE_DHE_RSA,
		0,
		256,
		160
	},
	{ TLS_DH_ANON_WITH_AES_256_CBC_SHA,
		SSL_CIPHER_TYPE_BLOCK,
		SSL_FLAG_SSLv30 | SSL_FLAG_SSLv31,
		SSL_CIPHER_AES,
		SSL_MAC_SHA,
		SSL_KEY_EXCHANGE_DH_ANON,
		0,
		256,
		160
	}
};

const uint SSL_CipherSpecs_Count =
	sizeof(SSL_CipherSpecs) / sizeof(SSL_CipherSpec);
