static char* sccs_buttons_c = "%W%%G%";

#include "gen.h"

static	int 	ReadALine PROTO((FILE*, char**));
static	int	CheckForComments PROTO((FILE*));
static	int	KeyWordLength PROTO((char*));
static  int	GetKeyword PROTO((char*));
static	void	GetTitle PROTO((char*, char**));
static	int	GetSymbol PROTO((char*));
static	void	ConvertTitle PROTO((char*));
extern	int	ParseFile PROTO((FILE*, Info*, char*));
extern	void	DefaultButtons PROTO((Info *,int));
extern	void	CreateSubButton PROTO((Info*, int, int, char*));
extern	void	CreateMainMenuButton PROTO((Info*, int, int, char*, char*));
extern  void	CreateSubMenuButton PROTO((Info*, int, char*, int, char*));



extern  int
ProcessFile(data, prog_name)
Info    *data;
char    *prog_name;
{
        int     i = 0;
        FILE    *fp;

        fp = fopen(data->icon_file,"r");
        if(fp == NULL)
        {
		(void) fprintf(stderr,"\n%s: unable to open file: %s\n", prog_name, data->icon_file);
                fp = fopen(data->icon_file,"w");
                (void) fprintf(fp,"# Default .briconsrc file\n");
                (void) fprintf(fp,"# A line starting with a '#' is a comment line\n");
                (void) fprintf(fp,"# first line must have keyword %%icon or %%text\n");
                (void) fprintf(fp,"# to indicate if button is an icon or text\n");
                (void) fprintf(fp,"# for more information select the help button\n");
                (void) fprintf(fp,"\n%%text test1\n");
                (void) fprintf(fp,"xterm\n");
                fclose(fp);
        }
        else
        {
                i = ParseFile(fp, data, prog_name);
                fclose(fp);
		if(i == 0)
		{
			(void) fprintf(stderr,"\n%s: Very sorry cannot understand file: %s Is it corrupted?\n", prog_name, data->icon_file);
			DefaultButtons(data,i);
			return(0);
		}
		else if(data->default_buttons == True)
		{
			DefaultButtons(data,i); 
			return(i);
		}
		else
			return(--i);
	}
	DefaultButtons(data,i);
	return(0);
}

extern int
ParseFile(fp, data, prog_name)
FILE	*fp;
Info	*data;
char	*prog_name;
{
	int	line_no = 0;
	int	prev_kword = UNKNOWN;
	int	kword = UNKNOWN;
	int	button_no = 0;
	int	in_sub_menu = FALSE;
	int	sub_menu_no = 0;
	int	found_title = FALSE;
	int	ch;	
	char	*title = NULL;
	char	*heading = NULL;
	char	*exe_command = NULL;
	char	path[MAXPATHLEN];

	GetPath(path);
	ch = getc(fp);
	while(ch != EOF)
	{
		ungetc(ch,fp);
		line_no += ReadALine(fp, &heading);
		if(heading == NULL)
		{
			fprintf(stderr,"\n%s: Very sorry cannot understand file: %s is it corrupted?\n", prog_name, data->icon_file);
			exit(1);
		}
		if(*heading == '%')
		{
			prev_kword = kword;
			kword = GetSymbol(heading);
			switch(kword)
			{
				case SUB_MENU:
					if(in_sub_menu)
					{
						fprintf(stderr,"%s: error: only one sub menu allowed per button.\n", prog_name);
						break;
					}
					else
					{
						in_sub_menu = TRUE;
						CreateSubButton(data, 
						button_no, prev_kword, title);
					}
					break;
				case END_SUB_MENU:
					if(in_sub_menu)
					{
						if(sub_menu_no == 0)
						{
							fprintf(stderr, "\n%s: \"%s\" line: %d cannot have a sub menu with no buttons.\n", prog_name, data->icon_file, line_no - 1);
							exit(1);
						}
						sub_menu_no = 0;
						button_no++;
						in_sub_menu = FALSE;
					}
					break;
				case ICON:
				case ICONPLUS:
				case TEXT:
				case TEXTPLUS:
				case PIXMAP:
				case PIXMAPPLUS:
					found_title = TRUE;
					GetTitle(heading, &title);
					ConvertTitle(title);
					break;
				case UNKNOWN:
				default:
					fprintf(stderr,"%s: syntax error: in %s line: %d\n", prog_name, data->icon_file, line_no);
					break;
			}
		}
		else
		{
			if((found_title) && (GetCommand(path, heading, 
					data->icon_file, prog_name, line_no)))
			{
				exe_command = malloc(strlen(heading) + 1);
				if(exe_command == NULL)
				{
					fprintf(stderr,"\nFATAL ERROR: malloc out of memory.\n");
					exit(1);
				}
				strcpy(exe_command, heading);
				if(in_sub_menu)
				{
					if(sub_menu_no > MAXSUBBUTTONS)
					{
						fprintf(stderr,"\n%s: only %d buttons allowed for each sub menu.\n", prog_name, MAXSUBBUTTONS + 1);
					}
					else
					{
						CreateSubMenuButton(data, 
						kword, 
						title, sub_menu_no, 
						exe_command);
						sub_menu_no++;
					}
				}
				else
				{
					CreateMainMenuButton(data, button_no, 
						kword, title, exe_command);
					button_no++;
				}
				found_title = FALSE;
			}
		}	
		free(heading);
		ch = getc(fp);
	}
	return(button_no);
}

static void
GetTitle(buffer, title)
char	*buffer;
char	**title;
{
	int	i = 0;
	int	x = 0;
	int	title_len = 0;
	char	*c_ptr = NULL;

	i = KeyWordLength(buffer);
	title_len = strlen(buffer) - i;
	*title = malloc(title_len + 1);
	if(title == NULL)
	{
		fprintf(stderr,"\nFATAL ERROR: malloc out of memory.\n");
		exit(1);
	}
	c_ptr = buffer;
	while(x <= i)
	{
		c_ptr++;
		x++;
	}
	strncpy(*title, c_ptr, title_len);
}

static int
GetSymbol(buffer)
char	*buffer;
{
	char	key_word[100];
	int		i = 0;

	if((strcmp(buffer, "%sub_menu\n")) == 0)
		return(SUB_MENU);
	else if((strcmp(buffer, "%end_sub_menu\n")) == 0)
		return(END_SUB_MENU);
	else
	{
		i = KeyWordLength(buffer);
		strncpy(key_word, buffer, i);
		key_word[i++] = '\0';
		return(GetKeyword(key_word));
	}
}

static int
KeyWordLength(buffer)
char	*buffer;
{
	char    *c_ptr = buffer;
	int	i = 0;

	while((!isspace(*c_ptr)) && (*c_ptr != '\0'))
	{
		i++;
		c_ptr++;
	}
	return(i);
}

static int
ReadALine(fp,command)
FILE	*fp;
char	**command;
{
	int	space_allocated = 20;
	int	length = 0;
	int	l_no = 0;
	int	ch;
	char	*c_line;

	c_line = malloc(space_allocated + 1);
	if(c_line == NULL)
	{
		(void) fprintf(stderr,"\nFATAL ERROR: malloc out of memory.\n");
		exit(1);
	}
	l_no += CheckForComments(fp);
	while (((ch = getc(fp))!= EOF) && (ch != '\n'))
	{
		if(length == space_allocated)
		{
			space_allocated += 10;
			c_line =  realloc(c_line, space_allocated + 1);
		}
		c_line[length++] = ch;
	}
	c_line[length] = '\0';
	*command = malloc(strlen(c_line) +1);
	if(*command == NULL)
	{
		(void) fprintf(stderr,"\nFATAL ERROR: malloc out of memory.\n");
		exit(1);
	}
	strcpy(*command, c_line);
	free(c_line);
	l_no++;
	return(l_no);
}


static int
GetKeyword(label)
char	*label;
{
	int		symbol = UNKNOWN;

	if((strcmp(label,"%icon")) == 0)
		symbol = ICON;
	else if((strcmp(label,"%icon+")) == 0)
		symbol = ICONPLUS;
	else if((strcmp(label,"%text")) == 0)
		symbol = TEXT;
	else if((strcmp(label,"%text+")) == 0)
		symbol = TEXTPLUS;
	else if((strcmp(label,"%sub_menu")) == 0)
		symbol = SUB_MENU;
	else if((strcmp(label,"%end_sub_menu")) == 0)
		symbol = END_SUB_MENU;
	else if((strcmp(label,"%pixmap")) == 0)
		symbol = PIXMAP;
	else if((strcmp(label,"%pixmap+")) == 0)
		symbol = PIXMAPPLUS;
	else if((strcmp(label,"\0")) == 0)
		symbol = END;
	else
		symbol = UNKNOWN;
	return(symbol);
}


/*
	Read the button title from file pointed at by file pointer fp. 
*/
static void
ConvertTitle(title)
char	*title;
{
	int	j = 0;
	char	*c_ptr = NULL;
	char	*c_tmp = NULL;

	c_tmp = malloc(strlen(title) + 1);
	if(c_tmp == NULL)
	{
		(void) fprintf(stderr,"\nFATAL ERROR: malloc out of memory.\n");
		exit(1);
	}
	c_ptr = title;
	while(*c_ptr != '\0')
	{
		if(*c_ptr == '\\')
		{
			c_ptr++;
			if(*c_ptr == 'n')
			{
				c_tmp[j] = '\n';
				c_ptr++;
				j++;
			}
			else
				c_ptr--;
		}
		if(*c_ptr != '\0')
		{
			c_tmp[j] = *c_ptr;
			j++;
			c_ptr++;
		}
	}
	c_tmp[j++] = '\0';
	*title = '\0';
	strcpy(title, c_tmp);
	free(c_tmp);
}


/*
	Any line of text beginning with a "#" character is a comment line.
	This function looks for comment lines and ignores them.
*/
static int
CheckForComments(fp)
FILE	*fp;
{
	int	l_no = 0;
	int	is_comment = TRUE;
	int	ch;

	ch = getc(fp);
	while(is_comment)
	{
		if(ch == '\n')
			l_no++;
		if(ch == '#')
		{
			while((ch != EOF) && (ch != '\n'))
				ch = getc(fp);
		}
		else if(isspace(ch))
		{
			 while((ch != EOF) && (isspace(ch)))
			 {
				ch = getc(fp);
				if(ch == '\n')
					l_no++;
			 }
		}
		else
		{
			is_comment = FALSE;
			ungetc(ch,fp);
		}
	}
	return(l_no);
}
