static char* sccs_gen_c = "%W%%G%";

#include "gen.h"
#include <stdio.h>

static	int	IsExecutable PROTO((char *,char *)), 
		Executable PROTO((char *));
extern	int	GetCommand PROTO((char*, char*, char*, char*, int));
extern	void	GetPath PROTO((char*));

/*
	IsExecutable function searches along the users path trying to
	locate the file program.  If found a check is made to see if it
	is executable.  If it is TRUE is returned, otherwise FALSE is
	returned.
*/
static int
IsExecutable(path,program)
char	*path;
char	*program;
{
	int i, j;
	char	pathname[MAXPATHLEN];

	i = 0;
	if(*program == '/')
	{
		if(Executable(program))
			return(TRUE);
		else
			return(FALSE);
	}
	while (path[i] != '\0')
	{
		if (path[i] == ' ')
			++i;
		for (j = 0; path[i] != ' ' && path[i] != '\0'; ++i, ++j)
			pathname[j] = path[i];
		pathname[j++] = '/';
		strcpy(&pathname[j], program);
		if(Executable(pathname)) 
			return(TRUE);
	}
	return(FALSE);
}


/*
	GetCommand reads a line of text from the file pointed at by file
	pointer fp.  It then checks if the first word is a valid command.
*/
extern int
GetCommand(path, command, source_file, exe_name, line_no)
char	*path;
char	*command;
char	*source_file;
char	*exe_name;
int	line_no;
{
	int	i = 0;
	int	is_binary = FALSE;
	char	prog_name[MAXPATHLEN];
	char	*c_ptr;

	prog_name[0] = '\0';
	if(*command != NULL)
	{
		c_ptr = command;
		/* get first word from line of text */
		while((*c_ptr != ' ') && (*c_ptr != '\0') && (*c_ptr != ';') &&
				(*c_ptr != '\n'))
		{
			if(*c_ptr == '`')
				c_ptr++;
			prog_name[i++] = *c_ptr++;
		}
		prog_name[i] = '\0';
		if(IsExecutable(path,prog_name))
			is_binary = TRUE;
		else
		{
			(void) fprintf(stderr,"%s: Errr... in ", exe_name);
			(void) fprintf(stderr,"\"%s\" file\nline: %d cannot execute [%s] (not on path?).\n", source_file, line_no, prog_name);
		}
	}
	return(is_binary);
}



/*
	The function GetPath fills in the given char array with the value of 
	the environmental variable PATH, with spaces instead of colons, and a 
	'.' in the appropriate place.
*/
extern void
GetPath(p)
char *p;
{
        char *path;

        path = getenv("PATH");
        if (*path == ':')
                *p++ = '.';
        while (*path != '\0') {
                if (*path == ':')
                        *p++ = ' ';
                else
                        *p++ = *path;
                ++path;
        }
        if (*--path == ':')
                *p++ = '.';
        *p = '\0';
}


/*
	The Executable  function returns True if file exists and is a directly 
	executable Regular file. Otherwise False is returned.
 */
static int
Executable(file)
char *file;
{
        struct stat st_buf;

        if ( stat(file, &st_buf) != 0 )
           return (FALSE); 
        else 
           return (S_IFREG & st_buf.st_mode) && (access(file,1)==0) && 
		( !(S_IFDIR & st_buf.st_mode) ) ; 
}
