.\" static char* sccs_bricons_c = "%W%%G%";
.\"  bricons.l  B. Ingram version 3.0 16th November 1992
.TH BRICONS l "16th November 1992"
.SH NAME
bricons \- quick start up utility for applications using text, icons, colour
icons and pop-up menus on an X display
.SH SYNOPSIS
.B bricons
\ [options]
.br
[\fB\-file\fP] [\fB\-col\fP] [\fB\-help\fP] 
.br
[\fB\-bw\fP] [\fB\-bh\fP] [\fB\-bmdir\fP] [\fB\-default\fP]
.br
.SH DESCRIPTION
.LP
Bricons program allows the user to quickly start up applications
by selecting the appropriate button from the display and pressing the left 
mouse button.  A maximum of up to sixteen main menu buttons can be displayed.  
Each main menu button can launch an application or pop-up a sub menu containing 
more buttons. The buttons can be represented as a bitmap, text or a colour
icon (i.e Pixmap).
.LP
Information on how the program is to present each button (either as a bitmap, 
text or colour icon) and the application that is to be executed if that button 
is selected is contained in script file called .briconsrc.  This file should 
be stored in the same directory as the program is executed from.
.LP
The \&.briconsrc file contains a number of key words which are used to
indicate if the button label is some text, bitmap or pixmap and if the button 
is to pop-up a sub menu or launch a program.  These key words are explained 
below:
.LP
The .briconsrc file should start with the keyword
.B %icon
or
.B %text
or
.B %pixmap
The key word %icon indicates that the button label is a bitmap.  This should be
followed by the file name containing the bitmap.  For example:
.sp
.ce
%icon clock.icon
.LP
The key word %pixmap indicates that the button label is a colour pixmap.  This
should be followed by the full path name where the pixmap can be found.  For
example:
.sp
.ce
%pixmap /usr/cur/bri/xpm/clock.xpm
.LP
The key word %text indicates that the button label is some text.  The text can
be split over three lines by using the new line character \\n.  For 
example:
.sp
.ce
%text Line1\\nLine2\\nLine3
.LP
would be presented as:
.ce 3
Line1
Line2
Line3
.LP
Once a button has been selected it is prevented from accidentally being 
re-selected by "graying out" the button (default action).  Sometimes however 
it maybe desirable to allow the button to be selected more than once.  This
can be done be using the keyword
.B %icon+
or 
.B %pixmap+
or
.B %text+
.LP
The next line in the \&.briconsrc file should either contain the key word
%sub_menu or the application to be started.  If the name of an 
application  is given then a check is made to see if such an program can be 
executed.  If the program does not exist or is not in the users path then an 
error message is printed and the button associated with the application is 
ignored.
.LP
If the key word %sub_menu is used then a pop-up sub menu is created.  Any
further buttons defined in the briconsrc file will appear in the sub menu for
that button until the key word %end_sub_menu is found.  A maximum of
ten buttons are allowed in a single pop-up sub menu.
.LP
Any line in the \&.briconsrc file starting with a # character is 
treated as a comment and will be ignored.  
.LP
This program has four default buttons labelled source, edit, help and quit.
The edit button allows the user to edit there icon file (default being an empty
\&./briconsrc file) and to add or delete buttons from the script file.  The 
source button causes the program to distory all the current buttons being 
displayed and re-read the icon file and display the new buttons.
.SH OPTIONS
.LP
bricons accepts all of the standard X  Toolkit  command  line options along 
with the additional options listed below:
.TP
-file
Tells the program to read this file instead of the default file.
.TP
-col
Indicates the number of buttons in a column before starting a new row.  The 
default number of columns is 15.
.TP
-help
Tells the program the path for the help file.
.TP
-bmdir
This program will search the default bitmap directory (./bitmaps) for any 
bitmaps that are to be used to represent buttons.  If you wish to add 
different bitmap directories then use this command line argument followed by
a colon separated list of path names.  For example if the program needs to find
bitmaps in two different directories then the following can be entered at the
command line:
.sp
.ce
bricons -bmdir /usr/local/bitmaps:/usr/mydir/bitmaps
.TP
-default
Toggle used for including/not including the default \*QEdit Icons\*U  button
in the bricons program.  This flag expects a Boolean value.  If the bricons
program is called with the -default flag set to False then the 
\*QEdit Icons\*U  button is not included.
.TP
-bw
Specify the width of each button.
.TP
-bh
Specify the height of each button.
.sp
.SH X DEFAULTS
.LP
The bricons program reads the .Xdefaults file and Xbricons resource file
during startup and uses the appropriate resource specification to
customise the appearance or characteristics of its display.  This program 
understands all of the core resource names and classes as well as:
.TP
no_of_cols
Specifies the number of buttons in a column.
.TP
icon_file
Specifies path name for icon file to be read.
.TP
help_file
Specifies path name for help file.
.TP
icon_dirs
Specifies path name for bitmap directories.
.TP
button_w
Specify the width of each button.
.TP
button_h
Specifies the height of each button.
.LP
.SH SETTING BITMAP DIRECTORIES
.LP
This section explains how to specify bitmap file paths using the .Xdefaults
file.  For the quickest and simplest method see the OPTIONS section under
-bmdir.
.LP
This program will search the default bitmap directory for any bitmaps that
are to be used to represent buttons. If the user wishes the program to
search other directories for bitmap files then this should be specified in
the users .X11defaults file.  *BitmapFilePath: should be added followed by
colon separated path names where the bitmap files can be found.  For example:
.sp
.ce
*BitmapFilePath:	/usr/local/include/X11/bitmaps:/usr/mydir/bitmaps
.LP
.SH "FORMAT OF PIXMAP FILES"
.LP
This program uses version 3.2 of the xpm libraries written by Arnaud Le Hors
(source code can be found from anonymous ftp to export.lcs.mit.edu and from 
many other sites).  The bricons program will produce colour bitmap buttons 
from pixmap files provided that these files are in the correct format.  Below 
is a outline summary of the format for pixmap files.  For more detailed 
information please consult the xpm manual.  These files are text files so they 
can be edited using a normal text editor.
.LP
The XPM format presents a C syntax, in order to provide the ability to include
XPM files in C.  It is in fact an array of strings composed of six different
sections as follows:
.sp
.nf
/* XPM */
static char * <variable name> [] = {
/* width height ncolours chars_per_pixel */
<values>
/* colours */
<colours>
/* pixels */
<Pixels>
<Extensions>
};
.fi
.sp
.LP
For example:
.sp
.nf
/* XPM */
static char * clock [] = {
/* width height ncolors chars_per_pixel */
"125 85 4 1",
/* colours */
"       c #ffffffffffff",
"B      c #ffff00000000",
"C      c #ffffffff0000",
"D      c #000000000000",
"    BBBBBBBB  BBBB BBBB    BBBB  BBBBBBB",
"    BB BB BB   BB   BBB    BBB    BB    B",
"    B  BB  B   BB   BBB    BBB    BB    B",
cont.....
"                                         "};
.fi
.sp
.LP
.SH RESOURCE FILES
.LP
The Xbricons file specifies the required resources.  To make sure the program
uses the resources file set the following line in your .login:
.ce
setenv  XUSERFILESEARCHPATH ~/app_defaults/%N
.LP
and place all all resources in the app_defaults directory.
.bp
.SH WIDGETS
.LP
The bricons program is a toolkit-based application which consists of a 
combination of widgets.  In order to specify resources, it is useful to know
the hierarchy of the widgets which compose bricons.  In the list below, 
indentation indicates hierarchical structure.  The widget class name is given 
first, followed by the widget instance name.
.sp
.nf
	Xbricons	toplevel	
		Form	box
			Command	action[18]
			OverrideShell	popup_shell
				Form	popup_layout
				Command	sub_action[10]
.fi
.SH EXAMPLE
.LP
Below is an example of a simple \&.briconsrc file:
.sp
.nf
# <-- a line starting with a '#' is a comment line
#
#       Bri's icon file
#

# first line must have keyword %icon or %text
# to indicate if button is an icon

%icon calculator
xcalc
%text Games\\n sub\\n menu
%sub_menu
	%text xeyes
	xeyes
	%text othello
	othello 
%end_sub_menu
.if
.sp
.SH BUGS
After selecting the source button the buttons may not be re-displayed 
correctly.  Selecting the source button a second time may help.
.SH AUTHOR
Bruce R Ingram, University of Kent at Canterbury.
