#!/bin/sh
PATH=/usr/ccs/bin:${PATH}
export PATH

template=CONFIG
# check template file
if [ -f $template ]; then
  exit
fi

# check compiler
CC=cc
#type
#if [ $? = 1 ]; then
  # Ultrix
  for file in `echo $PATH|sed 's/:/ /g'`
  do
    if [ -f $file/gcc ]; then
      CC=gcc
      OPTS=-g
      break
    fi
  done
#else
#  set `type gcc`
#  if [ $1 = gcc ]; then
#    CC=$3
#    OPTS=-g
#  fi
#fi

if [ -f /usr/include/utime.h ]; then
    FUTIME="-DHAME_UTIME_H"
fi

if [ -f /usr/lib/libc.a ]; then
    LIBC=/usr/lib/libc.a
elif [ -f /lib/libc.a ]; then
    LIBC=/lib/libc.a
elif [ -f /usr/lib/libc.so ]; then
    LIBC=/usr/lib/libc.so
elif [ -f /usr/shlib/libc.so ]; then
    LIBC=/usr/shlib/lic.so
fi
nm ${LIBC} | grep timelocal >/dev/null
if [ $? != 0 ]; then
  FMKTIME="-DUSE_MKTIME"
  nm ${LIBC} | grep mktime > /dev/null
  if [ $? != 0 ]; then
    MKTIME="mktime.o"
  fi
fi
echo CC=${CC} MKTIME=${MKTIME} FLAG1=${FMKTIME} FLAG2=${FUTIME} OPTS="${OPTS}" >$template
