
#include "UmlSequenceMessage.h"
#include "FileOut.h"
#include "UmlItem.h"

#include <qptrdict.h>
#include <qstack.h>
#include "UmlPackage.h"
#include "UmlOperation.h"
#include "UmlFragmentCompartment.h"
#include "UmlClassInstanceReference.h"

UmlSequenceMessage::UmlSequenceMessage() : reverse(0) {
}

void UmlSequenceMessage::write(FileOut & out, UmlItem * diagram, const QVector< UmlSequenceMessage > & msgs)
{
  set_reverses(msgs);
  
  QList<UmlSequenceMessage> l;
  
  msgs.toList(&l);
  
  UmlSequenceMessage * m;
  
  while ((m = l.getFirst()) != 0) {
    if (m->fragment() != 0)
      m->fragment()->write(out, diagram, l);
    else
      m->write_it(out, diagram, l);
  }
}

void UmlSequenceMessage::write_it(FileOut & out, UmlItem * diagram, QList< UmlSequenceMessage > & msgs) {
  msgs.removeRef(this);
  
#define MSG  "MSG", itsrank
#define REF_MSG  "MSG", reverse->itsrank
#define SEND "MSGOCCSPECSEND", itsrank
#define REC  "MSGOCCSPECREC", itsrank
#define BEH  "BEHEXECSPEC", itsrank
#define REF_BEH  "BEHEXECSPEC", reverse->itsrank
#define EXEC "EXECOCCSPEC", itsrank
#define REF_EXEC "EXECOCCSPEC", reverse->itsrank
    
  UmlPackage * prj = UmlPackage::getProject();
  
  switch (kind()) {
  case aSynchronousCall:
  case anAsynchronousCall:
    out.indent();
    out << "<fragment xmi:type=\"uml:MessageOccurrenceSpecification\"";
    out.id_prefix(diagram, SEND);
    out.ref(diagram, "covered", from()->lifeline());
    out.ref(prj, "event", 
	    (operation() != 0) ? operation()->event(FALSE)
			       : UmlOperation::event("SEND", form()));
    out.ref(diagram, "message", MSG);
    out << "/>\n";
    
    out.indent();
    out << "<message xmi:type=\"uml:Message\"";
    out.id_prefix(diagram, MSG);
    out << " name=\"";
    out.quote((operation() != 0) ? operation()->name()
				 : form());
    out << ((kind() == anAsynchronousCall)
	    ? "\" messageSort=\"asynchCall\""
	    : "\" messageSort=\"synchCall\"");
    out.ref(diagram, "sendEvent", SEND);
    out.ref(diagram, "receiveEvent", REC);
    out.ref(diagram, "connector", from()->connector(to()));
    out << "/>\n";
    
    out.indent();
    out << "<fragment xmi:type=\"uml:MessageOccurrenceSpecification\"";
    out.id_prefix(diagram, REC);
    out.ref(diagram, "covered", to()->lifeline());
    out.ref(prj, "event", 
	    (operation() != 0) ? operation()->event(TRUE)
			       : UmlOperation::event("REC", form()));
    out.ref(diagram, "message", MSG);
    out << "/>\n";
    
    out.indent();
    out << "<fragment xmi:type=\"uml:BehaviorExecutionSpecification\"";
    out.id_prefix(diagram, BEH);
    out.ref(diagram, "covered", to()->lifeline());
    out.ref(diagram, "start", REC);
    if (reverse != 0) {
      if (reverse->kind() == anExplicitReturn)
	out.ref(diagram, "finish", REF_MSG);
      else
	out.ref(diagram, "finish", REF_EXEC);
    }
    out << "/>\n";
    break;
  case anExplicitReturn:
    out.indent();
    out << "<fragment xmi:type=\"uml:MessageOccurrenceSpecification\"";
    out.id_prefix(diagram, SEND);
    out.ref(diagram, "covered", from()->lifeline());
    out.ref(prj, "event", UmlOperation::event("SEND", form()));
    out.ref(diagram, "message", MSG);
    out << "/>\n";
    
    out.indent();
    out << "<message xmi:type=\"uml:Message\"";
    out.id_prefix(diagram, MSG);
    out << " name=\"";
    out.quote(form());
    out << "\" messageSort=\"reply\"";
    out.ref(diagram, "sendEvent", SEND);
    out.ref(diagram, "receiveEvent", REC);
    out.ref(diagram, "connector", from()->connector(to()));
    out << "/>\n";
    
    out.indent();
    out << "<fragment xmi:type=\"uml:MessageOccurrenceSpecification\"";
    out.id_prefix(diagram, REC);
    out.ref(diagram, "covered", to()->lifeline());
    out.ref(prj, "event", UmlOperation::event("REC", form()));
    out.ref(diagram, "message", MSG);
    out << "/>\n";
    break;
  default:
    if (reverse != 0) {
      out.indent();
      out << "<fragment xmi:type=\"uml:ExecutionOccurrenceSpecification\"";
      out.id_prefix(diagram, EXEC);
      out.ref(diagram, "covered", from()->lifeline());
      out.ref(prj, "event", 
	      UmlOperation::event("EXEC", form()));
      out.ref(diagram, "execution", REF_BEH);
      out << "/>\n";
    }
    break;
  }

}

void UmlSequenceMessage::set_reverses(const QVector<UmlSequenceMessage> & msgs)
{
  QPtrDict<QStack<UmlSequenceMessage> > sent;
  int n = msgs.size();
  
  for (int i = 0; i != n; i += 1) {
    UmlSequenceMessage * m = msgs[i];
    QStack<UmlSequenceMessage> * stack = sent[m->from()];
    
    switch (m->kind()) {
    case aSynchronousCall:
    case anAsynchronousCall:
      stack = sent[m->to()];      
      if (stack == 0) {
	stack = new QStack<UmlSequenceMessage>();
	sent.insert(m->to(), stack);
      }
      stack->push(m);
      
      if (m->fragment() != 0)
	m->fragment()->fragment()->cover(m);
      break;
    default: //  return
      stack = sent[m->from()];
      
      if ((stack != 0) &&
	  !stack->isEmpty() &&
	  ((m->kind() != anExplicitReturn) ||
	   (m->to() == stack->top()->from())))
	(m->reverse = stack->pop())->reverse = m;
    }
  }
  
  sent.setAutoDelete(TRUE);
}

