/* $Id: format.h 6654 2007-02-26 00:25:29Z relson $ */

#ifndef FORMAT_H
#define FORMAT_H

#include "configfile.h"

typedef const char *FIELD;

/* Global variables */

extern const char *spam_header_name;
extern const char *spam_subject_tag;
extern const char *unsure_subject_tag;
//extern const char *spam_header_place;

/* needed by bogoconfig.c */

extern const char *header_format;
extern const char *terse_format;
extern const char *log_update_format;
extern const char *log_header_format;
extern FIELD *spamicity_tags;
extern FIELD *spamicity_formats;

extern void set_terse_mode_format(int mode);

extern bool set_spamicity_tags(const char *val);
extern bool set_spamicity_formats(const char *val);
extern bool set_spamicity_fields(FIELD *strings, const char *val);

/* Function Prototypes */

extern char *format_header(char *buff, size_t size);
extern char *format_terse(char *buff, size_t size);
extern char *format_log_header(char *buff, size_t size);
extern char *format_log_update(char *buff, size_t size, const char *reg, const char *unreg, uint wordcount, uint msgcount);
#endif
