// Copyright Notice
// ================
// BOCHS is Copyright 1994-1999 by Kevin P. Lawton.
//
// BOCHS is commercial software.
//
// For more information, read the file 'LICENSE' included in the bochs
// distribution.  If you don't have access to this file, or have questions
// regarding the licensing policy, the author may be contacted via:
//
//     US Mail:  Kevin Lawton
//               439 Marrett Rd.
//               Lexington, MA 02421-7714
//
//     EMail:    bochs@world.std.com


// Program which generates sample CMOS image files



extern "C" {
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
}


#if 1
unsigned char cmos[] = {
  0x29, 0x2b, 0x30, 0x2b, 0x16, 0x0b, 0x00, 0x01,
  0x01, 0x96, 0x26, 0x02, 0x50, 0x80, 0x00, 0x00,
  0x40, 0x8f, 0xf0, 0xc0, 0x3f, 0x80, 0x02, 0x00,
  0x3c, 0x2f, 0x00, 0x4c, 0x0c, 0x10, 0x00, 0x00,
  0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x48, 0x2b, 0x03, 0x03, 0x03, 0x04, 0xce,
  0x00, 0x3c, 0x19, 0xff, 0xff, 0xf0, 0x00, 0xf0,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x7b
  };

#else
unsigned char cmos[] = {
  0x29, 0x2b, 0x30, 0x2b, 0x16, 0x0b, 0x00, 0x01,
  0x01, 0x96, 0x26, 0x02, 0x50, 0x80, 0x00, 0x00,
  0x40, 0x8f, 0xf0, 0xc0, 0x0f, 0x80, 0x02, 0x00,
  0x3c, 0x2f, 0x00, 0x1e, 0x00, 0x04, 0xff, 0xff,
  0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x08, 0x08, 0x03, 0x03, 0x03, 0x05, 0xc5,
  0x00, 0x3c, 0x00, 0x00, 0x00, 0xf0, 0x00, 0x10,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x21,  // 0x21

  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x10,  // 50
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // 60
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  // 70
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
  };
#endif

  int
main(int argc, char *argv[])
{
  int fd, ret;

  if (argc != 2) {
    fprintf(stderr, "usage: %s pathname\n", argv[0]);
    exit(1);
    }

  fd = open(argv[1], O_WRONLY | O_CREAT
#ifdef O_BINARY
                                    | O_BINARY
#endif
           , S_IRUSR | S_IWUSR
           );
  if (fd < 0) {
    perror("trying to open cmos image file to write.\n");
    exit(1);
    }

  ret = write(fd, cmos, sizeof(cmos));
  if (ret != sizeof(cmos)) {
    perror("write() did not write all CMOS data.\n");
    exit(1);
    }
  printf("CMOS data successfuly written to file '%s'.\n", argv[1]);
}
