// Copyright Notice
// ================
// BOCHS is Copyright 1994-1999 by Kevin P. Lawton.
//
// BOCHS is commercial software.
//
// For more information, read the file 'LICENSE' included in the bochs
// distribution.  If you don't have access to this file, or have questions
// regarding the licensing policy, the author may be contacted via:
//
//     US Mail:  Kevin Lawton
//               439 Marrett Rd.
//               Lexington, MA 02421-7714
//
//     EMail:    bochs@world.std.com


#if BX_PCI_SUPPORT

#if BX_USE_PCI_SMF
#  define BX_PCI_SMF  static
#  define BX_PCI_THIS bx_pci.
#else
#  define BX_PCI_SMF
#  define BX_PCI_THIS this->
#endif


typedef struct {
  Bit32u confAddr;
  Bit32u confData;
  Bit32u array[256];
  Bit8u  shadow[4*16*4096];     // 256k of memory
  } bx_def440fx_t;



class bx_pci_c {

public:
  bx_pci_c(void);
  ~bx_pci_c(void);
  BX_PCI_SMF void   init(bx_devices_c *);
  BX_PCI_SMF void   reset(void);
  BX_PCI_SMF void   print_i440fx_state( FILE *fd );
  BX_PCI_SMF Bit32u rd_memType (Bit32u addr);
  BX_PCI_SMF Bit32u wr_memType (Bit32u addr);
  BX_PCI_SMF Bit8u* i440fx_fetch_ptr(Bit32u addr);

  struct {
    bx_def440fx_t i440fx;
    } s;

private:
  bx_devices_c *devices;

  static Bit32u read_handler(void *this_ptr, Bit32u address, unsigned io_len);
  static void   write_handler(void *this_ptr, Bit32u address, Bit32u value, unsigned io_len);
#if !BX_USE_PCI_SMF
  Bit32u read(Bit32u address, unsigned io_len);
  void   write(Bit32u address, Bit32u value, unsigned io_len);
#endif
  BX_PCI_SMF Bit32u mapRead (Bit32u val);
  BX_PCI_SMF Bit32u mapWrite (Bit32u val);
  };

#if BX_USE_PCI_SMF
extern bx_pci_c bx_pci;
#endif

#endif  // #if BX_PCI_SUPPORT
