// Copyright Notice
// ================
// BOCHS is Copyright 1994-1999 by Kevin P. Lawton.
//
// BOCHS is commercial software.
//
// For more information, read the file 'LICENSE' included in the bochs
// distribution.  If you don't have access to this file, or have questions
// regarding the licensing policy, the author may be contacted via:
//
//     US Mail:  Kevin Lawton
//               439 Marrett Rd.
//               Lexington, MA 02421-7714
//
//     EMail:    bochs@world.std.com

// Peter Grehan (grehan@iprg.nokia.com) coded all of this
// NE2000/ether stuff.

//  eth.h  - see eth_null.cc for implementation details

typedef void (*eth_rx_handler_t)(void *arg, const void *buf, unsigned len);


//
//  The eth_pktmover class is used by ethernet chip emulations
// to interface to the outside world. An instance of this
// would allow frames to be sent to and received from some
// entity. An example would be the packet filter on a Unix
// system, an NDIS driver in promisc mode on WinNT, or maybe
// a simulated network that talks to another process.
//
class eth_pktmover_c {
public:
  virtual void sendpkt(void *buf, unsigned io_len) = 0;
protected:
  eth_rx_handler_t  rxh;   // receive callback
  void *rxarg;
};


//
//  The eth_locator class is used by pktmover classes to register
// their name. Chip emulations use the static 'create' method
// to locate and instantiate a pktmover class.
//
class eth_locator_c {
public:
  static eth_pktmover_c *create(const char *type, const char *netif,
				const char *macaddr,
				eth_rx_handler_t rxh, 
				void *rxarg);
protected:
  eth_locator_c(const char *type);
  virtual eth_pktmover_c *allocate(const char *netif,
				const char *macaddr,
				eth_rx_handler_t rxh, 
				void *rxarg) = 0;
private:
  static eth_locator_c *all;
  eth_locator_c *next;
  const char *type;
};


// Define the known pktmover modules
#define ETH_NULL  1
#ifdef __FreeBSD__
#define ETH_FBSD  1
#endif
