// Copyright Notice
// ================
// BOCHS is Copyright 1994-1999 by Kevin P. Lawton.
//
// BOCHS is commercial software.
//
// For more information, read the file 'LICENSE' included in the bochs
// distribution.  If you don't have access to this file, or have questions
// regarding the licensing policy, the author may be contacted via:
//
//     US Mail:  Kevin Lawton
//               439 Marrett Rd.
//               Lexington, MA 02421-7714
//
//     EMail:    bochs@world.std.com





#include "bochs.h"




  void
BX_CPU_C::Resolve16Mod0Rm0(BxInstruction_t *i)
{
  i->rm_addr = (Bit16u) (BX + SI);
}
  void
BX_CPU_C::Resolve16Mod0Rm1(BxInstruction_t *i)
{
  i->rm_addr = (Bit16u) (BX + DI);
}
  void
BX_CPU_C::Resolve16Mod0Rm2(BxInstruction_t *i)
{
  i->rm_addr = (Bit16u) (BP + SI);
}
  void
BX_CPU_C::Resolve16Mod0Rm3(BxInstruction_t *i)
{
  i->rm_addr = (Bit16u) (BP + DI);
}
  void
BX_CPU_C::Resolve16Mod0Rm4(BxInstruction_t *i)
{
  i->rm_addr = (Bit16u) SI;
}
  void
BX_CPU_C::Resolve16Mod0Rm5(BxInstruction_t *i)
{
  i->rm_addr = (Bit16u) DI;
}
  void
BX_CPU_C::Resolve16Mod0Rm7(BxInstruction_t *i)
{
  i->rm_addr = (Bit16u) BX;
}

  void
BX_CPU_C::Resolve16Mod1or2Rm0(BxInstruction_t *i)
{
  i->rm_addr = (Bit16u) (BX + SI + (Bit16s) i->displ16u);
}
  void
BX_CPU_C::Resolve16Mod1or2Rm1(BxInstruction_t *i)
{
  i->rm_addr = (Bit16u) (BX + DI + (Bit16s) i->displ16u);
}
  void
BX_CPU_C::Resolve16Mod1or2Rm2(BxInstruction_t *i)
{
  i->rm_addr = (Bit16u) (BP + SI + (Bit16s) i->displ16u);
}
  void
BX_CPU_C::Resolve16Mod1or2Rm3(BxInstruction_t *i)
{
  i->rm_addr = (Bit16u) (BP + DI + (Bit16s) i->displ16u);
}
  void
BX_CPU_C::Resolve16Mod1or2Rm4(BxInstruction_t *i)
{
  i->rm_addr = (Bit16u) (SI + (Bit16s) i->displ16u);
}
  void
BX_CPU_C::Resolve16Mod1or2Rm5(BxInstruction_t *i)
{
  i->rm_addr = (Bit16u) (DI + (Bit16s) i->displ16u);
}
  void
BX_CPU_C::Resolve16Mod1or2Rm6(BxInstruction_t *i)
{
  i->rm_addr = (Bit16u) (BP + (Bit16s) i->displ16u);
}
  void
BX_CPU_C::Resolve16Mod1or2Rm7(BxInstruction_t *i)
{
  i->rm_addr = (Bit16u) (BX + (Bit16s) i->displ16u);
}
