/*	$NetBSD: config.c,v 1.4 2007/01/25 20:33:41 plunky Exp $	*/

/*-
 * Copyright (c) 2006 Itronix Inc.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of Itronix Inc. may not be used to endorse
 *    or promote products derived from this software without specific
 *    prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY ITRONIX INC. ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL ITRONIX INC. BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include <sys/time.h>
#include <bluetooth.h>
#include <db.h>
#include <errno.h>
#include <event.h>
#include <fcntl.h>
#include <stdlib.h>
#include <string.h>
#include <syslog.h>
#include <unistd.h>

#include "bthcid.h"

typedef struct {
	bdaddr_t laddr;
	bdaddr_t raddr;
} db_keyid_t;

static const char *key_file = "/var/db/bthcid.keys";
static DB *key_db = NULL;

static DB *
load_keys(void)
{
	if (key_db == NULL)
		key_db = dbopen(key_file, O_CREAT | O_RDWR, 0600,
		    DB_HASH, NULL);

	return key_db;
}

/*
 * Look up key in keys file. We store a dictionary for each
 * remote address, and inside that we have a data object for
 * each local address containing the key.
 */
uint8_t *
lookup_key(bdaddr_t *laddr, bdaddr_t *raddr)
{
	static uint8_t key[HCI_KEY_SIZE];
	db_keyid_t id;
	DB *db;
	DBT dbk;
	DBT dbd;

	db = load_keys();
	if (db == NULL)
		return NULL;

	memset(&id, 0, sizeof id);
	bdaddr_copy(&id.laddr, laddr);
	bdaddr_copy(&id.raddr, raddr);
	memset(&dbk, 0, sizeof dbk);
	dbk.size = sizeof id;
	dbk.data = &id;
	memset(&dbd, 0, sizeof dbd);
	if (db->get(db, &dbk, &dbd, 0) == 0 && dbd.size == HCI_KEY_SIZE)
		return (uint8_t *)dbd.data;

	return NULL;
}

void
save_key(bdaddr_t *laddr, bdaddr_t *raddr, uint8_t *key)
{
	DB *db;
	db_keyid_t id;
	DBT dbk;
	DBT dbd;

	db = load_keys();
	if (db == NULL)
		return;

	memset(&id, 0, sizeof id);
	bdaddr_copy(&id.laddr, laddr);
	bdaddr_copy(&id.raddr, raddr);
	memset(&dbk, 0, sizeof dbk);
	dbk.size = sizeof id;
	dbk.data = &id;
	memset(&dbd, 0, sizeof dbd);
	dbd.size = HCI_KEY_SIZE;
	dbd.data = key;
	(void)db->put(db, &dbk, &dbd, 0);
	db->sync(db, 0);
}
