/* Bluefish HTML Editor
 * html2.c - menu/toolbar callbacks, inserting functions, and other cool stuff 
 * otherwise html.c is getting so long ;-)
 *
 * Copyright (C) 1999 Olivier Sessink
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#include "default_include.h"

#include <locale.h>
#include <string.h>  	/* strlen() */

#include "gtk_easy.h"
#include "bf_lib.h"  /* strip_any_whitespace() */
#include "bluefish.h"
#include "stringlist.h"
#include "document.h"
#include "html.h"
#include "cap.h"
#include "pixmaps.h" /* new_pixmap */
#include "coloursel.h"  /* color_but_new */

#ifdef OLD_CSS_DIALOG
GList *garbage = NULL;

typedef struct {
	GtkWidget *table;
	GtkWidget *dialog;
	GtkWidget *label;
	GtkWidget *combo[54];
	GtkWidget *spin[2];
	GtkWidget *entry[4];
	GtkWidget *check[6];
	GtkWidget *radio[10];
	GtkWidget *okbutton;
	GtkWidget *cancelbutton;
	gint abort;
	gchar *tmpstring;
} Thtml2dialog;

void html2_dialog_cancel(GtkWidget * widget, Thtml2dialog * data);
void html2_dialog_ok(GtkWidget * widget, Thtml2dialog * data);
Thtml2dialog *startdialog(gchar * title, gint rows, gint cols);
void middle_dialog(Thtml2dialog * this_ds, gint leftbuts, gint middlebuts, gint rightbuts, gint topbuts, gint botbuts);

void html2_dialog_cancel(GtkWidget * widget, Thtml2dialog * data)
{
	gtk_signal_handlers_destroy(GTK_OBJECT(data->dialog));
	gtk_main_quit();
	DEBUG_MSG("html2_dialog_cancel, gtk_main_quit() called\n");
}

void html2_dialog_ok(GtkWidget * widget, Thtml2dialog * data)
{
	data->abort = 0;
	DEBUG_MSG("html2_dialog_ok, abort=%d, calling cancel to stop this gtk_main()\n", data->abort);
	html2_dialog_cancel(widget, data);
}

Thtml2dialog *startdialog(gchar * title, gint rows, gint cols)
{

	Thtml2dialog *return_ds;
	return_ds = g_malloc(sizeof(Thtml2dialog));

	return_ds->abort = 1;
	return_ds->dialog = gtk_window_new(GTK_WINDOW_DIALOG);
	gtk_container_border_width(GTK_CONTAINER(return_ds->dialog), 10);
	/*gtk_signal_connect (GTK_OBJECT (return_ds->dialog), "delete_event", GTK_SIGNAL_FUNC
	   (html2_dialog_cancel), return_ds); */
	gtk_signal_connect(GTK_OBJECT(return_ds->dialog), "destroy", GTK_SIGNAL_FUNC(html2_dialog_cancel), return_ds);
	gtk_window_set_title(GTK_WINDOW(return_ds->dialog), title);
	gtk_window_position(GTK_WINDOW(return_ds->dialog), GTK_WIN_POS_CENTER);

	return_ds->table = gtk_table_new(rows, cols, 0);
	gtk_container_add(GTK_CONTAINER(return_ds->dialog), return_ds->table);
	return return_ds;
}

void middle_dialog(Thtml2dialog * this_ds, gint leftbuts, gint middlebuts, gint rightbuts, gint topbuts, gint botbuts)
{
	this_ds->okbutton = bf_stock_ok_button(GTK_SIGNAL_FUNC(html2_dialog_ok), this_ds);
	this_ds->cancelbutton = bf_stock_cancel_button(GTK_SIGNAL_FUNC(html2_dialog_cancel), this_ds);

	GTK_WIDGET_SET_FLAGS(this_ds->okbutton, GTK_CAN_DEFAULT);
	GTK_WIDGET_SET_FLAGS(this_ds->cancelbutton, GTK_CAN_DEFAULT);
	gtk_table_attach_defaults(GTK_TABLE(this_ds->table), this_ds->okbutton, leftbuts, middlebuts, topbuts, botbuts);
	gtk_table_attach_defaults(GTK_TABLE(this_ds->table), this_ds->cancelbutton, middlebuts, rightbuts, topbuts, botbuts);

	gtk_widget_show_all(this_ds->dialog);
	gtk_widget_realize(this_ds->dialog);
	gtk_window_set_default(GTK_WINDOW(this_ds->dialog), this_ds->okbutton);
	gtk_grab_add(this_ds->dialog);
	DEBUG_MSG("middle_dialog, about to call gtk_main()\n");
	gtk_main();
	DEBUG_MSG("middle_dialog, this gtk_main() is finished\n");
}


gchar *insert_if_string(gchar * formatstring, GtkWidget * entry, gchar * return_if_empty)
{
	gchar *string2return;

	if (strlen(gtk_entry_get_text(GTK_ENTRY(entry))) > 1) {
		string2return = g_strdup_printf(formatstring, gtk_entry_get_text(GTK_ENTRY(entry)));
		garbage = g_list_append(garbage, string2return);
	} else {
		if (return_if_empty == NULL) {
			string2return = g_strdup("");
			garbage = g_list_append(garbage, string2return);
		} else {
			string2return = return_if_empty;
		}
	}
	DEBUG_MSG("insert_if_string, garbage=%p, lenght=%d\n", garbage, g_list_length(garbage));
	DEBUG_MSG("insert_if_string, finished, string2return=%p\n", string2return);
	return string2return;
}

GList *make_length_list(gfloat from, gfloat to, gint allow_percentage, gint high_percentage)
{

	GList *list2return;

	list2return = g_list_append(NULL, "");

	if ((from < 0.1) && (to > 0.3)) {
		list2return = g_list_append(list2return, "0.1em");
		list2return = g_list_append(list2return, "0.2em");
		list2return = g_list_append(list2return, "0.3em");
		list2return = g_list_append(list2return, "0.5em");
		list2return = g_list_append(list2return, "0.1ex");
		list2return = g_list_append(list2return, "0.2ex");
		list2return = g_list_append(list2return, "0.3ex");
		list2return = g_list_append(list2return, "0.5ex");
		list2return = g_list_append(list2return, "1pt");
		list2return = g_list_append(list2return, "2pt");
		list2return = g_list_append(list2return, "4pt");
		list2return = g_list_append(list2return, "6pt");
	}
	if ((from < 0.5) && (to > 3)) {
		list2return = g_list_append(list2return, "0.7em");
		list2return = g_list_append(list2return, "1em");
		list2return = g_list_append(list2return, "2em");
		list2return = g_list_append(list2return, "3em");
		list2return = g_list_append(list2return, "0.7ex");
		list2return = g_list_append(list2return, "1ex");
		list2return = g_list_append(list2return, "2ex");
		list2return = g_list_append(list2return, "3ex");
		list2return = g_list_append(list2return, "7pt");
		list2return = g_list_append(list2return, "10pt");
		list2return = g_list_append(list2return, "12pt");
		list2return = g_list_append(list2return, "15pt");
	}
	if ((from < 3) && (to > 15)) {
		list2return = g_list_append(list2return, "6em");
		list2return = g_list_append(list2return, "9em");
		list2return = g_list_append(list2return, "12em");
		list2return = g_list_append(list2return, "15em");
		list2return = g_list_append(list2return, "6ex");
		list2return = g_list_append(list2return, "9ex");
		list2return = g_list_append(list2return, "12ex");
		list2return = g_list_append(list2return, "15ex");
		list2return = g_list_append(list2return, "20pt");
		list2return = g_list_append(list2return, "25pt");
		list2return = g_list_append(list2return, "30pt");
		list2return = g_list_append(list2return, "50pt");
	}
	if (allow_percentage == 1) {
		list2return = g_list_append(list2return, "10%");
		list2return = g_list_append(list2return, "20%");
		list2return = g_list_append(list2return, "30%");
		list2return = g_list_append(list2return, "40%");
		list2return = g_list_append(list2return, "50%");
		list2return = g_list_append(list2return, "60%");
		list2return = g_list_append(list2return, "70%");
		list2return = g_list_append(list2return, "80%");
		list2return = g_list_append(list2return, "90%");
		list2return = g_list_append(list2return, "100%");
	}
	if (high_percentage == 1) {
		list2return = g_list_append(list2return, "110%");
		list2return = g_list_append(list2return, "120%");
		list2return = g_list_append(list2return, "130%");
		list2return = g_list_append(list2return, "140%");
		list2return = g_list_append(list2return, "160%");
		list2return = g_list_append(list2return, "180%");
		list2return = g_list_append(list2return, "200%");
		list2return = g_list_append(list2return, "250%");
		list2return = g_list_append(list2return, "300%");
		list2return = g_list_append(list2return, "500%");
	}
	return list2return;
}


/* the actual functions dialogs */


void insert_class(GtkWidget * widget, gpointer data)
{

	Thtml2dialog *ds;

	ds = startdialog(_("Insert class"), 3, 4);

	gtk_table_attach_defaults(GTK_TABLE(ds->table), gtk_label_new(_("Insert class")), 1, 3, 0, 1);
	gtk_table_attach_defaults(GTK_TABLE(ds->table), gtk_label_new(_("CLASS=")), 0, 1, 1, 2);

	ds->combo[1] = combo_with_popdown(NULL, main_v->current_project.classlist, 1);
	gtk_table_attach_defaults(GTK_TABLE(ds->table), ds->combo[1], 1, 4, 1, 2);

	middle_dialog(ds, 0, 2, 4, 2, 3);

	if (ds->abort != 1) {
		ds->tmpstring = g_strdup_printf(cap(" CLASS=\"%s\" "), gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(ds->combo[1])->entry)));
		main_v->current_project.classlist =
			add_to_stringlist(main_v->current_project.classlist, gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(ds->combo[1])->entry)));
		insert_dbl_text(ds->tmpstring, "");
		g_free(ds->tmpstring);
	}

	if (GTK_IS_WIDGET(ds->dialog))
		gtk_widget_destroy(ds->dialog);
	g_free(ds);
}
/* *************************
	better ones in html.c
	*************************

void insert_div(GtkWidget * widget, gpointer data)
{

	Thtml2dialog *ds;

	ds = startdialog(_("DIV"), 3, 4);
	gtk_table_attach_defaults(GTK_TABLE(ds->table), gtk_label_new(_("DIV")), 1, 3, 0, 1);
	gtk_table_attach_defaults(GTK_TABLE(ds->table), gtk_label_new(_("class ")), 0, 1, 1, 2);
	ds->combo[1] = gtk_combo_new();
	if (main_v->current_project.classlist != NULL) {
		gtk_combo_set_popdown_strings(GTK_COMBO(ds->combo[1]), main_v->current_project.classlist);
	}
	gtk_table_attach_defaults(GTK_TABLE(ds->table), ds->combo[1], 1, 4, 1, 2);

	middle_dialog(ds, 0, 2, 4, 2, 3);

	if (ds->abort != 1) {
		ds->tmpstring = g_strdup_printf(cap("<DIV CLASS=\"%s\">"), gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(ds->combo[1])->entry)));
		insert_dbl_text(ds->tmpstring, cap("</DIV>"));
		main_v->current_project.classlist =
			add_to_stringlist(main_v->current_project.classlist, gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(ds->combo[1])->entry)));
		g_free(ds->tmpstring);
	}

	if (GTK_IS_WIDGET(ds->dialog))
		gtk_widget_destroy(ds->dialog);
	g_free(ds);
} */

/* *************************
	better ones in html.c
	*************************
void insert_span(GtkWidget * widget, gpointer data)
{

	Thtml2dialog *ds;

	ds = startdialog(_("SPAN"), 3, 4);
	gtk_table_attach_defaults(GTK_TABLE(ds->table), gtk_label_new(_("SPAN")), 1, 3, 0, 1);
	gtk_table_attach_defaults(GTK_TABLE(ds->table), gtk_label_new(_("class ")), 0, 1, 1, 2);
	ds->combo[1] = gtk_combo_new();
	if (main_v->current_project.classlist != NULL) {
		gtk_combo_set_popdown_strings(GTK_COMBO(ds->combo[1]), main_v->current_project.classlist);
	}
	gtk_table_attach_defaults(GTK_TABLE(ds->table), ds->combo[1], 1, 4, 1, 2);

	middle_dialog(ds, 0, 2, 4, 2, 3);

	if (ds->abort != 1) {
		ds->tmpstring = g_strdup_printf(cap("<SPAN CLASS=\"%s\">"), gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(ds->combo[1])->entry)));
		insert_dbl_text(ds->tmpstring, cap("</SPAN>"));
		main_v->current_project.classlist =
			add_to_stringlist(main_v->current_project.classlist, gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(ds->combo[1])->entry)));
		g_free(ds->tmpstring);
	}

	if (GTK_IS_WIDGET(ds->dialog))
		gtk_widget_destroy(ds->dialog);
	g_free(ds);
}*/

/* the complex CSS dialog */
void sizing_unit_font_cb(GtkWidget * widget, Thtml2dialog * data)
{
	GList *tmplist;

	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(data->radio[1]))) {
		tmplist = g_list_append(NULL, "");
		tmplist = g_list_append(tmplist, "xx-small");
		tmplist = g_list_append(tmplist, "x-small");
		tmplist = g_list_append(tmplist, "small");
		tmplist = g_list_append(tmplist, "medium");
		tmplist = g_list_append(tmplist, "large");
		tmplist = g_list_append(tmplist, "x-large");
		tmplist = g_list_append(tmplist, "xx-large");
		gtk_combo_set_popdown_strings(GTK_COMBO(data->combo[5]), tmplist);
		gtk_combo_set_popdown_strings(GTK_COMBO(data->combo[6]), tmplist);
		gtk_editable_set_editable(GTK_EDITABLE(GTK_ENTRY(GTK_COMBO(data->combo[5])->entry)), FALSE);
		gtk_editable_set_editable(GTK_EDITABLE(GTK_ENTRY(GTK_COMBO(data->combo[6])->entry)), FALSE);
		g_list_free(tmplist);
	} else if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(data->radio[2]))) {
		tmplist = g_list_append(NULL, "");
		tmplist = g_list_append(tmplist, "larger");
		tmplist = g_list_append(tmplist, "smaller");
		gtk_combo_set_popdown_strings(GTK_COMBO(data->combo[5]), tmplist);
		gtk_combo_set_popdown_strings(GTK_COMBO(data->combo[6]), tmplist);
		gtk_editable_set_editable(GTK_EDITABLE(GTK_ENTRY(GTK_COMBO(data->combo[5])->entry)), FALSE);
		gtk_editable_set_editable(GTK_EDITABLE(GTK_ENTRY(GTK_COMBO(data->combo[6])->entry)), FALSE);
		g_list_free(tmplist);
	} else {
		tmplist = make_length_list(2.9, 20, 1, 1);
		gtk_combo_set_popdown_strings(GTK_COMBO(data->combo[5]), tmplist);
		gtk_combo_set_popdown_strings(GTK_COMBO(data->combo[6]), tmplist);
		gtk_editable_set_editable(GTK_EDITABLE(GTK_ENTRY(GTK_COMBO(data->combo[5])->entry)), TRUE);
		gtk_editable_set_editable(GTK_EDITABLE(GTK_ENTRY(GTK_COMBO(data->combo[6])->entry)), TRUE);
		g_list_free(tmplist);
	}
}

void sizing_unit_bg_cb(GtkWidget * widget, Thtml2dialog * data)
{
	GList *tmplist;

	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(data->radio[4]))) {
		tmplist = make_length_list(0, 0, 1, 0);
		gtk_combo_set_popdown_strings(GTK_COMBO(data->combo[16]), tmplist);
		gtk_combo_set_popdown_strings(GTK_COMBO(data->combo[17]), tmplist);
		gtk_editable_set_editable(GTK_EDITABLE(GTK_ENTRY(GTK_COMBO(data->combo[16])->entry)), TRUE);
		gtk_editable_set_editable(GTK_EDITABLE(GTK_ENTRY(GTK_COMBO(data->combo[17])->entry)), TRUE);
		g_list_free(tmplist);
	} else if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(data->radio[5]))) {
		tmplist = g_list_append(NULL, "");
		tmplist = g_list_append(tmplist, "1cm");
		tmplist = g_list_append(tmplist, "2cm");
		gtk_combo_set_popdown_strings(GTK_COMBO(data->combo[16]), tmplist);
		gtk_combo_set_popdown_strings(GTK_COMBO(data->combo[17]), tmplist);
		gtk_editable_set_editable(GTK_EDITABLE(GTK_ENTRY(GTK_COMBO(data->combo[16])->entry)), TRUE);
		gtk_editable_set_editable(GTK_EDITABLE(GTK_ENTRY(GTK_COMBO(data->combo[17])->entry)), TRUE);
		g_list_free(tmplist);
	} else {
		tmplist = g_list_append(NULL, "");
		tmplist = g_list_append(tmplist, "top");
		tmplist = g_list_append(tmplist, "center");
		tmplist = g_list_append(tmplist, "bottom");
		gtk_combo_set_popdown_strings(GTK_COMBO(data->combo[16]), tmplist);
		g_list_free(tmplist);
		tmplist = g_list_append(NULL, "");
		tmplist = g_list_append(tmplist, "left");
		tmplist = g_list_append(tmplist, "center");
		tmplist = g_list_append(tmplist, "right");
		gtk_combo_set_popdown_strings(GTK_COMBO(data->combo[17]), tmplist);
		g_list_free(tmplist);
		gtk_editable_set_editable(GTK_EDITABLE(GTK_ENTRY(GTK_COMBO(data->combo[16])->entry)), FALSE);
		gtk_editable_set_editable(GTK_EDITABLE(GTK_ENTRY(GTK_COMBO(data->combo[17])->entry)), FALSE);
	}
}

void insert_in_stylesheet(GtkWidget * widget, gpointer data)
{

	Thtml2dialog *ds;
	GtkWidget *notebook, *table, *vbox, *frame, *file_but;
	GList *tmplist = NULL;
	GSList *group;
	gchar *fontstring, *bgncolorstring, *textstring, *margstring, *padstring, *sizeplacestring, *borderstring, *classistring;

	ds = startdialog(_("New style"), 6, 4);
	gtk_table_attach_defaults(GTK_TABLE(ds->table), gtk_label_new(_("Insert new style")), 1, 3, 0, 1);
	gtk_table_attach_defaults(GTK_TABLE(ds->table), gtk_label_new(_("tag")), 0, 1, 1, 2);
	gtk_table_attach_defaults(GTK_TABLE(ds->table), gtk_label_new(_("class")), 0, 1, 2, 3);
	gtk_table_attach_defaults(GTK_TABLE(ds->table), gtk_label_new(_("pseudo class")), 0, 1, 3, 4);

	tmplist = glist_with_html_tags(0);
	ds->combo[8] = combo_with_popdown(NULL, tmplist, 1);
	g_list_free(tmplist);
	gtk_table_attach_defaults(GTK_TABLE(ds->table), ds->combo[8], 1, 3, 1, 2);
	ds->combo[9] = combo_with_popdown(NULL, main_v->current_project.classlist, 1);
	gtk_table_attach_defaults(GTK_TABLE(ds->table), ds->combo[9], 1, 3, 2, 3);
	tmplist = g_list_append(NULL, "");
	tmplist = g_list_append(tmplist, "link");
	tmplist = g_list_append(tmplist, "visited");
	tmplist = g_list_append(tmplist, "active");
	tmplist = g_list_append(tmplist, "hover");
	tmplist = g_list_append(tmplist, "focus");
	tmplist = g_list_append(tmplist, "after");
	tmplist = g_list_append(tmplist, "before");
	tmplist = g_list_append(tmplist, "first-line");
	tmplist = g_list_append(tmplist, "first-letter");
	tmplist = g_list_append(tmplist, "first-child");
	ds->combo[10] = combo_with_popdown(NULL, tmplist, 1);
	g_list_free(tmplist);
	gtk_table_attach_defaults(GTK_TABLE(ds->table), ds->combo[10], 1, 3, 3, 4);

	notebook = gtk_notebook_new();
	gtk_notebook_set_tab_border(GTK_NOTEBOOK(notebook), 0);
	gtk_notebook_set_tab_pos(GTK_NOTEBOOK(notebook), GTK_POS_BOTTOM);
	gtk_table_attach_defaults(GTK_TABLE(ds->table), notebook, 0, 4, 4, 5);

	/* start on font tab */
	table = gtk_table_new(4, 9, 0);
	gtk_table_attach_defaults(GTK_TABLE(table), gtk_label_new(_("font-family")), 0, 1, 1, 2);
	gtk_table_attach_defaults(GTK_TABLE(table), gtk_label_new(_("font-style")), 0, 1, 2, 3);
	gtk_table_attach_defaults(GTK_TABLE(table), gtk_label_new(_("font-variant")), 0, 1, 3, 4);
	gtk_table_attach_defaults(GTK_TABLE(table), gtk_label_new(_("font-weight")), 0, 1, 4, 5);
	gtk_table_attach_defaults(GTK_TABLE(table), gtk_label_new(_("font-size")), 2, 3, 5, 6);
	gtk_table_attach_defaults(GTK_TABLE(table), gtk_label_new(_("line-height")), 2, 3, 7, 8);
	ds->check[1] = gtk_check_button_new_with_label(_("Insert as one line"));
	gtk_table_attach_defaults(GTK_TABLE(table), ds->check[1], 0, 4, 0, 1);

	ds->combo[1] = combo_with_popdown(NULL, main_v->current_project.fontlist, 1);
	gtk_table_attach_defaults(GTK_TABLE(table), ds->combo[1], 1, 4, 1, 2);

	tmplist = g_list_append(NULL, "");
	tmplist = g_list_append(tmplist, "normal");
	tmplist = g_list_append(tmplist, "italic");
	tmplist = g_list_append(tmplist, "oblique");
	ds->combo[2] = combo_with_popdown(NULL, tmplist, 0);
	g_list_free(tmplist);
	gtk_table_attach_defaults(GTK_TABLE(table), ds->combo[2], 1, 4, 2, 3);

	tmplist = g_list_append(NULL, "");
	tmplist = g_list_append(tmplist, "normal");
	tmplist = g_list_append(tmplist, "small-caps");
	ds->combo[3] = combo_with_popdown(NULL, tmplist, 0);
	g_list_free(tmplist);
	gtk_table_attach_defaults(GTK_TABLE(table), ds->combo[3], 1, 4, 3, 4);

	tmplist = g_list_append(NULL, "");
	tmplist = g_list_append(tmplist, "normal");
	tmplist = g_list_append(tmplist, "bold");
	tmplist = g_list_append(tmplist, "bolder");
	tmplist = g_list_append(tmplist, "lighter");
	tmplist = g_list_append(tmplist, "100");
	tmplist = g_list_append(tmplist, "200");
	tmplist = g_list_append(tmplist, "300");
	tmplist = g_list_append(tmplist, "400");
	tmplist = g_list_append(tmplist, "500");
	tmplist = g_list_append(tmplist, "600");
	tmplist = g_list_append(tmplist, "700");
	tmplist = g_list_append(tmplist, "800");
	tmplist = g_list_append(tmplist, "900");
	ds->combo[4] = combo_with_popdown(NULL, tmplist, 0);
	gtk_table_attach_defaults(GTK_TABLE(table), ds->combo[4], 1, 4, 4, 5);
	g_list_free(tmplist);

	tmplist = g_list_append(NULL, "");
	ds->combo[5] = combo_with_popdown(NULL, tmplist, 1);
	gtk_table_attach_defaults(GTK_TABLE(table), ds->combo[5], 2, 4, 6, 7);

	tmplist = g_list_append(NULL, "");
	ds->combo[6] = combo_with_popdown(NULL, tmplist, 1);
	gtk_table_attach_defaults(GTK_TABLE(table), ds->combo[6], 2, 4, 8, 9);

	frame = gtk_frame_new("size unit");
	gtk_table_attach(GTK_TABLE(table), frame, 0, 2, 5, 9, GTK_FILL | GTK_EXPAND, GTK_FILL | GTK_EXPAND, 5, 5);
	vbox = gtk_vbox_new(TRUE, 1);
	gtk_container_add(GTK_CONTAINER(frame), vbox);
	ds->radio[1] = gtk_radio_button_new_with_label(NULL, _("absolute size"));
	gtk_box_pack_start(GTK_BOX(vbox), ds->radio[1], TRUE, TRUE, 0);
	group = gtk_radio_button_group(GTK_RADIO_BUTTON(ds->radio[1]));
	ds->radio[2] = gtk_radio_button_new_with_label(group, _("relative size"));
	gtk_box_pack_start(GTK_BOX(vbox), ds->radio[2], TRUE, TRUE, 0);
	group = gtk_radio_button_group(GTK_RADIO_BUTTON(ds->radio[2]));
	ds->radio[3] = gtk_radio_button_new_with_label(group, _("length/percentage"));
	gtk_box_pack_start(GTK_BOX(vbox), ds->radio[3], TRUE, TRUE, 0);
	group = gtk_radio_button_group(GTK_RADIO_BUTTON(ds->radio[3]));
	gtk_signal_connect(GTK_OBJECT(ds->radio[1]), "clicked", sizing_unit_font_cb, ds);
	gtk_signal_connect(GTK_OBJECT(ds->radio[2]), "clicked", sizing_unit_font_cb, ds);
	gtk_signal_connect(GTK_OBJECT(ds->radio[3]), "clicked", sizing_unit_font_cb, ds);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(ds->radio[3]), 1);
	/* font tab completed */
	gtk_notebook_append_page(GTK_NOTEBOOK(notebook), table, apply_font_style(gtk_label_new("Font"), main_v->props.cfg_tab_font));

	/* margin&padding tab started */
	/* check 3-4, combo 25-32 */

	table = table = gtk_table_new(3, 7, 0);
	gtk_table_attach_defaults(GTK_TABLE(table), gtk_label_new(_("margin")), 1, 2, 2, 3);
	gtk_table_attach_defaults(GTK_TABLE(table), gtk_label_new(_("padding")), 2, 3, 2, 3);
	gtk_table_attach_defaults(GTK_TABLE(table), gtk_label_new(_("top")), 0, 1, 3, 4);
	gtk_table_attach_defaults(GTK_TABLE(table), gtk_label_new(_("right")), 0, 1, 4, 5);
	gtk_table_attach_defaults(GTK_TABLE(table), gtk_label_new(_("bottom")), 0, 1, 5, 6);
	gtk_table_attach_defaults(GTK_TABLE(table), gtk_label_new(_("left")), 0, 1, 6, 7);
	ds->check[3] = gtk_check_button_new_with_label(_("Insert margin as one line"));
	gtk_table_attach_defaults(GTK_TABLE(table), ds->check[3], 0, 3, 0, 1);
	ds->check[4] = gtk_check_button_new_with_label(_("Insert padding as one line"));
	gtk_table_attach_defaults(GTK_TABLE(table), ds->check[4], 0, 3, 1, 2);
	tmplist = make_length_list(0.1, 10, 1, 0);
	g_list_append(tmplist, "auto");
	ds->combo[25] = combo_with_popdown(NULL, tmplist, 1);
	gtk_table_attach_defaults(GTK_TABLE(table), ds->combo[25], 1, 2, 3, 4);
	ds->combo[27] = combo_with_popdown(NULL, tmplist, 1);
	gtk_table_attach_defaults(GTK_TABLE(table), ds->combo[27], 1, 2, 4, 5);
	ds->combo[29] = combo_with_popdown(NULL, tmplist, 1);
	gtk_table_attach_defaults(GTK_TABLE(table), ds->combo[29], 1, 2, 5, 6);
	ds->combo[31] = combo_with_popdown(NULL, tmplist, 1);
	gtk_table_attach_defaults(GTK_TABLE(table), ds->combo[31], 1, 2, 6, 7);
	g_list_free(tmplist);

	tmplist = make_length_list(0.1, 10, 1, 0);
	ds->combo[26] = combo_with_popdown(NULL, tmplist, 1);
	gtk_table_attach_defaults(GTK_TABLE(table), ds->combo[26], 2, 3, 3, 4);
	ds->combo[28] = combo_with_popdown(NULL, tmplist, 1);
	gtk_table_attach_defaults(GTK_TABLE(table), ds->combo[28], 2, 3, 4, 5);
	ds->combo[30] = combo_with_popdown(NULL, tmplist, 1);
	gtk_table_attach_defaults(GTK_TABLE(table), ds->combo[30], 2, 3, 5, 6);
	ds->combo[32] = combo_with_popdown(NULL, tmplist, 1);
	gtk_table_attach_defaults(GTK_TABLE(table), ds->combo[32], 2, 3, 6, 7);
	g_list_free(tmplist);

	/* margin&padding tab completed */
	gtk_notebook_append_page(GTK_NOTEBOOK(notebook), table,
							 apply_font_style(gtk_label_new(_("Margin & padding")), main_v->props.cfg_tab_font));

	/* border tab started */
	table = table = gtk_table_new(4, 8, 0);
	gtk_table_attach_defaults(GTK_TABLE(table), gtk_label_new(_("width")), 1, 2, 3, 4);
	gtk_table_attach_defaults(GTK_TABLE(table), gtk_label_new(_("color")), 2, 3, 3, 4);
	gtk_table_attach_defaults(GTK_TABLE(table), gtk_label_new(_("style")), 3, 4, 3, 4);
	gtk_table_attach_defaults(GTK_TABLE(table), gtk_label_new(_("top")), 0, 1, 4, 5);
	gtk_table_attach_defaults(GTK_TABLE(table), gtk_label_new(_("right")), 0, 1, 5, 6);
	gtk_table_attach_defaults(GTK_TABLE(table), gtk_label_new(_("bottom")), 0, 1, 6, 7);
	gtk_table_attach_defaults(GTK_TABLE(table), gtk_label_new(_("left")), 0, 1, 7, 8);
	ds->radio[7] = gtk_radio_button_new_with_label(NULL, _("Insert values per property"));
	gtk_table_attach_defaults(GTK_TABLE(table), ds->radio[7], 0, 4, 0, 1);
	group = gtk_radio_button_group(GTK_RADIO_BUTTON(ds->radio[7]));
	ds->radio[8] = gtk_radio_button_new_with_label(group, _("Insert values per border side"));
	gtk_table_attach_defaults(GTK_TABLE(table), ds->radio[8], 0, 4, 1, 2);
	group = gtk_radio_button_group(GTK_RADIO_BUTTON(ds->radio[8]));
	ds->radio[9] = gtk_radio_button_new_with_label(group, _("Insert top-values as general value for all sides"));
	gtk_table_attach_defaults(GTK_TABLE(table), ds->radio[9], 0, 4, 2, 3);
	group = gtk_radio_button_group(GTK_RADIO_BUTTON(ds->radio[9]));
	tmplist = make_length_list(0, 0.5, 0, 0);
	tmplist = g_list_append(tmplist, "thin");
	tmplist = g_list_append(tmplist, "medium");
	tmplist = g_list_append(tmplist, "thick");
	ds->combo[41] = combo_with_popdown(NULL, tmplist, 1);
	gtk_table_attach_defaults(GTK_TABLE(table), ds->combo[41], 1, 2, 4, 5);
	ds->combo[44] = combo_with_popdown(NULL, tmplist, 1);
	gtk_table_attach_defaults(GTK_TABLE(table), ds->combo[44], 1, 2, 5, 6);
	ds->combo[47] = combo_with_popdown(NULL, tmplist, 1);
	gtk_table_attach_defaults(GTK_TABLE(table), ds->combo[47], 1, 2, 6, 7);
	ds->combo[50] = combo_with_popdown(NULL, tmplist, 1);
	gtk_table_attach_defaults(GTK_TABLE(table), ds->combo[50], 1, 2, 7, 8);

	ds->combo[42] = combo_with_popdown(NULL, main_v->current_project.colorlist, 1);
	gtk_table_attach_defaults(GTK_TABLE(table), ds->combo[42], 2, 3, 4, 5);
	ds->combo[45] = combo_with_popdown(NULL, main_v->current_project.colorlist, 1);
	gtk_table_attach_defaults(GTK_TABLE(table), ds->combo[45], 2, 3, 5, 6);
	ds->combo[48] = combo_with_popdown(NULL, main_v->current_project.colorlist, 1);
	gtk_table_attach_defaults(GTK_TABLE(table), ds->combo[48], 2, 3, 6, 7);
	ds->combo[51] = combo_with_popdown(NULL, main_v->current_project.colorlist, 1);
	gtk_table_attach_defaults(GTK_TABLE(table), ds->combo[51], 2, 3, 7, 8);

	tmplist = g_list_append(NULL, "");
	tmplist = g_list_append(tmplist, "none");
	tmplist = g_list_append(tmplist, "dotted");
	tmplist = g_list_append(tmplist, "dashed");
	tmplist = g_list_append(tmplist, "solid");
	tmplist = g_list_append(tmplist, "double");
	tmplist = g_list_append(tmplist, "groove");
	tmplist = g_list_append(tmplist, "ridge");
	tmplist = g_list_append(tmplist, "inset");
	tmplist = g_list_append(tmplist, "outset");
	ds->combo[43] = combo_with_popdown(NULL, tmplist, 1);
	gtk_table_attach_defaults(GTK_TABLE(table), ds->combo[43], 3, 4, 4, 5);
	ds->combo[46] = combo_with_popdown(NULL, tmplist, 1);
	gtk_table_attach_defaults(GTK_TABLE(table), ds->combo[46], 3, 4, 5, 6);
	ds->combo[49] = combo_with_popdown(NULL, tmplist, 1);
	gtk_table_attach_defaults(GTK_TABLE(table), ds->combo[49], 3, 4, 6, 7);
	ds->combo[52] = combo_with_popdown(NULL, tmplist, 1);
	gtk_table_attach_defaults(GTK_TABLE(table), ds->combo[52], 3, 4, 7, 8);
	g_list_free(tmplist);
	/* border tab completed */
	gtk_notebook_append_page(GTK_NOTEBOOK(notebook), table, apply_font_style(gtk_label_new("Border"), main_v->props.cfg_tab_font));

	/* size&placement tab started */
	/* combo 33 - 36 */
	table = table = gtk_table_new(2, 4, 0);
	gtk_table_attach_defaults(GTK_TABLE(table), gtk_label_new(_("width")), 0, 1, 0, 1);
	gtk_table_attach_defaults(GTK_TABLE(table), gtk_label_new(_("height")), 0, 1, 1, 2);
	gtk_table_attach_defaults(GTK_TABLE(table), gtk_label_new(_("float")), 0, 1, 2, 3);
	gtk_table_attach_defaults(GTK_TABLE(table), gtk_label_new(_("clear")), 0, 1, 3, 4);
	tmplist = make_length_list(2.9, 100, 1, 1);
	ds->combo[33] = combo_with_popdown(NULL, tmplist, 1);
	g_list_free(tmplist);
	gtk_table_attach_defaults(GTK_TABLE(table), ds->combo[33], 1, 2, 0, 1);
	tmplist = make_length_list(2.9, 100, 0, 0);
	ds->combo[34] = combo_with_popdown(NULL, tmplist, 1);
	g_list_free(tmplist);
	gtk_table_attach_defaults(GTK_TABLE(table), ds->combo[34], 1, 2, 1, 2);
	tmplist = g_list_append(NULL, "");
	tmplist = g_list_append(tmplist, "left");
	tmplist = g_list_append(tmplist, "right");
	tmplist = g_list_append(tmplist, "none");
	ds->combo[35] = combo_with_popdown(NULL, tmplist, 1);
	g_list_free(tmplist);
	gtk_table_attach_defaults(GTK_TABLE(table), ds->combo[35], 1, 2, 2, 3);
	tmplist = g_list_append(NULL, "");
	tmplist = g_list_append(tmplist, "left");
	tmplist = g_list_append(tmplist, "right");
	tmplist = g_list_append(tmplist, "none");
	tmplist = g_list_append(tmplist, "both");
	ds->combo[36] = combo_with_popdown(NULL, tmplist, 1);
	g_list_free(tmplist);
	gtk_table_attach_defaults(GTK_TABLE(table), ds->combo[36], 1, 2, 3, 4);
	/* size&placement tab completed */
	gtk_notebook_append_page(GTK_NOTEBOOK(notebook), table,
							 apply_font_style(gtk_label_new(_("Size & placement")), main_v->props.cfg_tab_font));

	/* color&background tab started */
	table = table = gtk_table_new(5, 9, 0);
	gtk_table_attach_defaults(GTK_TABLE(table), gtk_label_new(_("color")), 0, 1, 0, 1);
	gtk_table_attach_defaults(GTK_TABLE(table), gtk_label_new(_("background-color")), 0, 1, 2, 3);
	gtk_table_attach_defaults(GTK_TABLE(table), gtk_label_new(_("background-image")), 0, 1, 3, 4);
	gtk_table_attach_defaults(GTK_TABLE(table), gtk_label_new(_("background-repeat")), 0, 1, 4, 5);
	gtk_table_attach_defaults(GTK_TABLE(table), gtk_label_new(_("background-attachment")), 0, 1, 5, 6);
	gtk_table_attach_defaults(GTK_TABLE(table), gtk_label_new(_("background-position")), 2, 4, 6, 7);
	gtk_table_attach_defaults(GTK_TABLE(table), gtk_label_new(_("accross")), 2, 3, 7, 8);
	gtk_table_attach_defaults(GTK_TABLE(table), gtk_label_new(_("down")), 2, 3, 8, 9);

	ds->combo[11] = combo_with_popdown(NULL, main_v->current_project.colorlist, 1);
	gtk_table_attach_defaults(GTK_TABLE(table), ds->combo[11], 1, 4, 0, 1);
	ds->check[2] = gtk_check_button_new_with_label(_("Insert background as one line"));
	gtk_table_attach_defaults(GTK_TABLE(table), ds->check[2], 0, 4, 1, 2);
	ds->combo[12] = combo_with_popdown(NULL, main_v->current_project.colorlist, 1);
	gtk_table_attach_defaults(GTK_TABLE(table), ds->combo[12], 1, 4, 2, 3);
	ds->combo[13] = combo_with_popdown(NULL, main_v->current_project.urllist, 1);
	gtk_table_attach_defaults(GTK_TABLE(table), ds->combo[13], 1, 4, 3, 4);

	tmplist = g_list_append(NULL, "");
	tmplist = g_list_append(tmplist, "repeat");
	tmplist = g_list_append(tmplist, "repeat-x");
	tmplist = g_list_append(tmplist, "repeat-y");
	tmplist = g_list_append(tmplist, "no-repeat");
	ds->combo[14] = combo_with_popdown(NULL, tmplist, 0);
	gtk_table_attach_defaults(GTK_TABLE(table), ds->combo[14], 1, 4, 4, 5);
	g_list_free(tmplist);

	tmplist = g_list_append(NULL, "");
	tmplist = g_list_append(tmplist, "scroll");
	tmplist = g_list_append(tmplist, "fixed");
	ds->combo[15] = combo_with_popdown(NULL, tmplist, 0);
	gtk_table_attach_defaults(GTK_TABLE(table), ds->combo[15], 1, 4, 5, 6);
	g_list_free(tmplist);

	tmplist = g_list_append(NULL, "");
	ds->combo[16] = combo_with_popdown(NULL, tmplist, 1);
	gtk_table_attach_defaults(GTK_TABLE(table), ds->combo[16], 3, 5, 7, 8);

	tmplist = g_list_append(NULL, "");
	ds->combo[17] = combo_with_popdown(NULL, tmplist, 1);
	gtk_table_attach_defaults(GTK_TABLE(table), ds->combo[17], 3, 5, 8, 9);

	frame = gtk_frame_new(_("size unit"));
	gtk_table_attach(GTK_TABLE(table), frame, 0, 2, 6, 9, GTK_FILL | GTK_EXPAND, GTK_FILL | GTK_EXPAND, 5, 5);
	vbox = gtk_vbox_new(TRUE, 1);
	group = NULL;
	gtk_container_add(GTK_CONTAINER(frame), vbox);
	ds->radio[4] = gtk_radio_button_new_with_label(NULL, _("percentage"));
	gtk_box_pack_start(GTK_BOX(vbox), ds->radio[4], TRUE, TRUE, 0);
	group = gtk_radio_button_group(GTK_RADIO_BUTTON(ds->radio[4]));
	ds->radio[5] = gtk_radio_button_new_with_label(group, _("absolute size"));
	gtk_box_pack_start(GTK_BOX(vbox), ds->radio[5], TRUE, TRUE, 0);
	group = gtk_radio_button_group(GTK_RADIO_BUTTON(ds->radio[5]));
	ds->radio[6] = gtk_radio_button_new_with_label(group, _("keyword"));
	gtk_box_pack_start(GTK_BOX(vbox), ds->radio[6], TRUE, TRUE, 0);
	group = gtk_radio_button_group(GTK_RADIO_BUTTON(ds->radio[6]));
	gtk_signal_connect(GTK_OBJECT(ds->radio[4]), "clicked", sizing_unit_bg_cb, ds);
	gtk_signal_connect(GTK_OBJECT(ds->radio[5]), "clicked", sizing_unit_bg_cb, ds);
	gtk_signal_connect(GTK_OBJECT(ds->radio[6]), "clicked", sizing_unit_bg_cb, ds);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(ds->radio[4]), 1);

	/* color&background tab completed */
	gtk_notebook_append_page(GTK_NOTEBOOK(notebook), table,
							 apply_font_style(gtk_label_new(_("Color & background")), main_v->props.cfg_tab_font));

	/* text tab started */
	table = table = gtk_table_new(2, 7, 0);
	gtk_table_attach_defaults(GTK_TABLE(table), gtk_label_new(_("word-spacing")), 0, 1, 0, 1);
	gtk_table_attach_defaults(GTK_TABLE(table), gtk_label_new(_("letter-spacing")), 0, 1, 1, 2);
	gtk_table_attach_defaults(GTK_TABLE(table), gtk_label_new(_("vertical-align")), 0, 1, 2, 3);
	gtk_table_attach_defaults(GTK_TABLE(table), gtk_label_new(_("text-align")), 0, 1, 3, 4);
	gtk_table_attach_defaults(GTK_TABLE(table), gtk_label_new(_("text-decoration")), 0, 1, 4, 5);
	gtk_table_attach_defaults(GTK_TABLE(table), gtk_label_new(_("text-transform")), 0, 1, 5, 6);
	gtk_table_attach_defaults(GTK_TABLE(table), gtk_label_new(_("text-indent")), 0, 1, 6, 7);

	tmplist = make_length_list(0.4, 4, 0, 0);
	ds->combo[18] = combo_with_popdown(NULL, tmplist, 1);
	gtk_table_attach_defaults(GTK_TABLE(table), ds->combo[18], 1, 2, 0, 1);
	g_list_free(tmplist);
	tmplist = make_length_list(0, 0.6, 0, 0);
	ds->combo[19] = combo_with_popdown(NULL, tmplist, 1);
	gtk_table_attach_defaults(GTK_TABLE(table), ds->combo[19], 1, 2, 1, 2);
	g_list_free(tmplist);
	tmplist = g_list_append(NULL, "");
	tmplist = g_list_append(tmplist, "baseline");
	tmplist = g_list_append(tmplist, "sub");
	tmplist = g_list_append(tmplist, "super");
	tmplist = g_list_append(tmplist, "top");
	tmplist = g_list_append(tmplist, "text-top");
	tmplist = g_list_append(tmplist, "middle");
	tmplist = g_list_append(tmplist, "bottom");
	tmplist = g_list_append(tmplist, "text-bottom");
	tmplist = g_list_append(tmplist, "-50%");
	tmplist = g_list_append(tmplist, "-100%");
	tmplist = g_list_append(tmplist, "50%");
	tmplist = g_list_append(tmplist, "100%");
	ds->combo[20] = combo_with_popdown(NULL, tmplist, 1);
	gtk_table_attach_defaults(GTK_TABLE(table), ds->combo[20], 1, 2, 2, 3);
	g_list_free(tmplist);
	tmplist = g_list_append(NULL, "");
	tmplist = g_list_append(tmplist, "left");
	tmplist = g_list_append(tmplist, "right");
	tmplist = g_list_append(tmplist, "center");
	tmplist = g_list_append(tmplist, "justify");
	ds->combo[21] = combo_with_popdown(NULL, tmplist, 0);
	gtk_table_attach_defaults(GTK_TABLE(table), ds->combo[21], 1, 2, 3, 4);
	g_list_free(tmplist);
	tmplist = g_list_append(NULL, "");
	tmplist = g_list_append(tmplist, "none");
	tmplist = g_list_append(tmplist, "underline");
	tmplist = g_list_append(tmplist, "overline");
	tmplist = g_list_append(tmplist, "line-trough");
	tmplist = g_list_append(tmplist, "blink");
	ds->combo[22] = combo_with_popdown(NULL, tmplist, 0);
	gtk_table_attach_defaults(GTK_TABLE(table), ds->combo[22], 1, 2, 4, 5);
	g_list_free(tmplist);
	tmplist = g_list_append(NULL, "");
	tmplist = g_list_append(tmplist, "none");
	tmplist = g_list_append(tmplist, "capitalize");
	tmplist = g_list_append(tmplist, "uppercase");
	tmplist = g_list_append(tmplist, "lowercase");
	ds->combo[23] = combo_with_popdown(NULL, tmplist, 0);
	gtk_table_attach_defaults(GTK_TABLE(table), ds->combo[23], 1, 2, 5, 6);
	g_list_free(tmplist);
	tmplist = make_length_list(0, 4, 1, 1);
	ds->combo[24] = combo_with_popdown(NULL, tmplist, 1);
	gtk_table_attach_defaults(GTK_TABLE(table), ds->combo[24], 1, 2, 6, 7);
	g_list_free(tmplist);
	/* text tab completed */
	gtk_notebook_append_page(GTK_NOTEBOOK(notebook), table, apply_font_style(gtk_label_new("Text"), main_v->props.cfg_tab_font));

	/* classification tab started */
	/* combo 37-40, check 5, entry 3 */
	table = table = gtk_table_new(3, 6, 0);
	gtk_table_attach_defaults(GTK_TABLE(table), gtk_label_new(_("display")), 0, 1, 0, 1);
	gtk_table_attach_defaults(GTK_TABLE(table), gtk_label_new(_("white-space")), 0, 1, 1, 2);
	gtk_table_attach_defaults(GTK_TABLE(table), gtk_label_new(_("list-style-type")), 0, 1, 3, 4);
	gtk_table_attach_defaults(GTK_TABLE(table), gtk_label_new(_("list-style-image")), 0, 1, 4, 5);
	gtk_table_attach_defaults(GTK_TABLE(table), gtk_label_new(_("list-style-position")), 0, 1, 5, 6);
	tmplist = g_list_append(NULL, "");
	ds->combo[37] = combo_with_popdown(NULL, tmplist, 1);
	g_list_free(tmplist);
	gtk_table_attach_defaults(GTK_TABLE(table), ds->combo[37], 1, 2, 0, 1);
	tmplist = g_list_append(NULL, "");
	ds->combo[38] = combo_with_popdown(NULL, tmplist, 1);
	g_list_free(tmplist);
	gtk_table_attach_defaults(GTK_TABLE(table), ds->combo[38], 1, 2, 1, 2);
	ds->check[5] = gtk_check_button_new_with_label(_("Insert list-item as one line"));
	gtk_table_attach_defaults(GTK_TABLE(table), ds->check[5], 0, 2, 2, 3);
	tmplist = g_list_append(NULL, "");
	ds->combo[39] = combo_with_popdown(NULL, tmplist, 1);
	g_list_free(tmplist);
	gtk_table_attach_defaults(GTK_TABLE(table), ds->combo[39], 1, 2, 3, 4);
	tmplist = g_list_append(NULL, "");
	ds->combo[40] = combo_with_popdown(NULL, tmplist, 1);
	g_list_free(tmplist);
	gtk_table_attach_defaults(GTK_TABLE(table), ds->combo[40], 1, 2, 5, 6);
	ds->entry[3] = gtk_entry_new();
	gtk_table_attach_defaults(GTK_TABLE(table), ds->entry[3], 1, 2, 4, 5);
	file_but = file_but_new(ds->entry[3], ds->dialog, 0);
	gtk_table_attach(GTK_TABLE(table), file_but, 2, 3, 4, 5, 0, 0, 5, 5);
	/* classification tab completed */
	gtk_notebook_append_page(GTK_NOTEBOOK(notebook), table, apply_font_style(gtk_label_new("Classification"), main_v->props.cfg_tab_font));

	middle_dialog(ds, 0, 2, 4, 5, 6);
	if (ds->abort != 1) {

		/* font tab */
		if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(ds->check[1]))) {
			fontstring =
				g_strdup_printf("   font: %s %s %s %s%s %s;\n", insert_if_string("%s", GTK_WIDGET(GTK_COMBO(ds->combo[2])->entry), "normal")
								, insert_if_string("%s", GTK_WIDGET(GTK_COMBO(ds->combo[3])->entry), "normal")
								, insert_if_string("%s", GTK_WIDGET(GTK_COMBO(ds->combo[4])->entry), "normal")
								, gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(ds->combo[5])->entry))
								, insert_if_string("/%s", GTK_WIDGET(GTK_COMBO(ds->combo[6])->entry), NULL)
								, gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(ds->combo[1])->entry))
				);
		} else {
			fontstring =
				g_strdup_printf("%s%s%s%s%s%s", insert_if_string("   font-family: %s;\n", GTK_WIDGET(GTK_COMBO(ds->combo[1])->entry), NULL)
								, insert_if_string("   font-style: %s;\n", GTK_WIDGET(GTK_COMBO(ds->combo[2])->entry), NULL)
								, insert_if_string("   font-variant: %s;\n", GTK_WIDGET(GTK_COMBO(ds->combo[3])->entry), NULL)
								, insert_if_string("   font-weight: %s;\n", GTK_WIDGET(GTK_COMBO(ds->combo[4])->entry), NULL)
								, insert_if_string("   font-size: %s;\n", GTK_WIDGET(GTK_COMBO(ds->combo[5])->entry), NULL)
								, insert_if_string("   line-height: %s;\n", GTK_WIDGET(GTK_COMBO(ds->combo[6])->entry), NULL)
				);
		}
		garbage = g_list_append(garbage, fontstring);
		DEBUG_MSG("style, fontstring=%s\n", fontstring);
		/* end font tab */
		/* margin & padding tab */
		if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(ds->check[3]))) {
			margstring =
				g_strdup_printf("   margin: %s %s %s %s;\n", insert_if_string("%s", GTK_WIDGET(GTK_COMBO(ds->combo[25])->entry), "0")
								, insert_if_string("%s", GTK_WIDGET(GTK_COMBO(ds->combo[27])->entry), "0")
								, insert_if_string("%s", GTK_WIDGET(GTK_COMBO(ds->combo[29])->entry), "0")
								, insert_if_string("%s", GTK_WIDGET(GTK_COMBO(ds->combo[31])->entry), "0")
				);
		} else {
			margstring =
				g_strdup_printf("%s%s%s%s", insert_if_string("   margin-top: %s;\n", GTK_WIDGET(GTK_COMBO(ds->combo[25])->entry), NULL),
								insert_if_string("   margin-right: %s;\n", GTK_WIDGET(GTK_COMBO(ds->combo[27])->entry), NULL)
								, insert_if_string("   margin-bottom: %s;\n", GTK_WIDGET(GTK_COMBO(ds->combo[29])->entry), NULL)
								, insert_if_string("   margin-left: %s;\n", GTK_WIDGET(GTK_COMBO(ds->combo[31])->entry), NULL)
				);
		}
		garbage = g_list_append(garbage, margstring);
		if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(ds->check[4]))) {
			padstring =
				g_strdup_printf("   padding: %s %s %s %s;\n", insert_if_string("%s", GTK_WIDGET(GTK_COMBO(ds->combo[26])->entry), "0")
								, insert_if_string("%s", GTK_WIDGET(GTK_COMBO(ds->combo[28])->entry), "0")
								, insert_if_string("%s", GTK_WIDGET(GTK_COMBO(ds->combo[30])->entry), "0")
								, insert_if_string("%s", GTK_WIDGET(GTK_COMBO(ds->combo[32])->entry), "0")
				);
		} else {
			padstring =
				g_strdup_printf("%s%s%s%s", insert_if_string("   padding-top: %s;\n", GTK_WIDGET(GTK_COMBO(ds->combo[26])->entry), NULL),
								insert_if_string("   padding-right: %s;\n", GTK_WIDGET(GTK_COMBO(ds->combo[28])->entry), NULL)
								, insert_if_string("   padding-bottom: %s;\n", GTK_WIDGET(GTK_COMBO(ds->combo[30])->entry), NULL)
								, insert_if_string("   padding-left: %s;\n", GTK_WIDGET(GTK_COMBO(ds->combo[32])->entry), NULL)
				);
		}
		garbage = g_list_append(garbage, padstring);
		/* end of margin & padding */
		/* border tab */
		if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(ds->radio[7]))) {
			borderstring =
				g_strdup_printf("   border-width: %s %s %s %s;\n   border-color: %s %s %s %s;\n   border-style: %s %s %s %s;\n",
								insert_if_string("%s", GTK_WIDGET(GTK_COMBO(ds->combo[41])->entry), "medium")
								, insert_if_string("%s", GTK_WIDGET(GTK_COMBO(ds->combo[44])->entry), "medium")
								, insert_if_string("%s", GTK_WIDGET(GTK_COMBO(ds->combo[47])->entry), "medium")
								, insert_if_string("%s", GTK_WIDGET(GTK_COMBO(ds->combo[50])->entry), "medium")
								, gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(ds->combo[42])->entry))
								, gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(ds->combo[45])->entry))
								, gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(ds->combo[48])->entry))
								, gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(ds->combo[51])->entry))
								, insert_if_string("%s", GTK_WIDGET(GTK_COMBO(ds->combo[43])->entry), "none")
								, insert_if_string("%s", GTK_WIDGET(GTK_COMBO(ds->combo[46])->entry), "none")
								, insert_if_string("%s", GTK_WIDGET(GTK_COMBO(ds->combo[49])->entry), "none")
								, insert_if_string("%s", GTK_WIDGET(GTK_COMBO(ds->combo[52])->entry), "none")
				);
		} else if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(ds->radio[8]))) {
			borderstring =
				g_strdup_printf
				("   border-top: %s %s %s;\n   border-right: %s %s %s;\n   border-bottom: %s %s %s;\n   border-left: %s %s %s;\n",
				 gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(ds->combo[41])->entry))
				 , gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(ds->combo[42])->entry))
				 , gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(ds->combo[43])->entry))
				 , gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(ds->combo[44])->entry))
				 , gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(ds->combo[45])->entry))
				 , gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(ds->combo[46])->entry))
				 , gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(ds->combo[47])->entry))
				 , gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(ds->combo[48])->entry))
				 , gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(ds->combo[49])->entry))
				 , gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(ds->combo[50])->entry))
				 , gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(ds->combo[51])->entry))
				 , gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(ds->combo[52])->entry))
				);
		} else {
			borderstring = g_strdup_printf("   border: %s %s %s;\n", gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(ds->combo[41])->entry))
										   , gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(ds->combo[42])->entry))
										   , gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(ds->combo[43])->entry))
				);
		}
		garbage = g_list_append(garbage, borderstring);
		DEBUG_MSG("insert_in_stylesheet, borderstring=%s\n", borderstring);
		/* end border tab */
		/* size and placement tab */
		sizeplacestring = g_strdup_printf("%s%s%s%s", insert_if_string("   width: %s;\n", GTK_WIDGET(GTK_COMBO(ds->combo[33])->entry), NULL)
										  , insert_if_string("   height: %s;\n", GTK_WIDGET(GTK_COMBO(ds->combo[34])->entry), NULL)
										  , insert_if_string("   float: %s;\n", GTK_WIDGET(GTK_COMBO(ds->combo[35])->entry), NULL)
										  , insert_if_string("   clear: %s;\n", GTK_WIDGET(GTK_COMBO(ds->combo[36])->entry), NULL)
			);
		garbage = g_list_append(garbage, sizeplacestring);
		/* end of size and placement */
		/* color & background tab */
		if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(ds->check[2]))) {
			bgncolorstring =
				g_strdup_printf("%s   background: %s %s %s %s %s %s;\n",
								insert_if_string("   color: %s;\n", GTK_WIDGET(GTK_COMBO(ds->combo[11])->entry), NULL)
								, insert_if_string("%s", GTK_WIDGET(GTK_COMBO(ds->combo[12])->entry), "transparent")
								, insert_if_string("url(%s)", GTK_WIDGET(GTK_COMBO(ds->combo[13])->entry), NULL)
								, insert_if_string("%s", GTK_WIDGET(GTK_COMBO(ds->combo[14])->entry), "repeat")
								, insert_if_string("%s", GTK_WIDGET(GTK_COMBO(ds->combo[15])->entry), "scroll")
								, insert_if_string("%s", GTK_WIDGET(GTK_COMBO(ds->combo[16])->entry), "0%")
								, insert_if_string("%s", GTK_WIDGET(GTK_COMBO(ds->combo[17])->entry), "0%")
				);
		} else {
			bgncolorstring =
				g_strdup_printf("%s%s%s%s%s%s%s", insert_if_string("   color: %s;\n", GTK_WIDGET(GTK_COMBO(ds->combo[11])->entry), NULL)
								, insert_if_string("   background-color: %s;\n", GTK_WIDGET(GTK_COMBO(ds->combo[12])->entry), NULL)
								, insert_if_string("   background-image: url(%s);\n", GTK_WIDGET(GTK_COMBO(ds->combo[13])->entry), NULL)
								, insert_if_string("   background-repeat: %s;\n", GTK_WIDGET(GTK_COMBO(ds->combo[14])->entry), NULL)
								, insert_if_string("   background-attachment: %s;\n", GTK_WIDGET(GTK_COMBO(ds->combo[15])->entry), NULL)
								, insert_if_string("   background-position: %s", GTK_WIDGET(GTK_COMBO(ds->combo[16])->entry),
												   "   background-position: top")
								, insert_if_string(" %s;\n", GTK_WIDGET(GTK_COMBO(ds->combo[17])->entry), " left;\n")
				);
		}
		DEBUG_MSG("insert_in_stylesheet, bgncolorstring=%s\n", bgncolorstring);
		garbage = g_list_append(garbage, bgncolorstring);
		/* end color & background tab */
		DEBUG_MSG("insert_in_stylesheet, before text tab\n");
		/* text tab */
		textstring =
			g_strdup_printf("%s%s%s%s%s%s%s", insert_if_string("   word-spacing: %s;\n", GTK_WIDGET(GTK_COMBO(ds->combo[18])->entry), NULL)
							, insert_if_string("   letter-spacing: %s;\n", GTK_WIDGET(GTK_COMBO(ds->combo[19])->entry), NULL)
							, insert_if_string("   vertical-align: %s;\n", GTK_WIDGET(GTK_COMBO(ds->combo[20])->entry), NULL)
							, insert_if_string("   text-align: %s;\n", GTK_WIDGET(GTK_COMBO(ds->combo[21])->entry), NULL)
							, insert_if_string("   text-decoration: %s;\n", GTK_WIDGET(GTK_COMBO(ds->combo[22])->entry), NULL)
							, insert_if_string("   text-transform: %s;\n", GTK_WIDGET(GTK_COMBO(ds->combo[23])->entry), NULL)
							, insert_if_string("   text-indent: %s;\n", GTK_WIDGET(GTK_COMBO(ds->combo[24])->entry), NULL)
			);
		garbage = g_list_append(garbage, textstring);
		/* end text tab */
		DEBUG_MSG("insert_in_stylesheet, before classification tab\n");
		/* classification tab */
		if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(ds->check[5]))) {
			DEBUG_MSG("insert_in_stylesheet, check[5] = TRUE\n");
			classistring =
				g_strdup_printf("%s%s   list-style: %s %s %s;\n",
								insert_if_string("   display: %s;\n", GTK_WIDGET(GTK_COMBO(ds->combo[37])->entry), NULL)
								, insert_if_string("   white-space: %s;\n", GTK_WIDGET(GTK_COMBO(ds->combo[38])->entry), NULL)
								, insert_if_string("%s", GTK_WIDGET(GTK_COMBO(ds->combo[39])->entry), "disc")
								, insert_if_string("%s", GTK_WIDGET(ds->entry[3]), "none")
								, insert_if_string("%s", GTK_WIDGET(GTK_COMBO(ds->combo[40])->entry), "outside")
				);
		} else {
			DEBUG_MSG("insert_in_stylesheet, check[5] = FALSE\n");
			classistring =
				g_strdup_printf("%s%s%s%s%s", insert_if_string("   display: %s;\n", GTK_WIDGET(GTK_COMBO(ds->combo[37])->entry), NULL),
								insert_if_string("   white-space: %s;\n", GTK_WIDGET(GTK_COMBO(ds->combo[38])->entry), NULL)
								, insert_if_string("   list-style-type: %s;\n", GTK_WIDGET(GTK_COMBO(ds->combo[39])->entry), NULL)
								, insert_if_string("   list-style-image: %s;\n", GTK_WIDGET(ds->entry[3]), NULL)
								, insert_if_string("   list-style-position: %s;\n", GTK_WIDGET(GTK_COMBO(ds->combo[40])->entry), NULL)
				);
		}
		garbage = g_list_append(garbage, classistring);
		/* end of classification */
		DEBUG_MSG("insert_in_stylesheet, putting all the strings together\n");
		ds->tmpstring = g_strdup_printf("%s%s%s {\n%s%s%s%s%s%s%s}\n", gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(ds->combo[8])->entry))
										, insert_if_string(".%s", GTK_WIDGET(GTK_COMBO(ds->combo[9])->entry), NULL)
										, insert_if_string(":%s", GTK_WIDGET(GTK_COMBO(ds->combo[10])->entry), NULL)
										, fontstring, margstring, padstring, borderstring, bgncolorstring, textstring, classistring);
		DEBUG_MSG("insert_new_style, ds->tmpstring=%s\n", ds->tmpstring);
		insert_dbl_text(ds->tmpstring, "");
		DEBUG_MSG("insert_new_style, text inserted\n");
		main_v->current_project.fontlist =
			add_to_stringlist(main_v->current_project.fontlist, gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(ds->combo[1])->entry)));
		main_v->current_project.classlist =
			add_to_stringlist(main_v->current_project.classlist, gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(ds->combo[9])->entry)));
		g_free(ds->tmpstring);
	}
	DEBUG_MSG("insert_new_style, going to destroy dialog\n");
	if (GTK_IS_WIDGET(ds->dialog))
		gtk_widget_destroy(ds->dialog);
	DEBUG_MSG("insert_new_style, free-ing garbage\n");
	DEBUG_MSG("insert_new_style, garbage=%p, lenght=%d\n", garbage, g_list_length(garbage));
	if (garbage)
		free_stringlist(garbage);
	garbage = NULL;
	g_free(ds);
}
#endif /* OLD_CSS_DIALOG */

/**********************************************************************/
/**********************************************************************/
/********************this is where the new css dialog is***************/
/**********************************************************************/
/**********************************************************************/

static GList *glist_with_html_tags(gint with_pseudo_classes) {
	GList *tmplist;

	tmplist = g_list_append(NULL, "");
	if (with_pseudo_classes) {
		tmplist = g_list_append(tmplist, "a:link");
		tmplist = g_list_append(tmplist, "a:visited");
		tmplist = g_list_append(tmplist, "a:active");
	} else {
		tmplist = g_list_append(tmplist, "a");
	}
	if(main_v->props.allow_h4){
		tmplist = g_list_append(tmplist, "abbr");
		tmplist = g_list_append(tmplist, "acronym");
	}
	tmplist = g_list_append(tmplist, "address");
	tmplist = g_list_append(tmplist, "applet");
	tmplist = g_list_append(tmplist, "area");
	tmplist = g_list_append(tmplist, "b");
	if(main_v->props.allow_h4){
		tmplist = g_list_append(tmplist, "bdo");
	}
	tmplist = g_list_append(tmplist, "bockquote");
	tmplist = g_list_append(tmplist, "body");
	tmplist = g_list_append(tmplist, "br");
	if(main_v->props.allow_h4){
		tmplist = g_list_append(tmplist, "button");
	}
	tmplist = g_list_append(tmplist, "caption");
	tmplist = g_list_append(tmplist, "cite");
	tmplist = g_list_append(tmplist, "code");
	if(main_v->props.allow_h4){
		tmplist = g_list_append(tmplist, "col");
		tmplist = g_list_append(tmplist, "colgroup");
	}
	tmplist = g_list_append(tmplist, "dd");
	if(main_v->props.allow_h4){
		tmplist = g_list_append(tmplist, "del");
	}
	tmplist = g_list_append(tmplist, "dfn");
	tmplist = g_list_append(tmplist, "div");
	tmplist = g_list_append(tmplist, "dl");
	tmplist = g_list_append(tmplist, "dt");
	tmplist = g_list_append(tmplist, "em");
	tmplist = g_list_append(tmplist, "embed");
	if(main_v->props.allow_h4){
		tmplist = g_list_append(tmplist, "fieldset");
	}
	tmplist = g_list_append(tmplist, "form");
	tmplist = g_list_append(tmplist, "h1");
	tmplist = g_list_append(tmplist, "h2");
	tmplist = g_list_append(tmplist, "h3");
	tmplist = g_list_append(tmplist, "h4");
	tmplist = g_list_append(tmplist, "h5");
	tmplist = g_list_append(tmplist, "h6");
	tmplist = g_list_append(tmplist, "hr");
	tmplist = g_list_append(tmplist, "i");
	if(main_v->props.allow_h4){
		tmplist = g_list_append(tmplist, "iframe");
	}
	tmplist = g_list_append(tmplist, "img");
	tmplist = g_list_append(tmplist, "input");
	if(main_v->props.allow_h4){
		tmplist = g_list_append(tmplist, "ins");
	}
	tmplist = g_list_append(tmplist, "kbd");
	if(main_v->props.allow_h4){
		tmplist = g_list_append(tmplist, "label");
		tmplist = g_list_append(tmplist, "legend");
	}
	tmplist = g_list_append(tmplist, "li");
	tmplist = g_list_append(tmplist, "map");
	if(main_v->props.allow_frames){
		tmplist = g_list_append(tmplist, "noframes");
	}
	tmplist = g_list_append(tmplist, "noscript");
	if(main_v->props.allow_h4){
		tmplist = g_list_append(tmplist, "object");
	}
	tmplist = g_list_append(tmplist, "ol");
	if(main_v->props.allow_h4){
		tmplist = g_list_append(tmplist, "optgroup");
	}
	tmplist = g_list_append(tmplist, "option");
	tmplist = g_list_append(tmplist, "p");
	tmplist = g_list_append(tmplist, "pre");
	if(main_v->props.allow_h4){
		tmplist = g_list_append(tmplist, "q");
	}
	if(main_v->props.allow_ruby){
		tmplist = g_list_append(tmplist, "rb");
		tmplist = g_list_append(tmplist, "rp");
		tmplist = g_list_append(tmplist, "rt");
		tmplist = g_list_append(tmplist, "ruby");
	}
	tmplist = g_list_append(tmplist, "samp");
	tmplist = g_list_append(tmplist, "select");
	tmplist = g_list_append(tmplist, "small");
	if(main_v->props.allow_h4){
		tmplist = g_list_append(tmplist, "span");
	}
	tmplist = g_list_append(tmplist, "strong");
	tmplist = g_list_append(tmplist, "table");
	if(main_v->props.allow_h4){
		tmplist = g_list_append(tmplist, "tbody");
	}
	tmplist = g_list_append(tmplist, "td");
	tmplist = g_list_append(tmplist, "textarea");
	if(main_v->props.allow_h4){
		tmplist = g_list_append(tmplist, "tfoot");
	}
	tmplist = g_list_append(tmplist, "th");
	if(main_v->props.allow_h4){
		tmplist = g_list_append(tmplist, "thead");
	}
	tmplist = g_list_append(tmplist, "tr");
	tmplist = g_list_append(tmplist, "tt");
	tmplist = g_list_append(tmplist, "ul");
	tmplist = g_list_append(tmplist, "var");

	return tmplist;
}

#ifdef NEW_CS3

typedef enum {entry, textbox} Tdest_type;
typedef enum {onestyle, multistyle} Tcs3_style;
typedef enum {but_none, but_file, but_style, but_color} Textra_button;
typedef struct {
	Tdest_type dest_type;
	GtkWidget *entry;
	Tdocument *doc;
	gint doc_start;
	gint doc_end;
} Tcs3_destination;

typedef struct {
	GtkWidget *win;
	Tcs3_destination dest;
	Tcs3_style styletype;
	GtkWidget *clist;
	gint selected_row;
	gboolean grab;
	GtkWidget *selector;
	GtkWidget *property;
	GtkWidget *value;
	GtkWidget *rule_add_but;
	GtkWidget *rule_update_but;
	GtkWidget *extra_but;
} Tcs3_diag;

typedef struct {
	GtkWidget *win;
	GtkWidget *selector;
	GtkWidget *property;
	GtkWidget *value;
	GtkWidget *extra_but;
	gint whichrow;
	Tcs3_diag *diag;
} Tcs3_pd_diag;

typedef struct {
	gchar *property; /* the name of the property */
	gchar **possibilities; /* a list of possibilities */
	gint force_pos; 	/* force the possibility to be one of the options in possibilities */
	Textra_button buttype;
} Tcs3_arr;

static gchar *cs3_colors[] = {"white", "black", "blue", "red", "yellow", "green", "brown", "purple", NULL};
static gchar *cs3_repeat[] = {"repeat", "repeat-x", "repeat-y", "no-repeat", NULL};
static gchar *cs3_fonts[] = {"arial, helvetica, sans-serif", "roman, 'times new roman', times, serif", "courier, fixed, monospace", "western, fantasy",  "Zapf-Chancery, cursive", "serif", "sans-serif", "cursive", "fantasy", "monospace", NULL};
static gchar *cs3_font_size_adjustments[] = {"none", NULL};
static gchar *cs3_font_stretches[] = {"normal","wider","narrower","ultra-condensed","extra-condensed","condensed","semi-condensed","semi-expanded","expanded","extra-expanded","ultra-expanded", NULL};
static gchar *cs3_font_styles[] = {"normal", "italic", "oblique", NULL};
static gchar *cs3_font_variants[] = {"normal", "small-caps", NULL};
static gchar *cs3_font_weights[] = {"normal", "bold", "bolder", "lighter", "100", "200", "300", "400", "500", "600", "700", "800", "900",  NULL};
static gchar *cs3_background_attachments[] = {"scroll", "fixed", NULL};
static gchar *cs3_background_positions[] = {"top", "center", "bottom", "left", "center", "right", "10% 10%", NULL}; /* more 2 add */
static gchar *cs3_text_decorations[] = {"none", "underline", "overline", "line-through", "blink", NULL};
static gchar *cs3_text_transforms[] = {"none", "capitalize", "uppercase", "lowercase", NULL};
static gchar *cs3_text_aligns[] = {"left", "right", "center", "justify", NULL};
static gchar *cs3_border_styles[] = {"none", "dotted", "dashed", "solid", "double", "groove", "ridge", "inset", "outset", NULL};
static gchar *cs3_floats[] = {"left", "right", "none", NULL};
static gchar *cs3_positions[] = {"static", "relative", "absolute", "fixed", NULL};
static gchar *cs3_clears[] = {"left", "right", "none", "both", NULL};
static gchar *cs3_displays[] = {"block", "inline", "list-item", "run-in", "compact", "marker", "table", "inline-table", "table-row-group", "table-header-group", "table-footer-group", "table-row", "table-column-group", "table-column", "table-cell", "table-caption", "none",NULL};
static gchar *cs3_whitespaces[] = {"normal", "pre", "nowrap", NULL};
static gchar *cs3_list_style_types[] = {"disc", "circle", "square", "decimal", "lower-roman", "upper-roman", "lower-alpha", "upper-alpha", "none", NULL};
static gchar *cs3_list_style_positions[] = {"inside", "outside", NULL};
static gchar *cs3_zindices[] = {"auto", NULL};
static gchar *cs3_directions[] = {"ltr", "rtl", NULL};
static gchar *cs3_unicodebidis[] = {"normal", "embed", "bidi-override", NULL};
static gchar *cs3_vertical_aligns[] = {"baseline", "sub", "super", "top", "text-top", "middle", "bottom", "text-bottom", NULL};
static gchar *cs3_overflows[] = {"visible", "hidden", "scroll", "auto", NULL};
static gchar *cs3_visibilities[] = {"visible", "hidden", "collapse", NULL};
static gchar *cs3_none[] = {"none", NULL};
static gchar *cs3_caption_sides[] = {"top", "bottom", "left", "right", NULL};
static gchar *cs3_table_layouts[] = {"auto", "fixed", NULL};

static Tcs3_arr cs3_arr[] = {
{"font-family", cs3_fonts, 0, but_none},
{"font-stretch", cs3_font_stretches, 0, but_none},
{"font-style", cs3_font_styles, 1, but_none},
{"font-variant", cs3_font_variants, 1, but_none},
{"font-weight", cs3_font_weights, 1, but_none},
{"font-size", NULL, 0, but_none},
{"font-size-adjust", cs3_font_size_adjustments, 0, but_none},
{"font", NULL, 0, but_none},
{"color", cs3_colors, 0, but_color},
{"background-color", cs3_colors, 0, but_color},
{"background-image", NULL, 0, but_file},
{"background-repeat", cs3_repeat, 0, but_none},
{"background-attachment",cs3_background_attachments , 1, but_none},
{"background-position",cs3_background_positions , 0, but_none},
{"background", NULL, 0, but_none},
{"word-spacing", NULL, 0, but_none},
{"letter-spacing", NULL, 0, but_none},
{"text-decoration", cs3_text_decorations, 1, but_none},
{"text-transform", cs3_text_transforms, 1, but_none},
{"text-align", cs3_text_aligns, 1, but_none},
{"text-indent", NULL, 0, but_none},
{"text-shadow", cs3_none, 0, but_none},
{"line-height", NULL, 0, but_none},
{"margin-top", NULL, 0, but_none},
{"margin-right", NULL, 0, but_none},
{"margin-bottom", NULL, 0, but_none},
{"margin-left", NULL, 0, but_none},
{"margin", NULL, 0, but_none},
{"padding-top", NULL, 0, but_none},
{"padding-right", NULL, 0, but_none},
{"padding-bottom", NULL, 0, but_none},
{"padding-left", NULL, 0, but_none},
{"padding", NULL, 0, but_none},
{"border-top-width", NULL, 0, but_none},
{"border-right-width", NULL, 0, but_none},
{"border-bottom-width", NULL, 0, but_none},
{"border-left-width", NULL, 0, but_none},
{"border-width", NULL, 0, but_none},
{"border-top-color", cs3_colors, 0, but_color},
{"border-right-color", cs3_colors, 0, but_color},
{"border-bottom-color", cs3_colors, 0, but_color},
{"border-left-color", cs3_colors, 0, but_color},
{"border-color", cs3_colors, 0, but_color},
{"border-top-style", cs3_border_styles, 1, but_none},
{"border-right-style", cs3_border_styles, 1, but_none},
{"border-bottom-style", cs3_border_styles, 1, but_none},
{"border-left-style", cs3_border_styles, 1, but_none},
{"border-style", cs3_border_styles, 1, but_none},
{"border-top", NULL, 0, but_none},
{"border-right", NULL, 0, but_none},
{"border-bottom", NULL, 0, but_none},
{"border-left", NULL, 0, but_none},
{"border", NULL, 0, but_none},
{"width", NULL, 0, but_none},
{"height", NULL, 0, but_none},
{"float", cs3_floats, 1, but_none},
{"position", cs3_positions, 1, but_none},
{"top", NULL, 0, but_none},
{"right", NULL, 0, but_none},
{"bottom", NULL, 0, but_none},
{"left", NULL, 0, but_none},
{"clear", cs3_clears, 1, but_none},
{"display", cs3_displays, 1, but_none},
{"direction", cs3_directions, 1, but_none},
{"unicode-bidi", cs3_unicodebidis, 1, but_none},
{"z-index", cs3_zindices, 0, but_none},
{"min-width", NULL, 0, but_none},
{"max-width", NULL, 0, but_none},
{"min-height", NULL, 0, but_none},
{"max-height", NULL, 0, but_none},
{"line-height", NULL, 0, but_none},
{"white-space", cs3_whitespaces, 1, but_none},
{"list-style", NULL, 0, but_none},
{"list-style-type", cs3_list_style_types, 1, but_none},
{"list-style-image", NULL, 0, but_none},
{"list-style-position", cs3_list_style_positions, 1, but_none},
{"vertical-align", cs3_vertical_aligns, 0, but_none},
{"overflow", cs3_overflows, 0, but_none},
{"clip", cs3_zindices, 0, but_none},
{"visibility", cs3_visibilities, 0, but_none},
{"caption-side", cs3_caption_sides, 1, but_none},
{"table-layout", cs3_table_layouts, 1, but_none},
{NULL, NULL, 0, but_none}
};


static Tcs3_arr *cs3_arr_from_property(gchar *prop) {
	Tcs3_arr tmp;
	gint count=0;

	if (!prop) {
		return NULL;
	}
	tmp = cs3_arr[count];
	while (tmp.property) {
		if (strcmp(tmp.property, prop) ==0) {
			return &cs3_arr[count];
		}
		count++;
		tmp = cs3_arr[count];
	}
	return NULL;
}

/* the list should be freed, the contents of the list should NOT */
static GList *pointer_arr2glist(gchar **arr) {
	gchar **tmp;
	GList *retlist = NULL;

	if (!arr) {
		return NULL;
	}
	tmp = arr;
	while (*tmp) {
		retlist = g_list_append(retlist, *tmp);
		tmp++;
	}
	return retlist;
}

static void cs3d_destroy_lcb(GtkWidget * widget, GdkEvent *event, Tcs3_diag *diag) {
	window_destroy(diag->win);
	g_free(diag);
}

static void cs3d_cancel_clicked_lcb(GtkWidget * widget, Tcs3_diag *diag) {
	cs3d_destroy_lcb(NULL, NULL, diag);
}

static void cs3d_ok_clicked_lcb(GtkWidget * widget, Tcs3_diag *diag) {

	Tcs3_destination dest = diag->dest;
	gchar *stylebuf=NULL;

	if (diag->styletype == onestyle) {
		gchar *tmpbuf1 = NULL;
		gchar *tmpbuf2 = g_strdup("");
		gint retval=1, row=0;
		while (retval) {
			gchar *text[4];
			retval = gtk_clist_get_text(GTK_CLIST(diag->clist), row, 0, &text[0]);
			retval = gtk_clist_get_text(GTK_CLIST(diag->clist), row, 1, &text[1]);
			if (retval) {
				tmpbuf1 = g_strconcat(tmpbuf2, text[0], ": ", text[1], "; ", NULL);
				g_free(tmpbuf2);
				tmpbuf2 = tmpbuf1;
			}
			row++;
		}
		stylebuf = tmpbuf2;
	} else { /* multistyle */
		gchar *tmpbuf1 = NULL;
		gchar *tmpbuf2 = g_strdup("");
		gchar *prev_selector = NULL;
		gint retval=1, row=0;
		while (retval) {
			gchar *text[4];
			retval = gtk_clist_get_text(GTK_CLIST(diag->clist), row, 0, &text[0]);
			retval = gtk_clist_get_text(GTK_CLIST(diag->clist), row, 1, &text[1]);
			retval = gtk_clist_get_text(GTK_CLIST(diag->clist), row, 2, &text[2]);
			if (retval) {
				if (!prev_selector) {
					prev_selector = g_strdup(text[0]);
					tmpbuf1 = g_strconcat(tmpbuf2, text[0], " {\n", NULL);
					g_free(tmpbuf2);
					tmpbuf2 = tmpbuf1;
				} 
				if (strcmp(prev_selector, text[0]) == 0 ) {
					tmpbuf1 = g_strconcat(tmpbuf2, "\t", text[1], ": ", text[2], ";\n", NULL);
				} else {
					tmpbuf1 = g_strconcat(tmpbuf2, "}\n", text[0], " {\n\t", text[1], ": ", text[2], ";\n", NULL);
					g_free(prev_selector);
					prev_selector = g_strdup(text[0]);
				}
				g_free(tmpbuf2);
				tmpbuf2 = tmpbuf1;
				row++;
			}
		}
		g_free(prev_selector);
		stylebuf = g_strconcat(tmpbuf2, "}\n", NULL);
		g_free(tmpbuf2);
	}

	if (stylebuf) {
		if (dest.dest_type == entry) {
			DEBUG_MSG("cs3d_ok_clicked_lcb, entry? %p\n", dest.entry);
			if (dest.entry && GTK_IS_WIDGET(dest.entry)) {
				DEBUG_MSG("cs3d_ok_clicked_lcb, entry!\n");
				gtk_entry_set_text(GTK_ENTRY(dest.entry), stylebuf);
			}
		} else if (dest.dest_type == textbox) {
			DEBUG_MSG("cs3d_ok_clicked_lcb, textbox %p?\n", dest.doc->textbox);
			if (dest.doc && dest.doc->textbox && GTK_IS_WIDGET(dest.doc->textbox)) {
				DEBUG_MSG("cs3d_ok_clicked_lcb, textbox!\n");
				if (dest.doc_start != -1 || dest.doc_end != -1) {
					doc_replace_text(stylebuf, dest.doc_start, dest.doc_end, dest.doc);
				} else {
					doc_insert_text(dest.doc, stylebuf);
				}
			}
		} else {
#ifdef DEVELOPMENT
			g_print("cs3d_ok_clicked_lcb, an unknown dest type, this should never happen!\n");
#endif
		}
		g_free(stylebuf);
	}
	cs3d_destroy_lcb(NULL, NULL, diag);
}

static void cs3d_select_row_lcb(GtkWidget *clist, gint row, gint column, GdkEventButton *event, Tcs3_diag *diag) {
	diag->selected_row = row;
	if (diag->selected_row != -1) {
		gchar *text[3];
		if (diag->styletype == onestyle) {
			text[0] = NULL;
			gtk_clist_get_text(GTK_CLIST(diag->clist), diag->selected_row, 0, &text[1]);
			gtk_clist_get_text(GTK_CLIST(diag->clist), diag->selected_row, 1, &text[2]);
		} else { /* multistyle */
			gtk_clist_get_text(GTK_CLIST(diag->clist), diag->selected_row, 0, &text[0]);
			gtk_clist_get_text(GTK_CLIST(diag->clist), diag->selected_row, 1, &text[1]);
			gtk_clist_get_text(GTK_CLIST(diag->clist), diag->selected_row, 2, &text[2]);
		}
		if (text[0]) {
			gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(diag->selector)->entry), text[0]);
		}
		gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(diag->property)->entry), text[1]);
		gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(diag->value)->entry), text[2]);
		DEBUG_MSG("cs3d_select_row_lcb, sele=%s, prop=%s, val=%s\n", text[0], text[1], text[2]);
	}
}

static void cs3d_unselect_row_lcb(GtkWidget *clist, gint row, gint column, GdkEventButton *event, Tcs3_diag *diag) {
	diag->selected_row = -1;
	if (diag->styletype == multistyle) {
		gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(diag->selector)->entry), "");
	}
	gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(diag->property)->entry), "");
	gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(diag->value)->entry), "");
}

static void add_to_row(Tcs3_diag *diag, gint whichrow) {
	gchar *text[4];
	gint count, correct=1;
	if (diag->styletype == multistyle) {
		DEBUG_MSG("add_to_row, multistyle\n");
		text[0] = gtk_editable_get_chars(GTK_EDITABLE(GTK_COMBO(diag->selector)->entry), 0, -1);
		text[1] = gtk_editable_get_chars(GTK_EDITABLE(GTK_COMBO(diag->property)->entry), 0, -1);
		text[2] = gtk_editable_get_chars(GTK_EDITABLE(GTK_COMBO(diag->value)->entry), 0, -1);
	} else {
		DEBUG_MSG("add_to_row, onestyle\n");
		text[0] = gtk_editable_get_chars(GTK_EDITABLE(GTK_COMBO(diag->property)->entry), 0, -1);
		text[1] = gtk_editable_get_chars(GTK_EDITABLE(GTK_COMBO(diag->value)->entry), 0, -1);
		text[2] = NULL;
	}
	text[3] = NULL;

	count=0;
	while (text[count]) {
		if (strlen(text[count]) == 0) {
			correct = 0;
		}
		count++;
	}
	if (correct) {
		if (whichrow == -1) {
			gtk_clist_append(GTK_CLIST(diag->clist), text);
		} else {
			DEBUG_MSG("add_to_row, removing %d\n", whichrow);
			gtk_clist_remove(GTK_CLIST(diag->clist), whichrow);
			DEBUG_MSG("add_to_row, adding new %d\n", whichrow);
			gtk_clist_insert(GTK_CLIST(diag->clist), whichrow, text);
		}
		gtk_clist_sort(GTK_CLIST(diag->clist));
	}
	count=0;
	while (text[count]) {
		g_free(text[count]);
		count++;
	}
}

static void cs3d_add_clicked_lcb(GtkWidget * widget, Tcs3_diag *diag) {
	add_to_row(diag, -1);
}

static void cs3d_del_clicked_lcb(GtkWidget * widget, Tcs3_diag *diag) {
	if (diag->selected_row != -1) {
		gtk_clist_remove(GTK_CLIST(diag->clist), diag->selected_row);
		diag->selected_row = -1;
	}
}

static void cs3d_update_clicked_lcb(GtkWidget * widget, Tcs3_diag *diag) {
	if (diag->selected_row != -1) {
		DEBUG_MSG("cs3d_update_clicked_lcb, updating row=%d\n", diag->selected_row);
		add_to_row(diag, diag->selected_row);
	}
}

static void cs3d_prop_activate_lcb(GtkWidget * widget, Tcs3_diag *diag) {
	Tcs3_arr *tmp;
	gchar *tmpstr;

	tmpstr = gtk_editable_get_chars(GTK_EDITABLE(GTK_COMBO(diag->property)->entry), 0, -1);
	tmp = cs3_arr_from_property(tmpstr);
	g_free(tmpstr);
	if (tmp) {
		GList *list;
		list = pointer_arr2glist(tmp->possibilities);
		if (list) {
			gchar *tmpstr2=NULL;
			if (!tmp->force_pos) {
					tmpstr2 = gtk_editable_get_chars(GTK_EDITABLE(GTK_COMBO(diag->value)->entry), 0, -1);
			}
			gtk_combo_set_popdown_strings(GTK_COMBO(diag->value), list);
			g_list_free(list);
			if (tmpstr2) {
				gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(diag->value)->entry), tmpstr2);
				g_free(tmpstr2);
				gtk_entry_set_editable(GTK_ENTRY(GTK_COMBO(diag->value)->entry), TRUE);
			} else {
				gtk_entry_set_editable(GTK_ENTRY(GTK_COMBO(diag->value)->entry), FALSE);
			}
			switch(tmp->buttype) {
			case but_color:
				gtk_widget_show(diag->extra_but);
			break;
			default:
				gtk_widget_hide(diag->extra_but);
			break;
			}
		} else {
				gtk_widget_hide(diag->extra_but);
		}
	} else {
		gtk_widget_hide(diag->extra_but);
	}
}

static Tcs3_diag *css_diag(Tcs3_destination dest, Tcs3_style style, GtkWidget *transient_win, gboolean grab) {

	Tcs3_diag *diag;
	GtkWidget *scrolwin, *table, *but, *vbox, *hbox, *vbox2;
	GList *tmplist = NULL;
	Tcs3_arr tmp;
	gint count=0;
	
	diag = g_malloc(sizeof(Tcs3_diag));
	diag->win = window_full(_("Cascading StyleSheet dialog"), GTK_WIN_POS_MOUSE, 
			GTK_WINDOW_DIALOG, 5, cs3d_destroy_lcb, diag);
	gtk_window_set_wmclass(GTK_WINDOW(diag->win), "Bluefish", "css");
	diag->dest = dest;
	diag->styletype = style;
	diag->grab = grab;
	diag->selected_row = -1;

	vbox = gtk_vbox_new(FALSE, 5);
	gtk_container_add(GTK_CONTAINER(diag->win),vbox);
	
	table = gtk_table_new(3,3,0);
	gtk_box_pack_start(GTK_BOX(vbox), table, FALSE, FALSE, 0);
	tmplist = NULL;
	
	if (diag->styletype == multistyle) {
		tmplist = glist_with_html_tags(1);
		diag->selector = combo_with_popdown(NULL, tmplist,1);
		gtk_table_attach_defaults(GTK_TABLE(table), gtk_label_new(_("selector")), 0,1,0,1);
		gtk_table_attach_defaults(GTK_TABLE(table), diag->selector, 1,2,0,1);
		g_list_free(tmplist);
		tmplist = NULL;
	} 

	tmp = cs3_arr[count];
	while (tmp.property) {
		tmplist = g_list_append(tmplist, tmp.property);
		count++;
		tmp = cs3_arr[count];
	}
	diag->property = combo_with_popdown(NULL, tmplist,1);
	g_list_free(tmplist);
	tmplist = NULL;
	gtk_signal_connect(GTK_OBJECT(GTK_COMBO(diag->property)->entry), "activate", cs3d_prop_activate_lcb, diag);
	gtk_signal_connect(GTK_OBJECT(GTK_COMBO(diag->property)->entry), "changed", cs3d_prop_activate_lcb, diag);

	diag->value = combo_with_popdown(NULL, tmplist,1);
	gtk_table_attach_defaults(GTK_TABLE(table), gtk_label_new(_("property")), 0,1,1,2);
	gtk_table_attach_defaults(GTK_TABLE(table), diag->property, 1,2,1,2);
	gtk_table_attach_defaults(GTK_TABLE(table), gtk_label_new(_("value")), 0,1,2,3);
	gtk_table_attach_defaults(GTK_TABLE(table), diag->value, 1,2,2,3);

	gtk_widget_realize(diag->win);

	diag->extra_but = color_but_new(GTK_WIDGET(GTK_COMBO(diag->value)->entry), diag->win);
	gtk_table_attach_defaults(GTK_TABLE(table), diag->extra_but, 2,3,2,3);

	/* the list widget and the buttons are in a horizontal box */
	hbox = gtk_hbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, FALSE, 0);

	scrolwin = gtk_scrolled_window_new(NULL, NULL);
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrolwin), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
	gtk_widget_set_usize(scrolwin, 400, 300);
	gtk_box_pack_start(GTK_BOX(hbox), scrolwin, FALSE, FALSE, 0);
	
	if (diag->styletype == multistyle) {
		gchar *titles[] = {"Selector", "Property", "Value", NULL};
		diag->clist = gtk_clist_new_with_titles(3, titles);
	} else {
		gchar *titles[] = {"Property", "Value", NULL};
		diag->clist = gtk_clist_new_with_titles(2, titles);
	}
	gtk_clist_set_sort_column(GTK_CLIST(diag->clist), 0);
	gtk_clist_set_auto_sort(GTK_CLIST(diag->clist), TRUE);

/*	gtk_clist_columns_autosize(GTK_CLIST(diag->clist));*/
	gtk_signal_connect(GTK_OBJECT(diag->clist), "select_row", GTK_SIGNAL_FUNC(cs3d_select_row_lcb), diag);
	gtk_signal_connect(GTK_OBJECT(diag->clist), "unselect_row", GTK_SIGNAL_FUNC(cs3d_unselect_row_lcb), diag);

	gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(scrolwin), diag->clist);

	vbox2 = gtk_vbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(hbox), vbox2, FALSE, FALSE, 0);
	
	but = bf_stock_button(_(" Add "), cs3d_add_clicked_lcb, diag);
	gtk_box_pack_start(GTK_BOX(vbox2), but, FALSE, FALSE, 0);

	but = bf_stock_button(_(" Update "), cs3d_update_clicked_lcb, diag);
	gtk_box_pack_start(GTK_BOX(vbox2), but, FALSE, FALSE, 0);
	
	but = bf_stock_button(_(" Delete "), cs3d_del_clicked_lcb, diag);
	gtk_box_pack_start(GTK_BOX(vbox2), but, FALSE, FALSE, 0);

	/* the ok and cancel button are in a horizontal box below */
	hbox = gtk_hbox_new(TRUE, 0);
	gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, FALSE, 0);
	but = bf_stock_ok_button(cs3d_ok_clicked_lcb, diag);
	gtk_box_pack_start(GTK_BOX(hbox), but, TRUE, TRUE, 0);
	but = bf_stock_cancel_button(cs3d_cancel_clicked_lcb, diag);
	gtk_box_pack_start(GTK_BOX(hbox), but, TRUE, TRUE, 0);
	
	gtk_widget_show_all(diag->win);
	
	cs3d_prop_activate_lcb(NULL, diag);
	
	if (transient_win) {
		gtk_window_set_transient_for(GTK_WINDOW(diag->win), GTK_WINDOW(transient_win));
	}
	if (diag->grab) {
		gtk_grab_add(diag->win);
	}
	return diag;
}

typedef enum {property, value, end} Tcs3_prevtype_onestyle;
typedef enum {mselector, mproperty, mvalue, mend, mselectorend} Tcs3_prevtype_multistyle;

static void css_parse(Tcs3_diag *diag, gchar *data) {
	gchar *tmp = data;
	gint count = 0;

	if (!data) {
		DEBUG_MSG("css_parse, no data!\n");
		return;
	}

	if (diag->styletype == onestyle) {
		gint prev_end = 0;
		Tcs3_prevtype_onestyle prevtype = end;
		gchar *text[3];
		
		DEBUG_MSG("css_parse, onestyle\n");
		text[2] = NULL;
		while (tmp[count]) {
			switch (tmp[count]) {
			case ':':
				if (prevtype == end) {
					text[0] = g_strndup(&tmp[prev_end], count - prev_end);
					strip_any_whitespace(text[0]);
					prev_end = count+1;
					prevtype = property;
				}
			break;
			case ';':
				if (prevtype == property) {
					text[1] = g_strndup(&tmp[prev_end], count - prev_end);
					strip_any_whitespace(text[1]);
					prev_end = count+1;
					prevtype = value;
				}
			break;
			default:
				/* do nothing */
			break;
			}
			if (prevtype == value) {
				gtk_clist_append(GTK_CLIST(diag->clist), text);
				g_free(text[0]);
				g_free(text[1]);
				prevtype = end;
			}
			count++;
		}
	
	
	} else { /* multistyle */
		gint prev_end = 0;
		Tcs3_prevtype_multistyle prevtype = mselectorend;
		gchar *text[4];

		DEBUG_MSG("css_parse, multistylestyle\n");		
		text[3] = NULL;
		
		while (tmp[count]) {
			switch (tmp[count]) {
			case '}': /* found end of block */
				if (prevtype != mselectorend) {
					prevtype = mselectorend;
					prev_end = count+1;
					g_free(text[0]);
					text[0]=NULL;
				}
			break;
			case '{': /* found selector */
				if (prevtype == mselectorend) {
					text[0] = g_strndup(&tmp[prev_end], count - prev_end);
					strip_any_whitespace(text[0]);
					prev_end = count+1;
					prevtype = mselector;
				}
			break;
			case ':':
				if (prevtype == mselector || prevtype == mend) {
					text[1] = g_strndup(&tmp[prev_end], count - prev_end);
					strip_any_whitespace(text[1]);
					prev_end = count+1;
					prevtype = mproperty;
				}
			break;
			case ';':
				if (prevtype == mproperty) {
					text[2] = g_strndup(&tmp[prev_end], count - prev_end);
					strip_any_whitespace(text[2]);
					prev_end = count+1;
					prevtype = mvalue;
				}
			break;
			default:
				/* do nothing */
			break;
			}
			if (prevtype == mvalue) {
				gtk_clist_append(GTK_CLIST(diag->clist), text);
				g_free(text[1]);
				g_free(text[2]);
				prevtype = mend;
			}
			count++;
		}
		if (text[0]){
			g_free(text[0]);
		}
	}
	gtk_clist_sort(GTK_CLIST(diag->clist));
	DEBUG_MSG("css_parse, finished\n");
}

void new_css_dialog(GtkWidget *widget, gpointer data) {
	Tcs3_destination dest;
	Tcs3_diag *diag;

	dest.dest_type = textbox;
	dest.entry = NULL;
	dest.doc = main_v->current_document;
	if (GTK_EDITABLE(dest.doc->textbox)->has_selection) {
		dest.doc_start = GTK_EDITABLE(dest.doc->textbox)->selection_start_pos;
		dest.doc_end = GTK_EDITABLE(dest.doc->textbox)->selection_end_pos;
	} else {
		dest.doc_start = -1; /* have to set these from the selection !! */
		dest.doc_end = -1;	/* have to set these from the selection !! */
	}
	if (dest.doc_start > dest.doc_end) {
		gint swap = dest.doc_start;
		dest.doc_start = dest.doc_end;
		dest.doc_end = swap;
	}

	diag = css_diag(dest, multistyle, NULL, FALSE);
	if (GTK_EDITABLE(dest.doc->textbox)->has_selection) {
		gchar *data;

		data = gtk_editable_get_chars(GTK_EDITABLE(dest.doc->textbox), dest.doc_start, dest.doc_end);
		DEBUG_MSG("new_css_dialog, data=%p\n", data);
		css_parse(diag, data);
		g_free(data);
	}
}

static void style_but_clicked_lcb(GtkWidget * widget, GtkWidget * which_entry)
{
	Tcs3_destination dest;
	Tcs3_diag *diag;
	gchar *data;
	GtkWidget *win;

	dest.dest_type = entry;
	dest.entry = which_entry;
	dest.doc = NULL;

	win = gtk_widget_get_toplevel(which_entry);
	diag = css_diag(dest, onestyle, win, TRUE);
	data = gtk_editable_get_chars(GTK_EDITABLE(which_entry), 0, -1);
	css_parse(diag, data);
	g_free(data);
}

GtkWidget *style_but_new(GtkWidget * which_entry, GtkWidget * win)
{
	GtkWidget *pixmap, *style_but;

/* style_but = gtk_button_new_with_label("Edit style"); */
	style_but = gtk_button_new();
	pixmap = new_pixmap(192, win->window, NULL);
	gtk_widget_show(pixmap);
	gtk_container_add(GTK_CONTAINER(style_but), pixmap);

	gtk_signal_connect(GTK_OBJECT(style_but), "clicked", style_but_clicked_lcb, which_entry);
	gtk_widget_show(style_but);
	return style_but;
}
#endif /* #ifdef NEW_CS3 */
