/* Bluefish HTML Editor
 * spell_gui.c - Check Spelling GUI
 *
 * Copyright (C) 2000 Pablo De Napoli
 *
 * The code in this file was writen with the aid of glade.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#ifdef WITH_SPC

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>

#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>

#include "bluefish.h"
#include "intl.h"
#include "debug.h"
#include "spell.h"
#include "spell_gui.h"


/* macros to send messages to the spell checker */

static void
spc_start_button_clicked_lcb            (GtkButton       *button,
                                        gpointer         user_data)
{
  run_spell_checker ("");
}


static void
spc_stop_button_clicked_lcb        (GtkButton       *button,
                                    gpointer         user_data)
{
  spc_message = SPC_STOP ; /* stop_spell_checker */
}

static void
spc_done_button_clicked_lcb        (GtkButton       *button,
                                    gpointer         user_data)
{
  spc_message = SPC_DONE ; /* stop_spell_checker */
}


void
on_spc_options_button_clicked          (GtkButton       *button,
                                        gpointer         user_data)
{

}


void
spc_replace_combo_activate_lcb           (GtkEditable     *editable,
                                        gpointer         user_data)
{
  spc_message = SPC_REPLACE; /* Replace word */
}


void
on_spc_near_misses_combo_activate      (GtkEditable     *editable,
                                        gpointer         user_data)
{

}


void
on_spc_near_misses_combo_changed       (GtkEditable     *editable,
                                        gpointer         user_data)
{

}


void
on_spc_accept_button_clicked           (GtkButton       *button,
                                        gpointer         user_data)
{
  spc_message = SPC_ACCEPT ; /* accept word */
}


void
on_spc_insert_button_clicked           (GtkButton       *button,
                                        gpointer         user_data)
{
  spc_message = SPC_INSERT;
}


void
on_spc_ignore_button_clicked           (GtkButton       *button,
                                        gpointer         user_data)
{
 spc_message = SPC_IGNORE ; /* ignore_word() */
}


void
on_spc_replace_button_clicked          (GtkButton       *button,
                                        gpointer         user_data)
{
 spc_message = SPC_REPLACE; /* replace word */
}


Tspc_gui spc_gui;

GtkWidget*
create_spc_window (void)
{
  spc_gui.window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_object_set_data (GTK_OBJECT (spc_gui.window), "spc_window", spc_gui.window);
  gtk_window_set_title (GTK_WINDOW (spc_gui.window), _("Spell Checker"));

  spc_gui.vbox = gtk_vbox_new (FALSE, 0);
  gtk_widget_ref (spc_gui.vbox);
  gtk_object_set_data_full (GTK_OBJECT (spc_gui.window), "spc_vbox", spc_gui.vbox,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (spc_gui.vbox);
  gtk_container_add (GTK_CONTAINER (spc_gui.window), spc_gui.vbox);

  spc_gui. hbuttonbox_top = gtk_hbutton_box_new ();
  gtk_widget_ref (spc_gui.hbuttonbox_top);
  gtk_object_set_data_full (GTK_OBJECT (spc_gui.window), "sp_hbuttonbox_top", spc_gui.hbuttonbox_top,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (spc_gui.hbuttonbox_top);
  gtk_box_pack_start (GTK_BOX (spc_gui.vbox), spc_gui.hbuttonbox_top, TRUE, TRUE, 0);

  spc_gui . start_button = gtk_button_new_with_label (_("Start"));
  gtk_widget_ref (spc_gui . start_button);
  gtk_object_set_data_full (GTK_OBJECT (spc_gui.window), "spc_start_button", spc_gui.start_button,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (spc_gui.start_button);
  gtk_container_add (GTK_CONTAINER (spc_gui.hbuttonbox_top), spc_gui.start_button);
  GTK_WIDGET_SET_FLAGS (spc_gui.start_button, GTK_CAN_DEFAULT);

  spc_gui . stop_button = gtk_button_new_with_label (_("Stop"));
  gtk_widget_ref (spc_gui. stop_button);
  gtk_object_set_data_full (GTK_OBJECT (spc_gui.window), "spc_stop_button", spc_gui.stop_button,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (spc_gui.stop_button);
  gtk_container_add (GTK_CONTAINER (spc_gui.hbuttonbox_top), spc_gui.stop_button);
  GTK_WIDGET_SET_FLAGS (spc_gui.stop_button, GTK_CAN_DEFAULT);

  spc_gui.done_button = gtk_button_new_with_label (_("Done"));
  gtk_widget_ref (spc_gui. done_button);
  gtk_object_set_data_full (GTK_OBJECT (spc_gui.window), "spc_stop_button", spc_gui.done_button,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (spc_gui.done_button);
  gtk_container_add (GTK_CONTAINER (spc_gui.hbuttonbox_top), spc_gui.done_button);
  GTK_WIDGET_SET_FLAGS (spc_gui.done_button, GTK_CAN_DEFAULT);

  spc_gui. options_button = gtk_button_new_with_label (_("Options"));
  gtk_widget_ref (spc_gui.options_button);
  gtk_object_set_data_full (GTK_OBJECT (spc_gui. window), "spc_options_button", spc_gui.options_button,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (spc_gui. options_button);
  gtk_container_add (GTK_CONTAINER (spc_gui. hbuttonbox_top), spc_gui.options_button);
  GTK_WIDGET_SET_FLAGS (spc_gui.options_button, GTK_CAN_DEFAULT);

  spc_gui.word_frame = gtk_frame_new (_("Word"));
  gtk_widget_ref (spc_gui.word_frame);
  gtk_object_set_data_full (GTK_OBJECT (spc_gui.window), "sp_word_frame", spc_gui.word_frame,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (spc_gui.word_frame);
  gtk_box_pack_start (GTK_BOX (spc_gui.vbox), spc_gui.word_frame, TRUE, TRUE, 0);

  spc_gui.word_entry = gtk_entry_new ();
  gtk_widget_ref (spc_gui.word_entry);
  gtk_object_set_data_full (GTK_OBJECT (spc_gui.window), "spc_word_entry", spc_gui.word_entry,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (spc_gui.word_entry);
  gtk_container_add (GTK_CONTAINER (spc_gui.word_frame), spc_gui.word_entry);

  spc_gui .replace_frame = gtk_frame_new (_("Replace"));
  gtk_widget_ref (spc_gui.replace_frame);
  gtk_object_set_data_full (GTK_OBJECT (spc_gui.window), "spc_replace_frame", spc_gui.replace_frame,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (spc_gui.replace_frame);
  gtk_box_pack_start (GTK_BOX (spc_gui.vbox), spc_gui.replace_frame, FALSE, FALSE, 0);

  spc_gui.replace_combo = gtk_combo_new ();
  gtk_widget_ref (spc_gui.replace_combo);
  gtk_object_set_data_full (GTK_OBJECT (spc_gui.window), "replace_combo", spc_gui.replace_combo,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (spc_gui.replace_combo);
  gtk_container_add (GTK_CONTAINER (spc_gui.replace_frame),spc_gui.replace_combo);

  spc_gui.progress_frame = gtk_frame_new (_("Progress"));
  gtk_widget_ref (spc_gui.progress_frame);
  gtk_object_set_data_full (GTK_OBJECT (spc_gui.window), "spc_progress_frame", spc_gui.progress_frame,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (spc_gui.progress_frame);
  gtk_box_pack_start (GTK_BOX (spc_gui.vbox), spc_gui.progress_frame, TRUE, TRUE, 0);

  spc_gui.progressbar = gtk_progress_bar_new ();
  gtk_widget_ref (spc_gui.progressbar);
  gtk_object_set_data_full (GTK_OBJECT (spc_gui.window), "spc_progressbar", spc_gui.progressbar,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (spc_gui.progressbar);
  gtk_container_add (GTK_CONTAINER (spc_gui.progress_frame), spc_gui.progressbar);

  spc_gui.botton_hbuttonbox = gtk_hbutton_box_new ();
  gtk_widget_ref (spc_gui.botton_hbuttonbox);
  gtk_object_set_data_full (GTK_OBJECT (spc_gui.window), "spc_botton_hbuttonbox", spc_gui.botton_hbuttonbox,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (spc_gui.botton_hbuttonbox);
  gtk_box_pack_start (GTK_BOX (spc_gui.vbox), spc_gui.botton_hbuttonbox, TRUE, TRUE, 0);

  spc_gui.accept_button = gtk_button_new_with_label (_("Accept word\nin this section"));
  gtk_widget_ref (spc_gui.accept_button);
  gtk_object_set_data_full (GTK_OBJECT (spc_gui.window), "spc_accept_button", spc_gui.accept_button,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (spc_gui.accept_button);
  gtk_container_add (GTK_CONTAINER (spc_gui.botton_hbuttonbox), spc_gui.accept_button);
  GTK_WIDGET_SET_FLAGS (spc_gui.accept_button, GTK_CAN_DEFAULT);

  spc_gui.insert_button = gtk_button_new_with_label (_("Insert in Personal\nDictionary"));
  gtk_widget_ref (spc_gui.insert_button);
  gtk_object_set_data_full (GTK_OBJECT (spc_gui.window), "spc_insert_button", spc_gui.insert_button,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (spc_gui.insert_button);
  gtk_container_add (GTK_CONTAINER (spc_gui.botton_hbuttonbox), spc_gui.insert_button);
  GTK_WIDGET_SET_FLAGS (spc_gui.insert_button, GTK_CAN_DEFAULT);

  spc_gui.ignore_button = gtk_button_new_with_label (_("Ignore\nWord"));
  gtk_widget_ref (spc_gui.ignore_button);
  gtk_object_set_data_full (GTK_OBJECT (spc_gui.window), "spc_ignore_button", spc_gui.ignore_button,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (spc_gui.ignore_button);
  gtk_container_add (GTK_CONTAINER (spc_gui.botton_hbuttonbox), spc_gui.ignore_button);
  GTK_WIDGET_SET_FLAGS (spc_gui.ignore_button, GTK_CAN_DEFAULT);

  spc_gui.replace_button = gtk_button_new_with_label (_("Replace\nWord"));
  gtk_widget_ref (spc_gui.replace_button);
  gtk_object_set_data_full (GTK_OBJECT (spc_gui.window), "spc_replace_button", spc_gui.replace_button,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (spc_gui.replace_button);
  gtk_container_add (GTK_CONTAINER (spc_gui.botton_hbuttonbox), spc_gui.replace_button);
  GTK_WIDGET_SET_FLAGS (spc_gui.replace_button, GTK_CAN_DEFAULT);

  gtk_signal_connect (GTK_OBJECT (spc_gui.start_button), "clicked",
                      GTK_SIGNAL_FUNC (spc_start_button_clicked_lcb),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (spc_gui.stop_button), "clicked",
                      GTK_SIGNAL_FUNC (spc_stop_button_clicked_lcb),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (spc_gui.done_button), "clicked",
                      GTK_SIGNAL_FUNC (spc_done_button_clicked_lcb),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (spc_gui.options_button), "clicked",
                      GTK_SIGNAL_FUNC (on_spc_options_button_clicked),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (spc_gui.replace_combo), "activate",
                      GTK_SIGNAL_FUNC (spc_replace_combo_activate_lcb),
                      NULL);
 /* gtk_signal_connect (GTK_OBJECT (spc_gui.near_misses_combo), "activate",
                      GTK_SIGNAL_FUNC (on_spc_near_misses_combo_activate),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (spc_gui.replace_combo), "changed",
                      GTK_SIGNAL_FUNC (on_spc_near_misses_combo_changed),
                      NULL); */
  gtk_signal_connect (GTK_OBJECT (spc_gui.accept_button), "clicked",
                      GTK_SIGNAL_FUNC (on_spc_accept_button_clicked),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (spc_gui.insert_button), "clicked",
                      GTK_SIGNAL_FUNC (on_spc_insert_button_clicked),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (spc_gui.ignore_button), "clicked",
                      GTK_SIGNAL_FUNC (on_spc_ignore_button_clicked),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (spc_gui.replace_button), "clicked",
                      GTK_SIGNAL_FUNC (on_spc_replace_button_clicked),
                      NULL);
  gtk_grab_add(spc_gui.window); /* became modal */
  return spc_gui.window;
}

void destroy_spc_window(void)
{
 gtk_grab_remove(spc_gui.window);
 gtk_widget_destroy(spc_gui.window);
}



void spell_check_cb(GtkWidget * w, gpointer data)
{
        spc_gui.window = create_spc_window();
	gtk_widget_show(spc_gui.window);
}

#endif