/* Bluefish HTML Editor
 * html.c - menu/toolbar callbacks, inserting functions, and other cool stuff 
 *
 * Copyright (C) 
 * 1998 Olivier Sessink and Chris Mazuc
 * 1999-2000 Olivier Sessink
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "default_include.h"

#include <string.h>
#include <locale.h>

#include "cap.h"
#include "bluefish.h"
#include "html.h"
#include "init.h" 	/* positionlist */
#include "gtk_easy.h"
#include "undo.h"
#include "document.h"
#include "stringlist.h"

/*****************************************************************************/
/* function declarations */
void tabledialog_cb(GtkWidget * widget, gpointer data);
void tablerowdialog_cb(GtkWidget * widget, gpointer data);
void tableheaddialog_cb(GtkWidget * widget, gpointer data);
void tabledatadialog_cb(GtkWidget * widget, gpointer data);
void tabledialogok(GtkWidget * widget, gpointer data);
void tablerowdialogok(GtkWidget * widget, gpointer data);
void tablehead_cberdialogok(GtkWidget * widget, gpointer data);
void tabledatadialogok(GtkWidget * widget, gpointer data);
gchar *converttohex(gchar * color);

/************************************************************************/
void tabledialog_cb(GtkWidget * widget, gpointer data)
{
	GList *alignlist = NULL;
	GtkWidget *color_but;

	static gchar *tagitems[] = { "cellpadding", "cellspacing", "border", "align", "valign", "bgcolor", "width", NULL };
	gchar *tagvalues[8];
	gchar *custom = NULL;
	Treplacerange *replace_range = NULL;

	/* this is for the right click menu */
	if ((data != NULL) && (widget == NULL)) {
		replace_range = values_for_dialog(tagitems, tagvalues, &custom, (Ttagpopup *) data);
	} else {
		init_values_for_dialog(tagitems, tagvalues);
	}
	/* end for the right click menu */

	create_dialog(500, 125, _("Table"));
	dialogtable = gtk_table_new(4, 12, 0);
	gtk_box_pack_start(GTK_BOX(vbox), dialogtable, FALSE, FALSE, 0);

	adj = (GtkAdjustment *) gtk_adjustment_new((gfloat) 0, 0.0, 100.0, 1.0, 5.0, 0.0);
	spin1 = gtk_spin_button_new(adj, 1, 0);

	parse_integer_for_dialog(tagvalues[0], spin1, NULL, NULL);

	gtk_spin_button_set_numeric(GTK_SPIN_BUTTON(spin1), 1);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("Cell Padding")), 0, 1, 0, 1);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), spin1, 1, 4, 0, 1);

	alignlist = g_list_append(alignlist, "left");
	alignlist = g_list_append(alignlist, "right");
	alignlist = g_list_append(alignlist, "center");
	combo1 = combo_with_popdown(tagvalues[3], alignlist, 0);
	g_list_free(alignlist);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("Align")), 4, 5, 0, 1);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), GTK_WIDGET(GTK_COMBO(combo1)), 5, 8, 0, 1);

	adj = (GtkAdjustment *) gtk_adjustment_new((gfloat) 0, 0.0, 600.0, 1.0, 5.0, 0.0);
	spin2 = gtk_spin_button_new(adj, 1, 0);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_(" Width ")), 8, 9, 0, 1);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), spin2, 9, 12, 0, 1);
/* add a checkbo here for percentages !!!!!!!!!!!!!!!! */
	parse_integer_for_dialog(tagvalues[6], spin2, NULL, NULL);

	adj = (GtkAdjustment *) gtk_adjustment_new((gfloat) 0, 0.0, 100.0, 1.0, 5.0, 0.0);
	spin3 = gtk_spin_button_new(adj, 1, 0);
	gtk_spin_button_set_numeric(GTK_SPIN_BUTTON(spin3), 1);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("Spacing")), 0, 1, 1, 2);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), spin3, 1, 4, 1, 2);
	parse_integer_for_dialog(tagvalues[1], spin3, NULL, NULL);

	combo2 = combo_with_popdown(tagvalues[4], positionlist, 1);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("VAlign")), 4, 5, 1, 2);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), GTK_WIDGET(combo2), 5, 8, 1, 2);

	adj = (GtkAdjustment *) gtk_adjustment_new((gfloat) 0, 0.0, 100.0, 1.0, 5.0, 0.0);
	spin4 = gtk_spin_button_new(adj, 1, 0);
	gtk_spin_button_set_numeric(GTK_SPIN_BUTTON(spin4), 1);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("Border")), 8, 9, 1, 2);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), spin4, 9, 12, 1, 2);
	parse_integer_for_dialog(tagvalues[2], spin4, NULL, NULL);

	combo3 = combo_with_popdown(tagvalues[5], main_v->current_project.colorlist, 1);
	color_but = color_but_new(GTK_COMBO(combo3)->entry, dialog);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("Background Color")), 0, 1, 2, 3);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), GTK_WIDGET(combo3), 1, 7, 2, 3);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), GTK_WIDGET(color_but), 7, 8, 2, 3);

	textentry1 = entry_with_text(custom, 1024);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("Custom")), 0, 1, 3, 4);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), textentry1, 1, 8, 3, 4);
	create_buttons(GTK_SIGNAL_FUNC(tabledialogok), (gpointer) replace_range);
	if (custom)
		g_free(custom);
}

/************************************************************************/
void tablerowdialog_cb(GtkWidget * widget, gpointer data)
{
	GList *alignlist = NULL;
	GtkWidget *color_but;

	static gchar *tagitems[] = { "align", "valign", "bgcolor", NULL };
	gchar *tagvalues[4];
	gchar *custom = NULL;
	Treplacerange *replace_range = NULL;

	/* this is for the right click menu */
	if ((data != NULL) && (widget == NULL)) {
		replace_range = values_for_dialog(tagitems, tagvalues, &custom, (Ttagpopup *) data);
	} else {
		init_values_for_dialog(tagitems, tagvalues);
	}
	/* end for the right click menu */


	create_dialog(300, 123, _("Table Row"));
	dialogtable = gtk_table_new(3, 10, 0);
	gtk_box_pack_start(GTK_BOX(vbox), dialogtable, FALSE, FALSE, 0);

	alignlist = g_list_insert(alignlist, "left", 0);
	alignlist = g_list_insert(alignlist, "right", 1);
	alignlist = g_list_insert(alignlist, "center", 2);
	combo1 = combo_with_popdown(tagvalues[0], alignlist, 0);
	g_list_free(alignlist);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("Align")), 0, 1, 0, 1);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), GTK_WIDGET(combo1), 1, 10, 0, 1);

	combo2 = combo_with_popdown(tagvalues[1], positionlist, 0);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("VAlign")), 0, 1, 1, 2);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), GTK_WIDGET(GTK_COMBO(combo2)), 1, 10, 1, 2);


	combo3 = combo_with_popdown(tagvalues[2], main_v->current_project.colorlist, 1);
	color_but = color_but_new(GTK_COMBO(combo3)->entry, dialog);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("Background Color")), 0, 1, 2, 3);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), GTK_WIDGET(GTK_COMBO(combo3)), 1, 9, 2, 3);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), GTK_WIDGET(color_but), 9, 10, 2, 3);

	textentry1 = entry_with_text(custom, 1024);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("Custom")), 0, 1, 3, 4);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), textentry1, 1, 8, 3, 4);
	create_buttons(GTK_SIGNAL_FUNC(tablerowdialogok), (gpointer) replace_range);
	if (custom)
		g_free(custom);
}

/************************************************************************/
void tableheaddialog_cb(GtkWidget * widget, gpointer data)
{
	GList *alignlist = NULL;

	static gchar *tagitems[] = { "width", "align", "colspan", "height", "valign", "rowspan", "bgcolor", "nowrap", NULL };
	gchar *tagvalues[9];
	gchar *custom = NULL;
	Treplacerange *replace_range = NULL;

	/* this is for the right click menu */
	if ((data != NULL) && (widget == NULL)) {
		replace_range = values_for_dialog(tagitems, tagvalues, &custom, (Ttagpopup *) data);
	} else {
		init_values_for_dialog(tagitems, tagvalues);
	}
	/* end for the right click menu */

	create_dialog(500, 123, _("Table Header"));
	dialogtable = gtk_table_new(3, 12, 0);
	gtk_box_pack_start(GTK_BOX(vbox), dialogtable, FALSE, FALSE, 0);

	adj = (GtkAdjustment *) gtk_adjustment_new((gfloat) 0, 0.0, 100.0, 1.0, 5.0, 0.0);
	spin1 = gtk_spin_button_new(adj, 1, 0);
	parse_integer_for_dialog(tagvalues[0], spin1, NULL, NULL);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("Width")), 0, 1, 0, 1);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), spin1, 1, 4, 0, 1);

	alignlist = g_list_insert(alignlist, "left", 0);
	alignlist = g_list_insert(alignlist, "right", 1);
	alignlist = g_list_insert(alignlist, "center", 2);
	alignlist = g_list_insert(alignlist, "justify", 3);
	combo1 = combo_with_popdown(tagvalues[1], alignlist, 1);
	g_list_free(alignlist);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("Align")), 4, 5, 0, 1);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), GTK_WIDGET(GTK_COMBO(combo1)), 5, 8, 0, 1);

	adj = (GtkAdjustment *) gtk_adjustment_new((gfloat) 0, 0.0, 600.0, 1.0, 5.0, 0.0);
	spin2 = gtk_spin_button_new(adj, 1, 0);
	gtk_spin_button_set_numeric(GTK_SPIN_BUTTON(spin2), 1);
	parse_integer_for_dialog(tagvalues[2], spin2, NULL, NULL);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("Col Span")), 8, 9, 0, 1);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), spin2, 9, 12, 0, 1);

	adj = (GtkAdjustment *) gtk_adjustment_new((gfloat) 0, 0.0, 100.0, 1.0, 5.0, 0.0);
	spin3 = gtk_spin_button_new(adj, 1, 0);
	parse_integer_for_dialog(tagvalues[3], spin3, NULL, NULL);
	gtk_spin_button_set_numeric(GTK_SPIN_BUTTON(spin3), 1);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("Height")), 0, 1, 1, 2);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), spin3, 1, 4, 1, 2);

	combo2 = combo_with_popdown(tagvalues[4], positionlist, 1);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("VAlign")), 4, 5, 1, 2);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), GTK_WIDGET(GTK_COMBO(combo2)), 5, 8, 1, 2);

	adj = (GtkAdjustment *) gtk_adjustment_new((gfloat) 0, 0.0, 100.0, 1.0, 5.0, 0.0);
	spin4 = gtk_spin_button_new(adj, 1, 0);
	parse_integer_for_dialog(tagvalues[5], spin4, NULL, NULL);
	gtk_spin_button_set_numeric(GTK_SPIN_BUTTON(spin4), 1);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("Row Span")), 8, 9, 1, 2);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), spin4, 9, 12, 1, 2);

	combo3 = combo_with_popdown(tagvalues[6], main_v->current_project.colorlist, 1);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("Background Color")), 0, 1, 2, 3);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), GTK_WIDGET(GTK_COMBO(combo3)), 1, 7, 2, 3);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), GTK_WIDGET(color_but_new(GTK_COMBO(combo3)->entry, dialog)), 7, 8, 2, 3);

	checkbox1 = gtk_check_button_new();
	parse_existence_for_dialog(tagvalues[7], checkbox1);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("No Wrap")), 8, 9, 2, 3);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), checkbox1, 9, 10, 2, 3);

	textentry1 = entry_with_text(custom, 1024);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("Custom")), 0, 1, 3, 4);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), textentry1, 1, 8, 3, 4);
	create_buttons(GTK_SIGNAL_FUNC(tablehead_cberdialogok), (gpointer) replace_range);
	if (custom)
		g_free(custom);
}

/************************************************************************/
void tabledatadialog_cb(GtkWidget * widget, gpointer data)
{
	GList *alignlist = NULL;


	static gchar *tagitems[] = { "width", "align", "colspan", "height", "valign", "rowspan", "bgcolor", "nowrap", NULL };
	gchar *tagvalues[9];
	gchar *custom = NULL;
	Treplacerange *replace_range = NULL;

	/* this is for the right click menu */
	if ((data != NULL) && (widget == NULL)) {
		replace_range = values_for_dialog(tagitems, tagvalues, &custom, (Ttagpopup *) data);
	} else {
		init_values_for_dialog(tagitems, tagvalues);
	}
	/* end for the right click menu */

	create_dialog(500, 123, _("Table Data"));
	dialogtable = gtk_table_new(3, 12, 0);
	gtk_box_pack_start(GTK_BOX(vbox), dialogtable, FALSE, FALSE, 0);

	adj = (GtkAdjustment *) gtk_adjustment_new((gfloat) 0, 0.0, 100.0, 1.0, 5.0, 0.0);
	spin1 = gtk_spin_button_new(adj, 1, 0);
	parse_integer_for_dialog(tagvalues[0], spin1, NULL, NULL);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("Width")), 0, 1, 0, 1);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), spin1, 1, 4, 0, 1);

	alignlist = g_list_insert(alignlist, "left", 0);
	alignlist = g_list_insert(alignlist, "right", 1);
	alignlist = g_list_insert(alignlist, "center", 2);
	alignlist = g_list_insert(alignlist, "justify", 3);
	combo1 = combo_with_popdown(tagvalues[1], alignlist, 1);
	g_list_free(alignlist);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("Align")), 4, 5, 0, 1);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), GTK_WIDGET(GTK_COMBO(combo1)), 5, 8, 0, 1);

	adj = (GtkAdjustment *) gtk_adjustment_new((gfloat) 0, 0.0, 600.0, 1.0, 5.0, 0.0);
	spin2 = gtk_spin_button_new(adj, 1, 0);
	gtk_spin_button_set_numeric(GTK_SPIN_BUTTON(spin2), 1);
	parse_integer_for_dialog(tagvalues[2], spin2, NULL, NULL);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("Col Span")), 8, 9, 0, 1);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), spin2, 9, 12, 0, 1);

	adj = (GtkAdjustment *) gtk_adjustment_new((gfloat) 0, 0.0, 100.0, 1.0, 5.0, 0.0);
	spin3 = gtk_spin_button_new(adj, 1, 0);
	parse_integer_for_dialog(tagvalues[3], spin3, NULL, NULL);
	gtk_spin_button_set_numeric(GTK_SPIN_BUTTON(spin3), 1);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("Height")), 0, 1, 1, 2);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), spin3, 1, 4, 1, 2);

	combo2 = combo_with_popdown(tagvalues[4], positionlist, 1);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("VAlign")), 4, 5, 1, 2);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), GTK_WIDGET(GTK_COMBO(combo2)), 5, 8, 1, 2);

	adj = (GtkAdjustment *) gtk_adjustment_new((gfloat) 0, 0.0, 100.0, 1.0, 5.0, 0.0);
	spin4 = gtk_spin_button_new(adj, 1, 0);
	parse_integer_for_dialog(tagvalues[5], spin4, NULL, NULL);
	gtk_spin_button_set_numeric(GTK_SPIN_BUTTON(spin4), 1);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("Row Span")), 8, 9, 1, 2);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), spin4, 9, 12, 1, 2);

	combo3 = combo_with_popdown(tagvalues[6], main_v->current_project.colorlist, 1);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("Background Color")), 0, 1, 2, 3);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), GTK_WIDGET(GTK_COMBO(combo3)), 1, 7, 2, 3);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), GTK_WIDGET(color_but_new(GTK_COMBO(combo3)->entry, dialog)), 7, 8, 2, 3);

	checkbox1 = gtk_check_button_new();
	parse_existence_for_dialog(tagvalues[7], checkbox1);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("No Wrap")), 8, 9, 2, 3);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), checkbox1, 9, 10, 2, 3);

	textentry1 = entry_with_text(custom, 1024);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("Custom")), 0, 1, 3, 4);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), textentry1, 1, 8, 3, 4);
	create_buttons(GTK_SIGNAL_FUNC(tabledatadialogok), (gpointer) replace_range);
	if (custom)
		g_free(custom);
}

/************************************************************************/
void tabledialogok(GtkWidget * widget, gpointer data)
{
	gchar *tempstr;
	gint temp;
	stuff = g_malloc(1024);
	tempstr = g_malloc(1024);

	strncpy(stuff, cap("<TABLE"), 1023);

	if (strlen(gtk_entry_get_text(GTK_ENTRY(spin1)))) {
		temp = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(spin1));
		g_snprintf(tempstr, 1023, "%s%d\"", cap(" CELLPADDING=\""), temp);
		strncat(stuff, tempstr, 1023);
	}
	if (strlen(gtk_entry_get_text(GTK_ENTRY(spin3)))) {
		temp = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(spin3));
		g_snprintf(tempstr, 1023, "%s%d\"", cap(" CELLSPACING=\""), temp);
		strncat(stuff, tempstr, 1023);
	}
	if (strlen(gtk_entry_get_text(GTK_ENTRY(spin4)))) {
		temp = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(spin4));
		g_snprintf(tempstr, 1023, "%s%d\"", cap(" BORDER=\""), temp);
		strncat(stuff, tempstr, 1023);
	}
	if (strlen(gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(combo1)->entry)))) {
		strncat(strncat(strncat(stuff, cap(" ALIGN=\""), 1023), gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(combo1)->entry)), 1023), "\"", 1023);
	}
	if (strlen(gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(combo2)->entry)))) {
		strncat(strncat(strncat(stuff, cap(" VALIGN=\""), 1023), gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(combo2)->entry)), 1023), "\"",
				1023);
	}
	if (strlen(gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(combo3)->entry)))) {
		strncat(strncat
				(strncat(stuff, cap(" BGCOLOR=\""), 1023), converttohex(gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(combo3)->entry))), 1023),
				"\"", 1023);
	}
	if (strlen(gtk_entry_get_text(GTK_ENTRY(spin2)))) {
		temp = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(spin2));
		g_snprintf(tempstr, 1023, "%s%d\"", cap(" WIDTH=\""), temp);
		strncat(stuff, tempstr, 1023);
	}
	if (strlen((gchar *) gtk_entry_get_text(GTK_ENTRY(textentry1)))) {
		strncat(stuff, " ", 1023);
		strncat(stuff, (gchar *) gtk_entry_get_text(GTK_ENTRY(textentry1)), 1023);
	}
	strncat(stuff, ">", 1023);
	if (data == NULL) {
		insert_text(stuff, cap("</TABLE>"));
	} else {
		replace_text(stuff, ((Treplacerange *) data)->pos, ((Treplacerange *) data)->len);
		g_free(data);
	}

	g_free(tempstr);
	destroy_dialog();
}

/************************************************************************/
void tablerowdialogok(GtkWidget * widget, gpointer data)
{
	stuff = g_malloc(1024);

	strncpy(stuff, cap("<TR"), 1023);

	if (strlen(gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(combo1)->entry)))) {
		strncat(strncat(strncat(stuff, cap(" ALIGN=\""), 1023), gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(combo1)->entry)), 1023), "\"", 1023);
	}
	if (strlen(gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(combo2)->entry)))) {
		strncat(strncat(strncat(stuff, cap(" VALIGN=\""), 1023), gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(combo2)->entry)), 1023), "\"",
				1023);
	}
	if (strlen(gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(combo3)->entry)))) {
		strncat(strncat
				(strncat(stuff, cap(" BGCOLOR=\""), 1023), converttohex(gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(combo3)->entry))), 1023),
				"\"", 1023);
	}
	if (strlen((gchar *) gtk_entry_get_text(GTK_ENTRY(textentry1)))) {
		strncat(stuff, " ", 1023);
		strncat(stuff, (gchar *) gtk_entry_get_text(GTK_ENTRY(textentry1)), 1023);
	}
	strncat(stuff, ">", 1023);

	if (data == NULL) {
		insert_text(stuff, cap("</TR>"));
	} else {
		replace_text(stuff, ((Treplacerange *) data)->pos, ((Treplacerange *) data)->len);
		g_free(data);
	}
	destroy_dialog();
}

/************************************************************************/
void tablehead_cberdialogok(GtkWidget * widget, gpointer data)
{
	gchar *tempstr;
	gint temp;
	stuff = g_malloc(1024);
	tempstr = g_malloc(1024);

	strncpy(stuff, cap("<TH"), 1023);

	if (strlen(gtk_entry_get_text(GTK_ENTRY(spin1)))) {
		temp = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(spin1));
		g_snprintf(tempstr, 1023, "%s%d\"", cap(" WIDTH=\""), temp);
		strncat(stuff, tempstr, 1023);
	}
	if (strlen(gtk_entry_get_text(GTK_ENTRY(spin3)))) {
		temp = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(spin3));
		g_snprintf(tempstr, 1023, "%s%d\"", cap(" HEIGHT=\""), temp);
		strncat(stuff, tempstr, 1023);
	}
	if (strlen(gtk_entry_get_text(GTK_ENTRY(spin2)))) {
		temp = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(spin2));
		g_snprintf(tempstr, 1023, "%s%d\"", cap(" COLSPAN=\""), temp);
		strncat(stuff, tempstr, 1023);
	}
	if (strlen(gtk_entry_get_text(GTK_ENTRY(spin4)))) {
		temp = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(spin4));
		g_snprintf(tempstr, 1023, "%s%d\"", cap(" ROWSPAN=\""), temp);
		strncat(stuff, tempstr, 1023);
	}
	if (strlen(gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(combo1)->entry)))) {
		strncat(strncat(strncat(stuff, cap(" ALIGN=\""), 1023), gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(combo1)->entry)), 1023), "\"", 1023);
	}
	if (strlen(gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(combo2)->entry)))) {
		strncat(strncat(strncat(stuff, cap(" VALIGN=\""), 1023), gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(combo2)->entry)), 1023), "\"",
				1023);
	}
	if (strlen(gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(combo3)->entry)))) {
		strncat(strncat
				(strncat(stuff, cap(" BGCOLOR=\""), 1023), converttohex(gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(combo3)->entry))), 1023),
				"\"", 1023);
	}
	if (GTK_TOGGLE_BUTTON(checkbox1)->active) {
		strncat(stuff, cap(" NOWRAP"), 1023);
	}
	if (strlen((gchar *) gtk_entry_get_text(GTK_ENTRY(textentry1)))) {
		strncat(stuff, " ", 1023);
		strncat(stuff, (gchar *) gtk_entry_get_text(GTK_ENTRY(textentry1)), 1023);
	}
	strncat(stuff, ">", 1023);

	if (data == NULL) {
		insert_text(stuff, cap("</TH>"));
	} else {
		replace_text(stuff, ((Treplacerange *) data)->pos, ((Treplacerange *) data)->len);
		g_free(data);
	}

	g_free(tempstr);
	destroy_dialog();
}

/************************************************************************/
void tabledatadialogok(GtkWidget * widget, gpointer data)
{
	gchar *tempstr;
	gint temp;
	stuff = g_malloc(1024);
	tempstr = g_malloc(1024);

	strncpy(stuff, cap("<TD"), 1023);

	if (strlen(gtk_entry_get_text(GTK_ENTRY(spin1)))) {
		temp = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(spin1));
		g_snprintf(tempstr, 1023, "%s%d\"", cap(" WIDTH=\""), temp);
		strncat(stuff, tempstr, 1023);
	}
	if (strlen(gtk_entry_get_text(GTK_ENTRY(spin3)))) {
		temp = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(spin3));
		g_snprintf(tempstr, 1023, "%s%d\"", cap(" HEIGHT=\""), temp);
		strncat(stuff, tempstr, 1023);
	}
	if (strlen(gtk_entry_get_text(GTK_ENTRY(spin2)))) {
		temp = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(spin2));
		g_snprintf(tempstr, 1023, "%s%d\"", cap(" COLSPAN=\""), temp);
		strncat(stuff, tempstr, 1023);
	}
	if (strlen(gtk_entry_get_text(GTK_ENTRY(spin4)))) {
		temp = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(spin4));
		g_snprintf(tempstr, 1023, "%s%d\"", cap(" ROWSPAN=\""), temp);
		strncat(stuff, tempstr, 1023);
	}
	if (strlen(gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(combo1)->entry)))) {
		strncat(strncat(strncat(stuff, cap(" ALIGN=\""), 1023), gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(combo1)->entry)), 1023), "\"", 1023);
	}
	if (strlen(gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(combo2)->entry)))) {
		strncat(strncat(strncat(stuff, cap(" VALIGN=\""), 1023), gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(combo2)->entry)), 1023), "\"",
				1023);
	}
	if (strlen(gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(combo3)->entry)))) {
		strncat(strncat
				(strncat(stuff, cap(" BGCOLOR=\""), 1023), converttohex(gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(combo3)->entry))), 1023),
				"\"", 1023);
	}
	if (GTK_TOGGLE_BUTTON(checkbox1)->active) {
		strncat(stuff, cap(" NOWRAP"), 1023);
	}
	if (strlen((gchar *) gtk_entry_get_text(GTK_ENTRY(textentry1)))) {
		strncat(stuff, " ", 1023);
		strncat(stuff, (gchar *) gtk_entry_get_text(GTK_ENTRY(textentry1)), 1023);
	}
	strncat(stuff, ">", 1023);

	if (data == NULL) {
		insert_text(stuff, cap("</TD>"));
	} else {
		replace_text(stuff, ((Treplacerange *) data)->pos, ((Treplacerange *) data)->len);
		g_free(data);
	}

	g_free(tempstr);
	destroy_dialog();
}
