/* Bluefish HTML Editor
 * html.c - menu/toolbar callbacks, inserting functions, and other cool stuff 
 *
 * Copyright (C) 
 * 1998 Olivier Sessink and Chris Mazuc
 * 1999-2000 Olivier Sessink
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "default_include.h"

#include <string.h>
#include <locale.h>

#include "cap.h"
#include "bluefish.h"
#include "html.h"
#include "init.h"
#include "gtk_easy.h"
/* #include "undo.h" */
#include "document.h"
#include "stringlist.h"

/*****************************************************************************/
/* function declarations */
void formdialog_cb(GtkWidget * widget, gpointer data);
void submitdialog_cb(GtkWidget * widget, gpointer data);
void resetdialog_cb(GtkWidget * widget, gpointer data);
void textareadialog_cb(GtkWidget * widget, gpointer data);
void hiddendialog_cb(GtkWidget * widget, gpointer data);
void textdialog_cb(GtkWidget * widget, gpointer data);
void radiodialog_cb(GtkWidget * widget, gpointer data);
void checkdialog_cb(GtkWidget * widget, gpointer data);
void selectdialog_cb(GtkWidget * widget, gpointer data);
void formok(GtkWidget * widget, gpointer data);
void submitok(GtkWidget * widget, gpointer data);
void resetok(GtkWidget * widget, gpointer data);
void textok(GtkWidget * widget, gpointer data);
void hiddenok(GtkWidget * widget, gpointer data);
void textareaok(GtkWidget * widget, gpointer data);
void selectok(GtkWidget * widget, gpointer data);
void radiook(GtkWidget * widget, gpointer data);
void checkok(GtkWidget * widget, gpointer data);


/************************************************************************/
void formdialog_cb(GtkWidget * widget, gpointer data)
{
	GList *methodlist = NULL;
	GList *enctypelist = NULL;

	static gchar *tagitems[] = { "action", "method", "enctype", "target", NULL };
	gchar *tagvalues[5];
	gchar *custom = NULL;
	Treplacerange *replace_range = NULL;

	/* this is for the right click menu */
	if ((data != NULL) && (widget == NULL)) {
		replace_range = values_for_dialog(tagitems, tagvalues, &custom, (Ttagpopup *) data);
	} else {
		init_values_for_dialog(tagitems, tagvalues);
	}
	/* end for the right click menu */


	create_dialog(500, 123, _("Form"));
	dialogtable = gtk_table_new(4, 10, 0);
	gtk_box_pack_start(GTK_BOX(vbox), dialogtable, FALSE, FALSE, 0);

	textentry1 = entry_with_text(tagvalues[0], 256);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("Action")), 0, 1, 0, 1);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), textentry1, 1, 10, 0, 1);

	methodlist = g_list_append(methodlist, "GET");
	methodlist = g_list_append(methodlist, "POST");
	combo1 = combo_with_popdown(tagvalues[1], methodlist, 1);
	g_list_free(methodlist);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("Method")), 0, 1, 1, 2);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), GTK_WIDGET(GTK_COMBO(combo1)), 1, 2, 1, 2);

	/* I need to add more types */
	enctypelist = g_list_append(enctypelist, "application/x-www-form-urlencoded");
	enctypelist = g_list_append(enctypelist, "multipart/form-data");
	enctypelist = g_list_append(enctypelist, "text/plain");
	combo2 = combo_with_popdown(tagvalues[2], enctypelist, 1);
	g_list_free(enctypelist);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("Enctype")), 3, 4, 1, 2);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), GTK_WIDGET(combo2), 4, 10, 1, 2);

	combo3 = combo_with_popdown(tagvalues[3], main_v->current_project.targetlist, 1);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("Target")), 0, 1, 2, 3);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), GTK_WIDGET(GTK_COMBO(combo3)), 1, 10, 2, 3);

	textentry2 = entry_with_text(custom, 1024);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("Custom")), 0, 1, 3, 4);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), textentry2, 1, 12, 3, 4);
	create_buttons(GTK_SIGNAL_FUNC(formok), (gpointer) replace_range);
	if (custom)
		g_free(custom);
}

/************************************************************************/
void submitdialog_cb(GtkWidget * widget, gpointer data)
{
	create_dialog(300, 100, _("Submit"));
	dialogtable = gtk_table_new(1, 10, 0);
	gtk_box_pack_start(GTK_BOX(vbox), dialogtable, FALSE, FALSE, 0);

	label = gtk_label_new(_("Name"));
	textentry1 = gtk_entry_new_with_max_length(256);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), label, 0, 1, 0, 1);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), textentry1, 1, 10, 0, 1);
	label = gtk_label_new(_("Value"));
	textentry2 = gtk_entry_new_with_max_length(256);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), label, 0, 1, 1, 2);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), textentry2, 1, 10, 1, 2);

	create_buttons(GTK_SIGNAL_FUNC(submitok), NULL);
}

/************************************************************************/
void resetdialog_cb(GtkWidget * widget, gpointer data)
{
	create_dialog(300, 100, _("Reset"));
	dialogtable = gtk_table_new(1, 10, 0);
	gtk_box_pack_start(GTK_BOX(vbox), dialogtable, FALSE, FALSE, 0);


	label = gtk_label_new(_("Name"));
	textentry1 = gtk_entry_new_with_max_length(256);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), label, 0, 1, 0, 1);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), textentry1, 1, 10, 0, 1);
	label = gtk_label_new(_("Value"));
	textentry2 = gtk_entry_new_with_max_length(256);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), label, 0, 1, 1, 2);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), textentry2, 1, 10, 1, 2);

	create_buttons(GTK_SIGNAL_FUNC(resetok), NULL);
}

/************************************************************************/
void textareadialog_cb(GtkWidget * widget, gpointer data)
{
	static gchar *tagitems[] = { "name", "value", "rows", "cols", NULL };
	gchar *tagvalues[5];
	gchar *custom = NULL;
	Treplacerange *replace_range = NULL;

	/* this is for the right click menu */
	if ((data != NULL) && (widget == NULL)) {
		replace_range = values_for_dialog(tagitems, tagvalues, &custom, (Ttagpopup *) data);
	} else {
		init_values_for_dialog(tagitems, tagvalues);
	}
	/* end for the right click menu */


	create_dialog(300, 145, _("Text area"));
	dialogtable = gtk_table_new(5, 10, 0);
	gtk_box_pack_start(GTK_BOX(vbox), dialogtable, FALSE, FALSE, 0);

	textentry1 = entry_with_text(tagvalues[0], 256);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("Name")), 0, 1, 0, 1);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), textentry1, 1, 10, 0, 1);

	textentry2 = entry_with_text(tagvalues[1], 256);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("Value")), 0, 1, 1, 2);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), textentry2, 1, 10, 1, 2);

	adj = (GtkAdjustment *) gtk_adjustment_new((gfloat) 1, 0.0, 500.0, 1.0, 5.0, 0.0);
	spin1 = gtk_spin_button_new(adj, 1, 0);
	gtk_spin_button_set_numeric(GTK_SPIN_BUTTON(spin1), 1);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), spin1, 1, 2, 2, 3);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("Rows")), 0, 1, 2, 3);
	parse_integer_for_dialog(tagvalues[2], spin1, NULL, NULL);

	adj = (GtkAdjustment *) gtk_adjustment_new((gfloat) 1, 0.0, 500.0, 1.0, 5.0, 0.0);
	spin2 = gtk_spin_button_new(adj, 1, 0);
	gtk_spin_button_set_numeric(GTK_SPIN_BUTTON(spin2), 1);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), spin2, 1, 2, 3, 4);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("Cols")), 0, 1, 3, 4);
	parse_integer_for_dialog(tagvalues[3], spin2, NULL, NULL);

	textentry3 = entry_with_text(custom, 1024);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("Custom")), 0, 1, 4, 5);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), textentry3, 1, 10, 4, 5);
	create_buttons(GTK_SIGNAL_FUNC(textareaok), replace_range);
	if (custom)
		g_free(custom);
}

/************************************************************************/
void hiddendialog_cb(GtkWidget * widget, gpointer data)
{
	static gchar *tagitems[] = { "name", "value", "type", NULL };
	gchar *tagvalues[4];
	gchar *custom = NULL;
	Treplacerange *replace_range = NULL;

	/* this is for the right click menu */
	if ((data != NULL) && (widget == NULL)) {
		replace_range = values_for_dialog(tagitems, tagvalues, &custom, (Ttagpopup *) data);
	} else {
		init_values_for_dialog(tagitems, tagvalues);
	}
	/* end for the right click menu */


	create_dialog(300, 100, _("Hidden"));
	dialogtable = gtk_table_new(3, 10, 0);
	gtk_box_pack_start(GTK_BOX(vbox), dialogtable, FALSE, FALSE, 0);

	textentry1 = entry_with_text(tagvalues[0], 256);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("Name")), 0, 1, 0, 1);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), textentry1, 1, 10, 0, 1);

	textentry2 = entry_with_text(tagvalues[1], 256);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("Value")), 0, 1, 1, 2);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), textentry2, 1, 10, 1, 2);

	textentry3 = entry_with_text(custom, 1024);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("Custom")), 0, 1, 2, 3);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), textentry3, 1, 10, 2, 3);
	create_buttons(GTK_SIGNAL_FUNC(hiddenok), replace_range);
	if (custom)
		g_free(custom);
}

/************************************************************************/
void textdialog_cb(GtkWidget * widget, gpointer data)
{
	static gchar *tagitems[] = { "name", "value", "size", "maxlength", "type", NULL };
	gchar *tagvalues[6];
	gchar *custom = NULL;
	Treplacerange *replace_range = NULL;

	/* this is for the right click menu */
	if ((data != NULL) && (widget == NULL)) {
		replace_range = values_for_dialog(tagitems, tagvalues, &custom, (Ttagpopup *) data);
	} else {
		init_values_for_dialog(tagitems, tagvalues);
	}
	/* end for the right click menu */


	create_dialog(300, 145, _("Text"));
	dialogtable = gtk_table_new(4, 10, 0);
	gtk_box_pack_start(GTK_BOX(vbox), dialogtable, FALSE, FALSE, 0);

	textentry1 = entry_with_text(tagvalues[0], 256);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("Name")), 0, 1, 0, 1);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), textentry1, 1, 10, 0, 1);

	textentry2 = entry_with_text(tagvalues[1], 256);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("Value")), 0, 1, 1, 2);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), textentry2, 1, 10, 1, 2);

	adj = (GtkAdjustment *) gtk_adjustment_new((gfloat) 1, 0.0, 500.0, 1.0, 5.0, 0.0);
	spin1 = gtk_spin_button_new(adj, 1, 0);
	gtk_spin_button_set_numeric(GTK_SPIN_BUTTON(spin1), 1);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), spin1, 1, 2, 2, 3);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("Size")), 0, 1, 2, 3);
	parse_integer_for_dialog(tagvalues[2], spin1, NULL, NULL);

	adj = (GtkAdjustment *) gtk_adjustment_new((gfloat) 1, 0.0, 500.0, 1.0, 5.0, 0.0);
	spin2 = gtk_spin_button_new(adj, 1, 0);
	gtk_spin_button_set_numeric(GTK_SPIN_BUTTON(spin2), 1);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), spin2, 1, 2, 3, 4);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("Max Length")), 0, 1, 3, 4);
	parse_integer_for_dialog(tagvalues[3], spin2, NULL, NULL);

	textentry3 = entry_with_text(custom, 1024);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("Custom")), 0, 1, 4, 5);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), textentry3, 1, 10, 4, 5);
	create_buttons(GTK_SIGNAL_FUNC(textok), replace_range);
	if (custom)
		g_free(custom);

}

/************************************************************************/
void radiodialog_cb(GtkWidget * widget, gpointer data)
{
	static gchar *tagitems[] = { "name", "value", "checked", "type", NULL };
	gchar *tagvalues[5];
	gchar *custom = NULL;
	Treplacerange *replace_range = NULL;

	/* this is for the right click menu */
	if ((data != NULL) && (widget == NULL)) {
		replace_range = values_for_dialog(tagitems, tagvalues, &custom, (Ttagpopup *) data);
	} else {
		init_values_for_dialog(tagitems, tagvalues);
	}
	/* end for the right click menu */


	create_dialog(300, 117, _("Radio Button"));
	dialogtable = gtk_table_new(4, 10, 0);
	gtk_box_pack_start(GTK_BOX(vbox), dialogtable, FALSE, FALSE, 0);

	textentry1 = entry_with_text(tagvalues[0], 256);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("Name")), 0, 1, 0, 1);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), textentry1, 1, 10, 0, 1);

	textentry2 = entry_with_text(tagvalues[1], 256);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("Value")), 0, 1, 1, 2);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), textentry2, 1, 10, 1, 2);

	checkbox1 = gtk_check_button_new();
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), checkbox1, 1, 2, 2, 3);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("Checked")), 0, 1, 2, 3);
	parse_existence_for_dialog(tagvalues[2], checkbox1);

	textentry3 = entry_with_text(custom, 1024);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("Custom")), 0, 1, 3, 4);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), textentry3, 1, 10, 3, 4);
	create_buttons(GTK_SIGNAL_FUNC(radiook), replace_range);
	if (custom)
		g_free(custom);


}

/************************************************************************/
void checkdialog_cb(GtkWidget * widget, gpointer data)
{
	static gchar *tagitems[] = { "name", "value", "checked", "type", NULL };
	gchar *tagvalues[5];
	gchar *custom = NULL;
	Treplacerange *replace_range = NULL;

	/* this is for the right click menu */
	if ((data != NULL) && (widget == NULL)) {
		replace_range = values_for_dialog(tagitems, tagvalues, &custom, (Ttagpopup *) data);
	} else {
		init_values_for_dialog(tagitems, tagvalues);
	}
	/* end for the right click menu */


	create_dialog(300, 117, _("Check Box"));
	dialogtable = gtk_table_new(4, 10, 0);
	gtk_box_pack_start(GTK_BOX(vbox), dialogtable, FALSE, FALSE, 0);

	textentry1 = entry_with_text(tagvalues[0], 256);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("Name")), 0, 1, 0, 1);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), textentry1, 1, 10, 0, 1);

	textentry2 = entry_with_text(tagvalues[1], 256);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("Value")), 0, 1, 1, 2);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), textentry2, 1, 10, 1, 2);

	checkbox1 = gtk_check_button_new();
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), checkbox1, 1, 2, 2, 3);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("Checked")), 0, 1, 2, 3);
	parse_existence_for_dialog(tagvalues[2], checkbox1);

	textentry3 = entry_with_text(custom, 1024);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("Custom")), 0, 1, 3, 4);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), textentry3, 1, 10, 3, 4);
	create_buttons(GTK_SIGNAL_FUNC(checkok), replace_range);
	if (custom)
		g_free(custom);

}

/************************************************************************/
void selectdialog_cb(GtkWidget * widget, gpointer data)
{
	static gchar *tagitems[] = { "name", "size", "multiple", NULL };
	gchar *tagvalues[4];
	gchar *custom = NULL;
	Treplacerange *replace_range = NULL;

	/* this is for the right click menu */
	if ((data != NULL) && (widget == NULL)) {
		replace_range = values_for_dialog(tagitems, tagvalues, &custom, (Ttagpopup *) data);
	} else {
		init_values_for_dialog(tagitems, tagvalues);
	}
	/* end for the right click menu */


	create_dialog(300, 123, _("Select"));
	dialogtable = gtk_table_new(4, 10, 0);
	gtk_box_pack_start(GTK_BOX(vbox), dialogtable, FALSE, FALSE, 0);

	textentry1 = entry_with_text(tagvalues[0], 256);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("Name")), 0, 1, 0, 1);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), textentry1, 1, 10, 0, 1);

	adj = (GtkAdjustment *) gtk_adjustment_new((gfloat) 1, 0.0, 100.0, 1.0, 5.0, 0.0);
	spin1 = gtk_spin_button_new(adj, 1, 0);
	gtk_spin_button_set_numeric(GTK_SPIN_BUTTON(spin1), 1);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), spin1, 1, 2, 1, 2);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("Size")), 0, 1, 1, 2);
	parse_integer_for_dialog(tagvalues[1], spin1, NULL, NULL);

	checkbox1 = gtk_check_button_new();
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), checkbox1, 1, 2, 2, 3);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("Multiple selections")), 0, 1, 2, 3);
	parse_existence_for_dialog(tagvalues[2], checkbox1);

	textentry2 = entry_with_text(custom, 1024);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("Custom")), 0, 1, 3, 4);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), textentry2, 1, 10, 3, 4);
	create_buttons(GTK_SIGNAL_FUNC(selectok), replace_range);
	if (custom)
		g_free(custom);

}

/************************************************************************/
void formok(GtkWidget * widget, gpointer data)
{
	stuff = g_malloc(1024);

	strncpy(stuff, cap("<FORM"), 1023);

	if (strlen(gtk_entry_get_text(GTK_ENTRY(textentry1)))) {
		strncat(strncat(strncat(stuff, cap(" ACTION=\""), 1023), gtk_entry_get_text(GTK_ENTRY(textentry1)), 1023), "\"", 1023);
	}
	if (strlen(gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(combo1)->entry)))) {
		strncat(strncat(strncat(stuff, cap(" METHOD=\""), 1023), gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(combo1)->entry)), 1023), "\"",
				1023);
	}
	if (strlen(gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(combo2)->entry)))) {
		strncat(strncat(strncat(stuff, cap(" ENCTYPE=\""), 1023), gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(combo2)->entry)), 1023), "\"",
				1023);
	}
	if (strlen(gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(combo3)->entry)))) {
		strncat(strncat(strncat(stuff, cap(" TARGET=\""), 1023), gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(combo3)->entry)), 1023), "\"",
				1023);
		main_v->current_project.targetlist =
			add_to_stringlist(main_v->current_project.targetlist, gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(combo3)->entry)));
	}
	if (strlen((gchar *) gtk_entry_get_text(GTK_ENTRY(textentry2)))) {
		strncat(stuff, " ", 1023);
		strncat(stuff, (gchar *) gtk_entry_get_text(GTK_ENTRY(textentry2)), 1023);
	}
	strncat(stuff, ">", 1023);


	if (data == NULL) {
		insert_text(stuff, cap("</FORM>"));
	} else {
		replace_text(stuff, ((Treplacerange *) data)->pos, ((Treplacerange *) data)->len);
		g_free(data);
	}

	destroy_dialog();
}

/************************************************************************/
void submitok(GtkWidget * widget, gpointer data)
{
	stuff = g_malloc(1024);

	strncpy(stuff, cap("<INPUT TYPE=\"SUBMIT\""), 1023);

	if (strlen(gtk_entry_get_text(GTK_ENTRY(textentry1)))) {
		strncat(strncat(strncat(stuff, cap(" NAME=\""), 1023), gtk_entry_get_text(GTK_ENTRY(textentry1)), 1023), "\"", 1023);
	}
	if (strlen(gtk_entry_get_text(GTK_ENTRY(textentry2)))) {
		strncat(strncat(strncat(stuff, cap(" VALUE=\""), 1023), gtk_entry_get_text(GTK_ENTRY(textentry2)), 1023), "\"", 1023);
	}
	strncat(stuff, ">", 1023);
	insert_text(stuff, "");

	destroy_dialog();
}

/************************************************************************/
void resetok(GtkWidget * widget, gpointer data)
{
	stuff = g_malloc(1024);

	strncpy(stuff, cap("<INPUT TYPE=\"RESET\""), 1023);

	if (strlen(gtk_entry_get_text(GTK_ENTRY(textentry1)))) {
		strncat(strncat(strncat(stuff, cap(" NAME=\""), 1023), gtk_entry_get_text(GTK_ENTRY(textentry1)), 1023), "\"", 1023);
	}
	if (strlen(gtk_entry_get_text(GTK_ENTRY(textentry2)))) {
		strncat(strncat(strncat(stuff, cap(" VALUE=\""), 1023), gtk_entry_get_text(GTK_ENTRY(textentry2)), 1023), "\"", 1023);
	}
	strncat(stuff, ">", 1023);
	insert_text(stuff, "");

	destroy_dialog();
}

/************************************************************************/
void textok(GtkWidget * widget, gpointer data)
{
	gchar *tempstr;
	gint temp;
	stuff = g_malloc(1024);
	tempstr = g_malloc(1024);

	strncpy(stuff, cap("<INPUT TYPE=\"TEXT\""), 1023);

	if (strlen(gtk_entry_get_text(GTK_ENTRY(textentry1)))) {
		strncat(strncat(strncat(stuff, cap(" NAME=\""), 1023), gtk_entry_get_text(GTK_ENTRY(textentry1)), 1023), "\"", 1023);
	}
	if (strlen(gtk_entry_get_text(GTK_ENTRY(spin1)))) {
		temp = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(spin1));
		g_snprintf(tempstr, 1023, "%s%d\"", cap(" SIZE=\""), temp);
		strncat(stuff, tempstr, 1023);
	}
	if (strlen(gtk_entry_get_text(GTK_ENTRY(spin2)))) {
		temp = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(spin2));
		g_snprintf(tempstr, 1023, "%s%d\"", cap(" MAXLENGTH=\""), temp);
		strncat(stuff, tempstr, 1023);
	}
	if (strlen(gtk_entry_get_text(GTK_ENTRY(textentry2)))) {
		strncat(strncat(strncat(stuff, cap(" VALUE=\""), 1023), gtk_entry_get_text(GTK_ENTRY(textentry2)), 1023), "\"", 1023);
	}
	if (strlen((gchar *) gtk_entry_get_text(GTK_ENTRY(textentry3)))) {
		strncat(stuff, " ", 1023);
		strncat(stuff, (gchar *) gtk_entry_get_text(GTK_ENTRY(textentry3)), 1023);
	}
	strncat(stuff, ">", 1023);

	if (data == NULL) {
		insert_text(stuff, "");
	} else {
		replace_text(stuff, ((Treplacerange *) data)->pos, ((Treplacerange *) data)->len);
		g_free(data);
	}

	g_free(tempstr);
	destroy_dialog();
}

/************************************************************************/
void hiddenok(GtkWidget * widget, gpointer data)
{
	stuff = g_malloc(1024);

	strncpy(stuff, cap("<INPUT TYPE=\"HIDDEN\""), 1023);

	if (strlen(gtk_entry_get_text(GTK_ENTRY(textentry1)))) {
		strncat(strncat(strncat(stuff, cap(" NAME=\""), 1023), gtk_entry_get_text(GTK_ENTRY(textentry1)), 1023), "\"", 1023);
	}
	if (strlen(gtk_entry_get_text(GTK_ENTRY(textentry2)))) {
		strncat(strncat(strncat(stuff, cap(" VALUE=\""), 1023), gtk_entry_get_text(GTK_ENTRY(textentry2)), 1023), "\"", 1023);
	}
	if (strlen((gchar *) gtk_entry_get_text(GTK_ENTRY(textentry3)))) {
		strncat(stuff, " ", 1023);
		strncat(stuff, (gchar *) gtk_entry_get_text(GTK_ENTRY(textentry3)), 1023);
	}
	strncat(stuff, ">", 1023);

	if (data == NULL) {
		insert_text(stuff, "");
	} else {
		replace_text(stuff, ((Treplacerange *) data)->pos, ((Treplacerange *) data)->len);
		g_free(data);
	}
	destroy_dialog();
}

/************************************************************************/
void textareaok(GtkWidget * widget, gpointer data)
{
	gchar *tempstr;
	gint temp;
	stuff = g_malloc(1024);
	tempstr = g_malloc(1024);

	strncpy(stuff, cap("<TEXTAREA"), 1023);

	if (strlen(gtk_entry_get_text(GTK_ENTRY(textentry1)))) {
		strncat(strncat(strncat(stuff, cap(" NAME=\""), 1023), gtk_entry_get_text(GTK_ENTRY(textentry1)), 1023), "\"", 1023);
	}
	if (strlen(gtk_entry_get_text(GTK_ENTRY(spin1)))) {
		temp = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(spin1));
		g_snprintf(tempstr, 1023, "%s%d\"", cap(" ROWS=\""), temp);
		strncat(stuff, tempstr, 1023);
	}
	if (strlen(gtk_entry_get_text(GTK_ENTRY(spin2)))) {
		temp = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(spin2));
		g_snprintf(tempstr, 1023, "%s%d\"", cap(" COLS=\""), temp);
		strncat(stuff, tempstr, 1023);
	}
	if (strlen((gchar *) gtk_entry_get_text(GTK_ENTRY(textentry3)))) {
		strncat(stuff, " ", 1023);
		strncat(stuff, (gchar *) gtk_entry_get_text(GTK_ENTRY(textentry3)), 1023);
	}
	strncat(stuff, ">", 1023);

	if (strlen(gtk_entry_get_text(GTK_ENTRY(textentry2)))) {
		strncat(stuff, gtk_entry_get_text(GTK_ENTRY(textentry2)), 1023);
	}

	if (data == NULL) {
		insert_text(stuff, cap("</TEXTAREA>"));
	} else {
		replace_text(stuff, ((Treplacerange *) data)->pos, ((Treplacerange *) data)->len);
		g_free(data);
	}

	g_free(tempstr);
	destroy_dialog();
}

/************************************************************************/
void selectok(GtkWidget * widget, gpointer data)
{
	stuff = g_malloc(1024);

	strncpy(stuff, cap("<SELECT"), 1023);

	if (strlen(gtk_entry_get_text(GTK_ENTRY(textentry1)))) {
		strncat(strncat(strncat(stuff, cap(" NAME=\""), 1023), gtk_entry_get_text(GTK_ENTRY(textentry1)), 1023), "\"", 1023);
	}
	if (strlen(gtk_entry_get_text(GTK_ENTRY(spin1)))) {
		strncat(strncat(strncat(stuff, cap(" SIZE=\""), 1023), gtk_entry_get_text(GTK_ENTRY(spin1)), 1023), "\"", 1023);
	}
	if (GTK_TOGGLE_BUTTON(checkbox1)->active) {
		strncat(stuff, cap(" MULTIPLE"), 1023);
	}
	if (strlen((gchar *) gtk_entry_get_text(GTK_ENTRY(textentry2)))) {
		strncat(stuff, " ", 1023);
		strncat(stuff, (gchar *) gtk_entry_get_text(GTK_ENTRY(textentry2)), 1023);
	}
	strncat(stuff, ">", 1023);

	if (data == NULL) {
		insert_text(stuff, cap("\n</SELECT>"));
	} else {
		replace_text(stuff, ((Treplacerange *) data)->pos, ((Treplacerange *) data)->len);
		g_free(data);
	}

	destroy_dialog();
}

/************************************************************************/
void radiook(GtkWidget * widget, gpointer data)
{
	stuff = g_malloc(1024);

	strncpy(stuff, cap("<INPUT TYPE=\"RADIO\""), 1023);

	if (strlen(gtk_entry_get_text(GTK_ENTRY(textentry1)))) {
		strncat(strncat(strncat(stuff, cap(" NAME=\""), 1023), gtk_entry_get_text(GTK_ENTRY(textentry1)), 1023), "\"", 1023);
	}
	if (strlen(gtk_entry_get_text(GTK_ENTRY(textentry2)))) {
		strncat(strncat(strncat(stuff, cap(" VALUE=\""), 1023), gtk_entry_get_text(GTK_ENTRY(textentry2)), 1023), "\"", 1023);
	}
	if (GTK_TOGGLE_BUTTON(checkbox1)->active) {
		strncat(stuff, cap(" CHECKED"), 1023);
	}
	if (strlen((gchar *) gtk_entry_get_text(GTK_ENTRY(textentry3)))) {
		strncat(stuff, " ", 1023);
		strncat(stuff, (gchar *) gtk_entry_get_text(GTK_ENTRY(textentry3)), 1023);
	}
	strncat(stuff, ">", 1023);

	if (data == NULL) {
		insert_text(stuff, "");
	} else {
		replace_text(stuff, ((Treplacerange *) data)->pos, ((Treplacerange *) data)->len);
		g_free(data);
	}

	destroy_dialog();
}

/************************************************************************/
void checkok(GtkWidget * widget, gpointer data)
{
	stuff = g_malloc(1024);

	strncpy(stuff, cap("<INPUT TYPE=\"CHECKBOX\""), 1023);

	if (strlen(gtk_entry_get_text(GTK_ENTRY(textentry1)))) {
		strncat(strncat(strncat(stuff, cap(" NAME=\""), 1023), gtk_entry_get_text(GTK_ENTRY(textentry1)), 1023), "\"", 1023);
	}
	if (strlen(gtk_entry_get_text(GTK_ENTRY(textentry2)))) {
		strncat(strncat(strncat(stuff, cap(" VALUE=\""), 1023), gtk_entry_get_text(GTK_ENTRY(textentry2)), 1023), "\"", 1023);
	}
	if (GTK_TOGGLE_BUTTON(checkbox1)->active) {
		strncat(stuff, cap(" CHECKED"), 1023);
	}
	if (strlen((gchar *) gtk_entry_get_text(GTK_ENTRY(textentry3)))) {
		strncat(stuff, " ", 1023);
		strncat(stuff, (gchar *) gtk_entry_get_text(GTK_ENTRY(textentry3)), 1023);
	}
	strncat(stuff, ">", 1023);

	if (data == NULL) {
		insert_text(stuff, "");
	} else {
		replace_text(stuff, ((Treplacerange *) data)->pos, ((Treplacerange *) data)->len);
		g_free(data);
	}

	destroy_dialog();
}
