/* Bluefish HTML Editor
 * html2.c - menu/toolbar callbacks, inserting functions, and other cool stuff 
 * otherwise html.c is getting so long ;-)
 *
 * Copyright (C) 1999 Olivier Sessink
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#include "default_include.h"

#include <locale.h>

#include "gtk_easy.h"
#include "bluefish.h"
#include "stringlist.h"
#include "document.h"
#include "html.h"
#include "cap.h"


GList *garbage = NULL;

typedef struct {
	GtkWidget *table;
	GtkWidget *dialog;
	GtkWidget *label;
	GtkWidget *combo[54];
	GtkWidget *spin[2];
	GtkWidget *entry[4];
	GtkWidget *check[6];
	GtkWidget *radio[10];
	GtkWidget *okbutton;
	GtkWidget *cancelbutton;
	gint abort;
	gchar *tmpstring;
} Thtml2dialog;

void html2_dialog_cancel(GtkWidget * widget, Thtml2dialog * data);
void html2_dialog_ok(GtkWidget * widget, Thtml2dialog * data);
Thtml2dialog *startdialog(gchar * title, gint rows, gint cols);
void middle_dialog(Thtml2dialog * this_ds, gint leftbuts, gint middlebuts, gint rightbuts, gint topbuts, gint botbuts);

void html2_dialog_cancel(GtkWidget * widget, Thtml2dialog * data)
{
	gtk_signal_handlers_destroy(GTK_OBJECT(data->dialog));
	gtk_main_quit();
	DEBUG_MSG("html2_dialog_cancel, gtk_main_quit() called\n");
}

void html2_dialog_ok(GtkWidget * widget, Thtml2dialog * data)
{
	data->abort = 0;
	DEBUG_MSG("html2_dialog_ok, abort=%d, calling cancel to stop this gtk_main()\n", data->abort);
	html2_dialog_cancel(widget, data);
}

Thtml2dialog *startdialog(gchar * title, gint rows, gint cols)
{

	Thtml2dialog *return_ds;
	return_ds = g_malloc(sizeof(Thtml2dialog));

	return_ds->abort = 1;
	return_ds->dialog = gtk_window_new(GTK_WINDOW_DIALOG);
	gtk_container_border_width(GTK_CONTAINER(return_ds->dialog), 10);
	/*gtk_signal_connect (GTK_OBJECT (return_ds->dialog), "delete_event", GTK_SIGNAL_FUNC
	   (html2_dialog_cancel), return_ds); */
	gtk_signal_connect(GTK_OBJECT(return_ds->dialog), "destroy", GTK_SIGNAL_FUNC(html2_dialog_cancel), return_ds);
	gtk_window_set_title(GTK_WINDOW(return_ds->dialog), title);
	gtk_window_position(GTK_WINDOW(return_ds->dialog), GTK_WIN_POS_CENTER);

	return_ds->table = gtk_table_new(rows, cols, 0);
	gtk_container_add(GTK_CONTAINER(return_ds->dialog), return_ds->table);
	return return_ds;
}

void middle_dialog(Thtml2dialog * this_ds, gint leftbuts, gint middlebuts, gint rightbuts, gint topbuts, gint botbuts)
{
	this_ds->okbutton = bf_stock_ok_button(GTK_SIGNAL_FUNC(html2_dialog_ok), this_ds);
	this_ds->cancelbutton = bf_stock_cancel_button(GTK_SIGNAL_FUNC(html2_dialog_cancel), this_ds);

	GTK_WIDGET_SET_FLAGS(this_ds->okbutton, GTK_CAN_DEFAULT);
	GTK_WIDGET_SET_FLAGS(this_ds->cancelbutton, GTK_CAN_DEFAULT);
	gtk_table_attach_defaults(GTK_TABLE(this_ds->table), this_ds->okbutton, leftbuts, middlebuts, topbuts, botbuts);
	gtk_table_attach_defaults(GTK_TABLE(this_ds->table), this_ds->cancelbutton, middlebuts, rightbuts, topbuts, botbuts);

	gtk_widget_show_all(this_ds->dialog);
	gtk_widget_realize(this_ds->dialog);
	gtk_window_set_default(GTK_WINDOW(this_ds->dialog), this_ds->okbutton);
	gtk_grab_add(this_ds->dialog);
	DEBUG_MSG("middle_dialog, about to call gtk_main()\n");
	gtk_main();
	DEBUG_MSG("middle_dialog, this gtk_main() is finished\n");
}


gchar *insert_if_string(gchar * formatstring, GtkWidget * entry, gchar * return_if_empty)
{
	gchar *string2return;

	if (strlen(gtk_entry_get_text(GTK_ENTRY(entry))) > 1) {
		string2return = g_strdup_printf(formatstring, gtk_entry_get_text(GTK_ENTRY(entry)));
		garbage = g_list_append(garbage, string2return);
	} else {
		if (return_if_empty == NULL) {
			string2return = g_strdup("");
			garbage = g_list_append(garbage, string2return);
		} else {
			string2return = return_if_empty;
		}
	}
	DEBUG_MSG("insert_if_string, garbage=%p, lenght=%d\n", garbage, g_list_length(garbage));
	DEBUG_MSG("insert_if_string, finished, string2return=%p\n", string2return);
	return string2return;
}

GList *make_length_list(gfloat from, gfloat to, gint allow_percentage, gint high_percentage)
{

	GList *list2return;

	list2return = g_list_append(NULL, "");

	if ((from < 0.1) && (to > 0.3)) {
		list2return = g_list_append(list2return, "0.1em");
		list2return = g_list_append(list2return, "0.2em");
		list2return = g_list_append(list2return, "0.3em");
		list2return = g_list_append(list2return, "0.5em");
		list2return = g_list_append(list2return, "0.1ex");
		list2return = g_list_append(list2return, "0.2ex");
		list2return = g_list_append(list2return, "0.3ex");
		list2return = g_list_append(list2return, "0.5ex");
		list2return = g_list_append(list2return, "1pt");
		list2return = g_list_append(list2return, "2pt");
		list2return = g_list_append(list2return, "4pt");
		list2return = g_list_append(list2return, "6pt");
	}
	if ((from < 0.5) && (to > 3)) {
		list2return = g_list_append(list2return, "0.7em");
		list2return = g_list_append(list2return, "1em");
		list2return = g_list_append(list2return, "2em");
		list2return = g_list_append(list2return, "3em");
		list2return = g_list_append(list2return, "0.7ex");
		list2return = g_list_append(list2return, "1ex");
		list2return = g_list_append(list2return, "2ex");
		list2return = g_list_append(list2return, "3ex");
		list2return = g_list_append(list2return, "7pt");
		list2return = g_list_append(list2return, "10pt");
		list2return = g_list_append(list2return, "12pt");
		list2return = g_list_append(list2return, "15pt");
	}
	if ((from < 3) && (to > 15)) {
		list2return = g_list_append(list2return, "6em");
		list2return = g_list_append(list2return, "9em");
		list2return = g_list_append(list2return, "12em");
		list2return = g_list_append(list2return, "15em");
		list2return = g_list_append(list2return, "6ex");
		list2return = g_list_append(list2return, "9ex");
		list2return = g_list_append(list2return, "12ex");
		list2return = g_list_append(list2return, "15ex");
		list2return = g_list_append(list2return, "20pt");
		list2return = g_list_append(list2return, "25pt");
		list2return = g_list_append(list2return, "30pt");
		list2return = g_list_append(list2return, "50pt");
	}
	if (allow_percentage == 1) {
		list2return = g_list_append(list2return, "10%");
		list2return = g_list_append(list2return, "20%");
		list2return = g_list_append(list2return, "30%");
		list2return = g_list_append(list2return, "40%");
		list2return = g_list_append(list2return, "50%");
		list2return = g_list_append(list2return, "60%");
		list2return = g_list_append(list2return, "70%");
		list2return = g_list_append(list2return, "80%");
		list2return = g_list_append(list2return, "90%");
		list2return = g_list_append(list2return, "100%");
	}
	if (high_percentage == 1) {
		list2return = g_list_append(list2return, "110%");
		list2return = g_list_append(list2return, "120%");
		list2return = g_list_append(list2return, "130%");
		list2return = g_list_append(list2return, "140%");
		list2return = g_list_append(list2return, "160%");
		list2return = g_list_append(list2return, "180%");
		list2return = g_list_append(list2return, "200%");
		list2return = g_list_append(list2return, "250%");
		list2return = g_list_append(list2return, "300%");
		list2return = g_list_append(list2return, "500%");
	}
	return list2return;
}



/* the actual functions dialogs */


void insert_class(GtkWidget * widget, gpointer data)
{

	Thtml2dialog *ds;

	ds = startdialog(_("Insert class"), 3, 4);

	gtk_table_attach_defaults(GTK_TABLE(ds->table), gtk_label_new(_("Insert class")), 1, 3, 0, 1);
	gtk_table_attach_defaults(GTK_TABLE(ds->table), gtk_label_new(_("CLASS=")), 0, 1, 1, 2);

	ds->combo[1] = combo_with_popdown(NULL, main_v->current_project.classlist, 1);
	gtk_table_attach_defaults(GTK_TABLE(ds->table), ds->combo[1], 1, 4, 1, 2);

	middle_dialog(ds, 0, 2, 4, 2, 3);

	if (ds->abort != 1) {
		ds->tmpstring = g_strdup_printf(cap(" CLASS=\"%s\" "), gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(ds->combo[1])->entry)));
		main_v->current_project.classlist =
			add_to_stringlist(main_v->current_project.classlist, gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(ds->combo[1])->entry)));
		insert_text(ds->tmpstring, "");
		g_free(ds->tmpstring);
	}

	if (GTK_IS_WIDGET(ds->dialog))
		gtk_widget_destroy(ds->dialog);
	g_free(ds);
}

void insert_div(GtkWidget * widget, gpointer data)
{

	Thtml2dialog *ds;

	ds = startdialog(_("DIV"), 3, 4);
	gtk_table_attach_defaults(GTK_TABLE(ds->table), gtk_label_new(_("DIV")), 1, 3, 0, 1);
	gtk_table_attach_defaults(GTK_TABLE(ds->table), gtk_label_new(_("class ")), 0, 1, 1, 2);
	ds->combo[1] = gtk_combo_new();
	if (main_v->current_project.classlist != NULL) {
		gtk_combo_set_popdown_strings(GTK_COMBO(ds->combo[1]), main_v->current_project.classlist);
	}
	gtk_table_attach_defaults(GTK_TABLE(ds->table), ds->combo[1], 1, 4, 1, 2);

	middle_dialog(ds, 0, 2, 4, 2, 3);

	if (ds->abort != 1) {
		ds->tmpstring = g_strdup_printf(cap("<DIV CLASS=\"%s\">"), gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(ds->combo[1])->entry)));
		insert_text(ds->tmpstring, cap("</DIV>"));
		main_v->current_project.classlist =
			add_to_stringlist(main_v->current_project.classlist, gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(ds->combo[1])->entry)));
		g_free(ds->tmpstring);
	}

	if (GTK_IS_WIDGET(ds->dialog))
		gtk_widget_destroy(ds->dialog);
	g_free(ds);
}

void insert_span(GtkWidget * widget, gpointer data)
{

	Thtml2dialog *ds;

	ds = startdialog(_("SPAN"), 3, 4);
	gtk_table_attach_defaults(GTK_TABLE(ds->table), gtk_label_new(_("SPAN")), 1, 3, 0, 1);
	gtk_table_attach_defaults(GTK_TABLE(ds->table), gtk_label_new(_("class ")), 0, 1, 1, 2);
	ds->combo[1] = gtk_combo_new();
	if (main_v->current_project.classlist != NULL) {
		gtk_combo_set_popdown_strings(GTK_COMBO(ds->combo[1]), main_v->current_project.classlist);
	}
	gtk_table_attach_defaults(GTK_TABLE(ds->table), ds->combo[1], 1, 4, 1, 2);

	middle_dialog(ds, 0, 2, 4, 2, 3);

	if (ds->abort != 1) {
		ds->tmpstring = g_strdup_printf(cap("<SPAN CLASS=\"%s\">"), gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(ds->combo[1])->entry)));
		insert_text(ds->tmpstring, cap("</SPAN>"));
		main_v->current_project.classlist =
			add_to_stringlist(main_v->current_project.classlist, gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(ds->combo[1])->entry)));
		g_free(ds->tmpstring);
	}

	if (GTK_IS_WIDGET(ds->dialog))
		gtk_widget_destroy(ds->dialog);
	g_free(ds);
}

/* the complex CSS dialog */

void sizing_unit_font_cb(GtkWidget * widget, Thtml2dialog * data)
{
	GList *tmplist;

	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(data->radio[1]))) {
		tmplist = g_list_append(NULL, "");
		tmplist = g_list_append(tmplist, "xx-small");
		tmplist = g_list_append(tmplist, "x-small");
		tmplist = g_list_append(tmplist, "small");
		tmplist = g_list_append(tmplist, "medium");
		tmplist = g_list_append(tmplist, "large");
		tmplist = g_list_append(tmplist, "x-large");
		tmplist = g_list_append(tmplist, "xx-large");
		gtk_combo_set_popdown_strings(GTK_COMBO(data->combo[5]), tmplist);
		gtk_combo_set_popdown_strings(GTK_COMBO(data->combo[6]), tmplist);
		gtk_editable_set_editable(GTK_EDITABLE(GTK_ENTRY(GTK_COMBO(data->combo[5])->entry)), FALSE);
		gtk_editable_set_editable(GTK_EDITABLE(GTK_ENTRY(GTK_COMBO(data->combo[6])->entry)), FALSE);
		g_list_free(tmplist);
	} else if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(data->radio[2]))) {
		tmplist = g_list_append(NULL, "");
		tmplist = g_list_append(tmplist, "larger");
		tmplist = g_list_append(tmplist, "smaller");
		gtk_combo_set_popdown_strings(GTK_COMBO(data->combo[5]), tmplist);
		gtk_combo_set_popdown_strings(GTK_COMBO(data->combo[6]), tmplist);
		gtk_editable_set_editable(GTK_EDITABLE(GTK_ENTRY(GTK_COMBO(data->combo[5])->entry)), FALSE);
		gtk_editable_set_editable(GTK_EDITABLE(GTK_ENTRY(GTK_COMBO(data->combo[6])->entry)), FALSE);
		g_list_free(tmplist);
	} else {
		tmplist = make_length_list(2.9, 20, 1, 1);
		gtk_combo_set_popdown_strings(GTK_COMBO(data->combo[5]), tmplist);
		gtk_combo_set_popdown_strings(GTK_COMBO(data->combo[6]), tmplist);
		gtk_editable_set_editable(GTK_EDITABLE(GTK_ENTRY(GTK_COMBO(data->combo[5])->entry)), TRUE);
		gtk_editable_set_editable(GTK_EDITABLE(GTK_ENTRY(GTK_COMBO(data->combo[6])->entry)), TRUE);
		g_list_free(tmplist);
	}
}

void sizing_unit_bg_cb(GtkWidget * widget, Thtml2dialog * data)
{
	GList *tmplist;

	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(data->radio[4]))) {
		tmplist = make_length_list(0, 0, 1, 0);
		gtk_combo_set_popdown_strings(GTK_COMBO(data->combo[16]), tmplist);
		gtk_combo_set_popdown_strings(GTK_COMBO(data->combo[17]), tmplist);
		gtk_editable_set_editable(GTK_EDITABLE(GTK_ENTRY(GTK_COMBO(data->combo[16])->entry)), TRUE);
		gtk_editable_set_editable(GTK_EDITABLE(GTK_ENTRY(GTK_COMBO(data->combo[17])->entry)), TRUE);
		g_list_free(tmplist);
	} else if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(data->radio[5]))) {
		tmplist = g_list_append(NULL, "");
		tmplist = g_list_append(tmplist, "1cm");
		tmplist = g_list_append(tmplist, "2cm");
		gtk_combo_set_popdown_strings(GTK_COMBO(data->combo[16]), tmplist);
		gtk_combo_set_popdown_strings(GTK_COMBO(data->combo[17]), tmplist);
		gtk_editable_set_editable(GTK_EDITABLE(GTK_ENTRY(GTK_COMBO(data->combo[16])->entry)), TRUE);
		gtk_editable_set_editable(GTK_EDITABLE(GTK_ENTRY(GTK_COMBO(data->combo[17])->entry)), TRUE);
		g_list_free(tmplist);
	} else {
		tmplist = g_list_append(NULL, "");
		tmplist = g_list_append(tmplist, "top");
		tmplist = g_list_append(tmplist, "center");
		tmplist = g_list_append(tmplist, "bottom");
		gtk_combo_set_popdown_strings(GTK_COMBO(data->combo[16]), tmplist);
		g_list_free(tmplist);
		tmplist = g_list_append(NULL, "");
		tmplist = g_list_append(tmplist, "left");
		tmplist = g_list_append(tmplist, "center");
		tmplist = g_list_append(tmplist, "right");
		gtk_combo_set_popdown_strings(GTK_COMBO(data->combo[17]), tmplist);
		g_list_free(tmplist);
		gtk_editable_set_editable(GTK_EDITABLE(GTK_ENTRY(GTK_COMBO(data->combo[16])->entry)), FALSE);
		gtk_editable_set_editable(GTK_EDITABLE(GTK_ENTRY(GTK_COMBO(data->combo[17])->entry)), FALSE);
	}
}

void insert_in_stylesheet(GtkWidget * widget, gpointer data)
{

	Thtml2dialog *ds;
	GtkWidget *notebook, *table, *vbox, *frame, *file_but;
	GList *tmplist = NULL;
	GSList *group;
	gchar *fontstring, *bgncolorstring, *textstring, *margstring, *padstring, *sizeplacestring, *borderstring, *classistring;

	ds = startdialog(_("New style"), 6, 4);
	gtk_table_attach_defaults(GTK_TABLE(ds->table), gtk_label_new(_("Insert new style")), 1, 3, 0, 1);
	gtk_table_attach_defaults(GTK_TABLE(ds->table), gtk_label_new(_("tag")), 0, 1, 1, 2);
	gtk_table_attach_defaults(GTK_TABLE(ds->table), gtk_label_new(_("class")), 0, 1, 2, 3);
	gtk_table_attach_defaults(GTK_TABLE(ds->table), gtk_label_new(_("pseudo class")), 0, 1, 3, 4);

	tmplist = g_list_append(NULL, "");
	tmplist = g_list_append(tmplist, "a");
	tmplist = g_list_append(tmplist, "abbr");
	tmplist = g_list_append(tmplist, "acronym");
	tmplist = g_list_append(tmplist, "address");
	tmplist = g_list_append(tmplist, "applet");
	tmplist = g_list_append(tmplist, "area");
	tmplist = g_list_append(tmplist, "b");
	tmplist = g_list_append(tmplist, "bdo");
	tmplist = g_list_append(tmplist, "bockquote");
	tmplist = g_list_append(tmplist, "body");
	tmplist = g_list_append(tmplist, "br");
	tmplist = g_list_append(tmplist, "button");
	tmplist = g_list_append(tmplist, "caption");
	tmplist = g_list_append(tmplist, "cite");
	tmplist = g_list_append(tmplist, "code");
	tmplist = g_list_append(tmplist, "col");
	tmplist = g_list_append(tmplist, "colgroup");
	tmplist = g_list_append(tmplist, "dd");
	tmplist = g_list_append(tmplist, "del");
	tmplist = g_list_append(tmplist, "dfn");
	tmplist = g_list_append(tmplist, "div");
	tmplist = g_list_append(tmplist, "dl");
	tmplist = g_list_append(tmplist, "dt");
	tmplist = g_list_append(tmplist, "em");
	tmplist = g_list_append(tmplist, "embed");
	tmplist = g_list_append(tmplist, "fieldset");
	tmplist = g_list_append(tmplist, "form");
	tmplist = g_list_append(tmplist, "h1");
	tmplist = g_list_append(tmplist, "h2");
	tmplist = g_list_append(tmplist, "h3");
	tmplist = g_list_append(tmplist, "h4");
	tmplist = g_list_append(tmplist, "h5");
	tmplist = g_list_append(tmplist, "h6");
	tmplist = g_list_append(tmplist, "hr");
	tmplist = g_list_append(tmplist, "i");
	tmplist = g_list_append(tmplist, "iframe");
	tmplist = g_list_append(tmplist, "img");
	tmplist = g_list_append(tmplist, "input");
	tmplist = g_list_append(tmplist, "ins");
	tmplist = g_list_append(tmplist, "kbd");
	tmplist = g_list_append(tmplist, "label");
	tmplist = g_list_append(tmplist, "legend");
	tmplist = g_list_append(tmplist, "li");
	tmplist = g_list_append(tmplist, "map");
	tmplist = g_list_append(tmplist, "noframes");
	tmplist = g_list_append(tmplist, "noscript");
	tmplist = g_list_append(tmplist, "object");
	tmplist = g_list_append(tmplist, "ol");
	tmplist = g_list_append(tmplist, "optgroup");
	tmplist = g_list_append(tmplist, "option");
	tmplist = g_list_append(tmplist, "p");
	tmplist = g_list_append(tmplist, "pre");
	tmplist = g_list_append(tmplist, "q");
	tmplist = g_list_append(tmplist, "rb");
	tmplist = g_list_append(tmplist, "rp");
	tmplist = g_list_append(tmplist, "rt");
	tmplist = g_list_append(tmplist, "ruby");
	tmplist = g_list_append(tmplist, "s");
	tmplist = g_list_append(tmplist, "samp");
	tmplist = g_list_append(tmplist, "select");
	tmplist = g_list_append(tmplist, "small");
	tmplist = g_list_append(tmplist, "span");
	tmplist = g_list_append(tmplist, "strike");
	tmplist = g_list_append(tmplist, "strong");
	tmplist = g_list_append(tmplist, "sub");
	tmplist = g_list_append(tmplist, "sup");
	tmplist = g_list_append(tmplist, "table");
	tmplist = g_list_append(tmplist, "tbody");
	tmplist = g_list_append(tmplist, "td");
	tmplist = g_list_append(tmplist, "textarea");
	tmplist = g_list_append(tmplist, "tfoot");
	tmplist = g_list_append(tmplist, "th");
	tmplist = g_list_append(tmplist, "thead");
	tmplist = g_list_append(tmplist, "tr");
	tmplist = g_list_append(tmplist, "tt");
	tmplist = g_list_append(tmplist, "ul");
	tmplist = g_list_append(tmplist, "var");
	ds->combo[8] = combo_with_popdown(NULL, tmplist, 1);
	g_list_free(tmplist);
	gtk_table_attach_defaults(GTK_TABLE(ds->table), ds->combo[8], 1, 3, 1, 2);
	ds->combo[9] = combo_with_popdown(NULL, main_v->current_project.classlist, 1);
	gtk_table_attach_defaults(GTK_TABLE(ds->table), ds->combo[9], 1, 3, 2, 3);
	tmplist = g_list_append(NULL, "");
	tmplist = g_list_append(tmplist, "link");
	tmplist = g_list_append(tmplist, "visited");
	tmplist = g_list_append(tmplist, "active");
	tmplist = g_list_append(tmplist, "hover");
	tmplist = g_list_append(tmplist, "focus");
	tmplist = g_list_append(tmplist, "after");
	tmplist = g_list_append(tmplist, "before");
	tmplist = g_list_append(tmplist, "first-line");
	tmplist = g_list_append(tmplist, "first-letter");
	tmplist = g_list_append(tmplist, "first-child");
	ds->combo[10] = combo_with_popdown(NULL, tmplist, 1);
	g_list_free(tmplist);
	gtk_table_attach_defaults(GTK_TABLE(ds->table), ds->combo[10], 1, 3, 3, 4);

	notebook = gtk_notebook_new();
	gtk_notebook_set_tab_border(GTK_NOTEBOOK(notebook), 0);
	gtk_notebook_set_tab_pos(GTK_NOTEBOOK(notebook), GTK_POS_BOTTOM);
	gtk_table_attach_defaults(GTK_TABLE(ds->table), notebook, 0, 4, 4, 5);

	/* start on font tab */
	table = gtk_table_new(4, 9, 0);
	gtk_table_attach_defaults(GTK_TABLE(table), gtk_label_new(_("font- family")), 0, 1, 1, 2);
	gtk_table_attach_defaults(GTK_TABLE(table), gtk_label_new(_("font-style")), 0, 1, 2, 3);
	gtk_table_attach_defaults(GTK_TABLE(table), gtk_label_new(_("font-variant")), 0, 1, 3, 4);
	gtk_table_attach_defaults(GTK_TABLE(table), gtk_label_new(_("font-weight")), 0, 1, 4, 5);
	gtk_table_attach_defaults(GTK_TABLE(table), gtk_label_new(_("font-size")), 2, 3, 5, 6);
	gtk_table_attach_defaults(GTK_TABLE(table), gtk_label_new(_("line-height")), 2, 3, 7, 8);
	ds->check[1] = gtk_check_button_new_with_label(_("Insert as one line"));
	gtk_table_attach_defaults(GTK_TABLE(table), ds->check[1], 0, 4, 0, 1);

	ds->combo[1] = combo_with_popdown(NULL, main_v->current_project.fontlist, 1);
	gtk_table_attach_defaults(GTK_TABLE(table), ds->combo[1], 1, 4, 1, 2);

	tmplist = g_list_append(NULL, "");
	tmplist = g_list_append(tmplist, "normal");
	tmplist = g_list_append(tmplist, "italic");
	tmplist = g_list_append(tmplist, "oblique");
	ds->combo[2] = combo_with_popdown(NULL, tmplist, 0);
	g_list_free(tmplist);
	gtk_table_attach_defaults(GTK_TABLE(table), ds->combo[2], 1, 4, 2, 3);

	tmplist = g_list_append(NULL, "");
	tmplist = g_list_append(tmplist, "normal");
	tmplist = g_list_append(tmplist, "small-caps");
	ds->combo[3] = combo_with_popdown(NULL, tmplist, 0);
	g_list_free(tmplist);
	gtk_table_attach_defaults(GTK_TABLE(table), ds->combo[3], 1, 4, 3, 4);

	tmplist = g_list_append(NULL, "");
	tmplist = g_list_append(tmplist, "normal");
	tmplist = g_list_append(tmplist, "bold");
	tmplist = g_list_append(tmplist, "bolder");
	tmplist = g_list_append(tmplist, "lighter");
	tmplist = g_list_append(tmplist, "100");
	tmplist = g_list_append(tmplist, "200");
	tmplist = g_list_append(tmplist, "300");
	tmplist = g_list_append(tmplist, "400");
	tmplist = g_list_append(tmplist, "500");
	tmplist = g_list_append(tmplist, "600");
	tmplist = g_list_append(tmplist, "700");
	tmplist = g_list_append(tmplist, "800");
	tmplist = g_list_append(tmplist, "900");
	ds->combo[4] = combo_with_popdown(NULL, tmplist, 0);
	gtk_table_attach_defaults(GTK_TABLE(table), ds->combo[4], 1, 4, 4, 5);
	g_list_free(tmplist);

	tmplist = g_list_append(NULL, "");
	ds->combo[5] = combo_with_popdown(NULL, tmplist, 1);
	gtk_table_attach_defaults(GTK_TABLE(table), ds->combo[5], 2, 4, 6, 7);

	tmplist = g_list_append(NULL, "");
	ds->combo[6] = combo_with_popdown(NULL, tmplist, 1);
	gtk_table_attach_defaults(GTK_TABLE(table), ds->combo[6], 2, 4, 8, 9);

	frame = gtk_frame_new("size unit");
	gtk_table_attach(GTK_TABLE(table), frame, 0, 2, 5, 9, GTK_FILL | GTK_EXPAND, GTK_FILL | GTK_EXPAND, 5, 5);
	vbox = gtk_vbox_new(TRUE, 1);
	gtk_container_add(GTK_CONTAINER(frame), vbox);
	ds->radio[1] = gtk_radio_button_new_with_label(NULL, _("absolute size"));
	gtk_box_pack_start(GTK_BOX(vbox), ds->radio[1], TRUE, TRUE, 0);
	group = gtk_radio_button_group(GTK_RADIO_BUTTON(ds->radio[1]));
	ds->radio[2] = gtk_radio_button_new_with_label(group, _("relative size"));
	gtk_box_pack_start(GTK_BOX(vbox), ds->radio[2], TRUE, TRUE, 0);
	group = gtk_radio_button_group(GTK_RADIO_BUTTON(ds->radio[2]));
	ds->radio[3] = gtk_radio_button_new_with_label(group, _("length/percentage"));
	gtk_box_pack_start(GTK_BOX(vbox), ds->radio[3], TRUE, TRUE, 0);
	group = gtk_radio_button_group(GTK_RADIO_BUTTON(ds->radio[3]));
	gtk_signal_connect(GTK_OBJECT(ds->radio[1]), "clicked", sizing_unit_font_cb, ds);
	gtk_signal_connect(GTK_OBJECT(ds->radio[2]), "clicked", sizing_unit_font_cb, ds);
	gtk_signal_connect(GTK_OBJECT(ds->radio[3]), "clicked", sizing_unit_font_cb, ds);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(ds->radio[3]), 1);
	/* font tab completed */
	gtk_notebook_append_page(GTK_NOTEBOOK(notebook), table, apply_font_style(gtk_label_new("Font"), main_v->props.cfg_tab_font));

	/* margin&padding tab started */
	/* check 3-4, combo 25-32 */

	table = table = gtk_table_new(3, 7, 0);
	gtk_table_attach_defaults(GTK_TABLE(table), gtk_label_new(_("margin")), 1, 2, 2, 3);
	gtk_table_attach_defaults(GTK_TABLE(table), gtk_label_new(_("padding")), 2, 3, 2, 3);
	gtk_table_attach_defaults(GTK_TABLE(table), gtk_label_new(_("top")), 0, 1, 3, 4);
	gtk_table_attach_defaults(GTK_TABLE(table), gtk_label_new(_("right")), 0, 1, 4, 5);
	gtk_table_attach_defaults(GTK_TABLE(table), gtk_label_new(_("bottom")), 0, 1, 5, 6);
	gtk_table_attach_defaults(GTK_TABLE(table), gtk_label_new(_("left")), 0, 1, 6, 7);
	ds->check[3] = gtk_check_button_new_with_label(_("Insert margin as one line"));
	gtk_table_attach_defaults(GTK_TABLE(table), ds->check[3], 0, 3, 0, 1);
	ds->check[4] = gtk_check_button_new_with_label(_("Insert padding as one line"));
	gtk_table_attach_defaults(GTK_TABLE(table), ds->check[4], 0, 3, 1, 2);
	tmplist = make_length_list(0.1, 10, 1, 0);
	g_list_append(tmplist, "auto");
	ds->combo[25] = combo_with_popdown(NULL, tmplist, 1);
	gtk_table_attach_defaults(GTK_TABLE(table), ds->combo[25], 1, 2, 3, 4);
	ds->combo[27] = combo_with_popdown(NULL, tmplist, 1);
	gtk_table_attach_defaults(GTK_TABLE(table), ds->combo[27], 1, 2, 4, 5);
	ds->combo[29] = combo_with_popdown(NULL, tmplist, 1);
	gtk_table_attach_defaults(GTK_TABLE(table), ds->combo[29], 1, 2, 5, 6);
	ds->combo[31] = combo_with_popdown(NULL, tmplist, 1);
	gtk_table_attach_defaults(GTK_TABLE(table), ds->combo[31], 1, 2, 6, 7);
	g_list_free(tmplist);

	tmplist = make_length_list(0.1, 10, 1, 0);
	ds->combo[26] = combo_with_popdown(NULL, tmplist, 1);
	gtk_table_attach_defaults(GTK_TABLE(table), ds->combo[26], 2, 3, 3, 4);
	ds->combo[28] = combo_with_popdown(NULL, tmplist, 1);
	gtk_table_attach_defaults(GTK_TABLE(table), ds->combo[28], 2, 3, 4, 5);
	ds->combo[30] = combo_with_popdown(NULL, tmplist, 1);
	gtk_table_attach_defaults(GTK_TABLE(table), ds->combo[30], 2, 3, 5, 6);
	ds->combo[32] = combo_with_popdown(NULL, tmplist, 1);
	gtk_table_attach_defaults(GTK_TABLE(table), ds->combo[32], 2, 3, 6, 7);
	g_list_free(tmplist);

	/* margin&padding tab completed */
	gtk_notebook_append_page(GTK_NOTEBOOK(notebook), table,
							 apply_font_style(gtk_label_new(_("Margin & padding")), main_v->props.cfg_tab_font));

	/* border tab started */
	table = table = gtk_table_new(4, 8, 0);
	gtk_table_attach_defaults(GTK_TABLE(table), gtk_label_new(_("width")), 1, 2, 3, 4);
	gtk_table_attach_defaults(GTK_TABLE(table), gtk_label_new(_("color")), 2, 3, 3, 4);
	gtk_table_attach_defaults(GTK_TABLE(table), gtk_label_new(_("style")), 3, 4, 3, 4);
	gtk_table_attach_defaults(GTK_TABLE(table), gtk_label_new(_("top")), 0, 1, 4, 5);
	gtk_table_attach_defaults(GTK_TABLE(table), gtk_label_new(_("right")), 0, 1, 5, 6);
	gtk_table_attach_defaults(GTK_TABLE(table), gtk_label_new(_("bottom")), 0, 1, 6, 7);
	gtk_table_attach_defaults(GTK_TABLE(table), gtk_label_new(_("left")), 0, 1, 7, 8);
	ds->radio[7] = gtk_radio_button_new_with_label(NULL, _("Insert values per property"));
	gtk_table_attach_defaults(GTK_TABLE(table), ds->radio[7], 0, 4, 0, 1);
	group = gtk_radio_button_group(GTK_RADIO_BUTTON(ds->radio[7]));
	ds->radio[8] = gtk_radio_button_new_with_label(group, _("Insert values per border side"));
	gtk_table_attach_defaults(GTK_TABLE(table), ds->radio[8], 0, 4, 1, 2);
	group = gtk_radio_button_group(GTK_RADIO_BUTTON(ds->radio[8]));
	ds->radio[9] = gtk_radio_button_new_with_label(group, _("Insert top-values as general value for all sides"));
	gtk_table_attach_defaults(GTK_TABLE(table), ds->radio[9], 0, 4, 2, 3);
	group = gtk_radio_button_group(GTK_RADIO_BUTTON(ds->radio[9]));
	tmplist = make_length_list(0, 0.5, 0, 0);
	tmplist = g_list_append(tmplist, "thin");
	tmplist = g_list_append(tmplist, "medium");
	tmplist = g_list_append(tmplist, "thick");
	ds->combo[41] = combo_with_popdown(NULL, tmplist, 1);
	gtk_table_attach_defaults(GTK_TABLE(table), ds->combo[41], 1, 2, 4, 5);
	ds->combo[44] = combo_with_popdown(NULL, tmplist, 1);
	gtk_table_attach_defaults(GTK_TABLE(table), ds->combo[44], 1, 2, 5, 6);
	ds->combo[47] = combo_with_popdown(NULL, tmplist, 1);
	gtk_table_attach_defaults(GTK_TABLE(table), ds->combo[47], 1, 2, 6, 7);
	ds->combo[50] = combo_with_popdown(NULL, tmplist, 1);
	gtk_table_attach_defaults(GTK_TABLE(table), ds->combo[50], 1, 2, 7, 8);

	ds->combo[42] = combo_with_popdown(NULL, main_v->current_project.colorlist, 1);
	gtk_table_attach_defaults(GTK_TABLE(table), ds->combo[42], 2, 3, 4, 5);
	ds->combo[45] = combo_with_popdown(NULL, main_v->current_project.colorlist, 1);
	gtk_table_attach_defaults(GTK_TABLE(table), ds->combo[45], 2, 3, 5, 6);
	ds->combo[48] = combo_with_popdown(NULL, main_v->current_project.colorlist, 1);
	gtk_table_attach_defaults(GTK_TABLE(table), ds->combo[48], 2, 3, 6, 7);
	ds->combo[51] = combo_with_popdown(NULL, main_v->current_project.colorlist, 1);
	gtk_table_attach_defaults(GTK_TABLE(table), ds->combo[51], 2, 3, 7, 8);

	tmplist = g_list_append(NULL, "");
	tmplist = g_list_append(tmplist, "none");
	tmplist = g_list_append(tmplist, "dotted");
	tmplist = g_list_append(tmplist, "dashed");
	tmplist = g_list_append(tmplist, "solid");
	tmplist = g_list_append(tmplist, "double");
	tmplist = g_list_append(tmplist, "groove");
	tmplist = g_list_append(tmplist, "ridge");
	tmplist = g_list_append(tmplist, "inset");
	tmplist = g_list_append(tmplist, "outset");
	ds->combo[43] = combo_with_popdown(NULL, tmplist, 1);
	gtk_table_attach_defaults(GTK_TABLE(table), ds->combo[43], 3, 4, 4, 5);
	ds->combo[46] = combo_with_popdown(NULL, tmplist, 1);
	gtk_table_attach_defaults(GTK_TABLE(table), ds->combo[46], 3, 4, 5, 6);
	ds->combo[49] = combo_with_popdown(NULL, tmplist, 1);
	gtk_table_attach_defaults(GTK_TABLE(table), ds->combo[49], 3, 4, 6, 7);
	ds->combo[52] = combo_with_popdown(NULL, tmplist, 1);
	gtk_table_attach_defaults(GTK_TABLE(table), ds->combo[52], 3, 4, 7, 8);
	g_list_free(tmplist);
	/* border tab completed */
	gtk_notebook_append_page(GTK_NOTEBOOK(notebook), table, apply_font_style(gtk_label_new("Border"), main_v->props.cfg_tab_font));

	/* size&placement tab started */
	/* combo 33 - 36 */
	table = table = gtk_table_new(2, 4, 0);
	gtk_table_attach_defaults(GTK_TABLE(table), gtk_label_new(_("width")), 0, 1, 0, 1);
	gtk_table_attach_defaults(GTK_TABLE(table), gtk_label_new(_("height")), 0, 1, 1, 2);
	gtk_table_attach_defaults(GTK_TABLE(table), gtk_label_new(_("float")), 0, 1, 2, 3);
	gtk_table_attach_defaults(GTK_TABLE(table), gtk_label_new(_("clear")), 0, 1, 3, 4);
	tmplist = make_length_list(2.9, 100, 1, 1);
	ds->combo[33] = combo_with_popdown(NULL, tmplist, 1);
	g_list_free(tmplist);
	gtk_table_attach_defaults(GTK_TABLE(table), ds->combo[33], 1, 2, 0, 1);
	tmplist = make_length_list(2.9, 100, 0, 0);
	ds->combo[34] = combo_with_popdown(NULL, tmplist, 1);
	g_list_free(tmplist);
	gtk_table_attach_defaults(GTK_TABLE(table), ds->combo[34], 1, 2, 1, 2);
	tmplist = g_list_append(NULL, "");
	tmplist = g_list_append(tmplist, "left");
	tmplist = g_list_append(tmplist, "right");
	tmplist = g_list_append(tmplist, "none");
	ds->combo[35] = combo_with_popdown(NULL, tmplist, 1);
	g_list_free(tmplist);
	gtk_table_attach_defaults(GTK_TABLE(table), ds->combo[35], 1, 2, 2, 3);
	tmplist = g_list_append(NULL, "");
	tmplist = g_list_append(tmplist, "left");
	tmplist = g_list_append(tmplist, "right");
	tmplist = g_list_append(tmplist, "none");
	tmplist = g_list_append(tmplist, "both");
	ds->combo[36] = combo_with_popdown(NULL, tmplist, 1);
	g_list_free(tmplist);
	gtk_table_attach_defaults(GTK_TABLE(table), ds->combo[36], 1, 2, 3, 4);
	/* size&placement tab completed */
	gtk_notebook_append_page(GTK_NOTEBOOK(notebook), table,
							 apply_font_style(gtk_label_new(_("Size & placement")), main_v->props.cfg_tab_font));

	/* color&background tab started */
	table = table = gtk_table_new(5, 9, 0);
	gtk_table_attach_defaults(GTK_TABLE(table), gtk_label_new(_("color")), 0, 1, 0, 1);
	gtk_table_attach_defaults(GTK_TABLE(table), gtk_label_new(_("background-color")), 0, 1, 2, 3);
	gtk_table_attach_defaults(GTK_TABLE(table), gtk_label_new(_("background-image")), 0, 1, 3, 4);
	gtk_table_attach_defaults(GTK_TABLE(table), gtk_label_new(_("background-repeat")), 0, 1, 4, 5);
	gtk_table_attach_defaults(GTK_TABLE(table), gtk_label_new(_("background-attachment")), 0, 1, 5, 6);
	gtk_table_attach_defaults(GTK_TABLE(table), gtk_label_new(_("background-position")), 2, 4, 6, 7);
	gtk_table_attach_defaults(GTK_TABLE(table), gtk_label_new(_("accross")), 2, 3, 7, 8);
	gtk_table_attach_defaults(GTK_TABLE(table), gtk_label_new(_("down")), 2, 3, 8, 9);

	ds->combo[11] = combo_with_popdown(NULL, main_v->current_project.colorlist, 1);
	gtk_table_attach_defaults(GTK_TABLE(table), ds->combo[11], 1, 4, 0, 1);
	ds->check[2] = gtk_check_button_new_with_label(_("Insert background as one line"));
	gtk_table_attach_defaults(GTK_TABLE(table), ds->check[2], 0, 4, 1, 2);
	ds->combo[12] = combo_with_popdown(NULL, main_v->current_project.colorlist, 1);
	gtk_table_attach_defaults(GTK_TABLE(table), ds->combo[12], 1, 4, 2, 3);
	ds->combo[13] = combo_with_popdown(NULL, main_v->current_project.urllist, 1);
	gtk_table_attach_defaults(GTK_TABLE(table), ds->combo[13], 1, 4, 3, 4);

	tmplist = g_list_append(NULL, "");
	tmplist = g_list_append(tmplist, "repeat");
	tmplist = g_list_append(tmplist, "repeat-x");
	tmplist = g_list_append(tmplist, "repeat-y");
	tmplist = g_list_append(tmplist, "no-repeat");
	ds->combo[14] = combo_with_popdown(NULL, tmplist, 0);
	gtk_table_attach_defaults(GTK_TABLE(table), ds->combo[14], 1, 4, 4, 5);
	g_list_free(tmplist);

	tmplist = g_list_append(NULL, "");
	tmplist = g_list_append(tmplist, "scroll");
	tmplist = g_list_append(tmplist, "fixed");
	ds->combo[15] = combo_with_popdown(NULL, tmplist, 0);
	gtk_table_attach_defaults(GTK_TABLE(table), ds->combo[15], 1, 4, 5, 6);
	g_list_free(tmplist);

	tmplist = g_list_append(NULL, "");
	ds->combo[16] = combo_with_popdown(NULL, tmplist, 1);
	gtk_table_attach_defaults(GTK_TABLE(table), ds->combo[16], 3, 5, 7, 8);

	tmplist = g_list_append(NULL, "");
	ds->combo[17] = combo_with_popdown(NULL, tmplist, 1);
	gtk_table_attach_defaults(GTK_TABLE(table), ds->combo[17], 3, 5, 8, 9);

	frame = gtk_frame_new(_("size unit"));
	gtk_table_attach(GTK_TABLE(table), frame, 0, 2, 6, 9, GTK_FILL | GTK_EXPAND, GTK_FILL | GTK_EXPAND, 5, 5);
	vbox = gtk_vbox_new(TRUE, 1);
	group = NULL;
	gtk_container_add(GTK_CONTAINER(frame), vbox);
	ds->radio[4] = gtk_radio_button_new_with_label(NULL, _("percentage"));
	gtk_box_pack_start(GTK_BOX(vbox), ds->radio[4], TRUE, TRUE, 0);
	group = gtk_radio_button_group(GTK_RADIO_BUTTON(ds->radio[4]));
	ds->radio[5] = gtk_radio_button_new_with_label(group, _("absolute size"));
	gtk_box_pack_start(GTK_BOX(vbox), ds->radio[5], TRUE, TRUE, 0);
	group = gtk_radio_button_group(GTK_RADIO_BUTTON(ds->radio[5]));
	ds->radio[6] = gtk_radio_button_new_with_label(group, _("keyword"));
	gtk_box_pack_start(GTK_BOX(vbox), ds->radio[6], TRUE, TRUE, 0);
	group = gtk_radio_button_group(GTK_RADIO_BUTTON(ds->radio[6]));
	gtk_signal_connect(GTK_OBJECT(ds->radio[4]), "clicked", sizing_unit_bg_cb, ds);
	gtk_signal_connect(GTK_OBJECT(ds->radio[5]), "clicked", sizing_unit_bg_cb, ds);
	gtk_signal_connect(GTK_OBJECT(ds->radio[6]), "clicked", sizing_unit_bg_cb, ds);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(ds->radio[4]), 1);

	/* color&background tab completed */
	gtk_notebook_append_page(GTK_NOTEBOOK(notebook), table,
							 apply_font_style(gtk_label_new(_("Color & background")), main_v->props.cfg_tab_font));

	/* text tab started */
	table = table = gtk_table_new(2, 7, 0);
	gtk_table_attach_defaults(GTK_TABLE(table), gtk_label_new(_("word-spacing")), 0, 1, 0, 1);
	gtk_table_attach_defaults(GTK_TABLE(table), gtk_label_new(_("letter-spacing")), 0, 1, 1, 2);
	gtk_table_attach_defaults(GTK_TABLE(table), gtk_label_new(_("vertical-align")), 0, 1, 2, 3);
	gtk_table_attach_defaults(GTK_TABLE(table), gtk_label_new(_("text-align")), 0, 1, 3, 4);
	gtk_table_attach_defaults(GTK_TABLE(table), gtk_label_new(_("text-decoration")), 0, 1, 4, 5);
	gtk_table_attach_defaults(GTK_TABLE(table), gtk_label_new(_("text-transform")), 0, 1, 5, 6);
	gtk_table_attach_defaults(GTK_TABLE(table), gtk_label_new(_("text-indent")), 0, 1, 6, 7);

	tmplist = make_length_list(0.4, 4, 0, 0);
	ds->combo[18] = combo_with_popdown(NULL, tmplist, 1);
	gtk_table_attach_defaults(GTK_TABLE(table), ds->combo[18], 1, 2, 0, 1);
	g_list_free(tmplist);
	tmplist = make_length_list(0, 0.6, 0, 0);
	ds->combo[19] = combo_with_popdown(NULL, tmplist, 1);
	gtk_table_attach_defaults(GTK_TABLE(table), ds->combo[19], 1, 2, 1, 2);
	g_list_free(tmplist);
	tmplist = g_list_append(NULL, "");
	tmplist = g_list_append(tmplist, "baseline");
	tmplist = g_list_append(tmplist, "sub");
	tmplist = g_list_append(tmplist, "super");
	tmplist = g_list_append(tmplist, "top");
	tmplist = g_list_append(tmplist, "text-top");
	tmplist = g_list_append(tmplist, "middle");
	tmplist = g_list_append(tmplist, "bottom");
	tmplist = g_list_append(tmplist, "text-bottom");
	tmplist = g_list_append(tmplist, "-50%");
	tmplist = g_list_append(tmplist, "-100%");
	tmplist = g_list_append(tmplist, "50%");
	tmplist = g_list_append(tmplist, "100%");
	ds->combo[20] = combo_with_popdown(NULL, tmplist, 1);
	gtk_table_attach_defaults(GTK_TABLE(table), ds->combo[20], 1, 2, 2, 3);
	g_list_free(tmplist);
	tmplist = g_list_append(NULL, "");
	tmplist = g_list_append(tmplist, "left");
	tmplist = g_list_append(tmplist, "right");
	tmplist = g_list_append(tmplist, "center");
	tmplist = g_list_append(tmplist, "justify");
	ds->combo[21] = combo_with_popdown(NULL, tmplist, 0);
	gtk_table_attach_defaults(GTK_TABLE(table), ds->combo[21], 1, 2, 3, 4);
	g_list_free(tmplist);
	tmplist = g_list_append(NULL, "");
	tmplist = g_list_append(tmplist, "none");
	tmplist = g_list_append(tmplist, "underline");
	tmplist = g_list_append(tmplist, "overline");
	tmplist = g_list_append(tmplist, "line-trough");
	tmplist = g_list_append(tmplist, "blink");
	ds->combo[22] = combo_with_popdown(NULL, tmplist, 0);
	gtk_table_attach_defaults(GTK_TABLE(table), ds->combo[22], 1, 2, 4, 5);
	g_list_free(tmplist);
	tmplist = g_list_append(NULL, "");
	tmplist = g_list_append(tmplist, "none");
	tmplist = g_list_append(tmplist, "capitalize");
	tmplist = g_list_append(tmplist, "uppercase");
	tmplist = g_list_append(tmplist, "lowercase");
	ds->combo[23] = combo_with_popdown(NULL, tmplist, 0);
	gtk_table_attach_defaults(GTK_TABLE(table), ds->combo[23], 1, 2, 5, 6);
	g_list_free(tmplist);
	tmplist = make_length_list(0, 4, 1, 1);
	ds->combo[24] = combo_with_popdown(NULL, tmplist, 1);
	gtk_table_attach_defaults(GTK_TABLE(table), ds->combo[24], 1, 2, 6, 7);
	g_list_free(tmplist);
	/* text tab completed */
	gtk_notebook_append_page(GTK_NOTEBOOK(notebook), table, apply_font_style(gtk_label_new("Text"), main_v->props.cfg_tab_font));

	/* classification tab started */
	/* combo 37-40, check 5, entry 3 */
	table = table = gtk_table_new(3, 6, 0);
	gtk_table_attach_defaults(GTK_TABLE(table), gtk_label_new(_("display")), 0, 1, 0, 1);
	gtk_table_attach_defaults(GTK_TABLE(table), gtk_label_new(_("white-space")), 0, 1, 1, 2);
	gtk_table_attach_defaults(GTK_TABLE(table), gtk_label_new(_("list-style-type")), 0, 1, 3, 4);
	gtk_table_attach_defaults(GTK_TABLE(table), gtk_label_new(_("list-style-image")), 0, 1, 4, 5);
	gtk_table_attach_defaults(GTK_TABLE(table), gtk_label_new(_("list-style-position")), 0, 1, 5, 6);
	tmplist = g_list_append(NULL, "");
	ds->combo[37] = combo_with_popdown(NULL, tmplist, 1);
	g_list_free(tmplist);
	gtk_table_attach_defaults(GTK_TABLE(table), ds->combo[37], 1, 2, 0, 1);
	tmplist = g_list_append(NULL, "");
	ds->combo[38] = combo_with_popdown(NULL, tmplist, 1);
	g_list_free(tmplist);
	gtk_table_attach_defaults(GTK_TABLE(table), ds->combo[38], 1, 2, 1, 2);
	ds->check[5] = gtk_check_button_new_with_label(_("Insert list-item as one line"));
	gtk_table_attach_defaults(GTK_TABLE(table), ds->check[5], 0, 2, 2, 3);
	tmplist = g_list_append(NULL, "");
	ds->combo[39] = combo_with_popdown(NULL, tmplist, 1);
	g_list_free(tmplist);
	gtk_table_attach_defaults(GTK_TABLE(table), ds->combo[39], 1, 2, 3, 4);
	tmplist = g_list_append(NULL, "");
	ds->combo[40] = combo_with_popdown(NULL, tmplist, 1);
	g_list_free(tmplist);
	gtk_table_attach_defaults(GTK_TABLE(table), ds->combo[40], 1, 2, 5, 6);
	ds->entry[3] = gtk_entry_new();
	gtk_table_attach_defaults(GTK_TABLE(table), ds->entry[3], 1, 2, 4, 5);
	file_but = file_but_new(ds->entry[3], ds->dialog, 0);
	gtk_table_attach(GTK_TABLE(table), file_but, 2, 3, 4, 5, 0, 0, 5, 5);
	/* classification tab completed */
	gtk_notebook_append_page(GTK_NOTEBOOK(notebook), table, apply_font_style(gtk_label_new("Classification"), main_v->props.cfg_tab_font));

	middle_dialog(ds, 0, 2, 4, 5, 6);
	if (ds->abort != 1) {

		/* font tab */
		if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(ds->check[1]))) {
			fontstring =
				g_strdup_printf("   font: %s %s %s %s%s %s;\n", insert_if_string("%s", GTK_WIDGET(GTK_COMBO(ds->combo[2])->entry), "normal")
								, insert_if_string("%s", GTK_WIDGET(GTK_COMBO(ds->combo[3])->entry), "normal")
								, insert_if_string("%s", GTK_WIDGET(GTK_COMBO(ds->combo[4])->entry), "normal")
								, gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(ds->combo[5])->entry))
								, insert_if_string("/%s", GTK_WIDGET(GTK_COMBO(ds->combo[6])->entry), NULL)
								, gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(ds->combo[1])->entry))
				);
		} else {
			fontstring =
				g_strdup_printf("%s%s%s%s%s%s", insert_if_string("   font-family: %s;\n", GTK_WIDGET(GTK_COMBO(ds->combo[1])->entry), NULL)
								, insert_if_string("   font-style: %s;\n", GTK_WIDGET(GTK_COMBO(ds->combo[2])->entry), NULL)
								, insert_if_string("   font-variant: %s;\n", GTK_WIDGET(GTK_COMBO(ds->combo[3])->entry), NULL)
								, insert_if_string("   font-weight: %s;\n", GTK_WIDGET(GTK_COMBO(ds->combo[4])->entry), NULL)
								, insert_if_string("   font-size: %s;\n", GTK_WIDGET(GTK_COMBO(ds->combo[5])->entry), NULL)
								, insert_if_string("   line-height: %s;\n", GTK_WIDGET(GTK_COMBO(ds->combo[6])->entry), NULL)
				);
		}
		garbage = g_list_append(garbage, fontstring);
		DEBUG_MSG("style, fontstring=%s\n", fontstring);
		/* end font tab */
		/* margin & padding tab */
		if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(ds->check[3]))) {
			margstring =
				g_strdup_printf("   margin: %s %s %s %s;\n", insert_if_string("%s", GTK_WIDGET(GTK_COMBO(ds->combo[25])->entry), "0")
								, insert_if_string("%s", GTK_WIDGET(GTK_COMBO(ds->combo[27])->entry), "0")
								, insert_if_string("%s", GTK_WIDGET(GTK_COMBO(ds->combo[29])->entry), "0")
								, insert_if_string("%s", GTK_WIDGET(GTK_COMBO(ds->combo[31])->entry), "0")
				);
		} else {
			margstring =
				g_strdup_printf("%s%s%s%s", insert_if_string("   margin-top: %s;\n", GTK_WIDGET(GTK_COMBO(ds->combo[25])->entry), NULL),
								insert_if_string("   margin-right: %s;\n", GTK_WIDGET(GTK_COMBO(ds->combo[27])->entry), NULL)
								, insert_if_string("   margin-bottom: %s;\n", GTK_WIDGET(GTK_COMBO(ds->combo[29])->entry), NULL)
								, insert_if_string("   margin-left: %s;\n", GTK_WIDGET(GTK_COMBO(ds->combo[31])->entry), NULL)
				);
		}
		garbage = g_list_append(garbage, margstring);
		if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(ds->check[4]))) {
			padstring =
				g_strdup_printf("   padding: %s %s %s %s;\n", insert_if_string("%s", GTK_WIDGET(GTK_COMBO(ds->combo[26])->entry), "0")
								, insert_if_string("%s", GTK_WIDGET(GTK_COMBO(ds->combo[28])->entry), "0")
								, insert_if_string("%s", GTK_WIDGET(GTK_COMBO(ds->combo[30])->entry), "0")
								, insert_if_string("%s", GTK_WIDGET(GTK_COMBO(ds->combo[32])->entry), "0")
				);
		} else {
			padstring =
				g_strdup_printf("%s%s%s%s", insert_if_string("   padding-top: %s;\n", GTK_WIDGET(GTK_COMBO(ds->combo[26])->entry), NULL),
								insert_if_string("   padding-right: %s;\n", GTK_WIDGET(GTK_COMBO(ds->combo[28])->entry), NULL)
								, insert_if_string("   padding-bottom: %s;\n", GTK_WIDGET(GTK_COMBO(ds->combo[30])->entry), NULL)
								, insert_if_string("   padding-left: %s;\n", GTK_WIDGET(GTK_COMBO(ds->combo[32])->entry), NULL)
				);
		}
		garbage = g_list_append(garbage, padstring);
		/* end of margin & padding */
		/* border tab */
		if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(ds->radio[7]))) {
			borderstring =
				g_strdup_printf("   border-width: %s %s %s %s;\n   border-color: %s %s %s %s;\n   border-style: %s %s %s %s;\n",
								insert_if_string("%s", GTK_WIDGET(GTK_COMBO(ds->combo[41])->entry), "medium")
								, insert_if_string("%s", GTK_WIDGET(GTK_COMBO(ds->combo[44])->entry), "medium")
								, insert_if_string("%s", GTK_WIDGET(GTK_COMBO(ds->combo[47])->entry), "medium")
								, insert_if_string("%s", GTK_WIDGET(GTK_COMBO(ds->combo[50])->entry), "medium")
								, gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(ds->combo[42])->entry))
								, gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(ds->combo[45])->entry))
								, gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(ds->combo[48])->entry))
								, gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(ds->combo[51])->entry))
								, insert_if_string("%s", GTK_WIDGET(GTK_COMBO(ds->combo[43])->entry), "none")
								, insert_if_string("%s", GTK_WIDGET(GTK_COMBO(ds->combo[46])->entry), "none")
								, insert_if_string("%s", GTK_WIDGET(GTK_COMBO(ds->combo[49])->entry), "none")
								, insert_if_string("%s", GTK_WIDGET(GTK_COMBO(ds->combo[52])->entry), "none")
				);
		} else if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(ds->radio[8]))) {
			borderstring =
				g_strdup_printf
				("   border-top: %s %s %s;\n   border-right: %s %s %s;\n   border-bottom: %s %s %s;\n   border-left: %s %s %s;\n",
				 gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(ds->combo[41])->entry))
				 , gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(ds->combo[42])->entry))
				 , gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(ds->combo[43])->entry))
				 , gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(ds->combo[44])->entry))
				 , gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(ds->combo[45])->entry))
				 , gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(ds->combo[46])->entry))
				 , gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(ds->combo[47])->entry))
				 , gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(ds->combo[48])->entry))
				 , gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(ds->combo[49])->entry))
				 , gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(ds->combo[50])->entry))
				 , gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(ds->combo[51])->entry))
				 , gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(ds->combo[52])->entry))
				);
		} else {
			borderstring = g_strdup_printf("   border: %s %s %s;\n", gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(ds->combo[41])->entry))
										   , gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(ds->combo[42])->entry))
										   , gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(ds->combo[43])->entry))
				);
		}
		garbage = g_list_append(garbage, borderstring);
		DEBUG_MSG("insert_in_stylesheet, borderstring=%s\n", borderstring);
		/* end border tab */
		/* size and placement tab */
		sizeplacestring = g_strdup_printf("%s%s%s%s", insert_if_string("   width: %s;\n", GTK_WIDGET(GTK_COMBO(ds->combo[33])->entry), NULL)
										  , insert_if_string("   height: %s;\n", GTK_WIDGET(GTK_COMBO(ds->combo[34])->entry), NULL)
										  , insert_if_string("   float: %s;\n", GTK_WIDGET(GTK_COMBO(ds->combo[35])->entry), NULL)
										  , insert_if_string("   clear: %s;\n", GTK_WIDGET(GTK_COMBO(ds->combo[36])->entry), NULL)
			);
		garbage = g_list_append(garbage, sizeplacestring);
		/* end of size and placement */
		/* color & background tab */
		if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(ds->check[2]))) {
			bgncolorstring =
				g_strdup_printf("%s   background: %s %s %s %s %s %s;\n",
								insert_if_string("   color: %s;\n", GTK_WIDGET(GTK_COMBO(ds->combo[11])->entry), NULL)
								, insert_if_string("%s", GTK_WIDGET(GTK_COMBO(ds->combo[12])->entry), "transparent")
								, insert_if_string("url(%s)", GTK_WIDGET(GTK_COMBO(ds->combo[13])->entry), NULL)
								, insert_if_string("%s", GTK_WIDGET(GTK_COMBO(ds->combo[14])->entry), "repeat")
								, insert_if_string("%s", GTK_WIDGET(GTK_COMBO(ds->combo[15])->entry), "scroll")
								, insert_if_string("%s", GTK_WIDGET(GTK_COMBO(ds->combo[16])->entry), "0%")
								, insert_if_string("%s", GTK_WIDGET(GTK_COMBO(ds->combo[17])->entry), "0%")
				);
		} else {
			bgncolorstring =
				g_strdup_printf("%s%s%s%s%s%s%s", insert_if_string("   color: %s;\n", GTK_WIDGET(GTK_COMBO(ds->combo[11])->entry), NULL)
								, insert_if_string("   background-color: %s;\n", GTK_WIDGET(GTK_COMBO(ds->combo[12])->entry), NULL)
								, insert_if_string("   background-image: url(%s);\n", GTK_WIDGET(GTK_COMBO(ds->combo[13])->entry), NULL)
								, insert_if_string("   background-repeat: %s;\n", GTK_WIDGET(GTK_COMBO(ds->combo[14])->entry), NULL)
								, insert_if_string("   background-attachment: %s;\n", GTK_WIDGET(GTK_COMBO(ds->combo[15])->entry), NULL)
								, insert_if_string("   background-position: %s", GTK_WIDGET(GTK_COMBO(ds->combo[16])->entry),
												   "   background-position: top")
								, insert_if_string(" %s;\n", GTK_WIDGET(GTK_COMBO(ds->combo[17])->entry), " left;\n")
				);
		}
		DEBUG_MSG("insert_in_stylesheet, bgncolorstring=%s\n", bgncolorstring);
		garbage = g_list_append(garbage, bgncolorstring);
		/* end color & background tab */
		DEBUG_MSG("insert_in_stylesheet, before text tab\n");
		/* text tab */
		textstring =
			g_strdup_printf("%s%s%s%s%s%s%s", insert_if_string("   word-spacing: %s;\n", GTK_WIDGET(GTK_COMBO(ds->combo[18])->entry), NULL)
							, insert_if_string("   letter-spacing: %s;\n", GTK_WIDGET(GTK_COMBO(ds->combo[19])->entry), NULL)
							, insert_if_string("   vertical-align: %s;\n", GTK_WIDGET(GTK_COMBO(ds->combo[20])->entry), NULL)
							, insert_if_string("   text-align: %s;\n", GTK_WIDGET(GTK_COMBO(ds->combo[21])->entry), NULL)
							, insert_if_string("   text-decoration: %s;\n", GTK_WIDGET(GTK_COMBO(ds->combo[22])->entry), NULL)
							, insert_if_string("   text-transform: %s;\n", GTK_WIDGET(GTK_COMBO(ds->combo[23])->entry), NULL)
							, insert_if_string("   text-indent: %s;\n", GTK_WIDGET(GTK_COMBO(ds->combo[24])->entry), NULL)
			);
		garbage = g_list_append(garbage, textstring);
		/* end text tab */
		DEBUG_MSG("insert_in_stylesheet, before classification tab\n");
		/* classification tab */
		if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(ds->check[5]))) {
			DEBUG_MSG("insert_in_stylesheet, check[5] = TRUE\n");
			classistring =
				g_strdup_printf("%s%s   list-style: %s %s %s;\n",
								insert_if_string("   display: %s;\n", GTK_WIDGET(GTK_COMBO(ds->combo[37])->entry), NULL)
								, insert_if_string("   white-space: %s;\n", GTK_WIDGET(GTK_COMBO(ds->combo[38])->entry), NULL)
								, insert_if_string("%s", GTK_WIDGET(GTK_COMBO(ds->combo[39])->entry), "disc")
								, insert_if_string("%s", GTK_WIDGET(ds->entry[3]), "none")
								, insert_if_string("%s", GTK_WIDGET(GTK_COMBO(ds->combo[40])->entry), "outside")
				);
		} else {
			DEBUG_MSG("insert_in_stylesheet, check[5] = FALSE\n");
			classistring =
				g_strdup_printf("%s%s%s%s%s", insert_if_string("   display: %s;\n", GTK_WIDGET(GTK_COMBO(ds->combo[37])->entry), NULL),
								insert_if_string("   white-space: %s;\n", GTK_WIDGET(GTK_COMBO(ds->combo[38])->entry), NULL)
								, insert_if_string("   list-style-type: %s;\n", GTK_WIDGET(GTK_COMBO(ds->combo[39])->entry), NULL)
								, insert_if_string("   list-style-image: %s;\n", GTK_WIDGET(ds->entry[3]), NULL)
								, insert_if_string("   list-style-position: %s;\n", GTK_WIDGET(GTK_COMBO(ds->combo[40])->entry), NULL)
				);
		}
		garbage = g_list_append(garbage, classistring);
		/* end of classification */
		DEBUG_MSG("insert_in_stylesheet, putting all the strings together\n");
		ds->tmpstring = g_strdup_printf("%s%s%s {\n%s%s%s%s%s%s%s}\n", gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(ds->combo[8])->entry))
										, insert_if_string(".%s", GTK_WIDGET(GTK_COMBO(ds->combo[9])->entry), NULL)
										, insert_if_string(":%s", GTK_WIDGET(GTK_COMBO(ds->combo[10])->entry), NULL)
										, fontstring, margstring, padstring, borderstring, bgncolorstring, textstring, classistring);
		DEBUG_MSG("insert_new_style, ds->tmpstring=%s\n", ds->tmpstring);
		insert_text(ds->tmpstring, "");
		DEBUG_MSG("insert_new_style, text inserted\n");
		main_v->current_project.fontlist =
			add_to_stringlist(main_v->current_project.fontlist, gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(ds->combo[1])->entry)));
		main_v->current_project.classlist =
			add_to_stringlist(main_v->current_project.classlist, gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(ds->combo[9])->entry)));
		g_free(ds->tmpstring);
	}
	DEBUG_MSG("insert_new_style, going to destroy dialog\n");
	if (GTK_IS_WIDGET(ds->dialog))
		gtk_widget_destroy(ds->dialog);
	DEBUG_MSG("insert_new_style, free-ing garbage\n");
	DEBUG_MSG("insert_new_style, garbage=%p, lenght=%d\n", garbage, g_list_length(garbage));
	if (garbage)
		free_stringlist(garbage);
	garbage = NULL;
	g_free(ds);
}
