/* Bluefish HTML Editor
 * html.c - menu/toolbar callbacks, inserting functions, and other cool stuff 
 *
 * Copyright (C) 
 * 1998 Olivier Sessink and Chris Mazuc
 * 1999-2000 Olivier Sessink
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/* 
 * Changes by Antti-Juhani Kaijanaho <gaia@iki.fi> on 1999-10-20
 * $Id: html.c,v 0.6 1999/11/13 11:25:07 villain Exp $
 */

#include <stdio.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <string.h>
#include <stdlib.h>
#include <time.h>

#include <locale.h>
#include <libintl.h>
#include "intl.h"

#include "cap.h"
#include "config.h"

#include "bluefish.h"
#include "widgets.h"
#include "html.h"
#include "init.h"
#include "gtk_easy.h"
#include "coloursel.h"
#include "toolbars.h"
#include "undo.h"
#include "interface.h"
#include "images.h"
#include "callbacks.h"
#include "snr.h"
#include "wizards.h"
#include "stringlist.h"
#include "debug.h"

/* time insert struct */
typedef struct {
	GtkWidget *check[6];
	GtkWidget *label[6];
	GtkWidget *dialog;
} TimeInsert;
GtkWidget *dialog, *vbox, *hbox, *okbutton, *cancelbutton, *label, *dialogtable;
GtkWidget *textentry1, *textentry2, *textentry3, *textentry4, *spin1, *spin2;
GtkWidget *scrollbar, *checkbox1, *checkbox2, *radio1, *radio2, *spin3, *spin4;
GtkWidget *radio0, *radio3, *radio4, *radio5, *radio6, *radio7, *radio8, *radio9, *box;
GtkWidget *frame1, *frame2;
GtkWidget *combo1, *combo2, *combo3, *combo4, *combo5;
GtkWidget *clist1;

GtkAdjustment *adj;

/*****************************************************************************/
/* function declarations */

void general_html_cb(GtkWidget * widget, gpointer data);
Treplacerange *values_for_dialog(gchar * dialogitems[], gchar * dialogvalues[]
								 , gchar ** custom, Ttagpopup * data);
void init_values_for_dialog(gchar * dialogitems[], gchar * dialogvalues[]);
void parse_integer_for_dialog(gchar * valuestring, GtkWidget * spin, GtkWidget * entry, GtkWidget * checkbox);
void parse_existence_for_dialog(gchar * valuestring, GtkWidget * checkbox);
gchar *insert_integer_if_spin(GtkWidget * spin, gchar * itemname, gchar * string2add2, GtkWidget * percentage);
gchar *insert_string_if_entry(GtkWidget * entry, gchar * itemname, gchar * string2add2);
void new_dtd_cb(GtkWidget * widget, gpointer data);
void dtd_cb(GtkWidget * widget, gpointer data);
void dtd_cb_ok(GtkWidget * widget, gpointer data);
void head_cb(GtkWidget * widget, gpointer data);
void head_cb_new_list(GtkWidget * widget, gpointer data);
void head_cb_ok(GtkWidget * widget, gpointer data);
void body_cb(GtkWidget * widget, gpointer data);
void quickanchor_cb(GtkWidget * widget, gpointer data);
void quickrule_cb(GtkWidget * widget, gpointer data);
void email_cb(GtkWidget * widget, gpointer data);
void fontdialog_cb(GtkWidget * widget, gpointer data);
void basefont_cb(GtkWidget * widget, gpointer data);
void tabledialog_cb(GtkWidget * widget, gpointer data);
void tablerowdialog_cb(GtkWidget * widget, gpointer data);
void tableheaddialog_cb(GtkWidget * widget, gpointer data);
void tabledatadialog_cb(GtkWidget * widget, gpointer data);
void framesetdialog_cb(GtkWidget * widget, gpointer data);
void framedialog_cb(GtkWidget * widget, gpointer data);
void formdialog_cb(GtkWidget * widget, gpointer data);
void submitdialog_cb(GtkWidget * widget, gpointer data);
void resetdialog_cb(GtkWidget * widget, gpointer data);
void textareadialog_cb(GtkWidget * widget, gpointer data);
void hiddendialog_cb(GtkWidget * widget, gpointer data);
void textdialog_cb(GtkWidget * widget, gpointer data);
void radiodialog_cb(GtkWidget * widget, gpointer data);
void checkdialog_cb(GtkWidget * widget, gpointer data);
void selectdialog_cb(GtkWidget * widget, gpointer data);
void quicklist_cb(GtkWidget * widget, gpointer data);
void meta_cb(GtkWidget * widget, gpointer data);
void embed_cb(GtkWidget * widget, gpointer data);
void sel_colour_cb(GtkWidget * widget, gpointer data);
gchar *extract_time_string(char *original_string);
void insert_time_callback(GtkWidget * widget, TimeInsert * timeinsert);
void insert_time_cancel(GtkWidget * widget, TimeInsert * data);
void insert_time_cb(GtkWidget * widget, gpointer data);
void create_buttons(GtkSignalFunc ok_func, gpointer ok_data);
void create_dialog(int width, int height, gchar * title);
void destroy_dialog(void);
gchar *converttohex(gchar * color);
void quickanchorok(GtkWidget * widget, gpointer data);
void quickruleok(GtkWidget * widget, gpointer data);
void bodyok(GtkWidget * widget, gpointer data);
void emailok(void);
void fontok(GtkWidget * widget, gpointer data);
void basefontok(GtkWidget * widget, gpointer data);
void formok(GtkWidget * widget, gpointer data);
void submitok(GtkWidget * widget, gpointer data);
void resetok(GtkWidget * widget, gpointer data);
void textok(GtkWidget * widget, gpointer data);
void hiddenok(GtkWidget * widget, gpointer data);
void textareaok(GtkWidget * widget, gpointer data);
void selectok(GtkWidget * widget, gpointer data);
void radiook(GtkWidget * widget, gpointer data);
void checkok(GtkWidget * widget, gpointer data);
void quicklistok(GtkWidget * widget, gpointer data);
void metaok(GtkWidget * widget, gpointer data);
void embedok(GtkWidget * widget, gpointer data);
void tabledialogok(GtkWidget * widget, gpointer data);
void tablerowdialogok(GtkWidget * widget, gpointer data);
void tablehead_cberdialogok(GtkWidget * widget, gpointer data);
void tabledatadialogok(GtkWidget * widget, gpointer data);
void framesetdialogok(GtkWidget * widget, gpointer data);
void framedialogok(GtkWidget * widget, gpointer data);
GtkWidget *color_but_new(GtkWidget * which_entry, GtkWidget * win);
void color_but_clicked(GtkWidget * widget, GtkWidget * entry);
GtkWidget *file_but_new(GtkWidget * which_entry, GtkWidget * win, gint full_pathname);
void file_but_clicked(GtkWidget * widget, GtkWidget * which_entry);
void file_but_clicked_full(GtkWidget * widget, GtkWidget * which_entry);


/*****************************************************************************/
/* used by a lot of the callbacks */
gchar *stuff;

/* full_li, full_p  - initialized in init.c */
gint full_p, full_li;

/* stuff in html.h - used by the menus and toolbars */
void general_html_cb(GtkWidget * widget, gpointer data)
{
	gchar *tmp;
	switch ((int) data) {
	case 1:
		insert_text(cap("<B>"), cap("</B>"));
		break;
	case 2:
		insert_text(cap("<I>"), cap("</I>"));
		break;
	case 3:
		insert_text(cap("<U>"), cap("</U>"));
		break;
	case 4:
		insert_text(cap("<S>"), cap("</S>"));
		break;
	case 5:
		insert_text(cap("<P>"), full_p == 1 ? cap("</P>") : "");
		break;
	case 6:
		insert_text(cap("<BR>"), "");
		break;
	case 7:
		insert_text("&nbsp;", "");
		break;
	case 8:
		insert_text(cap("<CENTER>"), cap("</CENTER>"));
		break;
	case 9:
		insert_text(cap("<P ALIGN=\"RIGHT\">"), full_p == 1 ? cap("</P>") : "");
		break;
	case 10:
		insert_text("<!--", "-->");
		break;
	case 11:
		insert_text(cap("<FONT SIZE=\"+1\">"), cap("</FONT>"));
		break;
	case 12:
		insert_text(cap("<FONT SIZE=\"-1\">"), cap("</FONT>"));
		break;
	case 13:
		insert_text(cap("<PRE>"), cap("</PRE>"));
		break;
	case 14:
		insert_text(cap("<SUB>"), cap("</SUB>"));
		break;
	case 15:
		insert_text(cap("<SUP>"), cap("</SUP>"));
		break;
	case 16:
		insert_text(cap("<STRONG>"), cap("</STRONG>"));
		break;
	case 17:
		insert_text(cap("<EM>"), cap("</EM>"));
		break;
	case 18:
		insert_text(cap("<H1>"), cap("</H1>"));
		break;
	case 19:
		insert_text(cap("<H2>"), cap("</H2>"));
		break;
	case 20:
		insert_text(cap("<H3>"), cap("</H3>"));
		break;
	case 21:
		insert_text(cap("<H4>"), cap("</H4>"));
		break;
	case 22:
		insert_text(cap("<H5>"), cap("</H5>"));
		break;
	case 23:
		insert_text(cap("<H6>"), cap("</H6>"));
		break;
	case 24:
		insert_text(cap("<TABLE>"), cap("</TABLE>"));
		break;
	case 25:
		insert_text(cap("<TR>"), cap("</TR>"));
		break;
	case 26:
		insert_text(cap("<TH>"), cap("</TH>"));
		break;
	case 27:
		insert_text(cap("<TD>"), cap("</TD>"));
		break;
	case 28:
		insert_text(cap("<CAPTION>"), cap("</CAPTION>"));
		break;
	case 29:
		insert_text(cap("<FRAMESET>"), cap("</FRAMESET>"));
		break;
	case 30:
		insert_text(cap("<FRAME>"), "");
		break;
	case 31:
		insert_text(cap("<NOFRAMES>"), cap("</NOFRAMES>"));
		break;
	case 32:
		insert_text(cap("<BASE TARGET=\""), "\">");
		break;
	case 33:
		insert_text(cap("<UL>"), cap("</UL>"));
		break;
	case 34:
		insert_text(cap("<OL>"), cap("</OL>"));
		break;
	case 35:
		insert_text(cap("<LI>"), full_li == 1 ? cap("</LI>") : "");
		break;
	case 36:
		insert_text(cap("<DL>\n\t<DT><DD>\n</DL>"), "\n");
		break;
	case 37:
		insert_text(cap("<DT>"), "");
		break;
	case 38:
		insert_text(cap("<DD>"), "");
		break;
	case 39:
		insert_text(cap("<MENU>"), cap("</MENU>"));
		break;
	case 40:
		insert_text(cap("<MAP NAME=\""), cap("\">\n\t<AREA SHAPE=\"\" COORDS=\"\" HREF=\"\">\n</MAP>\n"));
		break;
	case 41:
		insert_text(cap("<BR CLEAR=ALL>"), "");
		break;
	case 42:
		/* the text/css should be always lowercase! */
		tmp = g_strdup_printf("<%s=\"text/css\"><!--\n", cap("STYLE TYPE"));
		insert_text(tmp, cap("\n--></STYLE>"));
		g_free(tmp);
		break;
	case 43:
		insert_text(cap("<NOBR>"), cap("</NOBR>"));
		break;
	case 44:
		tmp = g_strdup_printf("<%s=\"javascript\"><!--\n", cap("SCRIPT LANGUAGE"));
		insert_text(tmp, cap("\n//--></SCRIPT>"));
		g_free(tmp);
		break;
	case 45:
		tmp = g_strdup_printf("<%s=\"javascript\" %s=\"\">", cap("SCRIPT LANGUAGE"), cap("SRC"));
		insert_text(tmp, cap("</SCRIPT>"));
		g_free(tmp);
		break;
	case 46:
		tmp = g_strdup_printf("<%s=\"stylesheet\" %s=\"\">", cap("LINK REL"), cap("HREF"));
		insert_text(tmp, "");
		g_free(tmp);
		break;
	default:
		break;
	}
}

/************************************************************************/

Treplacerange *values_for_dialog(gchar * dialogitems[], gchar * dialogvalues[]
								 , gchar ** custom, Ttagpopup * data)
{

	gint count;
	gchar *customnew;
	GList *tmplist;
	gboolean found = FALSE;
	Treplacerange *replace_range = NULL;

	DEBUG_MSG("values_for_dialog, started\n");
	*custom = g_strdup("");
	count = 0;
	init_values_for_dialog(dialogitems, dialogvalues);
	tmplist = g_list_first(data->taglist);
	DEBUG_MSG("values_for_dialog, 1\n");
	while (tmplist) {
		DEBUG_MSG("values_for_dialog, 2\n");
		count = 0;
		found = FALSE;
		while (dialogitems[count]) {
			if (strcmp(((Ttagitem *) tmplist->data)->item, dialogitems[count]) == 0) {
				DEBUG_MSG("values_for_dialog, string found!, dialogitems[%d]=%s\n", count, dialogitems[count]);
				dialogvalues[count] = ((Ttagitem *) tmplist->data)->value;
				DEBUG_MSG("values_for_dialog, *dialogvalues[%d]=%s\n", count, dialogvalues[count]);
				found = TRUE;
			}
			count++;
		}
		if (!found) {
			customnew = g_strjoin(NULL, *custom, " ", ((Ttagitem *) tmplist->data)->item, NULL);
			if (*custom)
				g_free(*custom);
			*custom = customnew;
			if (((Ttagitem *) tmplist->data)->value) {
				customnew = g_strjoin(NULL, *custom, "=\"", ((Ttagitem *) tmplist->data)->value, "\"", NULL);
				if (*custom)
					g_free(*custom);
				*custom = customnew;
			}
		}
		tmplist = g_list_next(tmplist);
	}
	DEBUG_MSG("values_for_dialog, 3\n");
	replace_range = g_malloc(sizeof(Treplacerange));
	replace_range->pos = data->pos;
	replace_range->len = data->len;
	DEBUG_MSG("values_for_dialog, about to return %p\n", replace_range);
	return replace_range;
}

/************************************************************************/

void init_values_for_dialog(gchar * dialogitems[], gchar * dialogvalues[])
{

	gint count = 0;
	while (dialogitems[count]) {
		dialogvalues[count] = NULL;
		count++;
	}
}

/************************************************************************/

void parse_integer_for_dialog(gchar * valuestring, GtkWidget * spin, GtkWidget * entry, GtkWidget * checkbox)
{

	gchar *tmp;
	gint value = 0;
	gboolean found = FALSE;
	gchar *sign = NULL;
	gboolean percentage = FALSE;

	DEBUG_MSG("parse_integer_for_dialog, started, valuestring=%s\n", valuestring);
	if (!valuestring) {
		if (spin)
			gtk_entry_set_text(GTK_ENTRY(GTK_SPIN_BUTTON(spin)), "");
		if (entry)
			gtk_entry_set_text(GTK_ENTRY(entry), "");
		return;
	}
	tmp = strrchr(valuestring, '-');
	if (tmp) {
		DEBUG_MSG("parse_integer_for_dialog, found a -!, tmp=%s\n", tmp);
		value = strtod(++tmp, NULL);
		sign = "-";
		found = TRUE;
		DEBUG_MSG("parse_integer_for_dialog, value=%d\n", value);
	}
	tmp = strrchr(valuestring, '+');
	if (tmp) {
		DEBUG_MSG("parse_integer_for_dialog, found a +!, tmp=%s\n", tmp);
		value = strtod(++tmp, NULL);
		sign = "+";
		found = TRUE;
		DEBUG_MSG("parse_integer_for_dialog, value=%d\n", value);
	}
	tmp = strchr(valuestring, '%');
	if (tmp) {
		DEBUG_MSG("parse_integer_for_dialog, found a percentage!\n");
		valuestring = trunc_on_char(valuestring, '%');
		value = strtod(valuestring, NULL);
		percentage = TRUE;
		found = TRUE;
		DEBUG_MSG("parse_integer_for_dialog, value=%d\n", value);
	}
	if (!found) {
		value = strtod(valuestring, NULL);
	}
	if (spin)
		gtk_spin_button_set_value(GTK_SPIN_BUTTON(spin), value);

	if (entry) {
		if (sign) {
			gtk_entry_set_text(GTK_ENTRY(entry), sign);
		} else {
			gtk_entry_set_text(GTK_ENTRY(entry), "");
		}
	}

	if (checkbox) {
		DEBUG_MSG("parse_integer_for_dialog, checkbox set\n");
		gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(checkbox), percentage);
	} else {
		DEBUG_MSG("parse_integer_for_dialog, NO checkbox set\n");
	}
}

/************************************************************************/
void parse_existence_for_dialog(gchar * valuestring, GtkWidget * checkbox)
{

	if (valuestring) {
		gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(checkbox), TRUE);
		DEBUG_MSG("parse_existence_for_dialog, checkbox set YES, valuestring=%p\n", valuestring);
	} else {
		DEBUG_MSG("parse_existence_for_dialog, NO checkbox set, valuestring=%p\n", valuestring);
	}
}

/************************************************************************/
gchar *insert_integer_if_spin(GtkWidget * spin, gchar * itemname, gchar * string2add2, GtkWidget * percentage)
{

	gchar *tempstring;

	if (strlen(gtk_entry_get_text(GTK_ENTRY(spin)))) {
		if ((percentage) && (GTK_TOGGLE_BUTTON(percentage)->active)) {
			tempstring = g_strdup_printf("%s %s=\"%d%%\"", string2add2, itemname, gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(spin)));
		} else {
			tempstring = g_strdup_printf("%s %s=\"%d\"", string2add2, itemname, gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(spin)));
		}
		g_free(string2add2);
		string2add2 = tempstring;
	}
	return string2add2;
}

/************************************************************************/
gchar *insert_string_if_entry(GtkWidget * entry, gchar * itemname, gchar * string2add2)
{

	gchar *tempstring;

	if (strlen(gtk_entry_get_text(GTK_ENTRY(entry)))) {
		tempstring = g_strdup_printf("%s %s=\"%s\"", string2add2, itemname, gtk_entry_get_text(GTK_ENTRY(entry)));
		g_free(string2add2);
		string2add2 = tempstring;
	}
	return string2add2;

}

/************************************************************************/
void new_dtd_cb(GtkWidget * widget, gpointer data)
{
	if (GTK_TOGGLE_BUTTON(radio0)->active) {
		gtk_widget_set_sensitive(radio6, 0);
		gtk_widget_set_sensitive(radio7, 0);
		gtk_widget_set_sensitive(radio8, 0);
		gtk_widget_set_sensitive(radio9, 0);
		gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(combo1)->entry), "");
	} else if (GTK_TOGGLE_BUTTON(radio1)->active) {
		gtk_widget_set_sensitive(radio6, 1);
		gtk_widget_set_sensitive(radio7, 0);
		gtk_widget_set_sensitive(radio8, 0);
		gtk_widget_set_sensitive(radio9, 0);
		if (widget == radio1) {
			gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(radio5), TRUE);
		}
		if (GTK_TOGGLE_BUTTON(radio5)->active) {
			gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(combo1)->entry), "<!DOCTYPE HTML PUBLIC \"-//IETF//DTD HTML Level 2//EN//2.0\">");
		} else if (GTK_TOGGLE_BUTTON(radio6)->active) {
			gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(combo1)->entry), "<!DOCTYPE HTML PUBLIC \"-//IETF//DTD HTML Strict Level 2//EN\">");
		}
	} else if (GTK_TOGGLE_BUTTON(radio2)->active) {
		gtk_widget_set_sensitive(radio6, 1);
		gtk_widget_set_sensitive(radio7, 0);
		gtk_widget_set_sensitive(radio8, 0);
		gtk_widget_set_sensitive(radio9, 0);
		if (widget == radio2) {
			gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(radio5), TRUE);
		}
		if (GTK_TOGGLE_BUTTON(radio5)->active) {
			gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(combo1)->entry), "<!DOCTYPE HTML PUBLIC \"-//IETF//DTD HTML Level 3//EN//3.0\">");
		} else if (GTK_TOGGLE_BUTTON(radio6)->active) {
			gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(combo1)->entry), "<!DOCTYPE HTML PUBLIC \"-//IETF//DTD HTML Strict Level 3//EN\">");
		}
	} else if (GTK_TOGGLE_BUTTON(radio3)->active) {
		gtk_widget_set_sensitive(radio6, 0);
		gtk_widget_set_sensitive(radio7, 1);
		gtk_widget_set_sensitive(radio8, 0);
		gtk_widget_set_sensitive(radio9, 1);
		if (widget == radio3) {
			gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(radio5), TRUE);
		}
		if (GTK_TOGGLE_BUTTON(radio5)->active) {
			gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(combo1)->entry), "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 3.2//EN\">");
		} else if (GTK_TOGGLE_BUTTON(radio7)->active) {
			gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(combo1)->entry), "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 3.2 Final//EN\">");
		} else if (GTK_TOGGLE_BUTTON(radio9)->active) {
			gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(combo1)->entry), "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 3.2 Draft//EN\">");
		}
	} else if (GTK_TOGGLE_BUTTON(radio4)->active) {
		gtk_widget_set_sensitive(radio6, 0);
		gtk_widget_set_sensitive(radio7, 0);
		gtk_widget_set_sensitive(radio8, 1);
		gtk_widget_set_sensitive(radio9, 0);
		if (widget == radio4) {
			gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(radio5), TRUE);
		}
		if (GTK_TOGGLE_BUTTON(radio5)->active) {
			gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(combo1)->entry), "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0//EN\">");
		} else if (GTK_TOGGLE_BUTTON(radio8)->active) {
			gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(combo1)->entry), "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\">");
		}
	}
}

/************************************************************************/

void dtd_cb(GtkWidget * widget, gpointer data)
{
	create_dialog(450, 209, _("Quick Start - Document Type Definition Selection"));
	dialogtable = gtk_table_new(7, 4, 1);
	gtk_table_set_col_spacings(GTK_TABLE(dialogtable), 10);
	gtk_box_pack_start(GTK_BOX(vbox), dialogtable, FALSE, FALSE, 0);

	frame1 = gtk_frame_new(_("HTML Version"));
	gtk_container_set_border_width(GTK_CONTAINER(frame1), 10);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), frame1, 0, 2, 0, 6);
	gtk_container_border_width(GTK_CONTAINER(frame1), 0);

	box = gtk_vbox_new(FALSE, 0);
	gtk_container_add(GTK_CONTAINER(frame1), box);
	gtk_container_border_width(GTK_CONTAINER(box), 0);
	radio1 = gtk_radio_button_new_with_label(NULL, "2.0");
	radio0 = gtk_radio_button_new_with_label(gtk_radio_button_group(GTK_RADIO_BUTTON(radio1)), _("Don't use a DTD"));
	radio2 = gtk_radio_button_new_with_label(gtk_radio_button_group(GTK_RADIO_BUTTON(radio1)), _("3.0"));
	radio3 = gtk_radio_button_new_with_label(gtk_radio_button_group(GTK_RADIO_BUTTON(radio1)), _("3.2"));
	radio4 = gtk_radio_button_new_with_label(gtk_radio_button_group(GTK_RADIO_BUTTON(radio1)), _("4.0"));
	gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(radio0), TRUE);

	gtk_signal_connect(GTK_OBJECT(radio0), "toggled", GTK_SIGNAL_FUNC(new_dtd_cb), NULL);
	gtk_signal_connect(GTK_OBJECT(radio1), "toggled", GTK_SIGNAL_FUNC(new_dtd_cb), NULL);
	gtk_signal_connect(GTK_OBJECT(radio2), "toggled", GTK_SIGNAL_FUNC(new_dtd_cb), NULL);
	gtk_signal_connect(GTK_OBJECT(radio3), "toggled", GTK_SIGNAL_FUNC(new_dtd_cb), NULL);
	gtk_signal_connect(GTK_OBJECT(radio4), "toggled", GTK_SIGNAL_FUNC(new_dtd_cb), NULL);

	gtk_box_pack_start(GTK_BOX(box), radio0, FALSE, FALSE, 0);
	gtk_box_pack_start(GTK_BOX(box), radio1, FALSE, FALSE, 0);
	gtk_box_pack_start(GTK_BOX(box), radio2, FALSE, FALSE, 0);
	gtk_box_pack_start(GTK_BOX(box), radio3, FALSE, FALSE, 0);
	gtk_box_pack_start(GTK_BOX(box), radio4, FALSE, FALSE, 0);

	frame2 = gtk_frame_new("Type");
	gtk_container_set_border_width(GTK_CONTAINER(frame2), 10);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), frame2, 2, 4, 0, 6);
	gtk_container_border_width(GTK_CONTAINER(frame2), 0);

	box = gtk_vbox_new(FALSE, 0);
	gtk_container_add(GTK_CONTAINER(frame2), box);
	gtk_container_border_width(GTK_CONTAINER(box), 0);

	radio5 = gtk_radio_button_new_with_label(NULL, _("Basic"));
	radio6 = gtk_radio_button_new_with_label(gtk_radio_button_group(GTK_RADIO_BUTTON(radio5)), _("Strict"));
	radio7 = gtk_radio_button_new_with_label(gtk_radio_button_group(GTK_RADIO_BUTTON(radio5)), _("Final"));
	radio8 = gtk_radio_button_new_with_label(gtk_radio_button_group(GTK_RADIO_BUTTON(radio5)), _("Transitional"));
	radio9 = gtk_radio_button_new_with_label(gtk_radio_button_group(GTK_RADIO_BUTTON(radio5)), _("Draft"));
	gtk_signal_connect(GTK_OBJECT(radio5), "toggled", GTK_SIGNAL_FUNC(new_dtd_cb), NULL);
	gtk_signal_connect(GTK_OBJECT(radio6), "toggled", GTK_SIGNAL_FUNC(new_dtd_cb), NULL);
	gtk_signal_connect(GTK_OBJECT(radio7), "toggled", GTK_SIGNAL_FUNC(new_dtd_cb), NULL);
	gtk_signal_connect(GTK_OBJECT(radio8), "toggled", GTK_SIGNAL_FUNC(new_dtd_cb), NULL);
	gtk_signal_connect(GTK_OBJECT(radio9), "toggled", GTK_SIGNAL_FUNC(new_dtd_cb), NULL);
	gtk_widget_set_sensitive(radio7, 0);
	gtk_widget_set_sensitive(radio8, 0);
	gtk_widget_set_sensitive(radio9, 0);
	gtk_box_pack_start(GTK_BOX(box), radio5, FALSE, FALSE, 0);
	gtk_box_pack_start(GTK_BOX(box), radio6, FALSE, FALSE, 0);
	gtk_box_pack_start(GTK_BOX(box), radio7, FALSE, FALSE, 0);
	gtk_box_pack_start(GTK_BOX(box), radio8, FALSE, FALSE, 0);
	gtk_box_pack_start(GTK_BOX(box), radio9, FALSE, FALSE, 0);

	combo1 = gtk_combo_new();
	if (main_v->current_project.dtd_cblist) {
		gtk_combo_set_popdown_strings(GTK_COMBO(combo1), main_v->current_project.dtd_cblist);
	}
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), combo1, 0, 4, 6, 7);

	create_buttons(GTK_SIGNAL_FUNC(dtd_cb_ok), GPOINTER_TO_INT(data) == 1 ? GINT_TO_POINTER(1) : GINT_TO_POINTER(0));
}

/************************************************************************/
void dtd_cb_ok(GtkWidget * widget, gpointer data)
{
	/* if data==1 then part of quickstart dialog */
	main_v->current_project.dtd_cblist =
		add_to_stringlist(main_v->current_project.dtd_cblist, gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(combo1)->entry)));
	stuff = g_strdup_printf("%s\n%s\n\n", gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(combo1)->entry)), cap("<HTML>"));
	insert_text(stuff, cap("\n</HTML>"));
	g_free(stuff);
	stuff = NULL;
	destroy_dialog();
	if (GPOINTER_TO_INT(data) == 1) {
		head_cb(widget, GINT_TO_POINTER(1));
	}
}

/************************************************************************/
void head_cb(GtkWidget * widget, gpointer data)
{

	GList *tmplist;
	gchar *text[1];
	GtkWidget *scrolwin, *listbut;

	create_dialog(0, 0, _("Head"));
	gtk_box_pack_start(GTK_BOX(vbox), gtk_label_new(_("Title")), FALSE, FALSE, 0);
	textentry1 = gtk_entry_new_with_max_length(256);
	gtk_box_pack_start(GTK_BOX(vbox), textentry1, FALSE, FALSE, 0);
	gtk_box_pack_start(GTK_BOX(vbox), gtk_label_new(_("Meta tags")), FALSE, FALSE, 0);
	scrolwin = gtk_scrolled_window_new(NULL, NULL);
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrolwin), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
	gtk_box_pack_start(GTK_BOX(vbox), scrolwin, TRUE, TRUE, 0);
	clist1 = gtk_clist_new(1);
	gtk_clist_set_selection_mode(GTK_CLIST(clist1), GTK_SELECTION_MULTIPLE);
	gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(scrolwin), clist1);
	gtk_clist_freeze(GTK_CLIST(clist1));
	tmplist = g_list_first(main_v->current_project.metalist);
	while (tmplist) {
		text[0] = tmplist->data;
		gtk_clist_append(GTK_CLIST(clist1), text);
		tmplist = g_list_next(tmplist);
	}
	gtk_clist_thaw(GTK_CLIST(clist1));
	listbut = gtk_button_new_with_label(_("Edit meta tags"));
	gtk_signal_connect(GTK_OBJECT(listbut), "clicked", GTK_SIGNAL_FUNC(head_cb_new_list), NULL);
	gtk_box_pack_start(GTK_BOX(vbox), listbut, TRUE, TRUE, 0);
	create_buttons(GTK_SIGNAL_FUNC(head_cb_ok), GPOINTER_TO_INT(data) == 1 ? GINT_TO_POINTER(1) : GINT_TO_POINTER(0));
}

/************************************************************************/
void head_cb_new_list(GtkWidget * widget, gpointer data)
{
	GList *tmplist;
	gchar *text[1];

	main_v->current_project.metalist = edit_stringlist(main_v->current_project.metalist, "Bluefish project - metalist", 6);
	gtk_clist_freeze(GTK_CLIST(clist1));
	gtk_clist_clear(GTK_CLIST(clist1));
	tmplist = g_list_first(main_v->current_project.metalist);
	while (tmplist) {
		text[0] = tmplist->data;
		gtk_clist_append(GTK_CLIST(clist1), text);
		tmplist = g_list_next(tmplist);
	}
	gtk_clist_thaw(GTK_CLIST(clist1));
}

/************************************************************************/
void head_cb_ok(GtkWidget * widget, gpointer data)
{
	GList *tmplist;
	gchar *text, *tmpstring = NULL, *tmpstring2 = NULL;

	tmplist = g_list_first(GTK_CLIST(clist1)->selection);
	tmpstring2 = g_strdup(cap("<HEAD>\n"));
	while (tmplist) {
		DEBUG_MSG("tmplist->data=%d\n", GPOINTER_TO_INT(tmplist->data));
		gtk_clist_get_text(GTK_CLIST(clist1), GPOINTER_TO_INT(tmplist->data), 0, &text);
		tmpstring = g_strconcat(tmpstring2, text, "\n", NULL);
		g_free(tmpstring2);
		tmpstring2 = tmpstring;
		tmplist = g_list_next(tmplist);
	}
	stuff = g_strdup_printf("%s%s%s%s", tmpstring2, cap("<TITLE>"), gtk_entry_get_text(GTK_ENTRY(textentry1)), cap("</TITLE>\n</HEAD>\n")
		);
	g_free(tmpstring2);
	insert_text(stuff, "");
	g_free(stuff);
	stuff = NULL;
	destroy_dialog();
	if (GPOINTER_TO_INT(data) == 1) {
		body_cb(widget, GINT_TO_POINTER(1));
	}
}

/************************************************************************/

void body_cb(GtkWidget * widget, gpointer data)
{
	static gchar *bodyitems[] = { "background", "bgcolor", "text", "link", "vlink", "alink", NULL };

	GtkWidget *color_but, *file_but;
	gchar *bodyvalues[7];
	gchar *custom = NULL;
	Treplacerange *replace_range = NULL;

	/* this is for the right click menu */
	DEBUG_MSG("body_cb, data=%p, widget=%p\n", data, widget);
	if ((data != NULL) && (widget == NULL)) {
		DEBUG_MSG("body_cb, bodyitems=%p, bodyvalues=%p, bodyvalues=%p\n", bodyitems, bodyvalues, bodyvalues);
		replace_range = values_for_dialog(bodyitems, bodyvalues, &custom, (Ttagpopup *) data);
	} else {
		init_values_for_dialog(bodyitems, bodyvalues);
	}
	/* end for the right click menu */

	create_dialog(500, 190, _("Body"));
	dialogtable = gtk_table_new(7, 10, 0);
	gtk_box_pack_start(GTK_BOX(vbox), dialogtable, FALSE, FALSE, 0);

	textentry1 = gtk_entry_new_with_max_length(256);
	gtk_entry_set_text(GTK_ENTRY(textentry1), bodyvalues[0]);
	file_but = file_but_new(textentry1, dialog, 0);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), GTK_WIDGET(file_but), 9, 10, 0, 1);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("Background Image")), 0, 1, 0, 1);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), textentry1, 1, 9, 0, 1);

	combo1 = combo_with_popdown(bodyvalues[1], main_v->current_project.colorlist, 1);
	color_but = color_but_new(GTK_COMBO(combo1)->entry, dialog);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), GTK_WIDGET(color_but), 9, 10, 1, 2);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), GTK_WIDGET(GTK_COMBO(combo1)), 1, 9, 1, 2);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("Background Color")), 0, 1, 1, 2);

	combo2 = combo_with_popdown(bodyvalues[2], main_v->current_project.colorlist, 1);
	color_but = color_but_new(GTK_COMBO(combo2)->entry, dialog);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), GTK_WIDGET(color_but), 9, 10, 2, 3);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), GTK_WIDGET(GTK_COMBO(combo2)), 1, 9, 2, 3);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("Text Color")), 0, 1, 2, 3);

	combo3 = combo_with_popdown(bodyvalues[3], main_v->current_project.colorlist, 1);
	color_but = color_but_new(GTK_COMBO(combo3)->entry, dialog);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), GTK_WIDGET(color_but), 9, 10, 3, 4);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), GTK_WIDGET(GTK_COMBO(combo3)), 1, 9, 3, 4);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("Link Color")), 0, 1, 3, 4);

	combo4 = combo_with_popdown(bodyvalues[4], main_v->current_project.colorlist, 1);
	color_but = color_but_new(GTK_COMBO(combo4)->entry, dialog);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), GTK_WIDGET(color_but), 9, 10, 4, 5);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), GTK_WIDGET(GTK_COMBO(combo4)), 1, 9, 4, 5);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("Visited Link Color")), 0, 1, 4, 5);

	combo5 = combo_with_popdown(bodyvalues[5], main_v->current_project.colorlist, 1);
	color_but = color_but_new(GTK_COMBO(combo5)->entry, dialog);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), GTK_WIDGET(color_but), 9, 10, 5, 6);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), GTK_WIDGET(GTK_COMBO(combo5)), 1, 9, 5, 6);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("Active Link Color")), 0, 1, 5, 6);

	textentry2 = entry_with_text(custom, 1024);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), GTK_WIDGET(textentry2), 1, 9, 6, 7);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("Custom values")), 0, 1, 6, 7);

	create_buttons(GTK_SIGNAL_FUNC(bodyok), (gpointer) replace_range);
	if (custom)
		g_free(custom);
}

/************************************************************************/

void quickanchor_cb(GtkWidget * widget, gpointer data)
{
	static gchar *aitems[] = { "href", "target", "name", NULL };

	GtkWidget *file_but;
	gchar *custom = NULL;
	gchar *avalues[4];
	Treplacerange *replace_range = NULL;

	if ((data != NULL) && (widget == NULL)) {
		replace_range = values_for_dialog(aitems, avalues, &custom, (Ttagpopup *) data);
	} else {
		init_values_for_dialog(aitems, avalues);
	}

	create_dialog(520, 145, _("Quick Anchor"));
	dialogtable = gtk_table_new(4, 10, 0);
	gtk_box_pack_start(GTK_BOX(vbox), dialogtable, FALSE, FALSE, 0);

	combo2 = combo_with_popdown(avalues[0], main_v->current_project.urllist, 1);
	file_but = file_but_new(GTK_WIDGET(GTK_COMBO(combo2)->entry), dialog, 0);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), GTK_WIDGET(file_but), 9, 10, 0, 1);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("HREF")), 0, 1, 0, 1);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), GTK_WIDGET(GTK_COMBO(combo2)), 1, 9, 0, 1);

	combo1 = combo_with_popdown(avalues[1], main_v->current_project.targetlist, 1);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("Target")), 0, 1, 1, 2);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), GTK_WIDGET(GTK_COMBO(combo1)), 1, 10, 1, 2);

	textentry2 = entry_with_text(avalues[2], 256);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("Name")), 0, 1, 2, 3);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), textentry2, 1, 10, 2, 3);

	textentry3 = entry_with_text(custom, 1024);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("Custom")), 0, 1, 3, 4);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), textentry3, 1, 10, 3, 4);
	create_buttons(GTK_SIGNAL_FUNC(quickanchorok), (gpointer) replace_range);
	if (custom)
		g_free(custom);
}

/************************************************************************/
void quickrule_cb(GtkWidget * widget, gpointer data)
{
	GList *popdownlist = NULL;

	static gchar *hritems[] = { "align", "size", "width", "noshade", NULL };
	gchar *hrvalues[5];
	gchar *custom = NULL;
	Treplacerange *replace_range = NULL;

	/* this is for the right click menu */
	if ((data != NULL) && (widget == NULL)) {
		replace_range = values_for_dialog(hritems, hrvalues, &custom, (Ttagpopup *) data);
	} else {
		init_values_for_dialog(hritems, hrvalues);
	}
	/* end for the right click menu */


	create_dialog(520, 152, _("Horizontal Rule"));
	dialogtable = gtk_table_new(5, 10, 0);
	gtk_box_pack_start(GTK_BOX(vbox), dialogtable, FALSE, FALSE, 0);

	popdownlist = g_list_insert(popdownlist, "center", 0);
	popdownlist = g_list_insert(popdownlist, "left", 1);
	popdownlist = g_list_insert(popdownlist, "right", 2);
	combo1 = combo_with_popdown(hrvalues[0], popdownlist, 1);
	g_list_free(popdownlist);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("Align")), 0, 1, 0, 1);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), GTK_WIDGET(GTK_COMBO(combo1)), 1, 10, 0, 1);

	adj = (GtkAdjustment *) gtk_adjustment_new((gfloat) 1, 0.0, 200.0, 1.0, 5.0, 0.0);
	spin1 = gtk_spin_button_new(adj, 1, 0);
	/* gtk_spin_button_set_numeric (GTK_SPIN_BUTTON (spin1), 1); */
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), spin1, 1, 2, 1, 2);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("Size")), 0, 1, 1, 2);
	parse_integer_for_dialog(hrvalues[1], spin1, NULL, NULL);

	adj = (GtkAdjustment *) gtk_adjustment_new((gfloat) 50, 0.0, 600.0, 1.0, 5.0, 0.0);
	spin2 = gtk_spin_button_new(adj, 1, 0);
/*   gtk_spin_button_set_numeric (GTK_SPIN_BUTTON (spin2), 1); */
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), spin2, 1, 2, 2, 3);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("Width")), 0, 1, 2, 3);

	checkbox1 = gtk_check_button_new();
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), checkbox1, 3, 4, 2, 3);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("Is percent?")), 2, 3, 2, 3);

	parse_integer_for_dialog(hrvalues[2], spin2, NULL, checkbox1);

	checkbox2 = gtk_check_button_new();
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), checkbox2, 1, 2, 3, 4);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("No shading")), 0, 1, 3, 4);

	textentry1 = entry_with_text(custom, 1024);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("Custom")), 1, 2, 4, 5);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), textentry1, 2, 10, 4, 5);
	create_buttons(GTK_SIGNAL_FUNC(quickruleok), replace_range);
	if (custom)
		g_free(custom);
}

/************************************************************************/

void email_cb(GtkWidget * widget, gpointer data)
{
	create_dialog(265, 80, _("Email"));
	hbox = gtk_hbox_new(FALSE, 5);
	gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, FALSE, 0);

	label = gtk_label_new(_("Email address:"));
	textentry1 = gtk_entry_new_with_max_length(256);
	gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 0);
	gtk_box_pack_start(GTK_BOX(hbox), textentry1, FALSE, FALSE, 0);

	create_buttons(GTK_SIGNAL_FUNC(emailok), NULL);
}

/************************************************************************/
void fontdialog_cb(GtkWidget * widget, gpointer data)
{
	GList *popdownlist = NULL;
	GtkWidget *color_but;

	static gchar *fontitems[] = { "size", "face", "color", NULL };
	gchar *fontvalues[4];
	gchar *custom = NULL;
	Treplacerange *replace_range = NULL;

	/* this is for the right click menu */
	if ((data != NULL) && (widget == NULL)) {
		replace_range = values_for_dialog(fontitems, fontvalues, &custom, (Ttagpopup *) data);
	} else {
		init_values_for_dialog(fontitems, fontvalues);
	}

	/* end for the right click menu */

	create_dialog(500, 100, _("Font"));
	dialogtable = gtk_table_new(3, 10, 0);
	gtk_box_pack_start(GTK_BOX(vbox), dialogtable, FALSE, FALSE, 0);

	popdownlist = g_list_insert(popdownlist, "+", 0);
	popdownlist = g_list_insert(popdownlist, "-", 1);
	combo1 = combo_with_popdown("", popdownlist, 0);
	g_list_free(popdownlist);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("Size")), 0, 1, 0, 1);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), GTK_WIDGET(GTK_COMBO(combo1)), 1, 2, 0, 1);

	adj = (GtkAdjustment *) gtk_adjustment_new((gfloat) 1, 0.0, 7.0, 1.0, 5.0, 0.0);
	spin1 = gtk_spin_button_new(adj, 1, 0);
	/* gtk_spin_button_set_numeric (GTK_SPIN_BUTTON (spin1), 1); */
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), spin1, 2, 3, 0, 1);

	parse_integer_for_dialog(fontvalues[0], spin1, GTK_WIDGET(GTK_COMBO(combo1)->entry), NULL);

	combo2 = combo_with_popdown(fontvalues[2], main_v->current_project.colorlist, 1);
	color_but = color_but_new(GTK_COMBO(combo2)->entry, dialog);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("Color")), 6, 7, 0, 1);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), GTK_WIDGET(GTK_COMBO(combo2)), 7, 9, 0, 1);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), GTK_WIDGET(color_but), 9, 10, 0, 1);

	combo3 = combo_with_popdown(fontvalues[1], main_v->current_project.fontlist, 1);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("Face")), 0, 1, 1, 2);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), GTK_WIDGET(GTK_COMBO(combo3)), 1, 10, 1, 2);

	textentry1 = entry_with_text(custom, 1024);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("Custom")), 1, 2, 2, 3);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), textentry1, 2, 10, 2, 3);
	create_buttons(GTK_SIGNAL_FUNC(fontok), (gpointer) replace_range);
	if (custom)
		g_free(custom);
}

/************************************************************************/
void basefont_cb(GtkWidget * widget, gpointer data)
{
	GList *popdownlist = NULL;
	GtkWidget *color_but;

	static gchar *fontitems[] = { "size", "face", "color", NULL };
	gchar *fontvalues[4];
	gchar *custom = NULL;
	Treplacerange *replace_range = NULL;

	/* this is for the right click menu */
	if ((data != NULL) && (widget == NULL)) {
		replace_range = values_for_dialog(fontitems, fontvalues, &custom, (Ttagpopup *) data);
	} else {
		init_values_for_dialog(fontitems, fontvalues);
	}

	/* end for the right click menu */

	create_dialog(500, 100, _("Base Font"));
	dialogtable = gtk_table_new(3, 10, 0);
	gtk_box_pack_start(GTK_BOX(vbox), dialogtable, FALSE, FALSE, 0);

	popdownlist = g_list_insert(popdownlist, "+", 0);
	popdownlist = g_list_insert(popdownlist, "-", 1);
	combo1 = combo_with_popdown("", popdownlist, 0);
	g_list_free(popdownlist);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("Size")), 0, 1, 0, 1);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), GTK_WIDGET(GTK_COMBO(combo1)), 1, 2, 0, 1);

	adj = (GtkAdjustment *) gtk_adjustment_new((gfloat) 1, 0.0, 7.0, 1.0, 5.0, 0.0);
	spin1 = gtk_spin_button_new(adj, 1, 0);
	/* gtk_spin_button_set_numeric (GTK_SPIN_BUTTON (spin1), 1); */
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), spin1, 2, 3, 0, 1);

	parse_integer_for_dialog(fontvalues[0], spin1, GTK_WIDGET(GTK_COMBO(combo1)->entry), NULL);

	combo2 = combo_with_popdown(fontvalues[2], main_v->current_project.colorlist, 1);
	color_but = color_but_new(GTK_COMBO(combo2)->entry, dialog);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("Color")), 6, 7, 0, 1);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), GTK_WIDGET(GTK_COMBO(combo2)), 7, 9, 0, 1);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), GTK_WIDGET(color_but), 9, 10, 0, 1);

	combo3 = combo_with_popdown(fontvalues[1], main_v->current_project.fontlist, 1);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("Face")), 0, 1, 1, 2);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), GTK_WIDGET(GTK_COMBO(combo3)), 1, 10, 1, 2);

	textentry1 = entry_with_text(custom, 1024);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("Custom")), 1, 2, 2, 3);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), textentry1, 2, 10, 2, 3);
	create_buttons(GTK_SIGNAL_FUNC(basefontok), (gpointer) replace_range);
	if (custom)
		g_free(custom);
}

/************************************************************************/
void tabledialog_cb(GtkWidget * widget, gpointer data)
{
	GList *alignlist = NULL;
	GtkWidget *color_but;

	static gchar *tagitems[] = { "cellpadding", "cellspacing", "border", "align", "valign", "bgcolor", "width", NULL };
	gchar *tagvalues[8];
	gchar *custom = NULL;
	Treplacerange *replace_range = NULL;

	/* this is for the right click menu */
	if ((data != NULL) && (widget == NULL)) {
		replace_range = values_for_dialog(tagitems, tagvalues, &custom, (Ttagpopup *) data);
	} else {
		init_values_for_dialog(tagitems, tagvalues);
	}
	/* end for the right click menu */

	create_dialog(500, 125, _("Table"));
	dialogtable = gtk_table_new(4, 12, 0);
	gtk_box_pack_start(GTK_BOX(vbox), dialogtable, FALSE, FALSE, 0);

	adj = (GtkAdjustment *) gtk_adjustment_new((gfloat) 0, 0.0, 100.0, 1.0, 5.0, 0.0);
	spin1 = gtk_spin_button_new(adj, 1, 0);

	parse_integer_for_dialog(tagvalues[0], spin1, NULL, NULL);

	gtk_spin_button_set_numeric(GTK_SPIN_BUTTON(spin1), 1);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("Cell Padding")), 0, 1, 0, 1);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), spin1, 1, 4, 0, 1);

	alignlist = g_list_append(alignlist, "left");
	alignlist = g_list_append(alignlist, "right");
	alignlist = g_list_append(alignlist, "center");
	combo1 = combo_with_popdown(tagvalues[3], alignlist, 0);
	g_list_free(alignlist);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("Align")), 4, 5, 0, 1);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), GTK_WIDGET(GTK_COMBO(combo1)), 5, 8, 0, 1);

	adj = (GtkAdjustment *) gtk_adjustment_new((gfloat) 0, 0.0, 600.0, 1.0, 5.0, 0.0);
	spin2 = gtk_spin_button_new(adj, 1, 0);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_(" Width ")), 8, 9, 0, 1);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), spin2, 9, 12, 0, 1);
/* add a checkbo here for percentages !!!!!!!!!!!!!!!! */
	parse_integer_for_dialog(tagvalues[6], spin2, NULL, NULL);

	adj = (GtkAdjustment *) gtk_adjustment_new((gfloat) 0, 0.0, 100.0, 1.0, 5.0, 0.0);
	spin3 = gtk_spin_button_new(adj, 1, 0);
	gtk_spin_button_set_numeric(GTK_SPIN_BUTTON(spin3), 1);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("Spacing")), 0, 1, 1, 2);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), spin3, 1, 4, 1, 2);
	parse_integer_for_dialog(tagvalues[1], spin3, NULL, NULL);

	combo2 = combo_with_popdown(tagvalues[4], positionlist, 1);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("VAlign")), 4, 5, 1, 2);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), GTK_WIDGET(combo2), 5, 8, 1, 2);

	adj = (GtkAdjustment *) gtk_adjustment_new((gfloat) 0, 0.0, 100.0, 1.0, 5.0, 0.0);
	spin4 = gtk_spin_button_new(adj, 1, 0);
	gtk_spin_button_set_numeric(GTK_SPIN_BUTTON(spin4), 1);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("Border")), 8, 9, 1, 2);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), spin4, 9, 12, 1, 2);
	parse_integer_for_dialog(tagvalues[2], spin4, NULL, NULL);

	combo3 = combo_with_popdown(tagvalues[5], main_v->current_project.colorlist, 1);
	color_but = color_but_new(GTK_COMBO(combo3)->entry, dialog);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("Background Color")), 0, 1, 2, 3);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), GTK_WIDGET(combo3), 1, 7, 2, 3);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), GTK_WIDGET(color_but), 7, 8, 2, 3);

	textentry1 = entry_with_text(custom, 1024);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("Custom")), 0, 1, 3, 4);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), textentry1, 1, 8, 3, 4);
	create_buttons(GTK_SIGNAL_FUNC(tabledialogok), (gpointer) replace_range);
	if (custom)
		g_free(custom);
}

/************************************************************************/
void tablerowdialog_cb(GtkWidget * widget, gpointer data)
{
	GList *alignlist = NULL;
	GtkWidget *color_but;

	static gchar *tagitems[] = { "align", "valign", "bgcolor", NULL };
	gchar *tagvalues[4];
	gchar *custom = NULL;
	Treplacerange *replace_range = NULL;

	/* this is for the right click menu */
	if ((data != NULL) && (widget == NULL)) {
		replace_range = values_for_dialog(tagitems, tagvalues, &custom, (Ttagpopup *) data);
	} else {
		init_values_for_dialog(tagitems, tagvalues);
	}
	/* end for the right click menu */


	create_dialog(300, 123, _("Table Row"));
	dialogtable = gtk_table_new(3, 10, 0);
	gtk_box_pack_start(GTK_BOX(vbox), dialogtable, FALSE, FALSE, 0);

	alignlist = g_list_insert(alignlist, "left", 0);
	alignlist = g_list_insert(alignlist, "right", 1);
	alignlist = g_list_insert(alignlist, "center", 2);
	combo1 = combo_with_popdown(tagvalues[0], alignlist, 0);
	g_list_free(alignlist);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("Align")), 0, 1, 0, 1);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), GTK_WIDGET(combo1), 1, 10, 0, 1);

	combo2 = combo_with_popdown(tagvalues[1], positionlist, 0);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("VAlign")), 0, 1, 1, 2);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), GTK_WIDGET(GTK_COMBO(combo2)), 1, 10, 1, 2);


	combo3 = combo_with_popdown(tagvalues[2], main_v->current_project.colorlist, 1);
	color_but = color_but_new(GTK_COMBO(combo3)->entry, dialog);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("Background Color")), 0, 1, 2, 3);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), GTK_WIDGET(GTK_COMBO(combo3)), 1, 9, 2, 3);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), GTK_WIDGET(color_but), 9, 10, 2, 3);

	textentry1 = entry_with_text(custom, 1024);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("Custom")), 0, 1, 3, 4);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), textentry1, 1, 8, 3, 4);
	create_buttons(GTK_SIGNAL_FUNC(tablerowdialogok), (gpointer) replace_range);
	if (custom)
		g_free(custom);
}

/************************************************************************/
void tableheaddialog_cb(GtkWidget * widget, gpointer data)
{
	GList *alignlist = NULL;

	static gchar *tagitems[] = { "width", "align", "colspan", "height", "valign", "rowspan", "bgcolor", "nowrap", NULL };
	gchar *tagvalues[9];
	gchar *custom = NULL;
	Treplacerange *replace_range = NULL;

	/* this is for the right click menu */
	if ((data != NULL) && (widget == NULL)) {
		replace_range = values_for_dialog(tagitems, tagvalues, &custom, (Ttagpopup *) data);
	} else {
		init_values_for_dialog(tagitems, tagvalues);
	}
	/* end for the right click menu */

	create_dialog(500, 123, _("Table Header"));
	dialogtable = gtk_table_new(3, 12, 0);
	gtk_box_pack_start(GTK_BOX(vbox), dialogtable, FALSE, FALSE, 0);

	adj = (GtkAdjustment *) gtk_adjustment_new((gfloat) 0, 0.0, 100.0, 1.0, 5.0, 0.0);
	spin1 = gtk_spin_button_new(adj, 1, 0);
	parse_integer_for_dialog(tagvalues[0], spin1, NULL, NULL);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("Width")), 0, 1, 0, 1);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), spin1, 1, 4, 0, 1);

	alignlist = g_list_insert(alignlist, "left", 0);
	alignlist = g_list_insert(alignlist, "right", 1);
	alignlist = g_list_insert(alignlist, "center", 2);
	alignlist = g_list_insert(alignlist, "justify", 3);
	combo1 = combo_with_popdown(tagvalues[1], alignlist, 1);
	g_list_free(alignlist);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("Align")), 4, 5, 0, 1);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), GTK_WIDGET(GTK_COMBO(combo1)), 5, 8, 0, 1);

	adj = (GtkAdjustment *) gtk_adjustment_new((gfloat) 0, 0.0, 600.0, 1.0, 5.0, 0.0);
	spin2 = gtk_spin_button_new(adj, 1, 0);
	gtk_spin_button_set_numeric(GTK_SPIN_BUTTON(spin2), 1);
	parse_integer_for_dialog(tagvalues[2], spin2, NULL, NULL);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("Col Span")), 8, 9, 0, 1);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), spin2, 9, 12, 0, 1);

	adj = (GtkAdjustment *) gtk_adjustment_new((gfloat) 0, 0.0, 100.0, 1.0, 5.0, 0.0);
	spin3 = gtk_spin_button_new(adj, 1, 0);
	parse_integer_for_dialog(tagvalues[3], spin3, NULL, NULL);
	gtk_spin_button_set_numeric(GTK_SPIN_BUTTON(spin3), 1);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("Height")), 0, 1, 1, 2);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), spin3, 1, 4, 1, 2);

	combo2 = combo_with_popdown(tagvalues[4], positionlist, 1);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("VAlign")), 4, 5, 1, 2);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), GTK_WIDGET(GTK_COMBO(combo2)), 5, 8, 1, 2);

	adj = (GtkAdjustment *) gtk_adjustment_new((gfloat) 0, 0.0, 100.0, 1.0, 5.0, 0.0);
	spin4 = gtk_spin_button_new(adj, 1, 0);
	parse_integer_for_dialog(tagvalues[5], spin4, NULL, NULL);
	gtk_spin_button_set_numeric(GTK_SPIN_BUTTON(spin4), 1);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("Row Span")), 8, 9, 1, 2);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), spin4, 9, 12, 1, 2);

	combo3 = combo_with_popdown(tagvalues[6], main_v->current_project.colorlist, 1);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("Background Color")), 0, 1, 2, 3);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), GTK_WIDGET(GTK_COMBO(combo3)), 1, 7, 2, 3);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), GTK_WIDGET(color_but_new(GTK_COMBO(combo3)->entry, dialog)), 7, 8, 2, 3);

	checkbox1 = gtk_check_button_new();
	parse_existence_for_dialog(tagvalues[7], checkbox1);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("No Wrap")), 8, 9, 2, 3);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), checkbox1, 9, 10, 2, 3);

	textentry1 = entry_with_text(custom, 1024);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("Custom")), 0, 1, 3, 4);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), textentry1, 1, 8, 3, 4);
	create_buttons(GTK_SIGNAL_FUNC(tablehead_cberdialogok), (gpointer) replace_range);
	if (custom)
		g_free(custom);
}

/************************************************************************/
void tabledatadialog_cb(GtkWidget * widget, gpointer data)
{
	GList *alignlist = NULL;


	static gchar *tagitems[] = { "width", "align", "colspan", "height", "valign", "rowspan", "bgcolor", "nowrap", NULL };
	gchar *tagvalues[9];
	gchar *custom = NULL;
	Treplacerange *replace_range = NULL;

	/* this is for the right click menu */
	if ((data != NULL) && (widget == NULL)) {
		replace_range = values_for_dialog(tagitems, tagvalues, &custom, (Ttagpopup *) data);
	} else {
		init_values_for_dialog(tagitems, tagvalues);
	}
	/* end for the right click menu */

	create_dialog(500, 123, _("Table Data"));
	dialogtable = gtk_table_new(3, 12, 0);
	gtk_box_pack_start(GTK_BOX(vbox), dialogtable, FALSE, FALSE, 0);

	adj = (GtkAdjustment *) gtk_adjustment_new((gfloat) 0, 0.0, 100.0, 1.0, 5.0, 0.0);
	spin1 = gtk_spin_button_new(adj, 1, 0);
	parse_integer_for_dialog(tagvalues[0], spin1, NULL, NULL);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("Width")), 0, 1, 0, 1);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), spin1, 1, 4, 0, 1);

	alignlist = g_list_insert(alignlist, "left", 0);
	alignlist = g_list_insert(alignlist, "right", 1);
	alignlist = g_list_insert(alignlist, "center", 2);
	alignlist = g_list_insert(alignlist, "justify", 3);
	combo1 = combo_with_popdown(tagvalues[1], alignlist, 1);
	g_list_free(alignlist);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("Align")), 4, 5, 0, 1);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), GTK_WIDGET(GTK_COMBO(combo1)), 5, 8, 0, 1);

	adj = (GtkAdjustment *) gtk_adjustment_new((gfloat) 0, 0.0, 600.0, 1.0, 5.0, 0.0);
	spin2 = gtk_spin_button_new(adj, 1, 0);
	gtk_spin_button_set_numeric(GTK_SPIN_BUTTON(spin2), 1);
	parse_integer_for_dialog(tagvalues[2], spin2, NULL, NULL);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("Col Span")), 8, 9, 0, 1);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), spin2, 9, 12, 0, 1);

	adj = (GtkAdjustment *) gtk_adjustment_new((gfloat) 0, 0.0, 100.0, 1.0, 5.0, 0.0);
	spin3 = gtk_spin_button_new(adj, 1, 0);
	parse_integer_for_dialog(tagvalues[3], spin3, NULL, NULL);
	gtk_spin_button_set_numeric(GTK_SPIN_BUTTON(spin3), 1);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("Height")), 0, 1, 1, 2);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), spin3, 1, 4, 1, 2);

	combo2 = combo_with_popdown(tagvalues[4], positionlist, 1);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("VAlign")), 4, 5, 1, 2);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), GTK_WIDGET(GTK_COMBO(combo2)), 5, 8, 1, 2);

	adj = (GtkAdjustment *) gtk_adjustment_new((gfloat) 0, 0.0, 100.0, 1.0, 5.0, 0.0);
	spin4 = gtk_spin_button_new(adj, 1, 0);
	parse_integer_for_dialog(tagvalues[5], spin4, NULL, NULL);
	gtk_spin_button_set_numeric(GTK_SPIN_BUTTON(spin4), 1);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("Row Span")), 8, 9, 1, 2);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), spin4, 9, 12, 1, 2);

	combo3 = combo_with_popdown(tagvalues[6], main_v->current_project.colorlist, 1);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("Background Color")), 0, 1, 2, 3);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), GTK_WIDGET(GTK_COMBO(combo3)), 1, 7, 2, 3);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), GTK_WIDGET(color_but_new(GTK_COMBO(combo3)->entry, dialog)), 7, 8, 2, 3);

	checkbox1 = gtk_check_button_new();
	parse_existence_for_dialog(tagvalues[7], checkbox1);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("No Wrap")), 8, 9, 2, 3);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), checkbox1, 9, 10, 2, 3);

	textentry1 = entry_with_text(custom, 1024);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("Custom")), 0, 1, 3, 4);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), textentry1, 1, 8, 3, 4);
	create_buttons(GTK_SIGNAL_FUNC(tabledatadialogok), (gpointer) replace_range);
	if (custom)
		g_free(custom);
}

/************************************************************************/
void framesetdialog_cb(GtkWidget * widget, gpointer data)
{

	static gchar *tagitems[] = { "cols", "rows", "border", "spacing", NULL };
	gchar *tagvalues[5];
	gchar *custom = NULL;
	Treplacerange *replace_range = NULL;

	/* this is for the right click menu */
	if ((data != NULL) && (widget == NULL)) {
		replace_range = values_for_dialog(tagitems, tagvalues, &custom, (Ttagpopup *) data);
	} else {
		init_values_for_dialog(tagitems, tagvalues);
	}
	/* end for the right click menu */

	create_dialog(500, 147, _("Frameset"));
	dialogtable = gtk_table_new(5, 10, 0);
	gtk_box_pack_start(GTK_BOX(vbox), dialogtable, FALSE, FALSE, 0);

	textentry1 = gtk_entry_new_with_max_length(256);
	gtk_entry_set_text(GTK_ENTRY(textentry1), tagvalues[0]);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("Cols")), 0, 2, 0, 1);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), textentry1, 2, 10, 0, 1);

	textentry2 = gtk_entry_new_with_max_length(256);
	gtk_entry_set_text(GTK_ENTRY(textentry2), tagvalues[1]);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("Rows")), 0, 2, 1, 2);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), textentry2, 2, 10, 1, 2);

	checkbox1 = gtk_check_button_new();
	parse_existence_for_dialog(tagvalues[2], checkbox1);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("Border")), 0, 2, 2, 3);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), checkbox1, 2, 4, 2, 3);

	adj = (GtkAdjustment *) gtk_adjustment_new((gfloat) 1, 0.0, 500.0, 1.0, 5.0, 0.0);
	spin1 = gtk_spin_button_new(adj, 1, 0);
	parse_integer_for_dialog(tagvalues[3], spin1, NULL, NULL);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("Spacing")), 0, 2, 3, 4);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), spin1, 2, 4, 3, 4);

	textentry3 = entry_with_text(custom, 1024);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("Custom")), 0, 1, 4, 5);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), textentry3, 1, 10, 4, 5);
	create_buttons(GTK_SIGNAL_FUNC(framesetdialogok), (gpointer) replace_range);
	if (custom)
		g_free(custom);
}

/************************************************************************/

void framedialog_cb(GtkWidget * widget, gpointer data)
{
	GList *popuplist = NULL;

	static gchar *tagitems[] =
		{ "src", "name", "frameborder", "scrolling", "marginwidth", "marginheight", "framespacing", "noresize", NULL };
	gchar *tagvalues[9];
	gchar *custom = NULL;
	Treplacerange *replace_range = NULL;

	/* this is for the right click menu */
	if ((data != NULL) && (widget == NULL)) {
		replace_range = values_for_dialog(tagitems, tagvalues, &custom, (Ttagpopup *) data);
	} else {
		init_values_for_dialog(tagitems, tagvalues);
	}
	/* end for the right click menu */


	create_dialog(500, 147, _("Frame"));
	dialogtable = gtk_table_new(5, 12, 0);
	gtk_box_pack_start(GTK_BOX(vbox), dialogtable, FALSE, FALSE, 0);

	textentry1 = gtk_entry_new_with_max_length(256);
	gtk_entry_set_text(GTK_ENTRY(textentry1), tagvalues[0]);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("Source")), 0, 1, 0, 1);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), textentry1, 1, 12, 0, 1);

	textentry2 = gtk_entry_new_with_max_length(256);
	gtk_entry_set_text(GTK_ENTRY(textentry2), tagvalues[1]);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("Name")), 0, 1, 1, 2);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), textentry2, 1, 12, 1, 2);

	label = gtk_label_new(_("Border"));
	checkbox2 = gtk_check_button_new();
	parse_existence_for_dialog(tagvalues[2], checkbox2);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("Border")), 0, 1, 3, 4);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), GTK_WIDGET(checkbox2), 1, 4, 3, 4);

	popuplist = g_list_append(popuplist, "auto");
	popuplist = g_list_append(popuplist, "yes");
	popuplist = g_list_append(popuplist, "no");
	combo2 = combo_with_popdown(tagvalues[3], popuplist, 1);
	g_list_free(popuplist);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("Scrolling ")), 0, 1, 2, 3);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), GTK_WIDGET(GTK_COMBO(combo2)), 1, 4, 2, 3);

	adj = (GtkAdjustment *) gtk_adjustment_new((gfloat) 1, 0.0, 500.0, 1.0, 5.0, 0.0);
	spin1 = gtk_spin_button_new(adj, 1, 0);
	gtk_spin_button_set_numeric(GTK_SPIN_BUTTON(spin1), 1);
	parse_integer_for_dialog(tagvalues[4], spin1, NULL, NULL);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_(" Margin Width ")), 4, 5, 2, 3);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), spin1, 5, 8, 2, 3);

	adj = (GtkAdjustment *) gtk_adjustment_new((gfloat) 1, 0.0, 500.0, 1.0, 5.0, 0.0);
	spin2 = gtk_spin_button_new(adj, 1, 0);
	parse_integer_for_dialog(tagvalues[5], spin2, NULL, NULL);
	gtk_spin_button_set_numeric(GTK_SPIN_BUTTON(spin2), 1);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_(" Margin Height ")), 8, 9, 2, 3);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), spin2, 9, 12, 2, 3);

	adj = (GtkAdjustment *) gtk_adjustment_new((gfloat) 1, 0.0, 500.0, 1.0, 5.0, 0.0);
	spin3 = gtk_spin_button_new(adj, 1, 0);
	parse_integer_for_dialog(tagvalues[5], spin3, NULL, NULL);
	gtk_spin_button_set_numeric(GTK_SPIN_BUTTON(spin3), 1);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("Spacing")), 4, 5, 3, 4);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), spin3, 5, 8, 3, 4);

	checkbox1 = gtk_check_button_new();
	parse_existence_for_dialog(tagvalues[6], checkbox1);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("No Resize")), 8, 9, 3, 4);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), checkbox1, 9, 10, 3, 4);

	textentry3 = entry_with_text(custom, 1024);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("Custom")), 0, 1, 4, 5);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), textentry3, 1, 12, 4, 5);
	create_buttons(GTK_SIGNAL_FUNC(framedialogok), (gpointer) replace_range);
	if (custom)
		g_free(custom);
}

/************************************************************************/
void formdialog_cb(GtkWidget * widget, gpointer data)
{
	GList *methodlist = NULL;
	GList *enctypelist = NULL;

	static gchar *tagitems[] = { "action", "method", "enctype", "target", NULL };
	gchar *tagvalues[5];
	gchar *custom = NULL;
	Treplacerange *replace_range = NULL;

	/* this is for the right click menu */
	if ((data != NULL) && (widget == NULL)) {
		replace_range = values_for_dialog(tagitems, tagvalues, &custom, (Ttagpopup *) data);
	} else {
		init_values_for_dialog(tagitems, tagvalues);
	}
	/* end for the right click menu */


	create_dialog(500, 123, _("Form"));
	dialogtable = gtk_table_new(4, 10, 0);
	gtk_box_pack_start(GTK_BOX(vbox), dialogtable, FALSE, FALSE, 0);

	textentry1 = entry_with_text(tagvalues[0], 256);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("Action")), 0, 1, 0, 1);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), textentry1, 1, 10, 0, 1);

	methodlist = g_list_append(methodlist, "GET");
	methodlist = g_list_append(methodlist, "POST");
	combo1 = combo_with_popdown(tagvalues[1], methodlist, 1);
	g_list_free(methodlist);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("Method")), 0, 1, 1, 2);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), GTK_WIDGET(GTK_COMBO(combo1)), 1, 2, 1, 2);

	/* I need to add more types */
	enctypelist = g_list_append(enctypelist, "application/x-www-form-urlencoded");
	enctypelist = g_list_append(enctypelist, "multipart/form-data");
	enctypelist = g_list_append(enctypelist, "text/plain");
	combo2 = combo_with_popdown(tagvalues[2], enctypelist, 1);
	g_list_free(enctypelist);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("Enctype")), 3, 4, 1, 2);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), GTK_WIDGET(combo2), 4, 10, 1, 2);

	combo3 = combo_with_popdown(tagvalues[3], main_v->current_project.targetlist, 1);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("Target")), 0, 1, 2, 3);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), GTK_WIDGET(GTK_COMBO(combo3)), 1, 10, 2, 3);

	textentry2 = entry_with_text(custom, 1024);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("Custom")), 0, 1, 3, 4);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), textentry2, 1, 12, 3, 4);
	create_buttons(GTK_SIGNAL_FUNC(formok), (gpointer) replace_range);
	if (custom)
		g_free(custom);
}

/************************************************************************/
void submitdialog_cb(GtkWidget * widget, gpointer data)
{
	create_dialog(300, 100, _("Submit"));
	dialogtable = gtk_table_new(1, 10, 0);
	gtk_box_pack_start(GTK_BOX(vbox), dialogtable, FALSE, FALSE, 0);

	label = gtk_label_new(_("Name"));
	textentry1 = gtk_entry_new_with_max_length(256);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), label, 0, 1, 0, 1);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), textentry1, 1, 10, 0, 1);
	label = gtk_label_new(_("Value"));
	textentry2 = gtk_entry_new_with_max_length(256);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), label, 0, 1, 1, 2);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), textentry2, 1, 10, 1, 2);

	create_buttons(GTK_SIGNAL_FUNC(submitok), NULL);
}

/************************************************************************/
void resetdialog_cb(GtkWidget * widget, gpointer data)
{
	create_dialog(300, 100, _("Reset"));
	dialogtable = gtk_table_new(1, 10, 0);
	gtk_box_pack_start(GTK_BOX(vbox), dialogtable, FALSE, FALSE, 0);


	label = gtk_label_new(_("Name"));
	textentry1 = gtk_entry_new_with_max_length(256);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), label, 0, 1, 0, 1);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), textentry1, 1, 10, 0, 1);
	label = gtk_label_new(_("Value"));
	textentry2 = gtk_entry_new_with_max_length(256);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), label, 0, 1, 1, 2);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), textentry2, 1, 10, 1, 2);

	create_buttons(GTK_SIGNAL_FUNC(resetok), NULL);
}

/************************************************************************/
void textareadialog_cb(GtkWidget * widget, gpointer data)
{
	static gchar *tagitems[] = { "name", "value", "rows", "cols", NULL };
	gchar *tagvalues[5];
	gchar *custom = NULL;
	Treplacerange *replace_range = NULL;

	/* this is for the right click menu */
	if ((data != NULL) && (widget == NULL)) {
		replace_range = values_for_dialog(tagitems, tagvalues, &custom, (Ttagpopup *) data);
	} else {
		init_values_for_dialog(tagitems, tagvalues);
	}
	/* end for the right click menu */


	create_dialog(300, 145, _("Text area"));
	dialogtable = gtk_table_new(5, 10, 0);
	gtk_box_pack_start(GTK_BOX(vbox), dialogtable, FALSE, FALSE, 0);

	textentry1 = entry_with_text(tagvalues[0], 256);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("Name")), 0, 1, 0, 1);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), textentry1, 1, 10, 0, 1);

	textentry2 = entry_with_text(tagvalues[1], 256);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("Value")), 0, 1, 1, 2);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), textentry2, 1, 10, 1, 2);

	adj = (GtkAdjustment *) gtk_adjustment_new((gfloat) 1, 0.0, 500.0, 1.0, 5.0, 0.0);
	spin1 = gtk_spin_button_new(adj, 1, 0);
	gtk_spin_button_set_numeric(GTK_SPIN_BUTTON(spin1), 1);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), spin1, 1, 2, 2, 3);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("Rows")), 0, 1, 2, 3);
	parse_integer_for_dialog(tagvalues[2], spin1, NULL, NULL);

	adj = (GtkAdjustment *) gtk_adjustment_new((gfloat) 1, 0.0, 500.0, 1.0, 5.0, 0.0);
	spin2 = gtk_spin_button_new(adj, 1, 0);
	gtk_spin_button_set_numeric(GTK_SPIN_BUTTON(spin2), 1);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), spin2, 1, 2, 3, 4);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("Cols")), 0, 1, 3, 4);
	parse_integer_for_dialog(tagvalues[3], spin2, NULL, NULL);

	textentry3 = entry_with_text(custom, 1024);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("Custom")), 0, 1, 4, 5);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), textentry3, 1, 10, 4, 5);
	create_buttons(GTK_SIGNAL_FUNC(textareaok), replace_range);
	if (custom)
		g_free(custom);
}

/************************************************************************/
void hiddendialog_cb(GtkWidget * widget, gpointer data)
{
	static gchar *tagitems[] = { "name", "value", "type", NULL };
	gchar *tagvalues[4];
	gchar *custom = NULL;
	Treplacerange *replace_range = NULL;

	/* this is for the right click menu */
	if ((data != NULL) && (widget == NULL)) {
		replace_range = values_for_dialog(tagitems, tagvalues, &custom, (Ttagpopup *) data);
	} else {
		init_values_for_dialog(tagitems, tagvalues);
	}
	/* end for the right click menu */


	create_dialog(300, 100, _("Hidden"));
	dialogtable = gtk_table_new(3, 10, 0);
	gtk_box_pack_start(GTK_BOX(vbox), dialogtable, FALSE, FALSE, 0);

	textentry1 = entry_with_text(tagvalues[0], 256);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("Name")), 0, 1, 0, 1);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), textentry1, 1, 10, 0, 1);

	textentry2 = entry_with_text(tagvalues[1], 256);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("Value")), 0, 1, 1, 2);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), textentry2, 1, 10, 1, 2);

	textentry3 = entry_with_text(custom, 1024);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("Custom")), 0, 1, 2, 3);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), textentry3, 1, 10, 2, 3);
	create_buttons(GTK_SIGNAL_FUNC(hiddenok), replace_range);
	if (custom)
		g_free(custom);
}

/************************************************************************/
void textdialog_cb(GtkWidget * widget, gpointer data)
{
	static gchar *tagitems[] = { "name", "value", "size", "maxlength", "type", NULL };
	gchar *tagvalues[6];
	gchar *custom = NULL;
	Treplacerange *replace_range = NULL;

	/* this is for the right click menu */
	if ((data != NULL) && (widget == NULL)) {
		replace_range = values_for_dialog(tagitems, tagvalues, &custom, (Ttagpopup *) data);
	} else {
		init_values_for_dialog(tagitems, tagvalues);
	}
	/* end for the right click menu */


	create_dialog(300, 145, _("Text"));
	dialogtable = gtk_table_new(4, 10, 0);
	gtk_box_pack_start(GTK_BOX(vbox), dialogtable, FALSE, FALSE, 0);

	textentry1 = entry_with_text(tagvalues[0], 256);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("Name")), 0, 1, 0, 1);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), textentry1, 1, 10, 0, 1);

	textentry2 = entry_with_text(tagvalues[1], 256);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("Value")), 0, 1, 1, 2);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), textentry2, 1, 10, 1, 2);

	adj = (GtkAdjustment *) gtk_adjustment_new((gfloat) 1, 0.0, 500.0, 1.0, 5.0, 0.0);
	spin1 = gtk_spin_button_new(adj, 1, 0);
	gtk_spin_button_set_numeric(GTK_SPIN_BUTTON(spin1), 1);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), spin1, 1, 2, 2, 3);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("Size")), 0, 1, 2, 3);
	parse_integer_for_dialog(tagvalues[2], spin1, NULL, NULL);

	adj = (GtkAdjustment *) gtk_adjustment_new((gfloat) 1, 0.0, 500.0, 1.0, 5.0, 0.0);
	spin2 = gtk_spin_button_new(adj, 1, 0);
	gtk_spin_button_set_numeric(GTK_SPIN_BUTTON(spin2), 1);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), spin2, 1, 2, 3, 4);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("Max Length")), 0, 1, 3, 4);
	parse_integer_for_dialog(tagvalues[3], spin2, NULL, NULL);

	textentry3 = entry_with_text(custom, 1024);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("Custom")), 0, 1, 4, 5);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), textentry3, 1, 10, 4, 5);
	create_buttons(GTK_SIGNAL_FUNC(textok), replace_range);
	if (custom)
		g_free(custom);

}

/************************************************************************/
void radiodialog_cb(GtkWidget * widget, gpointer data)
{
	static gchar *tagitems[] = { "name", "value", "checked", "type", NULL };
	gchar *tagvalues[5];
	gchar *custom = NULL;
	Treplacerange *replace_range = NULL;

	/* this is for the right click menu */
	if ((data != NULL) && (widget == NULL)) {
		replace_range = values_for_dialog(tagitems, tagvalues, &custom, (Ttagpopup *) data);
	} else {
		init_values_for_dialog(tagitems, tagvalues);
	}
	/* end for the right click menu */


	create_dialog(300, 117, _("Radio Button"));
	dialogtable = gtk_table_new(4, 10, 0);
	gtk_box_pack_start(GTK_BOX(vbox), dialogtable, FALSE, FALSE, 0);

	textentry1 = entry_with_text(tagvalues[0], 256);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("Name")), 0, 1, 0, 1);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), textentry1, 1, 10, 0, 1);

	textentry2 = entry_with_text(tagvalues[1], 256);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("Value")), 0, 1, 1, 2);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), textentry2, 1, 10, 1, 2);

	checkbox1 = gtk_check_button_new();
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), checkbox1, 1, 2, 2, 3);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("Checked")), 0, 1, 2, 3);
	parse_existence_for_dialog(tagvalues[2], checkbox1);

	textentry3 = entry_with_text(custom, 1024);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("Custom")), 0, 1, 3, 4);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), textentry3, 1, 10, 3, 4);
	create_buttons(GTK_SIGNAL_FUNC(radiook), replace_range);
	if (custom)
		g_free(custom);


}

/************************************************************************/
void checkdialog_cb(GtkWidget * widget, gpointer data)
{
	static gchar *tagitems[] = { "name", "value", "checked", "type", NULL };
	gchar *tagvalues[5];
	gchar *custom = NULL;
	Treplacerange *replace_range = NULL;

	/* this is for the right click menu */
	if ((data != NULL) && (widget == NULL)) {
		replace_range = values_for_dialog(tagitems, tagvalues, &custom, (Ttagpopup *) data);
	} else {
		init_values_for_dialog(tagitems, tagvalues);
	}
	/* end for the right click menu */


	create_dialog(300, 117, _("Check Box"));
	dialogtable = gtk_table_new(4, 10, 0);
	gtk_box_pack_start(GTK_BOX(vbox), dialogtable, FALSE, FALSE, 0);

	textentry1 = entry_with_text(tagvalues[0], 256);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("Name")), 0, 1, 0, 1);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), textentry1, 1, 10, 0, 1);

	textentry2 = entry_with_text(tagvalues[1], 256);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("Value")), 0, 1, 1, 2);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), textentry2, 1, 10, 1, 2);

	checkbox1 = gtk_check_button_new();
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), checkbox1, 1, 2, 2, 3);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("Checked")), 0, 1, 2, 3);
	parse_existence_for_dialog(tagvalues[2], checkbox1);

	textentry3 = entry_with_text(custom, 1024);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("Custom")), 0, 1, 3, 4);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), textentry3, 1, 10, 3, 4);
	create_buttons(GTK_SIGNAL_FUNC(checkok), replace_range);
	if (custom)
		g_free(custom);

}

/************************************************************************/
void selectdialog_cb(GtkWidget * widget, gpointer data)
{
	static gchar *tagitems[] = { "name", "size", "multiple", NULL };
	gchar *tagvalues[4];
	gchar *custom = NULL;
	Treplacerange *replace_range = NULL;

	/* this is for the right click menu */
	if ((data != NULL) && (widget == NULL)) {
		replace_range = values_for_dialog(tagitems, tagvalues, &custom, (Ttagpopup *) data);
	} else {
		init_values_for_dialog(tagitems, tagvalues);
	}
	/* end for the right click menu */


	create_dialog(300, 123, _("Select"));
	dialogtable = gtk_table_new(4, 10, 0);
	gtk_box_pack_start(GTK_BOX(vbox), dialogtable, FALSE, FALSE, 0);

	textentry1 = entry_with_text(tagvalues[0], 256);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("Name")), 0, 1, 0, 1);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), textentry1, 1, 10, 0, 1);

	adj = (GtkAdjustment *) gtk_adjustment_new((gfloat) 1, 0.0, 100.0, 1.0, 5.0, 0.0);
	spin1 = gtk_spin_button_new(adj, 1, 0);
	gtk_spin_button_set_numeric(GTK_SPIN_BUTTON(spin1), 1);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), spin1, 1, 2, 1, 2);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("Size")), 0, 1, 1, 2);
	parse_integer_for_dialog(tagvalues[1], spin1, NULL, NULL);

	checkbox1 = gtk_check_button_new();
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), checkbox1, 1, 2, 2, 3);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("Multiple selections")), 0, 1, 2, 3);
	parse_existence_for_dialog(tagvalues[2], checkbox1);

	textentry2 = entry_with_text(custom, 1024);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("Custom")), 0, 1, 3, 4);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), textentry2, 1, 10, 3, 4);
	create_buttons(GTK_SIGNAL_FUNC(selectok), replace_range);
	if (custom)
		g_free(custom);

}

/************************************************************************/
void quicklist_cb(GtkWidget * widget, gpointer data)
{
	GSList *group;

	create_dialog(300, 102, _("Quick List"));
	dialogtable = gtk_table_new(2, 10, 0);
	gtk_box_pack_start(GTK_BOX(vbox), dialogtable, FALSE, FALSE, 0);


	label = gtk_label_new(_("Rows"));
	adj = (GtkAdjustment *) gtk_adjustment_new((gfloat) 1, 0.0, 100.0, 1.0, 5.0, 0.0);
	spin1 = gtk_spin_button_new(adj, 1, 0);
	gtk_entry_set_text(GTK_ENTRY(spin1), "");
	gtk_spin_button_set_numeric(GTK_SPIN_BUTTON(spin1), 1);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), label, 0, 1, 0, 1);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), spin1, 1, 2, 0, 1);

	label = gtk_label_new(_("Style"));
	radio1 = gtk_radio_button_new_with_label(NULL, _("Ordered"));
	group = gtk_radio_button_group(GTK_RADIO_BUTTON(radio1));
	radio2 = gtk_radio_button_new_with_label(group, _("Unordered"));
	gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(radio1), TRUE);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), label, 0, 1, 1, 2);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), radio1, 1, 5, 1, 2);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), radio2, 5, 10, 1, 2);

	create_buttons(GTK_SIGNAL_FUNC(quicklistok), NULL);
}

/************************************************************************/


void meta_cb(GtkWidget * widget, gpointer data)
{
	GList *popuplist = NULL;

	static gchar *tagitems[] = { "http-equiv", "name", "content", "scheme", NULL };
	gchar *tagvalues[5];
	gchar *custom = NULL;
	Treplacerange *replace_range = NULL;

	/* this is for the right click menu */
	if ((data != NULL) && (widget == NULL)) {
		replace_range = values_for_dialog(tagitems, tagvalues, &custom, (Ttagpopup *) data);
	} else {
		init_values_for_dialog(tagitems, tagvalues);
	}
	/* end for the right click menu */


	create_dialog(520, 168, _("Meta"));
	dialogtable = gtk_table_new(5, 10, 0);
	gtk_box_pack_start(GTK_BOX(vbox), dialogtable, FALSE, FALSE, 0);

	/* this is up here because "name" and "HTTP_EQUIV" share a list */
	/* and name doesn't need a refresh in the list */
	popuplist = g_list_append(popuplist, "description");
	popuplist = g_list_append(popuplist, "expires");
	popuplist = g_list_append(popuplist, "reply-to");
	popuplist = g_list_append(popuplist, "keywords");
	popuplist = g_list_append(popuplist, "PICS-label");

	combo2 = combo_with_popdown(tagvalues[1], popuplist, 1);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("Name")), 0, 1, 1, 2);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), GTK_WIDGET(GTK_COMBO(combo2)), 1, 10, 1, 2);

	popuplist = g_list_insert(popuplist, "refresh", 5);
	combo1 = combo_with_popdown(tagvalues[0], popuplist, 1);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("HTTP-EQUIV")), 0, 1, 0, 1);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), GTK_WIDGET(GTK_COMBO(combo1)), 1, 10, 0, 1);

	g_list_free(popuplist);

	textentry1 = entry_with_text(tagvalues[2], 512);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("Content")), 0, 1, 2, 3);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), textentry1, 1, 10, 2, 3);

	textentry2 = gtk_entry_new_with_max_length(256);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("Scheme")), 0, 1, 3, 4);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), textentry2, 1, 10, 3, 4);

	textentry3 = entry_with_text(custom, 1024);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), gtk_label_new(_("Custom")), 0, 1, 4, 5);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), textentry3, 1, 10, 4, 5);
	create_buttons(GTK_SIGNAL_FUNC(metaok), replace_range);
	if (custom)
		g_free(custom);
}

/************************************************************************/
void embed_cb(GtkWidget * widget, gpointer data)
{
	GtkWidget *file_but;

	create_dialog(500, 123, _("Embed"));
	dialogtable = gtk_table_new(3, 12, 0);
	gtk_box_pack_start(GTK_BOX(vbox), dialogtable, FALSE, FALSE, 0);

	label = gtk_label_new(_("URL"));
	textentry1 = gtk_entry_new_with_max_length(256);
	file_but = file_but_new(textentry1, dialog, 0);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), GTK_WIDGET(file_but), 10, 12, 0, 1);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), label, 0, 2, 0, 1);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), textentry1, 2, 10, 0, 1);
	label = gtk_label_new(_("Width"));
	adj = (GtkAdjustment *) gtk_adjustment_new((gfloat) 1, 0.0, 500.0, 1.0, 5.0, 0.0);
	spin1 = gtk_spin_button_new(adj, 1, 0);
	gtk_entry_set_text(GTK_ENTRY(spin1), "");
	gtk_spin_button_set_numeric(GTK_SPIN_BUTTON(spin1), 1);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), label, 0, 2, 1, 2);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), spin1, 2, 4, 1, 2);

	label = gtk_label_new(_("Height"));
	adj = (GtkAdjustment *) gtk_adjustment_new((gfloat) 1, 0.0, 500.0, 1.0, 5.0, 0.0);
	spin2 = gtk_spin_button_new(adj, 1, 0);
	gtk_entry_set_text(GTK_ENTRY(spin2), "");
	gtk_spin_button_set_numeric(GTK_SPIN_BUTTON(spin2), 1);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), label, 4, 6, 1, 2);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), spin2, 6, 8, 1, 2);

	label = gtk_label_new(_("Border"));
	adj = (GtkAdjustment *) gtk_adjustment_new((gfloat) 0, 0.0, 500.0, 1.0, 5.0, 0.0);
	spin3 = gtk_spin_button_new(adj, 1, 0);
	gtk_entry_set_text(GTK_ENTRY(spin3), "");
	gtk_spin_button_set_numeric(GTK_SPIN_BUTTON(spin3), 1);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), label, 8, 10, 1, 2);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), spin3, 10, 12, 1, 2);

	label = gtk_label_new(_("Align"));
	combo1 = gtk_combo_new();
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), label, 0, 2, 2, 3);
	gtk_table_attach_defaults(GTK_TABLE(dialogtable), GTK_WIDGET(GTK_COMBO(combo1)), 2, 12, 2, 3);
	gtk_combo_set_popdown_strings(GTK_COMBO(combo1), positionlist);
	gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(combo1)->entry), "");

	create_buttons(GTK_SIGNAL_FUNC(embedok), NULL);
}

/************************************************************************/
void sel_colour_cb(GtkWidget * widget, gpointer data)
{

	GtkWidget *colorseldlg;
	GtkWidget *colorsel;

	colorseldlg = gtk_color_selection_dialog_new(_("Select Colour"));
	colorsel = GTK_COLOR_SELECTION_DIALOG(colorseldlg)->colorsel;
	gtk_widget_show(colorseldlg);
}

/************************************************************************/

gchar *extract_time_string(char *original_string)
{
	static gchar *return_string;
	gchar *start_ptr;
	gchar *end_ptr;
	gint string_size;

	return_string = g_malloc0(32);
	start_ptr = strchr(original_string, '(');
	start_ptr++;
	end_ptr = strchr(original_string, ')');
	string_size = end_ptr - start_ptr;
	strncat(return_string, start_ptr, string_size);
	return return_string;
}

/************************************************************************/
void insert_time_callback(GtkWidget * widget, TimeInsert * timeinsert)
{
	gchar *temp_string;
	gchar *insert_string;
	gchar *final_string;
	gint count;

	insert_string = g_malloc0(32);
	final_string = g_malloc0(255);
	for (count = 1; count < 6; count++) {
		if (GTK_TOGGLE_BUTTON(timeinsert->check[count])->active) {
			gtk_label_get(GTK_LABEL(timeinsert->label[count]), &temp_string);
			insert_string = extract_time_string(temp_string);
			strncat(final_string, insert_string, 31);
			strncat(final_string, " ", 31);
		}
		DEBUG_MSG("insert_time_callback, count=%d\n", count);
	}
	DEBUG_MSG("insert_time_callback, final_string=%s\n", final_string);
	insert_text(final_string, "");
	DEBUG_MSG("insert_time_callback, text inserted\n");
	g_free(insert_string);
	g_free(final_string);
	gtk_widget_destroy(timeinsert->dialog);
	g_free(timeinsert);
	DEBUG_MSG("insert_time_callback, finished\n");
}

/************************************************************************/
void insert_time_cancel(GtkWidget * widget, TimeInsert * data)
{

	gtk_widget_destroy(GTK_WIDGET(data->dialog));
	g_free(data);
}

/************************************************************************/
void insert_time_cb(GtkWidget * widget, gpointer data)
{

	gint month, year, count;
	time_t time_var;
	gchar *temp = NULL;
	struct tm *time_struct;
	TimeInsert *timeinsert;
	GtkWidget *ok_b, *cancel_b;

	timeinsert = g_malloc(sizeof(TimeInsert));
	time_var = time(NULL);
	time_struct = localtime(&time_var);

	timeinsert->dialog = gtk_dialog_new();
	gtk_container_border_width(GTK_CONTAINER(timeinsert->dialog), 10);
	gtk_window_position(GTK_WINDOW(timeinsert->dialog), GTK_WIN_POS_MOUSE);
	gtk_window_set_title(GTK_WINDOW(timeinsert->dialog), "Insert Time");

	ok_b = bf_stock_ok_button(GTK_SIGNAL_FUNC(insert_time_callback), (gpointer) timeinsert);
	cancel_b = bf_stock_cancel_button(GTK_SIGNAL_FUNC(insert_time_cancel), (gpointer) timeinsert);

	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(timeinsert->dialog)->action_area), ok_b, TRUE, TRUE, 0);

	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(timeinsert->dialog)->action_area), cancel_b, TRUE, TRUE, 0);

	for (count = 1; count < 6; count++) {
		switch (count) {
		case 1:
			temp = g_strdup_printf("  Time (%i:%i:%i)", time_struct->tm_hour, time_struct->tm_min, time_struct->tm_sec);
			break;
		case 2:
			switch (time_struct->tm_wday) {
			case 0:
				temp = g_strdup(_("  Day of the week (Sunday)"));
				break;
			case 1:
				temp = g_strdup(_("  Day of the week (Monday)"));
				break;
			case 2:
				temp = g_strdup(_("  Day of the week (Tuesday)"));
				break;
			case 3:
				temp = g_strdup(_("  Day of the week (Wednesday)"));
				break;
			case 4:
				temp = g_strdup(_("  Day of the week (Thursday)"));
				break;
			case 5:
				temp = g_strdup(_("  Day of the week (Friday)"));
				break;
			case 6:
				temp = g_strdup(_("  Day of the week (Saturday)"));
				break;
			default:
				g_message(_("You appear to have a non existant day!\n"));
				temp = g_strdup(" ** Error ** see stdout");
			}					/* end of switch day of week */
			break;
		case 3:
			month = time_struct->tm_mon + 1;
			year = time_struct->tm_year;
			year = 1900 + year;
			temp = g_strdup_printf(_("  Date (%i/%i/%i)"), time_struct->tm_mday, month, year);
			break;
		case 4:
			temp = g_strdup_printf(_("  Unix Time (%i)"), (int) time_var);
			break;
		case 5:
			temp = g_strdup_printf(_("  Unix Date String (%s"), ctime(&time_var));
			/* Replace \n on ')' */
			temp[strlen(temp) - 1] = ')';
			break;
		default:
			break;
		}						/* end of switch count */
		timeinsert->check[count] = gtk_check_button_new();
		timeinsert->label[count] = gtk_label_new(temp);
		g_free(temp);
		gtk_container_add(GTK_CONTAINER(timeinsert->check[count]), GTK_WIDGET(timeinsert->label[count]));
		gtk_box_pack_start(GTK_BOX(GTK_DIALOG(timeinsert->dialog)->vbox), GTK_WIDGET(timeinsert->check[count]), TRUE, TRUE, 0);
		gtk_widget_show(timeinsert->check[count]);
		gtk_widget_show(timeinsert->label[count]);
	}							/* end of for loop */

	gtk_widget_show(cancel_b);
	gtk_widget_show(ok_b);
	GTK_WIDGET_SET_FLAGS(ok_b, GTK_CAN_DEFAULT);
	gtk_widget_show(timeinsert->dialog);
}

/************************************************************************/

void create_buttons(GtkSignalFunc ok_func, gpointer ok_data)
{
	DEBUG_MSG("create_buttons, ok_data=%p\n", ok_data);
	hbox = gtk_hbutton_box_new();
	gtk_hbutton_box_set_layout_default(4);
	gtk_button_box_set_spacing(GTK_BUTTON_BOX(hbox), 5);

	okbutton = bf_stock_ok_button(ok_func, ok_data);
	GTK_WIDGET_SET_FLAGS(okbutton, GTK_CAN_DEFAULT);

	cancelbutton = gtk_button_new_with_label(_(" Cancel "));
	gtk_signal_connect_object(GTK_OBJECT(cancelbutton), "clicked", GTK_SIGNAL_FUNC(gtk_object_destroy), (GtkObject *) dialog);

	GTK_WIDGET_SET_FLAGS(cancelbutton, GTK_CAN_DEFAULT);

	gtk_box_pack_start(GTK_BOX(hbox), okbutton, FALSE, FALSE, 0);
	gtk_box_pack_start(GTK_BOX(hbox), cancelbutton, FALSE, FALSE, 0);

	gtk_widget_realize(dialog);
	gtk_window_set_default(GTK_WINDOW(dialog), okbutton);
/* causes some random crashes??? */
/*  gtk_window_set_transient_for(GTK_WINDOW(main_window), GTK_WINDOW(dialog)); */
	gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, FALSE, 0);
	gtk_widget_show_all(GTK_WIDGET(dialog));
}

/************************************************************************/

void create_dialog(int width, int height, gchar * title)
{
	dialog = gtk_window_new(GTK_WINDOW_DIALOG);
	DEBUG_MSG("create_dialog, dialog pointer = %p\n", dialog);
	gtk_grab_add(dialog);
	gtk_container_border_width(GTK_CONTAINER(dialog), 10);
	gtk_signal_connect(GTK_OBJECT(dialog), "delete_event", GTK_SIGNAL_FUNC(window_close), dialog);
	gtk_signal_connect(GTK_OBJECT(dialog), "destroy", GTK_SIGNAL_FUNC(window_close), dialog);
	/* gtk_widget_set_usize(GTK_WIDGET(dialog), width, height); */
	gtk_window_set_title(GTK_WINDOW(dialog), title);
	gtk_window_position(GTK_WINDOW(dialog), GTK_WIN_POS_CENTER);
	vbox = gtk_vbox_new(FALSE, 5);
	gtk_container_add(GTK_CONTAINER(dialog), vbox);
	gtk_widget_realize(dialog);
	DEBUG_MSG("create_dialog, finished\n");
}

/************************************************************************/

void destroy_dialog(void)
{
	/* this makes sure that there is no memory leak with dialogs */
	DEBUG_MSG("destroy_dialog, dialog pointer = %p\n", dialog);
	if (stuff != NULL) {
		g_free(stuff);
		stuff = NULL;
	}
	window_close(NULL, dialog);
	DEBUG_MSG("destroy_dialog, dialog destroyed\n");
}

/************************************************************************/

gchar *converttohex(gchar * color)
{
	if (!strncasecmp(color, "black", 32)) {
		return "#000000";
	}
	if (!strncasecmp(color, "maroon", 32)) {
		return "#800000";
	}
	if (!strncasecmp(color, "green", 32)) {
		return "#008000";
	}
	if (!strncasecmp(color, "olive", 32)) {
		return "#808000";
	}
	if (!strncasecmp(color, "navy", 32)) {
		return "#000080";
	}
	if (!strncasecmp(color, "purple", 32)) {
		return "#800080";
	}
	if (!strncasecmp(color, "fuchsia", 32)) {
		return "#FF00FF";
	}
	if (!strncasecmp(color, "teal", 32)) {
		return "#008080";
	}
	if (!strncasecmp(color, "gray", 32)) {
		return "#808080";
	}
	if (!strncasecmp(color, "silver", 32)) {
		return "#C0C0C0";
	}
	if (!strncasecmp(color, "red", 32)) {
		return "#FF0000";
	}
	if (!strncasecmp(color, "lime", 32)) {
		return "#00FF00";
	}
	if (!strncasecmp(color, "yellow", 32)) {
		return "#FFFF00";
	}
	if (!strncasecmp(color, "blue", 32)) {
		return "#0000FF";
	}
	if (!strncasecmp(color, "aqua", 32)) {
		return "#00FFFF";
	}
	if (!strncasecmp(color, "white", 32)) {
		return "#FFFFFF";
	}
	return color;
}

/************************************************************************/

void quickanchorok(GtkWidget * widget, gpointer data)
{
	stuff = g_malloc(1024);
	strncpy(stuff, cap("<A"), 1023);
	if (strlen((gchar *) gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(combo2)->entry)))) {
		strncat(strncat(strncat(stuff, cap(" HREF=\""), 1023), (gchar *) gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(combo2)->entry)), 1023),
				"\"", 1023);
		main_v->current_project.urllist =
			add_to_stringlist(main_v->current_project.urllist, gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(combo2)->entry)));
	}
	if (strlen((gchar *) gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(combo1)->entry)))) {
		strncat(strncat
				(strncat(stuff, cap(" TARGET=\""), 1023), (gchar *) gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(combo1)->entry)), 1023),
				"\"", 1023);
		main_v->current_project.targetlist =
			add_to_stringlist(main_v->current_project.targetlist, gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(combo1)->entry)));
	}
	if (strlen((gchar *) gtk_entry_get_text(GTK_ENTRY(textentry2)))) {
		strncat(strncat(strncat(stuff, cap(" NAME=\""), 1023), (gchar *) gtk_entry_get_text(GTK_ENTRY(textentry2)), 1023), "\"", 1023);
	}
	if (strlen((gchar *) gtk_entry_get_text(GTK_ENTRY(textentry3)))) {
		strncat(stuff, " ", 1023);
		strncat(stuff, (gchar *) gtk_entry_get_text(GTK_ENTRY(textentry3)), 1023);
	}
	strncat(stuff, ">", 1023);

	if (data == NULL) {
		insert_text(stuff, cap("</A>"));
	} else {
		replace_text(stuff, ((Treplacerange *) data)->pos, ((Treplacerange *) data)->len);
		g_free(data);
	}

	destroy_dialog();
}

/************************************************************************/

void quickruleok(GtkWidget * widget, gpointer data)
{
	gchar *tempstr;
	gint temp;

	stuff = g_malloc(1024);
	tempstr = g_malloc(1024);

	strncpy(stuff, cap("<HR"), 1023);

	if (strlen(gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(combo1)->entry)))) {
		strncat(strncat(strncat(stuff, cap(" ALIGN=\""), 1023), gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(combo1)->entry)), 1023), "\"", 1023);
	}
	if (strlen(gtk_entry_get_text(GTK_ENTRY(spin1)))) {
		temp = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(spin1));
		g_snprintf(tempstr, 1023, "%d", temp);
		strncat(strncat(strncat(stuff, cap(" SIZE=\""), 1023), tempstr, 1023), "\"", 1023);
	}
	if (strlen(gtk_entry_get_text(GTK_ENTRY(spin2)))) {
		temp = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(spin2));
		g_snprintf(tempstr, 1023, "%d", temp);
		strncat(strncat(stuff, cap(" WIDTH=\""), 1023), tempstr, 1023);
		if (GTK_TOGGLE_BUTTON(checkbox1)->active) {
			strncat(stuff, "%", 1023);
		}
		strncat(stuff, "\"", 1023);
	}
	/* noshade */
	if (GTK_TOGGLE_BUTTON(checkbox2)->active) {
		/* If control reaches here, the toggle button is down */
		strncat(stuff, cap(" NOSHADE"), 1023);
	}
	if (strlen((gchar *) gtk_entry_get_text(GTK_ENTRY(textentry1)))) {
		strncat(stuff, " ", 1023);
		strncat(stuff, (gchar *) gtk_entry_get_text(GTK_ENTRY(textentry1)), 1023);
	}

	strncat(stuff, ">", 1023);

	if (data == NULL) {
		insert_text(stuff, "");
	} else {
		replace_text(stuff, ((Treplacerange *) data)->pos, ((Treplacerange *) data)->len);
		g_free(data);
	}
	destroy_dialog();
	g_free(tempstr);

}

/************************************************************************/

void bodyok(GtkWidget * widget, gpointer data)
{
	DEBUG_MSG("bodyok, started, data=%p\n", data);
	stuff = g_malloc(1024);
	strncpy(stuff, cap("<BODY"), 1023);
	if (strlen(gtk_entry_get_text(GTK_ENTRY(textentry1)))) {
		strncat(strncat(strncat(stuff, cap(" BACKGROUND=\""), 1023), gtk_entry_get_text(GTK_ENTRY(textentry1)), 1023), "\"", 1023);
	}
	if (strlen(gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(combo1)->entry)))) {
		strncat(strncat
				(strncat(stuff, cap(" BGCOLOR=\""), 1023), converttohex(gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(combo1)->entry))), 1023),
				"\"", 1023);
		main_v->current_project.colorlist =
			add_to_stringlist(main_v->current_project.colorlist, gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(combo1)->entry)));
	}
	if (strlen(gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(combo2)->entry)))) {
		strncat(strncat
				(strncat(stuff, cap(" TEXT=\""), 1023), converttohex(gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(combo2)->entry))), 1023),
				"\"", 1023);
		main_v->current_project.colorlist =
			add_to_stringlist(main_v->current_project.colorlist, gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(combo2)->entry)));
	}
	if (strlen(gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(combo3)->entry)))) {
		strncat(strncat
				(strncat(stuff, cap(" LINK=\""), 1023), converttohex(gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(combo3)->entry))), 1023),
				"\"", 1023);
		main_v->current_project.colorlist =
			add_to_stringlist(main_v->current_project.colorlist, gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(combo3)->entry)));
	}
	if (strlen(gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(combo4)->entry)))) {
		strncat(strncat
				(strncat(stuff, cap(" VLINK=\""), 1023), converttohex(gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(combo4)->entry))), 1023),
				"\"", 1023);
		main_v->current_project.colorlist =
			add_to_stringlist(main_v->current_project.colorlist, gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(combo4)->entry)));
	}
	if (strlen(gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(combo5)->entry)))) {
		strncat(strncat
				(strncat(stuff, cap(" ALINK=\""), 1023), converttohex(gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(combo5)->entry))), 1023),
				"\"", 1023);
		main_v->current_project.colorlist =
			add_to_stringlist(main_v->current_project.colorlist, gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(combo5)->entry)));
	}
	if (strlen((gchar *) gtk_entry_get_text(GTK_ENTRY(textentry2)))) {
		strncat(stuff, " ", 1023);
		strncat(stuff, (gchar *) gtk_entry_get_text(GTK_ENTRY(textentry2)), 1023);
	}

	strncat(stuff, ">\n", 1023);

	if (data == NULL) {
		DEBUG_MSG("bodyok, calling insert_text\n");
		insert_text(stuff, cap("\n\n</BODY>"));
	} else {
		DEBUG_MSG("bodyok, calling replace_text, data->pos=%d, data->len=%d\n", ((Treplacerange *) data)->pos,
				  ((Treplacerange *) data)->len);
		replace_text(stuff, ((Treplacerange *) data)->pos, ((Treplacerange *) data)->len);
		g_free(data);
	}

	destroy_dialog();
}

/************************************************************************/
void emailok(void)
{
	gchar *address;
	address = g_malloc(256);

	strncat(strncat
			(strncat(strncpy(address, cap("<A HREF="), 255), "\"mailto:", 255), (gchar *) gtk_entry_get_text(GTK_ENTRY(textentry1)),
			 255), "\">", 255);
	insert_text(address, cap("</A>"));
	destroy_dialog();
	g_free(address);
}

/************************************************************************/
void fontok(GtkWidget * widget, gpointer data)
{
	gchar *tempstr;
	gint temp, doh;

	stuff = g_malloc(1024);
	tempstr = g_malloc(1024);
	strncpy(stuff, cap("<FONT"), 1023);
	doh = 0;
	if (strlen(gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(combo1)->entry)))) {
		strncat(strncat(stuff, cap(" SIZE=\""), 1023), gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(combo1)->entry)), 1023);
		temp = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(spin1));
		g_snprintf(tempstr, 1023, "%d", temp);
		strncat(strncat(stuff, tempstr, 1023), "\"", 1023);
		doh = 1;
	}
	if (strlen(gtk_entry_get_text(GTK_ENTRY(spin1))) && doh != 1) {
		strncat(stuff, cap(" SIZE=\""), 1023);
		temp = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(spin1));
		g_snprintf(tempstr, 1023, "%d", temp);
		strncat(strncat(stuff, tempstr, 1023), "\"", 1023);
	}
	if (strlen(gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(combo2)->entry)))) {
		strncat(strncat
				(strncat(stuff, cap(" COLOR=\""), 1023), converttohex(gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(combo2)->entry))), 1023),
				"\"", 1023);
		main_v->current_project.colorlist =
			add_to_stringlist(main_v->current_project.colorlist, gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(combo2)->entry)));
	}
	if (strlen(gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(combo3)->entry)))) {
		strncat(strncat(strncat(stuff, cap(" FACE=\""), 1023), gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(combo3)->entry)), 1023), "\"", 1023);
		main_v->current_project.fontlist =
			add_to_stringlist(main_v->current_project.fontlist, gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(combo3)->entry)));
	}
	if (strlen((gchar *) gtk_entry_get_text(GTK_ENTRY(textentry1)))) {
		strncat(stuff, " ", 1023);
		strncat(stuff, (gchar *) gtk_entry_get_text(GTK_ENTRY(textentry1)), 1023);
	}

	strncat(stuff, ">", 1023);

	if (data == NULL) {
		insert_text(stuff, cap("</FONT>"));
	} else {
		replace_text(stuff, ((Treplacerange *) data)->pos, ((Treplacerange *) data)->len);
		g_free(data);
	}

	destroy_dialog();
	g_free(tempstr);
}

/************************************************************************/
void basefontok(GtkWidget * widget, gpointer data)
{
	gchar *tempstr;
	gint temp, doh;
	stuff = g_malloc(1024);
	tempstr = g_malloc(1024);

	strncpy(stuff, cap("<BASEFONT"), 1023);

	doh = 0;
	if (strlen(gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(combo1)->entry)))) {
		strncat(strncat(stuff, cap(" SIZE=\""), 1023), gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(combo1)->entry)), 1023);
		temp = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(spin1));
		g_snprintf(tempstr, 1023, "%d", temp);
		strncat(strncat(stuff, tempstr, 1023), "\"", 1023);
		doh = 1;
	}
	if (strlen(gtk_entry_get_text(GTK_ENTRY(spin1))) && doh != 1) {
		strncat(stuff, cap(" SIZE=\""), 1023);
		temp = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(spin1));
		g_snprintf(tempstr, 1023, "%d", temp);
		strncat(strncat(stuff, tempstr, 1023), "\"", 1023);
	}
	if (strlen(gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(combo2)->entry)))) {
		strncat(strncat
				(strncat(stuff, cap(" COLOR=\""), 1023), converttohex(gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(combo2)->entry))), 1023),
				"\"", 1023);
		main_v->current_project.colorlist =
			add_to_stringlist(main_v->current_project.colorlist, gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(combo2)->entry)));
	}
	if (strlen(gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(combo3)->entry)))) {
		strncat(strncat(strncat(stuff, cap(" FACE=\""), 1023), gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(combo3)->entry)), 1023), "\"", 1023);
		main_v->current_project.fontlist =
			add_to_stringlist(main_v->current_project.fontlist, gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(combo3)->entry)));
	}
	if (strlen((gchar *) gtk_entry_get_text(GTK_ENTRY(textentry1)))) {
		strncat(stuff, " ", 1023);
		strncat(stuff, (gchar *) gtk_entry_get_text(GTK_ENTRY(textentry1)), 1023);
	}

	strncat(stuff, ">", 1023);

	if (data == NULL) {
		insert_text(stuff, "");
	} else {
		replace_text(stuff, ((Treplacerange *) data)->pos, ((Treplacerange *) data)->len);
		g_free(data);
	}

	destroy_dialog();
	g_free(tempstr);
}

/************************************************************************/
void formok(GtkWidget * widget, gpointer data)
{
	stuff = g_malloc(1024);

	strncpy(stuff, "<FORM", 1023);

	if (strlen(gtk_entry_get_text(GTK_ENTRY(textentry1)))) {
		strncat(strncat(strncat(stuff, cap(" ACTION=\""), 1023), gtk_entry_get_text(GTK_ENTRY(textentry1)), 1023), "\"", 1023);
	}
	if (strlen(gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(combo1)->entry)))) {
		strncat(strncat(strncat(stuff, cap(" METHOD=\""), 1023), gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(combo1)->entry)), 1023), "\"",
				1023);
	}
	if (strlen(gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(combo2)->entry)))) {
		strncat(strncat(strncat(stuff, cap(" ENCTYPE=\""), 1023), gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(combo2)->entry)), 1023), "\"",
				1023);
	}
	if (strlen(gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(combo3)->entry)))) {
		strncat(strncat(strncat(stuff, cap(" TARGET=\""), 1023), gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(combo3)->entry)), 1023), "\"",
				1023);
		main_v->current_project.targetlist =
			add_to_stringlist(main_v->current_project.targetlist, gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(combo3)->entry)));
	}
	if (strlen((gchar *) gtk_entry_get_text(GTK_ENTRY(textentry2)))) {
		strncat(stuff, " ", 1023);
		strncat(stuff, (gchar *) gtk_entry_get_text(GTK_ENTRY(textentry2)), 1023);
	}
	strncat(stuff, ">", 1023);


	if (data == NULL) {
		insert_text(stuff, cap("</FORM>"));
	} else {
		replace_text(stuff, ((Treplacerange *) data)->pos, ((Treplacerange *) data)->len);
		g_free(data);
	}

	destroy_dialog();
}

/************************************************************************/
void submitok(GtkWidget * widget, gpointer data)
{
	stuff = g_malloc(1024);

	strncpy(stuff, cap("<INPUT TYPE=\"SUBMIT\""), 1023);

	if (strlen(gtk_entry_get_text(GTK_ENTRY(textentry1)))) {
		strncat(strncat(strncat(stuff, cap(" NAME=\""), 1023), gtk_entry_get_text(GTK_ENTRY(textentry1)), 1023), "\"", 1023);
	}
	if (strlen(gtk_entry_get_text(GTK_ENTRY(textentry2)))) {
		strncat(strncat(strncat(stuff, cap(" VALUE=\""), 1023), gtk_entry_get_text(GTK_ENTRY(textentry2)), 1023), "\"", 1023);
	}
	strncat(stuff, ">", 1023);
	insert_text(stuff, "");

	destroy_dialog();
}

/************************************************************************/
void resetok(GtkWidget * widget, gpointer data)
{
	stuff = g_malloc(1024);

	strncpy(stuff, cap("<INPUT TYPE=\"RESET\""), 1023);

	if (strlen(gtk_entry_get_text(GTK_ENTRY(textentry1)))) {
		strncat(strncat(strncat(stuff, cap(" NAME=\""), 1023), gtk_entry_get_text(GTK_ENTRY(textentry1)), 1023), "\"", 1023);
	}
	if (strlen(gtk_entry_get_text(GTK_ENTRY(textentry2)))) {
		strncat(strncat(strncat(stuff, cap(" VALUE=\""), 1023), gtk_entry_get_text(GTK_ENTRY(textentry2)), 1023), "\"", 1023);
	}
	strncat(stuff, ">", 1023);
	insert_text(stuff, "");

	destroy_dialog();
}

/************************************************************************/
void textok(GtkWidget * widget, gpointer data)
{
	gchar *tempstr;
	gint temp;
	stuff = g_malloc(1024);
	tempstr = g_malloc(1024);

	strncpy(stuff, cap("<INPUT TYPE=\"TEXT\""), 1023);

	if (strlen(gtk_entry_get_text(GTK_ENTRY(textentry1)))) {
		strncat(strncat(strncat(stuff, cap(" NAME=\""), 1023), gtk_entry_get_text(GTK_ENTRY(textentry1)), 1023), "\"", 1023);
	}
	if (strlen(gtk_entry_get_text(GTK_ENTRY(spin1)))) {
		temp = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(spin1));
		g_snprintf(tempstr, 1023, "%s%d\"", cap(" SIZE=\""), temp);
		strncat(stuff, tempstr, 1023);
	}
	if (strlen(gtk_entry_get_text(GTK_ENTRY(spin2)))) {
		temp = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(spin2));
		g_snprintf(tempstr, 1023, "%s%d\"", cap(" MAXLENGTH=\""), temp);
		strncat(stuff, tempstr, 1023);
	}
	if (strlen(gtk_entry_get_text(GTK_ENTRY(textentry2)))) {
		strncat(strncat(strncat(stuff, cap(" VALUE=\""), 1023), gtk_entry_get_text(GTK_ENTRY(textentry2)), 1023), "\"", 1023);
	}
	if (strlen((gchar *) gtk_entry_get_text(GTK_ENTRY(textentry3)))) {
		strncat(stuff, " ", 1023);
		strncat(stuff, (gchar *) gtk_entry_get_text(GTK_ENTRY(textentry3)), 1023);
	}
	strncat(stuff, ">", 1023);

	if (data == NULL) {
		insert_text(stuff, "");
	} else {
		replace_text(stuff, ((Treplacerange *) data)->pos, ((Treplacerange *) data)->len);
		g_free(data);
	}

	g_free(tempstr);
	destroy_dialog();
}

/************************************************************************/
void hiddenok(GtkWidget * widget, gpointer data)
{
	stuff = g_malloc(1024);

	strncpy(stuff, cap("<INPUT TYPE=\"HIDDEN\""), 1023);

	if (strlen(gtk_entry_get_text(GTK_ENTRY(textentry1)))) {
		strncat(strncat(strncat(stuff, cap(" NAME=\""), 1023), gtk_entry_get_text(GTK_ENTRY(textentry1)), 1023), "\"", 1023);
	}
	if (strlen(gtk_entry_get_text(GTK_ENTRY(textentry2)))) {
		strncat(strncat(strncat(stuff, cap(" VALUE=\""), 1023), gtk_entry_get_text(GTK_ENTRY(textentry2)), 1023), "\"", 1023);
	}
	if (strlen((gchar *) gtk_entry_get_text(GTK_ENTRY(textentry3)))) {
		strncat(stuff, " ", 1023);
		strncat(stuff, (gchar *) gtk_entry_get_text(GTK_ENTRY(textentry3)), 1023);
	}
	strncat(stuff, ">", 1023);

	if (data == NULL) {
		insert_text(stuff, "");
	} else {
		replace_text(stuff, ((Treplacerange *) data)->pos, ((Treplacerange *) data)->len);
		g_free(data);
	}
	destroy_dialog();
}

/************************************************************************/
void textareaok(GtkWidget * widget, gpointer data)
{
	gchar *tempstr;
	gint temp;
	stuff = g_malloc(1024);
	tempstr = g_malloc(1024);

	strncpy(stuff, cap("<TEXTAREA"), 1023);

	if (strlen(gtk_entry_get_text(GTK_ENTRY(textentry1)))) {
		strncat(strncat(strncat(stuff, cap(" NAME=\""), 1023), gtk_entry_get_text(GTK_ENTRY(textentry1)), 1023), "\"", 1023);
	}
	if (strlen(gtk_entry_get_text(GTK_ENTRY(spin1)))) {
		temp = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(spin1));
		g_snprintf(tempstr, 1023, "%s%d\"", cap(" ROWS=\""), temp);
		strncat(stuff, tempstr, 1023);
	}
	if (strlen(gtk_entry_get_text(GTK_ENTRY(spin2)))) {
		temp = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(spin2));
		g_snprintf(tempstr, 1023, "%s%d\"", cap(" COLS=\""), temp);
		strncat(stuff, tempstr, 1023);
	}
	if (strlen((gchar *) gtk_entry_get_text(GTK_ENTRY(textentry3)))) {
		strncat(stuff, " ", 1023);
		strncat(stuff, (gchar *) gtk_entry_get_text(GTK_ENTRY(textentry3)), 1023);
	}
	strncat(stuff, ">", 1023);

	if (strlen(gtk_entry_get_text(GTK_ENTRY(textentry2)))) {
		strncat(stuff, gtk_entry_get_text(GTK_ENTRY(textentry2)), 1023);
	}

	if (data == NULL) {
		insert_text(stuff, cap("</TEXTAREA>"));
	} else {
		replace_text(stuff, ((Treplacerange *) data)->pos, ((Treplacerange *) data)->len);
		g_free(data);
	}

	g_free(tempstr);
	destroy_dialog();
}

/************************************************************************/
void selectok(GtkWidget * widget, gpointer data)
{
	stuff = g_malloc(1024);

	strncpy(stuff, cap("<SELECT"), 1023);

	if (strlen(gtk_entry_get_text(GTK_ENTRY(textentry1)))) {
		strncat(strncat(strncat(stuff, cap(" NAME=\""), 1023), gtk_entry_get_text(GTK_ENTRY(textentry1)), 1023), "\"", 1023);
	}
	if (strlen(gtk_entry_get_text(GTK_ENTRY(spin1)))) {
		strncat(strncat(strncat(stuff, cap(" SIZE=\""), 1023), gtk_entry_get_text(GTK_ENTRY(spin1)), 1023), "\"", 1023);
	}
	if (GTK_TOGGLE_BUTTON(checkbox1)->active) {
		strncat(stuff, cap(" MULTIPLE"), 1023);
	}
	if (strlen((gchar *) gtk_entry_get_text(GTK_ENTRY(textentry2)))) {
		strncat(stuff, " ", 1023);
		strncat(stuff, (gchar *) gtk_entry_get_text(GTK_ENTRY(textentry2)), 1023);
	}
	strncat(stuff, ">", 1023);

	if (data == NULL) {
		insert_text(stuff, cap("\n</SELECT>"));
	} else {
		replace_text(stuff, ((Treplacerange *) data)->pos, ((Treplacerange *) data)->len);
		g_free(data);
	}

	destroy_dialog();
}

/************************************************************************/
void radiook(GtkWidget * widget, gpointer data)
{
	stuff = g_malloc(1024);

	strncpy(stuff, cap("<INPUT TYPE=\"RADIO\""), 1023);

	if (strlen(gtk_entry_get_text(GTK_ENTRY(textentry1)))) {
		strncat(strncat(strncat(stuff, cap(" NAME=\""), 1023), gtk_entry_get_text(GTK_ENTRY(textentry1)), 1023), "\"", 1023);
	}
	if (strlen(gtk_entry_get_text(GTK_ENTRY(textentry2)))) {
		strncat(strncat(strncat(stuff, cap(" VALUE=\""), 1023), gtk_entry_get_text(GTK_ENTRY(textentry2)), 1023), "\"", 1023);
	}
	if (GTK_TOGGLE_BUTTON(checkbox1)->active) {
		strncat(stuff, cap(" CHECKED"), 1023);
	}
	if (strlen((gchar *) gtk_entry_get_text(GTK_ENTRY(textentry3)))) {
		strncat(stuff, " ", 1023);
		strncat(stuff, (gchar *) gtk_entry_get_text(GTK_ENTRY(textentry3)), 1023);
	}
	strncat(stuff, ">", 1023);

	if (data == NULL) {
		insert_text(stuff, "");
	} else {
		replace_text(stuff, ((Treplacerange *) data)->pos, ((Treplacerange *) data)->len);
		g_free(data);
	}

	destroy_dialog();
}

/************************************************************************/
void checkok(GtkWidget * widget, gpointer data)
{
	stuff = g_malloc(1024);

	strncpy(stuff, cap("<INPUT TYPE=\"CHECKBOX\""), 1023);

	if (strlen(gtk_entry_get_text(GTK_ENTRY(textentry1)))) {
		strncat(strncat(strncat(stuff, cap(" NAME=\""), 1023), gtk_entry_get_text(GTK_ENTRY(textentry1)), 1023), "\"", 1023);
	}
	if (strlen(gtk_entry_get_text(GTK_ENTRY(textentry2)))) {
		strncat(strncat(strncat(stuff, cap(" VALUE=\""), 1023), gtk_entry_get_text(GTK_ENTRY(textentry2)), 1023), "\"", 1023);
	}
	if (GTK_TOGGLE_BUTTON(checkbox1)->active) {
		strncat(stuff, cap(" CHECKED"), 1023);
	}
	if (strlen((gchar *) gtk_entry_get_text(GTK_ENTRY(textentry3)))) {
		strncat(stuff, " ", 1023);
		strncat(stuff, (gchar *) gtk_entry_get_text(GTK_ENTRY(textentry3)), 1023);
	}
	strncat(stuff, ">", 1023);

	if (data == NULL) {
		insert_text(stuff, "");
	} else {
		replace_text(stuff, ((Treplacerange *) data)->pos, ((Treplacerange *) data)->len);
		g_free(data);
	}

	destroy_dialog();
}

/************************************************************************/
void quicklistok(GtkWidget * widget, gpointer data)
{
	gint active, temp, i;
	stuff = g_malloc(1024);

	/* speed optimization, only tests once */
	active = GTK_TOGGLE_BUTTON(radio1)->active;

	if (active) {
		strncpy(stuff, cap("<OL>"), 1023);
	} else {
		strncpy(stuff, "<UL>", 1023);
	}

	if (strlen(gtk_entry_get_text(GTK_ENTRY(spin1)))) {
		temp = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(spin1));
		for (i = 0; i < temp; i++) {
			strncat(stuff, cap("\n\t<LI>"), 1023);
		}
	}
	strncat(stuff, "\n", 1023);

	if (active) {
		insert_text(stuff, cap("</OL>"));
	} else {
		insert_text(stuff, cap("</UL>"));
	}

	destroy_dialog();
}

/************************************************************************/
void metaok(GtkWidget * widget, gpointer data)
{
	gchar *tmpchar;

	stuff = g_malloc(1024);

	strncpy(stuff, cap("<META"), 1023);

	if (strlen(gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(combo1)->entry)))) {
		strncat(strncat(strncat(stuff, cap(" HTTP-EQUIV=\""), 1023), gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(combo1)->entry)), 1023),
				"\"", 1023);
	}
	if (strlen(gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(combo2)->entry)))) {
		strncat(strncat(strncat(stuff, cap(" NAME=\""), 1023), gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(combo2)->entry)), 1023), "\"", 1023);
	}
	/* gtk_editable_get_chars allocates memory --> we should free it afterwards */
	tmpchar = gtk_editable_get_chars(GTK_EDITABLE(textentry1), 0, -1);
	if (strlen(tmpchar)) {
		strncat(strncat(strncat(stuff, cap(" CONTENT=\""), 1023), gtk_editable_get_chars(GTK_EDITABLE(textentry1), 0, -1), 1023), "\"",
				1023);
	}
	g_free(tmpchar);
	if (strlen(gtk_entry_get_text(GTK_ENTRY(textentry2)))) {
		strncat(strncat(strncat(stuff, cap(" SCHEME=\""), 1023), gtk_entry_get_text(GTK_ENTRY(textentry2)), 1023), "\"", 1023);
	}
	if (strlen((gchar *) gtk_entry_get_text(GTK_ENTRY(textentry3)))) {
		strncat(stuff, " ", 1023);
		strncat(stuff, (gchar *) gtk_entry_get_text(GTK_ENTRY(textentry3)), 1023);
	}
	strncat(stuff, ">", 1023);

	if (data == NULL) {
		insert_text(stuff, "");
	} else {
		replace_text(stuff, ((Treplacerange *) data)->pos, ((Treplacerange *) data)->len);
		g_free(data);
	}


	destroy_dialog();
}

/************************************************************************/
void embedok(GtkWidget * widget, gpointer data)
{
	gchar *tempstr;
	gint temp;
	stuff = g_malloc(1024);
	tempstr = g_malloc(1024);

	strncpy(stuff, cap("<EMBED"), 1023);

	if (strlen(gtk_entry_get_text(GTK_ENTRY(textentry1)))) {
		strncat(strncat(strncat(stuff, cap(" SRC=\""), 1023), gtk_entry_get_text(GTK_ENTRY(textentry1)), 1023), "\"", 1023);
	}
	if (strlen(gtk_entry_get_text(GTK_ENTRY(spin1)))) {
		temp = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(spin1));
		g_snprintf(tempstr, 1023, "%s%d\"", cap(" WIDTH=\""), temp);
		strncat(stuff, tempstr, 1023);
	}
	if (strlen(gtk_entry_get_text(GTK_ENTRY(spin2)))) {
		temp = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(spin2));
		g_snprintf(tempstr, 1023, "%s%d\"", cap(" HEIGHT=\""), temp);
		strncat(stuff, tempstr, 1023);
	}
	if (strlen(gtk_entry_get_text(GTK_ENTRY(spin3)))) {
		temp = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(spin3));
		g_snprintf(tempstr, 1023, "%s%d\"", cap(" BORDER=\""), temp);
		strncat(stuff, tempstr, 1023);
	}
	if (strlen(gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(combo1)->entry)))) {
		strncat(strncat(strncat(stuff, cap(" ALIGN=\""), 1023), gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(combo1)->entry)), 1023), "\"", 1023);
	}
	strncat(stuff, ">", 1023);
	insert_text(stuff, "");

	g_free(tempstr);
	destroy_dialog();
}

/************************************************************************/
void tabledialogok(GtkWidget * widget, gpointer data)
{
	gchar *tempstr;
	gint temp;
	stuff = g_malloc(1024);
	tempstr = g_malloc(1024);

	strncpy(stuff, cap("<TABLE"), 1023);

	if (strlen(gtk_entry_get_text(GTK_ENTRY(spin1)))) {
		temp = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(spin1));
		g_snprintf(tempstr, 1023, "%s%d\"", cap(" CELLPADDING=\""), temp);
		strncat(stuff, tempstr, 1023);
	}
	if (strlen(gtk_entry_get_text(GTK_ENTRY(spin3)))) {
		temp = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(spin3));
		g_snprintf(tempstr, 1023, "%s%d\"", cap(" CELLSPACING=\""), temp);
		strncat(stuff, tempstr, 1023);
	}
	if (strlen(gtk_entry_get_text(GTK_ENTRY(spin4)))) {
		temp = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(spin4));
		g_snprintf(tempstr, 1023, "%s%d\"", cap(" BORDER=\""), temp);
		strncat(stuff, tempstr, 1023);
	}
	if (strlen(gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(combo1)->entry)))) {
		strncat(strncat(strncat(stuff, cap(" ALIGN=\""), 1023), gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(combo1)->entry)), 1023), "\"", 1023);
	}
	if (strlen(gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(combo2)->entry)))) {
		strncat(strncat(strncat(stuff, cap(" VALIGN=\""), 1023), gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(combo2)->entry)), 1023), "\"",
				1023);
	}
	if (strlen(gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(combo3)->entry)))) {
		strncat(strncat
				(strncat(stuff, cap(" BGCOLOR=\""), 1023), converttohex(gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(combo3)->entry))), 1023),
				"\"", 1023);
	}
	if (strlen(gtk_entry_get_text(GTK_ENTRY(spin2)))) {
		temp = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(spin2));
		g_snprintf(tempstr, 1023, "%s%d\"", cap(" WIDTH=\""), temp);
		strncat(stuff, tempstr, 1023);
	}
	if (strlen((gchar *) gtk_entry_get_text(GTK_ENTRY(textentry1)))) {
		strncat(stuff, " ", 1023);
		strncat(stuff, (gchar *) gtk_entry_get_text(GTK_ENTRY(textentry1)), 1023);
	}
	strncat(stuff, ">", 1023);
	if (data == NULL) {
		insert_text(stuff, cap("</TABLE>"));
	} else {
		replace_text(stuff, ((Treplacerange *) data)->pos, ((Treplacerange *) data)->len);
		g_free(data);
	}

	g_free(tempstr);
	destroy_dialog();
}

/************************************************************************/
void tablerowdialogok(GtkWidget * widget, gpointer data)
{
	stuff = g_malloc(1024);

	strncpy(stuff, cap("<TR"), 1023);

	if (strlen(gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(combo1)->entry)))) {
		strncat(strncat(strncat(stuff, cap(" ALIGN=\""), 1023), gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(combo1)->entry)), 1023), "\"", 1023);
	}
	if (strlen(gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(combo2)->entry)))) {
		strncat(strncat(strncat(stuff, cap(" VALIGN=\""), 1023), gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(combo2)->entry)), 1023), "\"",
				1023);
	}
	if (strlen(gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(combo3)->entry)))) {
		strncat(strncat
				(strncat(stuff, cap(" BGCOLOR=\""), 1023), converttohex(gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(combo3)->entry))), 1023),
				"\"", 1023);
	}
	if (strlen((gchar *) gtk_entry_get_text(GTK_ENTRY(textentry1)))) {
		strncat(stuff, " ", 1023);
		strncat(stuff, (gchar *) gtk_entry_get_text(GTK_ENTRY(textentry1)), 1023);
	}
	strncat(stuff, ">", 1023);

	if (data == NULL) {
		insert_text(stuff, cap("</TR>"));
	} else {
		replace_text(stuff, ((Treplacerange *) data)->pos, ((Treplacerange *) data)->len);
		g_free(data);
	}
	destroy_dialog();
}

/************************************************************************/
void tablehead_cberdialogok(GtkWidget * widget, gpointer data)
{
	gchar *tempstr;
	gint temp;
	stuff = g_malloc(1024);
	tempstr = g_malloc(1024);

	strncpy(stuff, cap("<TH"), 1023);

	if (strlen(gtk_entry_get_text(GTK_ENTRY(spin1)))) {
		temp = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(spin1));
		g_snprintf(tempstr, 1023, "%s%d\"", cap(" WIDTH=\""), temp);
		strncat(stuff, tempstr, 1023);
	}
	if (strlen(gtk_entry_get_text(GTK_ENTRY(spin3)))) {
		temp = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(spin3));
		g_snprintf(tempstr, 1023, "%s%d\"", cap(" HEIGHT=\""), temp);
		strncat(stuff, tempstr, 1023);
	}
	if (strlen(gtk_entry_get_text(GTK_ENTRY(spin2)))) {
		temp = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(spin2));
		g_snprintf(tempstr, 1023, "%s%d\"", cap(" COLSPAN=\""), temp);
		strncat(stuff, tempstr, 1023);
	}
	if (strlen(gtk_entry_get_text(GTK_ENTRY(spin4)))) {
		temp = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(spin4));
		g_snprintf(tempstr, 1023, "%s%d\"", cap(" ROWSPAN=\""), temp);
		strncat(stuff, tempstr, 1023);
	}
	if (strlen(gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(combo1)->entry)))) {
		strncat(strncat(strncat(stuff, cap(" ALIGN=\""), 1023), gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(combo1)->entry)), 1023), "\"", 1023);
	}
	if (strlen(gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(combo2)->entry)))) {
		strncat(strncat(strncat(stuff, cap(" VALIGN=\""), 1023), gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(combo2)->entry)), 1023), "\"",
				1023);
	}
	if (strlen(gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(combo3)->entry)))) {
		strncat(strncat
				(strncat(stuff, cap(" BGCOLOR=\""), 1023), converttohex(gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(combo3)->entry))), 1023),
				"\"", 1023);
	}
	if (GTK_TOGGLE_BUTTON(checkbox1)->active) {
		strncat(stuff, cap(" NOWRAP"), 1023);
	}
	if (strlen((gchar *) gtk_entry_get_text(GTK_ENTRY(textentry1)))) {
		strncat(stuff, " ", 1023);
		strncat(stuff, (gchar *) gtk_entry_get_text(GTK_ENTRY(textentry1)), 1023);
	}
	strncat(stuff, ">", 1023);

	if (data == NULL) {
		insert_text(stuff, cap("</TH>"));
	} else {
		replace_text(stuff, ((Treplacerange *) data)->pos, ((Treplacerange *) data)->len);
		g_free(data);
	}

	g_free(tempstr);
	destroy_dialog();
}

/************************************************************************/
void tabledatadialogok(GtkWidget * widget, gpointer data)
{
	gchar *tempstr;
	gint temp;
	stuff = g_malloc(1024);
	tempstr = g_malloc(1024);

	strncpy(stuff, cap("<TD"), 1023);

	if (strlen(gtk_entry_get_text(GTK_ENTRY(spin1)))) {
		temp = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(spin1));
		g_snprintf(tempstr, 1023, "%s%d\"", cap(" WIDTH=\""), temp);
		strncat(stuff, tempstr, 1023);
	}
	if (strlen(gtk_entry_get_text(GTK_ENTRY(spin3)))) {
		temp = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(spin3));
		g_snprintf(tempstr, 1023, "%s%d\"", cap(" HEIGHT=\""), temp);
		strncat(stuff, tempstr, 1023);
	}
	if (strlen(gtk_entry_get_text(GTK_ENTRY(spin2)))) {
		temp = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(spin2));
		g_snprintf(tempstr, 1023, "%s%d\"", cap(" COLSPAN=\""), temp);
		strncat(stuff, tempstr, 1023);
	}
	if (strlen(gtk_entry_get_text(GTK_ENTRY(spin4)))) {
		temp = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(spin4));
		g_snprintf(tempstr, 1023, "%s%d\"", cap(" ROWSPAN=\""), temp);
		strncat(stuff, tempstr, 1023);
	}
	if (strlen(gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(combo1)->entry)))) {
		strncat(strncat(strncat(stuff, cap(" ALIGN=\""), 1023), gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(combo1)->entry)), 1023), "\"", 1023);
	}
	if (strlen(gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(combo2)->entry)))) {
		strncat(strncat(strncat(stuff, cap(" VALIGN=\""), 1023), gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(combo2)->entry)), 1023), "\"",
				1023);
	}
	if (strlen(gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(combo3)->entry)))) {
		strncat(strncat
				(strncat(stuff, cap(" BGCOLOR=\""), 1023), converttohex(gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(combo3)->entry))), 1023),
				"\"", 1023);
	}
	if (GTK_TOGGLE_BUTTON(checkbox1)->active) {
		strncat(stuff, cap(" NOWRAP"), 1023);
	}
	if (strlen((gchar *) gtk_entry_get_text(GTK_ENTRY(textentry1)))) {
		strncat(stuff, " ", 1023);
		strncat(stuff, (gchar *) gtk_entry_get_text(GTK_ENTRY(textentry1)), 1023);
	}
	strncat(stuff, ">", 1023);

	if (data == NULL) {
		insert_text(stuff, cap("</TD>"));
	} else {
		replace_text(stuff, ((Treplacerange *) data)->pos, ((Treplacerange *) data)->len);
		g_free(data);
	}

	g_free(tempstr);
	destroy_dialog();
}

/************************************************************************/
void framesetdialogok(GtkWidget * widget, gpointer data)
{
	gchar *tempstr;
	gint temp;
	stuff = g_malloc(1024);
	tempstr = g_malloc(1024);

	strncpy(stuff, cap("<FRAMESET"), 1023);

	if (strlen(gtk_entry_get_text(GTK_ENTRY(textentry1)))) {
		strncat(strncat(strncat(stuff, cap(" COLS=\""), 1023), gtk_entry_get_text(GTK_ENTRY(textentry1)), 1023), "\"", 1023);
	}
	if (strlen(gtk_entry_get_text(GTK_ENTRY(textentry2)))) {
		strncat(strncat(strncat(stuff, cap(" ROWS=\""), 1023), gtk_entry_get_text(GTK_ENTRY(textentry2)), 1023), "\"", 1023);
	}
	if (GTK_TOGGLE_BUTTON(checkbox1)->active) {
		strncat(stuff, cap(" FRAMEBORDER=\"1\""), 1023);
	} else {
		strncat(stuff, cap(" FRAMEBORDER=\"0\""), 1023);
	}

	if (strlen(gtk_entry_get_text(GTK_ENTRY(spin1)))) {
		temp = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(spin1));
		g_snprintf(tempstr, 1023, "%s%d\"", cap(" FRAMESPACING=\""), temp);
		strncat(stuff, tempstr, 1023);
	}
	if (strlen((gchar *) gtk_entry_get_text(GTK_ENTRY(textentry3)))) {
		strncat(stuff, " ", 1023);
		strncat(stuff, (gchar *) gtk_entry_get_text(GTK_ENTRY(textentry3)), 1023);
	}
	strncat(stuff, ">", 1023);

	if (data == NULL) {
		insert_text(stuff, cap("\n\n</FRAMESET>"));
	} else {
		replace_text(stuff, ((Treplacerange *) data)->pos, ((Treplacerange *) data)->len);
		g_free(data);
	}

	g_free(tempstr);
	destroy_dialog();
}

/************************************************************************/
void framedialogok(GtkWidget * widget, gpointer data)
{
	gchar *tempstr;
	gint temp;
	stuff = g_malloc(1024);
	tempstr = g_malloc(1024);

	strncpy(stuff, cap("<FRAME"), 1023);

	if (strlen(gtk_entry_get_text(GTK_ENTRY(textentry1)))) {
		strncat(strncat(strncat(stuff, cap(" SRC=\""), 1023), gtk_entry_get_text(GTK_ENTRY(textentry1)), 1023), "\"", 1023);
	}
	if (strlen(gtk_entry_get_text(GTK_ENTRY(textentry2)))) {
		strncat(strncat(strncat(stuff, cap(" NAME=\""), 1023), gtk_entry_get_text(GTK_ENTRY(textentry2)), 1023), "\"", 1023);
	}
	if (GTK_TOGGLE_BUTTON(checkbox2)->active) {
		strncat(stuff, cap(" FRAMEBORDER=\"1\""), 1023);
	} else {
		strncat(stuff, " FRAMEBORDER=\"0\"", 1023);
	}

	if (strlen(gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(combo2)->entry)))) {
		strncat(strncat(strncat(stuff, cap(" SCROLLING=\""), 1023), gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(combo2)->entry)), 1023),
				"\"", 1023);
	}
	if (strlen(gtk_entry_get_text(GTK_ENTRY(spin1)))) {
		temp = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(spin1));
		g_snprintf(tempstr, 1023, "%s%d\"", cap(" MARGINWIDTH=\""), temp);
		strncat(stuff, tempstr, 1023);
	}
	if (strlen(gtk_entry_get_text(GTK_ENTRY(spin2)))) {
		temp = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(spin2));
		g_snprintf(tempstr, 1023, "%s%d\"", cap(" MARGINHEIGHT=\""), temp);
		strncat(stuff, tempstr, 1023);
	}
	if (strlen(gtk_entry_get_text(GTK_ENTRY(spin3)))) {
		temp = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(spin3));
		g_snprintf(tempstr, 1023, "%s%d\"", cap(" FRAMESPACING=\""), temp);
		strncat(stuff, tempstr, 1023);
	}
	if (GTK_TOGGLE_BUTTON(checkbox1)->active) {
		strncat(stuff, cap(" NORESIZE"), 1023);
	}
	if (strlen((gchar *) gtk_entry_get_text(GTK_ENTRY(textentry3)))) {
		strncat(stuff, " ", 1023);
		strncat(stuff, (gchar *) gtk_entry_get_text(GTK_ENTRY(textentry3)), 1023);
	}
	strncat(stuff, ">", 1023);

	if (data == NULL) {
		insert_text(stuff, "");
	} else {
		replace_text(stuff, ((Treplacerange *) data)->pos, ((Treplacerange *) data)->len);
		g_free(data);
	}
	g_free(tempstr);
	destroy_dialog();
}

/************************************************************************/
GtkWidget *color_but_new(GtkWidget * which_entry, GtkWidget * win)
{

	GtkWidget *pixmap, *color_but;

	color_but = gtk_button_new();
	pixmap = new_pixmap(176, win->window, NULL);
	gtk_widget_show(pixmap);
	gtk_container_add(GTK_CONTAINER(color_but), pixmap);
	gtk_signal_connect(GTK_OBJECT(color_but), "clicked", color_but_clicked, which_entry);
	gtk_widget_show(color_but);
	return color_but;
}

/************************************************************************/
void color_but_clicked(GtkWidget * widget, GtkWidget * entry)
{
	gchar *tmpstring;

	DEBUG_MSG("color_but_clicked, before return_color\n");
	tmpstring = return_color();
	DEBUG_MSG("color_but_clicked, return_color=%s\n", tmpstring);
	gtk_entry_set_text(GTK_ENTRY(entry), tmpstring);
	g_free(tmpstring);

}

/************************************************************************/
GtkWidget *file_but_new(GtkWidget * which_entry, GtkWidget * win, gint full_pathname)
{
	GtkWidget *pixmap, *file_but;

	file_but = gtk_button_new();
	pixmap = new_pixmap(177, win->window, NULL);
	gtk_widget_show(pixmap);
	gtk_container_add(GTK_CONTAINER(file_but), pixmap);
	if (full_pathname == 1) {
		gtk_signal_connect(GTK_OBJECT(file_but), "clicked", file_but_clicked_full, which_entry);
	} else {
		gtk_signal_connect(GTK_OBJECT(file_but), "clicked", file_but_clicked, which_entry);
	}
	gtk_widget_show(file_but);
	return file_but;
}

/************************************************************************/
void file_but_clicked(GtkWidget * widget, GtkWidget * which_entry)
{
	gchar *tmpstring, *tmp2string;

	tmpstring = return_file("");
	if (tmpstring != NULL) {
		if (main_v->current_document->filename != NULL) {
			tmp2string = strip_common_path(tmpstring, main_v->current_document->filename);
			g_free(tmpstring);
			tmpstring = tmp2string;
		}
		gtk_entry_set_text(GTK_ENTRY(which_entry), tmpstring);
		gtk_signal_emit_by_name(GTK_OBJECT(which_entry), "activate");
		g_free(tmpstring);
	}
}

/************************************************************************/
void file_but_clicked_full(GtkWidget * widget, GtkWidget * which_entry)
{
	gchar *tmpstring;

	tmpstring = return_file("");
	if (tmpstring != NULL) {
		gtk_entry_set_text(GTK_ENTRY(which_entry), tmpstring);
		g_free(tmpstring);
	}
}

/************************************************************************/
