/* Bluefish HTML Editor
 * bluefish.h - global prototypes live here
 *
 * Copyright (C) 1998 Olivier Sessink and Chris Mazuc
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __BLUEFISH_H_
#define __BLUEFISH_H_

#include <glib.h>
#include <gtk/gtkwidget.h>

/* The current version !!!!!! */
#define CURRENT_VERSION_NUMBER "0.3.6"
/* don't remove the version number out of this name again
   or I'll kill you.... ;-]
 */
#define CURRENT_VERSION_NAME "Bluefish 0.3.6 HTML editor"
/* You should probably edit configure_cb.in too, when you update the
   version number. */

/* This is the type of each document */
typedef struct {
	gchar *filename;
	gint modified;
	unsigned del_txt_id;		/* Copyright (C) 1998 Andy C. Kahn <kahn@zk3.dec.com> */
	unsigned ins_txt_id;		/* undo/redo part is copied from gnotepad code */
	GList *undolist;
	GList *undotail;
	GList *redolist;
	GList *redotail;
	GtkWidget *textbox;
	GtkWidget *tab_label;
	gint highlightstate;
	gint need_highlighting;		/* +1 means a '"' is added, +2 means a '<' is added, 4 means a '>' is added */
} filestruct;

/* This is the current project */
typedef struct {
	gint modified;
	gchar *filename;
	gchar *basedir;
	gchar *webdir;
	gchar *template;
	GList *fontlist;
	GList *urllist;
	GList *targetlist;
	GList *colorlist;
	GList *dtd_cblist;
	GList *classlist;
	GList *metalist;
	GList *filenames;
} projectstruct;

typedef struct {
	gint v_html_tb;				/* view html toolbar */
	gint v_custom_tb;			/* view custom menubar */
	gint v_main_tb;				/* view main toolbar */
	gint main_window_h;			/* main window height */
	gint main_window_w;			/* main window width */
	gchar *cfg_browser_cline;	/* browser commandline */
	gchar *cfg_weblint_cline;	/* weblint command line */
	gchar *cfg_editor_font;		/* editor font */
	gint cfg_editor_tabwidth;	/* editor tabwidth */
	gchar *cfg_tab_pos;			/* notebook tabs positioning */
	gchar *cfg_tab_font;		/* notebook tabs font */
	gchar *cfg_thumbnailstring;	/* string to append to thumbnail filenames */
	gchar *cfg_thumbnailtype;	/* fileformat to use for thumbnails */
	gint full_p;				/* use </p> */
	gint full_li;				/* use </li> */
	gint lowercase_tags;		/* use lowercase tags */
	gint cont_highlight_update;	/* update the syntax highlighting continuous */
	GList *external_filters;	/* external filter in list */
	GList *external_commands;	/* external filter in list */
	GList *syntax_configstrings;	/* the strings containing the colors and patters */
} propertystruct;

typedef struct {
	projectstruct current_project;
	propertystruct props;
	filestruct *current_document;	/* This is always the current visible one */
	GList *documentlist;		/* The documents are now placed in a Glist */
	GtkWidget *notebook;
	gint last_notebook_page;	/* this is the last used, this can be used to track down if the notebook page really changed */
	GtkWidget *statusbar;
	GtkWidget *menubar;
	GtkWidget *main_window;
	GList *syntax_structs;		/* the props.syntax_configstrings parsed into structs with GdkColor and regex pattern */
	GList *command_strings;
	GList *filter_strings;
	gshort fontset;
} mainstruct;

extern mainstruct *main_v;

/* for exiting bluefish */
void cya_later(GtkWidget * widget, gpointer data);

/* changes the current working directory to the directory of this filename */
gboolean change_dir(gchar * filename);

/* removes the first of a char in a string, making it a \0 */
gchar *trunc_on_char(gchar * string, gchar which_char);

/* strips the path of the filename */
char *strip_filename(gchar * string);

/* strips the path that is common for both files */
gchar *strip_common_path(char *image_fn, char *html_fn);
void window_close(GtkWidget * button, gpointer windowname);

/* returns 1 if the file is readable */
gint file_exists_and_readable(gchar * filename);

/* runs through all the events in the gtk and gdk queue */
void flush_queue(void);

/* this function starts a file select dialog, and returns the selected file
   or returns NULL if non selected */
gchar *return_file(gchar * set_file);
GList *return_files(gchar * setfile);
#endif							/* __BLUEFISH_H_ */
