/* 
 * $Id: Curve.h,v 1.21 2007/03/15 01:09:11 campbellbarton Exp $
 *
 * ***** BEGIN GPL/BL DUAL LICENSE BLOCK *****
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version. The Blender
 * Foundation also sells licenses for use in proprietary software under
 * the Blender License.  See http://www.blender.org/BL/ for information
 * about this.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * The Original Code is Copyright (C) 2001-2002 by NaN Holding BV.
 * All rights reserved.
 *
 * This is a new part of Blender.
 *
 * Contributor(s): Jacques Guignot, Stephen Swaney
 *
 * ***** END GPL/BL DUAL LICENSE BLOCK *****
*/

#ifndef EXPP_CURVE_H
#define EXPP_CURVE_H

#include <Python.h>
#include "DNA_curve_types.h"

extern PyTypeObject Curve_Type;

#define BPy_Curve_Check(v) ((v)->ob_type==&Curve_Type)

/* Python BPy_Curve structure definition */
typedef struct {
	PyObject_HEAD		/* required py macro */
	Curve * curve;		/* libdata must be second */
	/* pointer for iterator:  does not point to owned memory */
	Nurb *iter_pointer;
} BPy_Curve;


/*
 *  protoypes
 */

PyObject *Curve_Init( void );
PyObject *Curve_CreatePyObject( struct Curve * curve );
struct Curve *Curve_FromPyObject( PyObject * py_obj );
PyObject *Curve_update( BPy_Curve * self );

PyObject *Curve_getName( BPy_Curve * self );
PyObject *Curve_setName( BPy_Curve * self, PyObject * args );
PyObject *Curve_getMode( BPy_Curve * self );
PyObject *Curve_setMode( BPy_Curve * self, PyObject * args );
PyObject *Curve_getBevresol( BPy_Curve * self );
PyObject *Curve_setBevresol( BPy_Curve * self, PyObject * args );
PyObject *Curve_getResolu( BPy_Curve * self );
PyObject *Curve_setResolu( BPy_Curve * self, PyObject * args );
PyObject *Curve_getResolv( BPy_Curve * self );
PyObject *Curve_setResolv( BPy_Curve * self, PyObject * args );
PyObject *Curve_getExt1( BPy_Curve * self );
PyObject *Curve_setExt1( BPy_Curve * self, PyObject * args );
PyObject *Curve_getExt2( BPy_Curve * self );
PyObject *Curve_setExt2( BPy_Curve * self, PyObject * args );
PyObject *Curve_getWidth( BPy_Curve * self );
PyObject *Curve_setWidth( BPy_Curve * self, PyObject * args );

#endif				/* EXPP_CURVE_H */
