#ifndef BU_Joint_H
#define BU_Joint_H

class RigidBody;
class BU_Joint;
#include "SimdScalar.h"

struct BU_ContactJointNode {
  BU_Joint *joint;		// pointer to enclosing BU_Joint object
  RigidBody*body;			// *other* body this joint is connected to
};
typedef SimdScalar dVector3[4];


class BU_Joint  {
  
public:
	// naming convention: the "first" body this is connected to is node[0].body,
  // and the "second" body is node[1].body. if this joint is only connected
  // to one body then the second body is 0.

  // info returned by getInfo1 function. the constraint dimension is m (<=6).
  // i.e. that is the total number of rows in the jacobian. `nub' is the
  // number of unbounded variables (which have lo,hi = -/+ infinity).

  BU_Joint();
  virtual ~BU_Joint();
  

  struct Info1 {
    int m,nub;
  };

  // info returned by getInfo2 function

  struct Info2 {
    // integrator parameters: frames per second (1/stepsize), default error
    // reduction parameter (0..1).
    SimdScalar fps,erp;

    // for the first and second body, pointers to two (linear and angular)
    // n*3 jacobian sub matrices, stored by rows. these matrices will have
    // been initialized to 0 on entry. if the second body is zero then the
    // J2xx pointers may be 0.
    SimdScalar *J1l,*J1a,*J2l,*J2a;

    // elements to jump from one row to the next in J's
    int rowskip;

    // right hand sides of the equation J*v = c + cfm * lambda. cfm is the
    // "constraint force mixing" vector. c is set to zero on entry, cfm is
    // set to a constant value (typically very small or zero) value on entry.
    SimdScalar *c,*cfm;

    // lo and hi limits for variables (set to -/+ infinity on entry).
    SimdScalar *lo,*hi;

    // findex vector for variables. see the LCP solver interface for a
    // description of what this does. this is set to -1 on entry.
    // note that the returned indexes are relative to the first index of
    // the constraint.
    int *findex;
  };

  // virtual function table: size of the joint structure, function pointers.
  // we do it this way instead of using C++ virtual functions because
  // sometimes we need to allocate joints ourself within a memory pool.

  virtual void GetInfo1 (Info1 *info)=0;
  virtual void GetInfo2 (Info2 *info)=0;

  int flags;			// dJOINT_xxx flags
  BU_ContactJointNode node[2];		// connections to bodies. node[1].body can be 0
   SimdScalar lambda[6];		// lambda generated by last step
};


#endif //BU_Joint_H
