/*
			(c) Copyright 1998-2000 - Tord Jansson
			======================================

		This file is part of the BladeEnc MP3 Encoder, based on
		ISO's reference code for MPEG Layer 3 compression, and might
		contain smaller or larger sections that are directly taken
		from ISO's reference code.

		All changes to the ISO reference code herein are either
		copyrighted by Tord Jansson (tord.jansson@swipnet.se)
		or sublicensed to Tord Jansson by a third party.

	BladeEnc is free software; you can redistribute this file
	and/or modify it under the terms of the GNU Lesser General Public
	License as published by the Free Software Foundation; either
	version 2.1 of the License, or (at your option) any later version.

	2000-03-08  Andr Piotrowski
*/

/**********************************************************************
 * ISO MPEG Audio Subgroup Software Simulation Group (1996)
 * ISO 13818-3 MPEG-2 Audio Encoder - Lower Sampling Frequency Extension
 *
 * $Id: mdct.h,v 1.1 1996/02/14 04:04:23 rowlands Exp $
 *
 * $Log: mdct.h,v $
 * Revision 1.1  1996/02/14 04:04:23  rowlands
 * Initial revision
 *
 * Received from Mike Coleman
 **********************************************************************/

#ifndef MDCT_DOT_H
#define MDCT_DOT_H





typedef double					L3SBS[2][3][18][SBLIMIT];   /* [ch][gr] - gr: 0..2 !!! */

extern	int					gr_idx[3];



void mdct
(
	double					inA[18][32],
	double					inB[18][32],
	int						band,
	double					*out,
	int						block_type
);

void mdct_sub
(
	L3SBS					*sb_sample,
	double					(*mdct_freq)[2][576],
	int						stereo,
	III_side_info_t			*l3_side,
	int						mode_gr
);





#endif /* MDCT_DOT_H */
