/*
 * Copyright (c) 2001 Tommy Bohlin <tommy@gatespace.com>,
                      Dieter Baron <dillo@giga.or.at>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
/* mkobexmemo.c
 */

#include <obexformat.h>

#include <sys/types.h>
#include <sys/stat.h>

#include <errno.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>

int main(int argc, char** argv)
{
  int c;
  int usage=0;
  unsigned int class;
  FILE *pdb;
  char buf[500];
  int n;
  struct stat st;

  class = 0x6c6e6368; /* lnch */
  
  while((c=getopt(argc,argv,"hlz"))!=-1) {
    switch(c) {
    case 'l':
      class = 0x6c6e6368; /* lnch */
      break;
    case 'z':
      class = 0x7a724354; /* zrCT */
      break;
    case 'h': usage=1; break;
    case '?': usage=1; break;
    }
  }

  if(usage || optind!=argc-1) {
    fprintf(stderr,"Format Palm Pilot PDB or PRC file\n");
    fprintf(stderr,"Usage: %s [-lz] pdb-file\n",argv[0]);
    return 0;
  }

  if ((pdb=fopen(argv[optind], "rb")) == NULL) {
      fprintf(stderr, "%s: cannot open `%s': %s\n",
	      argv[0], argv[optind], strerror(errno));
      return 1;
  }

  n = fread(buf, 1, sizeof(buf), pdb);

  putName(buf,strlen(buf));

  if (fstat(fileno(pdb), &st) == 0)
      putLength(st.st_size);

  putClass(class);

  while (n) {
      putBody(buf, n);

      n = fread(buf, 1, sizeof(buf), pdb);
  }

  putEndOfBody(buf,0);

  fclose(pdb);

  return 0;
}
