/*
 * Copyright (c) 2001 Tommy Bohlin <tommy@gatespace.com>,
 *                    Dieter Baron <dillo@giga.or.at>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
/* mkobexcard.c
 */

#include <obexformat.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#define MAXNAME                  24

static int ofs;
static int cr;
static int size;
static char* text;

static void addChar(int c)
{
  if(ofs>size-3) {
    size*=2;
    text=realloc(text,size);
  }
  if(c=='\n') {
    if(!cr) text[ofs++]='\r';
  } else {
    if(cr) text[ofs++]='\n';
  }
  text[ofs++]=c;
  cr= c=='\r';
}

static void addStr(const char* s)
{
  if (s == NULL)
    return;

  while(*s) addChar(*s++);
}

static void endInput(void)
{
  if(cr) text[ofs++]='\n';
}

int main(int argc, char** argv)
{
  int c,usage=0,cmdline=0;
  char name[MAXNAME+1];
  char* lname=0;
  char* fname=0;
  char* title=0;
  char* company=0;
  char* address=0;
  char* city=0;
  char* state=0;
  char* zip=0;
  char* country=0;

  /* XXX: missing: phone/fax/email, custom, note */

  name[0] = '\0';

  while((c=getopt(argc,argv,"a:c:C:f:l:n:o:s:t:z:h"))!=-1) {
    switch(c) {
    case 'a': address=optarg; cmdline=1; break;
    case 'c': city=optarg; cmdline=1; break;
    case 'C': country=optarg; cmdline=1; break;
    case 'f': fname=optarg; cmdline=1; break;
    case 'l': lname=optarg; cmdline=1; break;
    case 'n': strncpy(name, optarg, MAXNAME); name[MAXNAME]='\0'; break;
    case 'o': company=optarg; cmdline=1; break;
    case 's': state=optarg; cmdline=1; break;
    case 't': title=optarg; cmdline=1; break;
    case 'z': zip=optarg; cmdline=1; break;
    case 'h': usage=1; break;
    case '?': usage=1; break;
    }
  }

  if(usage) {
    fprintf(stderr,"Format Palm Pilot address from stdin or command line\n");
    fprintf(stderr,"Usage: %s [-a addr] [-c city] [-C country] [-f first-name] [-l last-name] [-n obj-name] [-o company] [-s state] [-t title] [-z zip]\n",argv[0]);
    return 0;
  }

  if (cmdline) {
      addStr("BEGIN:VCARD\nVERSION:2.1\n");
      if (fname || lname) {
	  addStr("N:");
	  addStr(lname);
	  addChar(';');
	  addStr(fname);
	  addChar('\n');
	  if (name[0] == '\0')
	      snprintf(name, MAXNAME+1, "%s%s%s",
		       (fname ? fname : ""),
		       (fname && lname ? " " : ""),
		       (lname ? lname : ""));
      }
      if (address || city || state || zip || country) {
	  addStr("ADR:;;");
	  addStr(address);
	  addChar(';');
	  addStr(city);
	  addChar(';');
	  addStr(state);
	  addChar(';');
	  addStr(zip);
	  addChar(';');
	  addStr(country);
	  addChar('\n');
      }
      if (company) {
	  addStr("ORG:");
	  addStr(company);
	  addChar('\n');
	  if (name[0] == '\0')
	      snprintf(name, MAXNAME+1, company);
      }
      if (title) {
	  addStr("TITLE:");
	  addStr(title);
	  addChar('\n');
      }
      /* note */
      /* phone */
      /* custom */
      addStr("END:VCARD");
  } else
      while((c=getchar())!=EOF) addChar(c);

  endInput();

  if (name[0] != '\0')
      putName(name,strlen(name));
  putLength(ofs);
  putClass(0x61646472); /* 'addr' */
  putEndOfBody(text,ofs);

  return 0;
}
