/* bfbtester -- Brute Force Binary Tester
 *
 * Copyright 2000	Mike Heffner <spock@techfour.net>
 * Use it and abuse it, but send patches and/or money to me. =)
 */


#include <stdio.h>
#include <stdlib.h>
#include <strings.h>
#include <unistd.h>
#include <dirent.h>
#include <signal.h>
#include <errno.h>

#include <sys/types.h>
#include <sys/wait.h>
#include <sys/time.h>
#include <sys/resource.h>
#include <sys/stat.h>

#include <pthread.h>

#include "datatypes.h"
#include "breaker.h"
#include "breaker_data.h"
#include "exec.h"
#include "main.h"

extern THREAD_DATA 	*q;
extern int			flags;
extern char			*run_location;
extern char			*rejects;
extern char			**environ;

static void *
breaker_run(void *data)
{
	char			*long_arg;
	char			*path;
	struct stat		sb;
	
	for(;(path=breaker_get_next_exec());free(path)){
		if( isareject(path) )
			continue;
		if(stat(path, &sb) == -1){
			debugmsg(0, "Can't stat %s\n", path);
			continue;
		}
		if( !S_ISREG(sb.st_mode) )
			continue;
		if( access(path, X_OK) == -1 )
			continue;
		printf("=> %s", path);
		if( sb.st_mode & S_ISUID )
			printf(" (setuid: %d)", sb.st_uid);
		if( sb.st_mode & S_ISGID )
			printf(" (setgid: %d)", sb.st_gid);
		printf("\n");

		/* Single arg test */
		if( flags & FLAGS_SINGLE_ARG_TEST )
		{
			char	*args[4]= { path,
								NULL, NULL, NULL };
			int 	i;
			int		long_arg_len=50*1024+1, short_arg_len=5*1024+1;
			
			printf("   * Single argument testing\n");
			printf("            -> First test - opt/arg - short\n");
			long_arg = Malloc(short_arg_len);
			memset(long_arg, 'A', short_arg_len-1);
			args[2]=long_arg;
			for(i=0; i < (sizeof(args_options)/sizeof(args_options[0])); i++){
				args[1]=(char *)args_options[i];
				breaker_execute_command(args, NULL);
			}
			usleep(500000);
			free(long_arg);
			printf("            -> Second test - opt/arg - long\n");
			long_arg = Malloc(long_arg_len);
			memset(long_arg, 'A', long_arg_len-1);
			args[2]=long_arg;
			for(i=0; i < (sizeof(args_options)/sizeof(args_options[0])); i++){
				args[1]=(char *)args_options[i];
				breaker_execute_command(args, NULL);
			}
			usleep(500000);
			printf("            -> Third test - arg - long\n");
			args[1]=long_arg;
			args[2]=NULL;
			breaker_execute_command(args, NULL);
			free(long_arg);
			sleep(1);
			
		}
		/* Multiple args test */
		if( flags & FLAGS_MULTIPLE_ARG_TEST )
		{
			char	*args[7]={NULL};
			int		i,j;
			int		arg_len=10*1024+1; /* only one arg */
			args[0] = path;
			
			printf("   * Multiple arguments testing\n");
			printf("            -> First test - opt/arg + arg\n");
			long_arg = Malloc(arg_len);
			memset(long_arg, 'A', arg_len-1);
			args[2] = long_arg; args[3] = long_arg; args[4] = NULL;
			for(i=0; i < (sizeof(args_options)/sizeof(args_options[0])); i++){
				args[1]=(char *)args_options[i];
				breaker_execute_command(args, NULL);
			}
			usleep(500000);
			printf("            -> Second test - opt/arg + opt/arg\n");
			args[2]=long_arg; args[4]=long_arg; args[5]=NULL;
			for(i=0; i < (sizeof(args_options)/sizeof(args_options[0])); i++){
				args[1] = (char *)args_options[i];
				for(j=0; j < (sizeof(args_options)/sizeof(args_options[0])); j++){
					args[3] = (char *)args_options[j];
					breaker_execute_command(args, NULL);
				}
				usleep(500000);
			}
			printf("            -> Third test - opt/arg + opt/arg + arg\n");
			args[2]=long_arg; args[4]=long_arg; args[5]=long_arg; args[6]=NULL;
			for(i=0; i < (sizeof(args_options)/sizeof(args_options[0])); i++){
				args[1] = (char *)args_options[i];
				for(j=0; j < (sizeof(args_options)/sizeof(args_options[0])); j++){
					args[3] = (char *)args_options[j];
					breaker_execute_command(args, NULL);
				}
				usleep(500000);
			}
			printf("            -> Fourth test - arg + arg\n");
			args[1] = long_arg; args[2] = long_arg; args[3] = NULL;
			breaker_execute_command(args, NULL);
			usleep(100000);
			free(long_arg);
			sleep(1);
		}
		/* Environment variable test */
		if( flags & FLAGS_ENV_TEST )
		{
			char	*args_arr[]={path, NULL, NULL};
			char	*envs_arr[]={NULL, NULL};
			char	*long_arg2;
			int		i, env_len;
			int		long_arg_len=10*1024 + 1;
			
			printf("   * Environment variable testing\n");
			long_arg = Malloc(long_arg_len);
			long_arg2 = Malloc(long_arg_len);
			memset(long_arg2, 'A', long_arg_len-1);
			envs_arr[0]=long_arg;
			for(i=0; i < (sizeof(envs)/sizeof(envs[0])); i++){
				env_len = strlen(envs[i]);
				if(env_len+1 >= long_arg_len-1) continue; /*ahh!*/
				strcpy(long_arg, envs[i]);
				long_arg[env_len] = '=';
				memset(long_arg+env_len+1, 'A', long_arg_len - env_len -1 -1);

				breaker_execute_command(args_arr, envs_arr); /* env no args */

				args_arr[1]=(char *)long_arg2;
				breaker_execute_command(args_arr, envs_arr);
				args_arr[1]=NULL;

				if(i % 25 == 0)
					usleep(300000);
			}
			free(long_arg);
			free(long_arg2);
		}
	}
	return (void *)0;
}

void
breaker_start(void)
{
	if( pthread_create(&(q->run_thread), NULL, breaker_run, NULL) != 0 ){
		debugmsg(0, "Can't create run_thread: %s", strerror(errno));
		exit(1);
	}

	if( pthread_create(&(q->poll_thread), NULL, poll_execs, NULL) != 0 ){
		debugmsg(0, "Can't create poll_thread: %s", strerror(errno));
		exit(1);
	}
}

void *
poll_execs(void *data)
{
	pthread_cleanup_push(breaker_cleanup, NULL);
	for(;;){
		exec_poll();
		usleep(100000);
	}
	return NULL;
}

void
breaker_execute_command(char ** args, char ** env)
{
	int		i;
	for(i=10000;  execute_program(args, env) != 0 ; i*=3)
		usleep(i);

}

#define	FILE_TYPE_DIR	1  	/* we go through with readdir() */
#define	FILE_TYPE_EXEC	2	/* a single exec, iterate once */
char *
breaker_get_next_exec(void)
{
	static	int				file_type=0;
	static	DIR				*dir;
	static	struct	dirent	*dent;

	if( !file_type ){
		/* first run */
		struct	stat	sb;
		if(stat(run_location, &sb) == -1){
			debugmsg(0, "Can't stat %s\n", run_location);
			return NULL;
		}
		if( S_ISDIR(sb.st_mode) ){
			file_type = FILE_TYPE_DIR;
			if( (dir=opendir(run_location)) == NULL){
				debugmsg(0, "Can't open dir %s\n", run_location);
				return NULL;
			}
			if( (dent=readdir(dir)) == NULL )
				return NULL;
			return make_fullpath(run_location, dent->d_name);
		}
		/* assume type is file exec */
		file_type = FILE_TYPE_EXEC;
		return strdup(run_location);
	}
	if( file_type == FILE_TYPE_DIR ){
		if( (dent=readdir(dir)) == NULL )
			return NULL;
		return make_fullpath(run_location, dent->d_name);
	}
	
	return NULL;
}
		
		
int
isareject(char *path)
{
	char	*ptr, *ptr2;
	if(!rejects)
		return 0;
	if((ptr=strstr(rejects, path))){
		if(ptr == rejects || *(ptr-1) == ' ' || *(ptr-1) == ',')
			if(*(ptr+strlen(path)) == '\0' || *(ptr+strlen(path)) == ' ' ||
			   *(ptr+strlen(path)) == ',')
				return 1;
	}
	if( (ptr2=strrchr(path, '/')) && (ptr=strstr(rejects, ++ptr2)) )
		if(ptr == rejects || *(ptr-1) == ' ' || *(ptr-1) == ',')
			if(*(ptr+strlen(ptr2)) == '\0' || *(ptr+strlen(ptr2)) == ' ' ||
			   *(ptr+strlen(ptr2)) == ',')
				return 1;
	return 0;
}
	
/* Cleanup routine
 * Runs exec_poll() twice after 5 second delay
 */
void
breaker_cleanup(void * arg)
{
	debugmsg(0, "Cleaning up...might take a few seconds");
	sleep(EXEC_TIMEOUT+1);
	exec_poll();
	exec_poll();
}
