/* bfbtester -- Brute Force Binary Tester
 *
 * Copyright 2000	Mike Heffner <spock@techfour.net>
 * Use it and abuse it, but send patches and/or money to me. =)
 */


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>
#include <unistd.h>

#include "datatypes.h"
#include "main.h"
#include "exec.h"
#include "breaker.h"

void	usage(void);

THREAD_DATA		*q;
int			flags=0;
int			debug_level=0;
char		*run_location;
char		*rejects=NULL;

extern int	optind;
extern char	*optarg;

int
main( int ac, char ** av )
{
	int ch;

	while( (ch = getopt(ac, av, "d:asmer:")) != -1 )
		switch (ch) {
		case 'd':
			debug_level = atoi(optarg);
			break;
		case 'a':
			flags |= FLAGS_ALL;
			break;
		case 's':
			flags |= FLAGS_SINGLE_ARG_TEST;
			break;
		case 'm':
			flags |= FLAGS_MULTIPLE_ARG_TEST;
			break;
		case 'e':
			flags |= FLAGS_ENV_TEST;
			break;
		case 'r':
			rejects = optarg;
			break;
		default:
			usage();
			/* NOTREACHED */
		}

	if(!flags)
		usage();

	ac -= optind;
	av += optind;

	if( (run_location = *av) == NULL )
		usage();

	q = Malloc(sizeof(THREAD_DATA));
	q->max_execs = 512;
	q->mut = Malloc(sizeof(pthread_mutex_t));

	if( pthread_mutex_init(q->mut, NULL) != 0 ){
		debugmsg(0, "mutex_init1");
		exit(1);
	}
	
	breaker_start();
	pthread_join(q->run_thread, NULL);
	/* cancel poll thread */
	pthread_cancel(q->poll_thread);
	pthread_join(q->poll_thread, NULL);

	return 0;

}


/*
 * Memory allocation with error checking
 * Also zero's mem.
 */
inline void *
main_malloc( size_t a,  char * func,  int line )
{
	void	* temp;
	if( (temp=malloc(a)) == NULL){
		printf("[%s:%d] Out of memory!\n", func, line);
		exit(1);
	}
	bzero(temp, a);
	return temp;
}
	
void
usage(void)
{
	printf("%s  v%s\n"
		   "bfbtester -(asme) [-d level] [-r rejects] BinOrDir\n"
		   "Must specify one or more of the following tests:\n"
		   "	-s	Single Argument Test\n"
		   "	-m	Multiple Argument Test\n"
		   "	-e	Environment Variable Test\n"
		   "	-a	Selects all tests\n"
		   "-d level	Debug level\n"
		   "-r rejects	Comma seperated list of binarys to skip\n"
		   "BinOrDir	Specific Binary or Directory of binaries to test\n\n",
		   IDSTRING, VERSION_STR);
	exit(2);
}

char *
make_fullpath(char *root, char *file)
{
	char *str;
	asprintf(&str, "%s%s%s",
			 root, *(root+strlen(root)-1)=='/' ? "" : "/", file);
	return str;
}

void
print_debug(char *func, int line, int level, char *fmt, ...)
{
	va_list		ap;
	if(debug_level >= level){
		va_start(ap, fmt);
		printf("[%s:%d] ", func, line);
		vprintf(fmt, ap);
		printf("\n");
		va_end(ap);
	}
}
