/*
 *      This program is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published by
 *      the Free Software Foundation; either version 2 of the License, or
 *      (at your option) any later version.
 *
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 *
 *      You should have received a copy of the GNU General Public License
 *      along with this program; if not, write to the Free Software
 *      Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */
#include <string.h>
#include <gtk/gtk.h>
#include "mask.xbm"
/*#include "icmask-club_mask.xbm"
#include "icmask-diamond_mask.xbm"
#include "icmask-heart_mask.xbm"
#include "icmask-spade_mask.xbm"
#define iconmask_width 16
#define iconmask_height 16*/
#include "def.h"


/* load_list_add: takes care of charging a new file 
 * as an image, and makes it a card in the list 
 * called "all" in struct _prog (see file def.h 
 * for more details about it).
 */
void load_list_add(GList **ptrlist,
	const gchar *file,
	gint num, gint family,
	GtkWidget *widget)
{
	struct _card *data_card = (struct _card*) g_malloc(sizeof(struct _card) );
	
	if(data_card != NULL)
	{
		data_card->family = family;
		data_card->num = num;

		data_card->dim.x = 0;
		data_card->dim.y = 0;
		
		data_card->draw = FALSE;
		
		data_card->blink = FALSE;

		data_card->img = gdk_pixmap_create_from_xpm(
			widget->window, NULL, NULL, file);
		
		gdk_drawable_get_size(data_card->img, 
			&(data_card->dim.w), &(data_card->dim.h));
		
		*ptrlist = g_list_prepend(*ptrlist, (gpointer)data_card);
	}
}

/* load_cards : 
 * this is a one time call, which takes care 
 * to load every cards (52 actually), loading 
 * the mask of them (one only) and also loads 
 * the back images of the cards (one) and 
 * icons of the different family (4)
 */
gboolean load_cards(const gchar *path, 
	struct _prog* prog_data, GtkWidget *widget)
{
	
	GList **ptrlist = &(prog_data->all);
	
	gchar cn_ace[] = "ace";
	gchar cn_jack[] = "jack";
	gchar cn_queen[] = "queen";
	gchar cn_king[] = "king";
	gchar *c_num[13]= {cn_ace, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, cn_jack, cn_queen, cn_king};
	gchar cf_diamond[] = "diamond", cf_spade[] = "spade", cf_heart[] = "heart", cf_club[] = "club";
	gchar *c_family[4]= {cf_diamond, cf_spade, cf_heart, cf_club};

	gchar *num;
	gchar *family;
	
	
	char model[] = "paris";
	
	/* 18 is the longest string (queen + diamond) Not translatable. */
	gint i, j, max = (strlen(path)+18+strlen(model));

	
	gboolean  error = FALSE;

	gchar *cardname = (gchar*)g_malloc(sizeof(gchar)*max);

	if(cardname != NULL)
	{
		if(prog_data->icons)
		{
		
			for(j=0; j < 4; j++)
			{
				family = c_family[j];
				
				g_sprintf(cardname, "%s/icon-%s.xpm", path, family);
		
				
				if ( g_file_test(cardname, G_FILE_TEST_EXISTS) == TRUE )
					prog_data->icons[j] = gdk_pixbuf_new_from_file(cardname, NULL);
				else
					error = TRUE;
				
			}
			

			g_sprintf(cardname, "%s/icon-none.xpm", path);
				
				
			if ( g_file_test(cardname, G_FILE_TEST_EXISTS) == TRUE )
			{
				if(prog_data->output)
					fprintf(prog_data->output, "okicon %s\n",cardname);
				prog_data->icons[4] = gdk_pixbuf_new_from_file(cardname, NULL);
			}
			else
				error = TRUE;
		}
	
		
		
		for( i = 0; i < 13; i++)
		{
			num = c_num[i];
			
			
			for( j = 0; j < 4 ; j++)
			{
				family = c_family[j];
				
				
				if(num != NULL)
					g_sprintf(cardname, "%s/%s%s.xpm", path, num, family);
				else
					g_sprintf(cardname, "%s/%d%s.xpm", path, (i+1), family);
				
				if ( g_file_test(cardname, G_FILE_TEST_EXISTS) == TRUE )
				{
					load_list_add(ptrlist, cardname, i, j, widget);
				}
				else
					error = TRUE;
			}
		}
		
		if(prog_data->cardmask == NULL)
			prog_data->cardmask = gdk_bitmap_create_from_data(
				widget->window, mask_bits, mask_width, mask_height);
		
		/* back of cards */
		g_sprintf(cardname, "%s/%s/back.xpm", path,model);
		
		if(g_file_test(cardname, G_FILE_TEST_EXISTS) == TRUE)
		{
			prog_data->back = gdk_pixmap_create_from_xpm(
				widget->window, 
				&(prog_data->backmask), 
				&(prog_data->area->style->black), 
				cardname);
			
		}
		else
			error = TRUE;
		
		g_free(cardname);
	}
	
	return(error);
}
